<?php
include_once 'functions.php';

if( !isset( $_GET[ "database" ] ) || $_GET[ "database" ] == "" )
{
    pr( "El nombre de la Base de Datos es importante." );
    pr( "Parametro: [database=]" );
    exit;
}

if( !isset( $_GET[ "schema" ] ) || $_GET[ "schema" ] == "" )
{
    pr( "El nombre de la schema es importante." );
    pr( "Parametro: [schema=]" );
    exit;
}

if( !isset( $_GET[ "package" ] ) || $_GET[ "package" ] == "" )
{
    pr( "El nombre de la package es importante." );
    pr( "Parametro: [package=]" );
    exit;
}

$s_DatabaseName = $_GET[ "database" ];
$s_SchemaName   = $_GET[ "schema" ];
$s_Package      = $_GET[ "package" ];
$s_TableName    = isset( $_GET[ "table" ] ) && $_GET[ "table" ] != "" ? $_GET[ "table" ] : "";

$host        = "host = 127.0.0.1";
$port        = "port = 5432";
$dbname      = "dbname = $s_DatabaseName";
$credentials = "user = postgres password=mhwinv";

$cn = pg_connect( "$host $port $dbname $credentials"  );
if( !$cn )
{
    pr( "Error : Unable to open database." );
}

$s_Where = "";

if( $s_DatabaseName )
{
    $s_Where .= " and table_catalog='$s_DatabaseName' ";
}
if( $s_SchemaName )
{
    $s_Where .= " and table_schema='$s_SchemaName' ";
}
if( $s_TableName )
{
    $s_Where .= " and table_name='$s_TableName' ";
}

$s_Sql = "SELECT * FROM information_schema.tables where 1=1 $s_Where ";
$rs = pg_query( $cn, $s_Sql );
$num_row = pg_num_rows( $rs );

if( $num_row > 0 )
{
    while ( $row = pg_fetch_array( $rs, NULL, PGSQL_ASSOC ) )
    {
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //AHORA SE GENERA CODIGO PARA LOS ENTITY
        $s_TableName = $row['table_name'];
        
        $s_ClassName = camelize( substr( $s_TableName, 3, strlen( $s_TableName ) ) ); //."Entity";
        $s_FileName  = $s_ClassName.".java";

        $s_IdClassJPA = "Null";
        $s_IdFielName = "idParam";

        $b_CtrlIncrement = false;
        
        $s_PhpCode = "@Entity<br>";
        $s_PhpCode .= "@Table( name = \"$s_TableName\", schema = \"$s_SchemaName\" )<br>";
        $s_PhpCode .= "public class $s_ClassName implements Serializable<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= $s_Tab."private static final long serialVersionUID = -8104762492739097848L;<br>";
        
        $a_DataColumn = array();
        $s_Sql = " SELECT * FROM information_schema.columns where 1=1 and table_catalog='$s_DatabaseName' and table_schema='$s_SchemaName' and table_name='$s_TableName'; ";
        $rs2 = pg_query( $cn, $s_Sql );
        if( pg_num_rows( $rs2 ) > 0 )
        {
            $i_Cont = 1;
            while ( $row = pg_fetch_array( $rs2, NULL, PGSQL_ASSOC ) )
            {
                $a_DataColumn[$i_Cont] = $row;
                $a_DataColumn[$i_Cont]['Primary'] = false;

                $b_CtrlPrimary = false;
                $s_ColumnName = $row['column_name'];
                $s_Sql = "SELECT * FROM information_schema.key_column_usage where 1=1 and table_catalog='$s_DatabaseName' and table_schema='$s_SchemaName' and table_name='$s_TableName' and column_name='$s_ColumnName';";
                $rs3 = pg_query( $cn, $s_Sql );
                if( pg_num_rows( $rs3 ) > 0 )
                {
                    $a_DataColumn[$i_Cont]['Primary'] = true;
                    $b_CtrlPrimary = true;
                }

                $a_DataColumn[$i_Cont]['EsNulo'] = $row['is_nullable'] == "YES" ? "true" : "false";

                switch ( strtolower( $row['udt_name'] ) )
                {
                    case "float":
                    case "decimal":
                    case "numeric":
                    case "double":
                    case "real":
                        $a_DataColumn[$i_Cont]['Detalle'] = false;
                        $a_DataColumn[$i_Cont]['Clase']   = "Double";
                    break;
                    case "int":
                    case "int4":
                    case "integer":
                    case "smallint":
                    case "tinyint":
                    case "bigint":
                        $a_DataColumn[$i_Cont]['Detalle'] = false;
                        $a_DataColumn[$i_Cont]['Clase'] = "Integer";
                        if( $b_CtrlPrimary )
                        {
                            $a_DataColumn[$i_Cont]['Clase'] = "Long";
                        }
                    break;
                    case "date":
                        $a_DataColumn[$i_Cont]['Detalle'] = false;
                        $a_DataColumn[$i_Cont]['Clase'] = "Date";
                    break;    
                    case "datetime":
                    case "timestamp":
                        $a_DataColumn[$i_Cont]['Detalle'] = false;
                        $a_DataColumn[$i_Cont]['Clase'] = "Date";
                    break;    
                    case "text":
                    case "char":
                    case "varchar":
                    case "blob":
                        $a_DataColumn[$i_Cont]['Detalle'] = true;
                        $a_DataColumn[$i_Cont]['Clase'] = "String";
                    break;
                    default:
                        pr( "No tiene definido el tipo de dato." );
                    break;
                }

                $i_Cont++;
            }
        }
        //AQUI SE HACE UN FOREACH
        foreach( $a_DataColumn as $i_Key => $a_Column )
        {
            $s_ColumnName = $a_Column['column_name'];
            $s_Length     = $a_Column['character_maximum_length'];
            $s_TipoDato   = $a_Column['udt_name'];
            $s_PhpCode .= "<br>";
            if( $a_Column['Primary'] )
            {
                $s_IdClassJPA = $a_Column['Clase'];
                $s_IdFielName = strtolower( camelize( $s_ColumnName ) );
                $s_PhpCode .= $s_Tab."@Id<br>";

                $s_Sql = "SELECT * FROM information_schema.sequences where lower( sequence_name ) = 'seq_".strtolower( $s_TableName )."';";
                $rs2 = pg_query( $cn, $s_Sql );
                if( pg_num_rows( $rs2 ) > 0 )
                {
                    $b_CtrlIncrement = true;
                    $row2 = pg_fetch_array( $rs2, NULL, PGSQL_ASSOC );
                    $s_PhpCode .= $s_Tab."@GeneratedValue( strategy = GenerationType.SEQUENCE, generator = \"".strtolower( $row2['sequence_name'] )."\" )<br>";
                    $s_PhpCode .= $s_Tab."@SequenceGenerator(name = \"".strtolower( $row2['sequence_name'] )."\", sequenceName = \"".strtolower( $row2['sequence_name'] )."\", schema = \"".$row2['sequence_schema']."\", allocationSize = ".$row2['increment'].", initialValue = ".$row2['start_value'].")<br>";
                }
            }
            $s_PhpCode .= $a_Column['Detalle'] ? $s_Tab."@Column( name = \"$s_ColumnName\", nullable = ".$a_Column['EsNulo'].", length = $s_Length )<br>" : $s_Tab."@Column ( name = \"$s_ColumnName\", nullable = ".$a_Column['EsNulo']." )<br>";
            $s_PhpCode .= $s_Tab."private ".$a_Column['Clase']." ".lcfirst( camelize( $s_ColumnName ) ).";<br>";
        }
        //$s_PhpCode .= "<br>";
        foreach( $a_DataColumn as $i_Key => $a_Column )
        {
            $s_ColumnName = $a_Column['column_name'];
            $s_PhpCode .= "<br>";
            $s_PhpCode .= $s_Tab."public ".$a_Column['Clase']." get".camelize( $s_ColumnName )."()<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."return this.".lcfirst( camelize( $s_ColumnName ) ).";<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
            $s_PhpCode .= $s_Tab."public void set".camelize( $s_ColumnName )."( ".$a_Column['Clase']." ".strtolower( camelize( $s_ColumnName ) )." )<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab." this.".lcfirst( camelize( $s_ColumnName ) )." = ".strtolower( camelize( $s_ColumnName ) ).";<br>";
            $s_PhpCode .= $s_Tab."}<br>";
        }
        $s_PhpCode .= "}";

        $s_PhpCode2  = "package $s_Package.entity;<br>";
        $s_PhpCode2 .= "<br>";
        $s_PhpCode2 .= "import java.io.Serializable;<br>";
        $s_PhpCode2 .= "import java.util.Date;<br>";
        $s_PhpCode2 .= "<br>";
        $s_PhpCode2 .= "import javax.persistence.Column;<br>";
        $s_PhpCode2 .= "import javax.persistence.Entity;<br>";
        if( $b_CtrlIncrement )
        {
            $s_PhpCode2 .= "import javax.persistence.GeneratedValue;<br>";
            $s_PhpCode2 .= "import javax.persistence.GenerationType;<br>";
            $s_PhpCode2 .= "import javax.persistence.SequenceGenerator;<br>";
        }
        $s_PhpCode2 .= "import javax.persistence.Id;<br>";
        $s_PhpCode2 .= "import javax.persistence.Table;<br>";
        $s_PhpCode2 .= "<br>";
        $s_PhpCode2 .= $s_PhpCode;

        $s_PhpCode = $s_PhpCode2;

        $s_NombreRepo = "repositorio";
        if ( !file_exists( $s_NombreRepo ) )
        {
            mkdir( $s_NombreRepo );
        }
        if ( !file_exists( $s_NombreRepo."/Entity" ) )
        {
            mkdir( $s_NombreRepo."/Entity" );
        }
        $i_archivo = fopen( $s_NombreRepo."/Entity/".$s_FileName, "w" );
        $s_clase = $s_PhpCode."<br>";
        $s_clase = str_replace( "<br>", "\n", $s_clase);
        $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase);
        $s_clase = str_replace( "&nbsp;", " ", $s_clase);
        fputs ( $i_archivo, $s_clase );
        fclose( $i_archivo );
        ?>
        <div style = "margin: 5px 20px 20px;">
            <div class= "smallfont" style = "margin-bottom: 2px;">codigo XML: <?php echo $s_FileName; ?></div>
            <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 60%; text-align: left;">
                <pre style = "white-space: nowrap;" lang="xml">
                    <code lang="xml"><?php echo $s_PhpCode ?></code>
                </pre>
            </div>
        </div>
        <?php
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //AHORA SE GENERA CODIGO PARA LOS REPOSITORY
        $s_FileName  = $s_ClassName."Repository.java";
        $s_NombreJavaSrc = "repository";

        $s_PhpCode  = "package $s_Package.$s_NombreJavaSrc;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import org.springframework.data.jpa.repository.JpaRepository;<br>";
        $s_PhpCode .= "import org.springframework.stereotype.Repository;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import $s_Package.entity.$s_ClassName;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "@Repository<br>";
        $s_PhpCode .= "public interface ".$s_ClassName."Repository extends JpaRepository< $s_ClassName, $s_IdClassJPA ><br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "}";

        $s_NombreRepo    = "repositorio";
        
        if ( !file_exists( $s_NombreRepo ) )
        {
            mkdir( $s_NombreRepo );
        }
        if ( !file_exists( $s_NombreRepo."/".$s_NombreJavaSrc ) )
        {
            mkdir( $s_NombreRepo."/".$s_NombreJavaSrc );
        }
        $i_archivo = fopen( $s_NombreRepo."/".$s_NombreJavaSrc."/".$s_FileName, "w" );
        $s_clase = $s_PhpCode."<br>";
        $s_clase = str_replace( "<br>", "\n", $s_clase);
        $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase);
        $s_clase = str_replace( "&nbsp;", " ", $s_clase);
        fputs ( $i_archivo, $s_clase );
        fclose( $i_archivo );
        ?>
        <div style = "margin: 5px 20px 20px;">
            <div class= "smallfont" style = "margin-bottom: 2px;">codigo XML: <?php echo $s_FileName; ?></div>
            <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 60%; text-align: left;">
                <pre style = "white-space: nowrap;" lang="xml">
                    <code lang="xml"><?php echo $s_PhpCode ?></code>
                </pre>
            </div>
        </div>
        <?php
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //AHORA SE GENERA CODIGO PARA LOS DTOs 
        $s_FileName  = $s_ClassName."ReadDto.java";

        $s_PhpCode  = "package $s_Package.dto;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import com.fasterxml.jackson.annotation.JsonInclude;<br>";
        $s_PhpCode .= "import java.util.Date;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "public class ".$s_ClassName."ReadDto<br>";
        $s_PhpCode .= "{";
        
        //AQUI SE HACE UN FOREACH
        foreach( $a_DataColumn as $i_Key => $a_Column )
        {
            $s_PhpCode .= "<br>";
            $s_ColumnName = $a_Column['column_name'];
            $s_Length     = $a_Column['character_maximum_length'];
            $s_TipoDato   = $a_Column['udt_name'];
            $s_PhpCode .= $s_Tab."@JsonInclude(JsonInclude.Include.NON_NULL)<br>";
            $s_PhpCode .= $s_Tab."private ".$a_Column['Clase']." ".lcfirst( camelize( $s_ColumnName ) ).";<br>";
        }

        foreach( $a_DataColumn as $i_Key => $a_Column )
        {
            $s_PhpCode .= "<br>";
            $s_ColumnName = $a_Column['column_name'];
            $s_PhpCode .= $s_Tab."public ".$a_Column['Clase']." get".camelize( $s_ColumnName )."()<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."return this.".lcfirst( camelize( $s_ColumnName ) ).";<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
            $s_PhpCode .= $s_Tab."public void set".camelize( $s_ColumnName )."( ".$a_Column['Clase']." ".strtolower( camelize( $s_ColumnName ) )." )<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab." this.".lcfirst( camelize( $s_ColumnName ) )." = ".strtolower( camelize( $s_ColumnName ) ).";<br>";
            $s_PhpCode .= $s_Tab."}<br>";
        }

        $s_PhpCode .= "}";

        $s_NombreRepo    = "repositorio";
        $s_NombreJavaSrc = "dto";
        if ( !file_exists( $s_NombreRepo ) )
        {
            mkdir( $s_NombreRepo );
        }
        if ( !file_exists( $s_NombreRepo."/".$s_NombreJavaSrc ) )
        {
            mkdir( $s_NombreRepo."/".$s_NombreJavaSrc );
        }
        $i_archivo = fopen( $s_NombreRepo."/".$s_NombreJavaSrc."/".$s_FileName, "w" );
        $s_clase = $s_PhpCode."<br>";
        $s_clase = str_replace( "<br>", "\n", $s_clase);
        $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase);
        $s_clase = str_replace( "&nbsp;", " ", $s_clase);
        fputs ( $i_archivo, $s_clase );
        fclose( $i_archivo );
        ?>
        <div style = "margin: 5px 20px 20px;">
            <div class= "smallfont" style = "margin-bottom: 2px;">codigo XML: <?php echo $s_FileName; ?></div>
            <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 60%; text-align: left;">
                <pre style = "white-space: nowrap;" lang="xml">
                    <code lang="xml"><?php echo $s_PhpCode ?></code>
                </pre>
            </div>
        </div>
        <?php
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //AHORA SE GENERA CODIGO PARA LOS ServiceInterface
        /*$s_FileName  = $s_ClassName."ServiceInterface.java";

        $s_PhpCode  = "package $s_Package.interfaces;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import java.util.List;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import $s_Package.dto.".$s_ClassName."ReadDto;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "public interface ".$s_ClassName."ServiceInterface<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= $s_Tab."List< ".$s_ClassName."ReadDto > findAll();<br>";
        $s_PhpCode .= $s_Tab.$s_ClassName."ReadDto findById( $s_IdClassJPA $s_IdFielName ) throws Exception;<br>";
        $s_PhpCode .= "}";

        $s_NombreRepo    = "repositorio";
        $s_NombreJavaSrc = "interfaces";
        if ( !file_exists( $s_NombreRepo ) )
        {
            mkdir( $s_NombreRepo );
        }
        if ( !file_exists( $s_NombreRepo."/".$s_NombreJavaSrc ) )
        {
            mkdir( $s_NombreRepo."/".$s_NombreJavaSrc );
        }
        $i_archivo = fopen( $s_NombreRepo."/".$s_NombreJavaSrc."/".$s_FileName, "w" );
        $s_clase = $s_PhpCode."<br>";
        $s_clase = str_replace( "<br>", "\n", $s_clase);
        $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase);
        $s_clase = str_replace( "&nbsp;", " ", $s_clase);
        fputs ( $i_archivo, $s_clase );
        fclose( $i_archivo );*/
        ?>
        <!--<div style = "margin: 5px 20px 20px;">
            <div class= "smallfont" style = "margin-bottom: 2px;">codigo XML: <?php echo $s_FileName; ?></div>
            <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 60%; text-align: left;">
                <pre style = "white-space: nowrap;" lang="xml">
                    <code lang="xml"><?php echo $s_PhpCode ?></code>
                </pre>
            </div>
        </div>-->
        <?php
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //AHORA SE GENERA CODIGO PARA LOS Services
        /*$s_FileName  = $s_ClassName."Service.java";

        $s_PhpCode  = "package $s_Package.service;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import java.util.ArrayList;<br>";
        $s_PhpCode .= "import java.util.List;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import org.dozer.Mapper;<br>";
        $s_PhpCode .= "import org.springframework.beans.factory.annotation.Autowired;<br>";
        $s_PhpCode .= "import org.springframework.stereotype.Service;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "import com.qtc.seguridad.core.exception.ResourceNotFoundException;<br>";
        $s_PhpCode .= "import $s_Package.dto.".$s_ClassName."ReadDto;<br>";
        $s_PhpCode .= "import $s_Package.entity.".$s_ClassName.";<br>";
        $s_PhpCode .= "import $s_Package.interfaces.".$s_ClassName."Repository;<br>";
        $s_PhpCode .= "import $s_Package.interfaces.".$s_ClassName."ServiceInterface;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= "@Service<br>";
        $s_PhpCode .= "public class ".$s_ClassName."Service implements ".$s_ClassName."ServiceInterface<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= $s_Tab."@Autowired<br>";
        $s_PhpCode .= $s_Tab."private ".$s_ClassName."Repository o".$s_ClassName."Repository;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= $s_Tab."@Autowired<br>";
        $s_PhpCode .= $s_Tab."Mapper oMapper;<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= $s_Tab."@Override<br>";
        $s_PhpCode .= $s_Tab."public List< ".$s_ClassName."ReadDto > findAll()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."List< ".$s_ClassName." > a".$s_ClassName." = o".$s_ClassName."Repository.findAll();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."List< {$s_ClassName}ReadDto > a{$s_ClassName}ReadDto = new ArrayList<>();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{$s_ClassName}ReadDto o{$s_ClassName}ReadDto;<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."for( {$s_ClassName} o{$s_ClassName} : a{$s_ClassName} )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."o{$s_ClassName}ReadDto = new {$s_ClassName}ReadDto();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."oMapper.map( o{$s_ClassName}, o{$s_ClassName}ReadDto );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."a{$s_ClassName}ReadDto.add( o{$s_ClassName}ReadDto );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return a{$s_ClassName}ReadDto;<br>";
        $s_PhpCode .= $s_Tab."}<br>";
        $s_PhpCode .= "<br>";
        $s_PhpCode .= $s_Tab."@Override<br>";
        $s_PhpCode .= $s_Tab."public {$s_ClassName}ReadDto findById( String $s_IdFielName ) throws Exception<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{$s_ClassName}ReadDto o{$s_ClassName}ReadDto = new {$s_ClassName}ReadDto();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{$s_ClassName} o{$s_ClassName} = o{$s_ClassName}Repository.findById( $s_IdFielName ).orElseThrow( () -> new ResourceNotFoundException( \"Codigo no encontrado: \" + $s_IdFielName ) );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."oMapper.map( o{$s_ClassName}, o{$s_ClassName}ReadDto );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return o{$s_ClassName}ReadDto;<br>";
        $s_PhpCode .= $s_Tab."}<br>";
        $s_PhpCode .= "}";

        $s_NombreRepo    = "repositorio";
        $s_NombreJavaSrc = "service";
        if ( !file_exists( $s_NombreRepo ) )
        {
            mkdir( $s_NombreRepo );
        }
        if ( !file_exists( $s_NombreRepo."/".$s_NombreJavaSrc ) )
        {
            mkdir( $s_NombreRepo."/".$s_NombreJavaSrc );
        }
        $i_archivo = fopen( $s_NombreRepo."/".$s_NombreJavaSrc."/".$s_FileName, "w" );
        $s_clase = $s_PhpCode."<br>";
        $s_clase = str_replace( "<br>", "\n", $s_clase);
        $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase);
        $s_clase = str_replace( "&nbsp;", " ", $s_clase);
        fputs ( $i_archivo, $s_clase );
        fclose( $i_archivo );*/
        ?>
        <!--<div style = "margin: 5px 20px 20px;">
            <div class= "smallfont" style = "margin-bottom: 2px;">codigo XML: <?php echo $s_FileName; ?></div>
            <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 60%; text-align: left;">
                <pre style = "white-space: nowrap;" lang="xml">
                    <code lang="xml"><?php echo $s_PhpCode ?></code>
                </pre>
            </div>
        </div>-->
        <?php
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    }
}





