<?php
/*
Pendientes:
- FN: Asociar tablas relacionadas (join)
- BN: Crear atributos de tablas relacionadas
- BN: Validar matriz de objetos de tablas relacionadas.
*/

function clearText( $s_Text )
{
    $s_Text = str_replace( "á", "a", $s_Text );
    $s_Text = str_replace( "é", "e", $s_Text );
    $s_Text = str_replace( "í", "i", $s_Text );
    $s_Text = str_replace( "ó", "o", $s_Text );
    $s_Text = str_replace( "ú", "u", $s_Text );
    $s_Text = str_replace( "ñ", "n", $s_Text );
    $s_Text = str_replace( "\n", " ", $s_Text );
    return $s_Text;
}

include_once 'functions.php';

/*
Generacion de librerias de la capa dispatcher v2.1:
===================================================
- BaseBN ( abstract )..................: Establece y recupera el valor de los campos
    |
    +- BN ( extends )..................: Para que el usuario pueda redefinir la clase
    |    |
    |    +- BaseBV ( abstract )........: Valida el tipo de dato y establece el valor del campo
    |        |
    |        +- BV ( extends ).........: Para que el usuario pueda redefinir la clase
    |            |
    |            + BaseDP ( abstract ).: Realiza el mantenimiento de la tabla ( save, update, delete )
    |                |
    |                +- DP ( extends ).: Para que el usuario pueda redefinir la clase
    |
    +- BaseFN ( abstract ).............: Realiza la busqueda de los registros
        |
        +- FN ( extends )..............: Para que el usuario pueda redefinir la clase
*/
?>

<style> 
    body{ color: #000000; font: 12px "Lucida Sans Unicode", "Lucida Sans", "Lucida Grande", Malayalam, Verdana, sans-serif;    margin: 10px 0px 0px 0px; padding: 0px; }
    .alt2, .alt2Active{    background: #EEE; color: #000000; }
    .smallfont{    font: 11px verdana, geneva, lucida, 'lucida grande', arial, helvetica, sans-serif; }
</style>

<?php
if ( !isset( $_GET[ "folder" ] ) || $_GET[ "folder" ] == "" 
    || !isset( $_GET[ "file" ] ) || $_GET[ "file" ] == "" 
    || !isset( $_GET["output" ] ) || ( $_GET[ "output" ] !== "BBN" && $_GET[ "output" ] !== "BN" 
        && $_GET[ "output" ] !== "BBV" && $_GET[ "output" ] !== "BV" 
        && $_GET[ "output" ] !== "BDP" && $_GET[ "output" ] !== "DP" 
        && $_GET[ "output" ] !== "BFN" && $_GET[ "output" ] !== "FN" ) )
{
?>
    <table width = "100%" border = "1">
        <tr>
            <td>
            Se requiere de los siguientes par&aacute;metros:<br/>
            - folder = [ carpeta donde se ubica el archivo XML ]<br/>
            - file   = [ Archivo XML ]<br/>
            - output = [ BBN = Base Single Bean | BBV = Base Bean Valid (model) | BDP = Base Dispatcher | BFN = Base Find] | [BN = Single Bean | BV = Bean Valid (model) | DP = Dispatcher | FN = Find ]
    </tr>
  </table><?php
  exit;
}
/* obtenemos la estructura del modelo (Erwin) */
$s_folderRead = $_GET[ "folder" ];
$s_fileXML    = $_GET[ "file" ];

$a_Model = array();
$a_Model[ "entity" ] = array();

$fh = fopen( $s_folderRead . DIRECTORY_SEPARATOR . $s_fileXML, 'r' );

$a_Lst = array();

while ( ! feof( $fh ) )
{
    $row = fgetcsv( $fh );
    if( is_array( $row ) )
    {
        $a_Lst[] = $row;
    }
}

fclose( $fh );

$i_Entity = 0;

$a_Name = explode( ".", $s_fileXML );
$s_NameTable = $a_Name[0];

//$a_Model[ "entity" ][ $i_Entity ][ "id_xml" ]        = ( string ) $o_Entity->EntityProps->Long_Id;
$a_Model[ "entity" ][ $i_Entity ][ "name_entity" ]   = $s_NameTable;
$a_Model[ "entity" ][ $i_Entity ][ "name" ]          = $s_NameTable;
$a_Model[ "entity" ][ $i_Entity ][ "physical_name" ] = $s_NameTable;
$a_Model[ "entity" ][ $i_Entity ][ "column" ]        = array();

//pr( $a_Model );
array_shift( $a_Lst );

foreach ( $a_Lst as $a_FieldNam )
{
    $s_NameLogic    = $a_FieldNam[0];
    $s_NamePhysical = $a_FieldNam[0];
    
    $i_Column = $s_NameLogic;
    
    $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "name" ]          = $s_NameLogic;
    $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "physical_name" ] = $s_NamePhysical;
    
    $s_DataType = $a_FieldNam[1];
    $s_DataType = str_replace( ")", "", $s_DataType );
    $s_DataType = str_replace( "(", ",", $s_DataType );
    $s_DataType = trim( $s_DataType );
    $aDataType = explode( ",", $s_DataType );
    
    $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "primary" ]     = false;
    $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ]    = strtolower( $aDataType[ 0 ] );
    //$a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "domain" ]      = ( string ) $o_Attribute->AttributeProps->Parent_Domain_Ref;
    //$a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "length" ]      = $aDataType[ 1 ];
    //$a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "decimal" ]     = $aDataType[ 2 ];
    $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "not_null" ]    = $a_FieldNam[2];
    //$a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "valid" ]       = ( string ) $o_Attribute->AttributeProps->Validation_Rule_Ref;
    //$a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "default" ]     = ( string ) $o_Attribute->AttributeProps->Default;
    //$a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "definition" ]  = ( string ) $o_Attribute->AttributeProps->Definition;
    $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "show" ]        = true;
    
    switch ( strtolower( $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] ) )
    {
        case "number":
        case "float":
        case "decimal":
        case "numeric":
        case "double":
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = "float";
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "";
            break;
        case "real":
        case "integer":
        case "int":
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = "integer";
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "";
            break;
        case "bigint":
        case "smallint":
        case "tinyint":
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = "boolean";
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "";
            break;
        case "datetime":
        case "date":
        case "timestamp":
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = "datetime";
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'";
            break;
        case "text":
        case "char":
        case "varchar":
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = "string";
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'";
            break;
        case "blob":
        default:
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "datatype" ] = "no-definido";
            $a_Model[ "entity" ][ $i_Entity ][ "column" ][ $i_Column ][ "delimiter" ] = "'";
            break;
    }

}

/* construimos el codigo php */
$s_Tab = "&nbsp;&nbsp;&nbsp;&nbsp;";
$sp  = "&nbsp;";
$s_Base = "Base";
$s_Concat = "";
foreach ( $a_Model[ "entity" ] as $o_Entity )
{
    $s_PhpEntityFile    = $o_Entity[ "name" ].".php";
    $s_PhpEntityClass   = $o_Entity[ "name_entity" ];
    $s_PhpClassBN       = $o_Entity[ "name" ].'BN';
    $s_PhpClassFN       = $o_Entity[ "name" ].'FN';
    $s_PhpClassDP       = $o_Entity[ "name" ].'DP';
    $s_PhpClassBaseBN   = $s_Base.$o_Entity[ "name" ].'BN';
    $s_PhpClassBaseFN   = $s_Base.$o_Entity[ "name" ].'FN';
    $s_PhpClassBaseDP   = $s_Base.$o_Entity[ "name" ].'DP';
    
    $s_PhpCode =  "/**<br>";
    $s_PhpCode .= "$sp*<br>";
    $s_PhpCode .= "$sp*$sp@author William L. Taype Perez<br>";
    //$s_PhpCode .= "$sp*$sp@filesource $s_PhpFileName<br>";
    $s_PhpCode .= "$sp*$sp@schema  ".$_GET[ "file" ]."<br>";
    $s_PhpCode .= "$sp*$sp@version 1.1<br>";
    $s_PhpCode .= "$sp*$sp@date ".date( "Y-m-d H:i:s" )."<br>";
    $s_PhpCode .= "$sp*<br>";
    $s_PhpCode .= "$sp*/<br>";
    
    ////////////////////////////////////////////////////////// BBN //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "BBN" )
    {
        $s_PhpFileName = $s_PhpClassBaseBN.".class.php";
        
        /* concatenamos el codigo php ( class )  */
        $s_PhpCode .= "abstract class ".$s_PhpClassBaseBN."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= $s_Tab."/* Campos de la tabla */<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab."protected \$".( $a_Column[ "name" ] ).";  <br>";
        }
        $s_PhpCode .= "<br>";
        
        /* concatenamos el codigo php ( set y get ) */
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab."/* Establece el valor del campo ".$a_Column[ "name" ]." */<br>";
            $s_PhpCode .= $s_Tab."public function set".( $a_Column[ "name" ] )."( \$".( $a_Column[ "name" ] )." )<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."\$this->".( $a_Column[ "name" ] )." = \$".( $a_Column[ "name" ] ).";<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
            $s_PhpCode .= $s_Tab."/* Obtiene el valor del campo ".$a_Column[ "name" ]." */<br>";
            $s_PhpCode .= $s_Tab."public function get".( $a_Column[ "name" ] )."()<br>";
            $s_PhpCode .= $s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."return \$this->".( $a_Column[ "name" ] ).";<br>";
            $s_PhpCode .= $s_Tab."}<br><br>";
        }
        
        /* concatenamos el codigo php ( retrieveByRs ) */
        $s_PhpCode .= $s_Tab."/* Recupera un objeto ".( $o_Entity[ "name" ] )."BN desde un RecordSet */<br>";
        $s_PhpCode .= $s_Tab."public static function retrieveByRs( \$o_".( $o_Entity[ "name" ] )."Rs )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_".( $o_Entity[ "name" ] )."BN = new ".( $o_Entity[ "name" ] )."BN();<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_Field = "\$o_".( $o_Entity[ "name" ] )."Rs[ \"".( $a_Column[ "name" ] )."\" ]";
            $s_PhpCode .= $s_Tab.$s_Tab."\$o_".( $o_Entity[ "name" ] )."BN->set".( $a_Column[ "name" ] )."( ".$s_Field." );<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return \$o_".( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab."}<br>";
        
        /* fin de la concatenacion del codigo php */
        $s_PhpCode .= "}";
    }
    
    ////////////////////////////////////////////////////////// BN //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == 'BN' )
    {
        $s_PhpFileName = $s_PhpClassBN.".class.php";

        $s_PhpCode .= "class ".$s_PhpClassBN." extends ".$s_PhpClassBaseBN."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }
    ////////////////////////////////////////////////////////// BDP //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "BDP" )
    {
        $s_PhpFileName = $s_PhpClassBaseDP.".class.php";
        
        $s_PhpCode .= "abstract class {$s_PhpClassBaseDP} extends {$s_PhpClassBN}<br>";
        $s_PhpCode .= "{<br>";

        $s_PhpCode .= $s_Tab."protected \$o_Resource;<br>";

        $s_PhpCode .= $s_Tab."public function setResource( \$v )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->o_Resource = \$v;<br>";
        $s_PhpCode .= $s_Tab."}<br>";

        $s_PhpCode .= $s_Tab."public function getResource()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if( is_null( \$this->o_Resource ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"No se encuentra seteado la conexion.\" );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$this->o_Resource;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        // concatenamos el codigo php ( __construct )
        $s_PhpCode .= $s_Tab."public function __construct( {$s_PhpClassBN} \$o_{$s_PhpClassBN} = null )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$o_{$s_PhpClassBN} ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$this->setByBN( \$o_{$s_PhpClassBN} );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        //SECCION setByBN()
        $s_PhpCode .= $s_Tab."public function setByBN( {$s_PhpClassBN} \$o_{$s_PhpClassBN} = null )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$o_{$s_PhpClassBN} ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."if ( !is_null( \$o_{$s_PhpClassBN}->get{$a_Column["name"]}() ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."\$this->set{$a_Column["name"]}( \$o_{$s_PhpClassBN}->get{$a_Column["name"]}() );<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
            //not_null
            if( $a_Column["not_null"] == "" )
            {
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."else<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."{<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El Campo {$a_Column["name"]} no puede ser Nulo. \" );<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."}<br>";
            }
        }
        $s_PhpCode .= $s_Tab.$s_Tab."}<br><br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        
        //BLOQUE DEL METODO save()
        $s_PhpCode .= $s_Tab."public function save()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery1 = \"INSERT INTO {$o_Entity[ "physical_name" ]} ( \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery2 = \"VALUES ( \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$this->get".( $a_Column[ "name" ] )."() ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery1 .= \$s_Separator.\"".$a_Column[ "physical_name" ]."\";<br>";
            switch( $a_Column['datatype'] )
            {
                case "datetime":
                    $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery2 .= \$s_Separator . \"to_date(".$a_Column[ "delimiter" ]."\".\$this->get".( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ].",'dd/mm/yyyy hh24:mi:ss')\";<br>";
                break;
                default:
                    $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery2 .= \$s_Separator.\"".$a_Column[ "delimiter" ]."\".\$this->get".( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]."\";<br>";
                break;
            }
            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \", \";<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
            if( $a_Column["not_null"] == "" )
            {
                $s_PhpCode .= $s_Tab.$s_Tab."else<br>";
                $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El Campo {$a_Column["name"]} no puede ser Nulo. \" );<br>";
                $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
            }
        }
        
        $s_ConcatenarReturn = "";
        
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \$s_SQLQuery1.\" ) \".\$s_SQLQuery2.\" ){$s_ConcatenarReturn} \";<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab."\$o_DBC_Connection = Conexion::getConexion( \"oracleprb\" );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_DBC_Connection = \$this->getResource();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$i_Rows_Affected = \$o_DBC_Connection->executeUpdate( \$s_SQLQuery );<br>";
        
        $s_PhpCode .= $s_Tab.$s_Tab."return \$i_Rows_Affected;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        //BLOQUE DEL METODO update()
        $s_PhpCode .= $s_Tab."public function update()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        
        
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery = \"UPDATE ".$o_Entity[ "physical_name" ]." SET \";<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_Separator = \"\";<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( \$this->get".( $a_Column[ "name" ] )."() ) )<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
            switch( $a_Column['datatype'] )
            {
                case "datetime":
                    $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$s_Separator.\"".$a_Column[ "physical_name" ]." = to_date( ".$a_Column[ "delimiter" ]."\".\$this->get".( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ].", 'dd/mm/yyyy hh24:mi:ss' )\";<br>";
                break;
                default:
                    $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_SQLQuery .= \$s_Separator.\"".$a_Column[ "physical_name" ]." = ".$a_Column[ "delimiter" ]."\".\$this->get".( $a_Column[ "name" ] )."().\"".$a_Column[ "delimiter" ]."\";<br>";
                break;
            }

            $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."\$s_Separator = \", \";<br>";
            $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
            if( $a_Column["not_null"] == "" )
            {
                $s_PhpCode .= $s_Tab.$s_Tab."else<br>";
                $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
                $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"El Campo {$a_Column["name"]} no puede ser Nulo. \" );<br>";
                $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
            }
        }
        $s_PhpCode .= $s_Tab.$s_Tab."\$s_SQLQuery .= \" WHERE IDCABTRA = \".\$this->getFacturaId().\"\";<br>";
        //$s_PhpCode .= $s_Tab.$s_Tab."\$o_DBC_Connection = Conexion::getConexion( \"oracleprb\" );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_DBC_Connection = \$this->getResource();<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$i_Rows_Affected = \$o_DBC_Connection->executeUpdate( \$s_SQLQuery );<br>";
        
        $s_PhpCode .= $s_Tab.$s_Tab."return \$i_Rows_Affected;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";
        
        //BLOQUE DEL METODO delete()
        $s_PhpCode .= $s_Tab."public function delete()<br>";
        $s_PhpCode .= $s_Tab."{<br>";

        $s_PhpCode .= $s_Tab.$s_Tab."return true;<br>";
        $s_PhpCode .= $s_Tab."}<br>";
        $s_PhpCode .= "}";
    }
    ////////////////////////////////////////////////////////// DP //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "DP" )
    {
        $s_PhpFileName = $s_PhpClassDP.".class.php";

        /* concatenamos el codigo php ( class ) */
        $s_PhpCode .= "class ".$s_PhpClassDP." extends ".$s_PhpClassBaseDP."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }
    ////////////////////////////////////////////////////////// BFN //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "BFN" )
    {
        $s_PhpFileName = $s_PhpClassBaseFN.".class.php";
        
        /* concatenamos el codigo php ( class ) */
        $s_PhpCode .= "abstract class {$s_PhpClassBaseFN} extends {$s_PhpClassBN}<br>";
        $s_PhpCode .= "{<br>";

        $s_PhpCode .= $s_Tab."protected \$o_Resource;<br>";

        $s_PhpCode .= $s_Tab."public function setResource( \$v )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$this->o_Resource = \$v;<br>";
        $s_PhpCode .= $s_Tab."}<br>";

        $s_PhpCode .= $s_Tab."public function getResource()<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."if( is_null( \$this->o_Resource ) )<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab.$s_Tab."throw new Exception( \"No se encuentra seteado la conexion.\" );<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."}<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."return \$this->o_Resource;<br>";
        $s_PhpCode .= $s_Tab."}<br><br>";

        /* concatenamos el codigo php ( insertObjectBN ) */
        $s_PhpCode .= $s_Tab."/* Devuelve un objeto ".( $o_Entity[ "name" ] )."BN desde un objeto propel */<br>";
        $s_PhpCode .= $s_Tab."public function insertObjectBN( \$o_{$o_Entity[ "name" ]} )<br>";
        $s_PhpCode .= $s_Tab."{<br>";
        $s_PhpCode .= $s_Tab.$s_Tab."\$o_".( $o_Entity[ "name" ] )."BN = new ".( $o_Entity[ "name" ] )."BN();<br>";
        foreach ( $o_Entity[ "column" ] as $a_Column )
        {
            $s_Field1 = "\$o_".( $o_Entity[ "name" ] )."->".$a_Column[ "name" ]."";
            
            $s_PhpCode .= $s_Tab.$s_Tab."if ( !is_null( $s_Field1 ) ) \$o_{$o_Entity[ "name" ]}BN->set{$a_Column[ "name" ]}( $s_Field1 );<br>";
        }
        $s_PhpCode .= $s_Tab.$s_Tab."return \$o_".( $o_Entity[ "name" ] )."BN;<br>";
        $s_PhpCode .= $s_Tab."}<br>";
        
        $s_PhpCode .= "}";
    }
    ////////////////////////////////////////////////////////// FN //////////////////////////////////////////////////////////
    if ( $_GET[ "output" ] == "FN" )
    {
        $s_PhpFileName = $s_PhpClassFN.".class.php";
        
        /* concatenamos el codigo php ( class ) */
        $s_PhpCode .= "class ".$s_PhpClassFN." extends ".$s_PhpClassBaseFN."<br>";
        $s_PhpCode .= "{<br>";
        $s_PhpCode .= "}";
    }
    ////////////////////////////////////////////////////////// FILE //////////////////////////////////////////////////////////
    list( $s_NombreXml, $sExtencionXml ) = explode( ".", $s_fileXML );
    if ( !file_exists( $s_NombreXml ) )
    {
        mkdir( $s_NombreXml );
    }
    if ( !file_exists( $s_NombreXml."/".strtolower( $_GET[ "output" ] ) ) )
    {
        mkdir( $s_NombreXml."/".strtolower( $_GET[ "output" ] ) );
    }
    
    $i_archivo = fopen( $s_NombreXml."/".strtolower( $_GET[ "output" ] )."/".$s_PhpFileName, "w" );
    $s_clase = "<?php<br>".$s_PhpCode."<br>?>";
    $s_clase = str_replace( "<br>", "\n", $s_clase);
    $s_clase = str_replace( "&nbsp;&nbsp;&nbsp;&nbsp;", "    ", $s_clase );
    $s_clase = str_replace( "&nbsp;", " ", $s_clase);
    fputs ( $i_archivo, $s_clase );
    fclose( $i_archivo );
    ?>
    <div style = "margin: 5px 20px 20px;">
    <div class= "smallfont" style = "margin-bottom: 2px;">codigo PHP: <?php echo $s_PhpFileName; ?></div>
    <div class= "alt2" dir= "ltr" style = "border: 1px inset ; margin: 0px; padding: 6px; overflow: auto; width: 100%; height: 90%; text-align: left;">
    <code style = "white-space: nowrap;">
    <code><?php echo $s_PhpCode ?></code>
    </code>
    </div>
    </div>
    <?php
}
?>