<?php
define( 'SF_ROOT_DIR', "../../../" );
//define( 'SF_ROOT_DIR', realpath( dirname( __FILE__ ) ) );
define( 'SF_APP',      'sys' );
define( 'SF_DEBUG',    false );
require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );
set_memory_max_time();

error_reporting( E_ALL );
ini_set( 'display_errors', TRUE );
ini_set( 'display_startup_errors', TRUE );
date_default_timezone_set( 'Europe/London');
define( 'EOL', ( PHP_SAPI == 'cli' ) ? PHP_EOL : '<br />' );

set_header_utf8();

//----------------------------------------------------------------------------------------------------------------------------------------------------------
/** Include PHPExcel */
require_once 'PHPExcel-1.8/Classes/PHPExcel.php';
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
if( !isset( $_REQUEST['archivo'] ) )
{
    pr( "Se necesita el parametro [archivo=]" );
    exit;
}
if( isset( $_REQUEST['archivo'] ) && trim( $_REQUEST['archivo'] ) == "" )
{
    pr( "Se necesita el parametro [archivo=]" );
    exit;
}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
PARA LIMPIAR ANTES DE REALIZAR LA CARGA INICIAL
PARA REALIZAR UNA TRANSACCION DE STOCK INICIAL SE HACE UN DIA ATRAS

UPDATE GSS_Compania SET FechaCreacion=now();
UPDATE SEG_Usuario SET UsuarioPassword=md5(123), UsuarioContrasenia='123' WHERE IdUsuario='admin';

UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='ALM' AND IdSerie='ITEM';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=500 WHERE IdTipocomprobante='VTA' AND IdSerie='ORD';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='VTA' AND IdSerie='CAB';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='VTA' AND IdSerie='M';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=0 WHERE IdTipocomprobante='RECIBO' AND IdSerie='FCO';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=0 WHERE IdTipocomprobante='APLICA' AND IdSerie='FCO';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=0 WHERE IdTipocomprobante='REPINV' AND IdSerie='ALM';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=0 WHERE IdTipocomprobante='REGLOG' AND IdSerie='HIST';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='SER' AND IdSerie='CAB';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='SER' AND IdSerie='DET';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='AL' AND IdSerie='TR';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='SERIE' AND IdSerie='PRSE';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='SERIE' AND IdSerie='SERI';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='USUSES' AND IdSerie='SEG';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='CTRINT' AND IdSerie='TIPO';
UPDATE GSS_CorrelativoMast SET CorrelativoNumero=100 WHERE IdTipocomprobante='OBLIGA' AND IdSerie='CP';

DELETE FROM ALM_ItemMast;
DELETE FROM ALM_Marca WHERE IdMarca<>'0';

DELETE FROM ALM_ItemAlmacenStock;
DELETE FROM ALM_ItemStockDetHis;
DELETE FROM ALM_Kardex;
DELETE FROM ALM_OrdenGuiaFactura;
DELETE FROM ALM_RequerimientoCabecera;
DELETE FROM ALM_RequerimientoDetalle;
DELETE FROM ALM_RequerimientoDetalleLog;
DELETE FROM COM_OrdenCompraCabecera;
DELETE FROM COM_OrdenCompraDetalle;
DELETE FROM ALM_TransaccionCabecera;
DELETE FROM ALM_TransaccionDetalle;
DELETE FROM ALM_TransParaRepInv;
DELETE FROM MST_ItemUbicacion;
DELETE FROM ALM_Lote;

DELETE FROM SEG_UsuarioSesion;
DELETE FROM MST_ClaseFamilia WHERE IdFamilia<>'0';
DELETE FROM MST_ClaseLinea WHERE IdLinea<>'0';
DELETE FROM MST_ClaseSubFamilia;
DELETE FROM MST_ListaPrecioDetalle;
DELETE FROM VTA_PrsProyectos;

DELETE FROM RegistroHistorial;
DELETE FROM CP_Obligaciones;
DELETE FROM CP_Aplicacion;
DELETE FROM CP_DocRecibo;
DELETE FROM FCO_Aplicacion;
DELETE FROM FCO_Cierre;
DELETE FROM FCO_DocRecibo;
DELETE FROM VTA_Orden;
DELETE FROM VTA_OrdenDetalle;
DELETE FROM VTA_OrdenArchivos;
DELETE FROM VTA_Documento;
DELETE FROM VTA_DocumentoDetalle;
DELETE FROM VTA_DocumentoCuotas;
DELETE FROM VTA_FacturacionElectronica;
DELETE FROM SR_Movimiento;
DELETE FROM SR_MovimientoDetalle;
DELETE FROM SR_GuiaRemisionH;
DELETE FROM SR_GuiaRemisionDet;
DELETE FROM SR_Serie;
DELETE FROM SR_SerieEscaneo;
DELETE FROM SR_PreSerie;
DELETE FROM SR_PreSerieEscaneo;
DELETE FROM SR_CotizacionDevolucionCab;
DELETE FROM STE_ServicioTecnico;
DELETE FROM PRD_OrdenCab;
DELETE FROM PRD_OrdenDet;
DELETE FROM PR_Grupo;
DELETE FROM PR_ListaItem;
DELETE FROM PLA_MarcacionEmpleado;

DELETE FROM MST_PersonaMast WHERE IdPersona NOT IN (249,260);
DELETE FROM MST_ClienteMast WHERE IdCliente NOT IN (260);
DELETE FROM MST_PersonaEmpleado WHERE IdPersona NOT IN (249);
DELETE FROM VTA_Vendedor WHERE IdPersona NOT IN (249);
DELETE FROM SEG_Usuario WHERE IdUsuario NOT IN ('admin');
DELETE FROM SEG_UsuarioCompania WHERE IdUsuario NOT IN ('admin');
DELETE FROM SEG_SucursalUsuario WHERE IdUsuario NOT IN ('admin');
DELETE FROM FCO_CajaUsuario WHERE IdUsuario NOT IN ('admin') AND IdCaja NOT IN (1);
DELETE FROM FCO_Caja WHERE IdCaja NOT IN (1);
DELETE FROM GSS_UsuarioSucuDocumento WHERE IdUsuario NOT IN ('admin');
DELETE FROM GSS_Sucursal WHERE IdSucursal NOT IN (1);
DELETE FROM ALM_AlmacenMast WHERE IdAlmacen NOT IN ('A1101');

DELETE FROM MST_PersonaMast WHERE IdPersona NOT IN (249,260);
DELETE FROM MST_ClienteMast WHERE IdCliente NOT IN (260);
DELETE FROM MST_PersonaEmpleado WHERE IdPersona NOT IN (249);
DELETE FROM VTA_Vendedor WHERE IdPersona NOT IN (249);
DELETE FROM SEG_Usuario WHERE IdUsuario NOT IN ('admin');
DELETE FROM SEG_UsuarioCompania WHERE IdUsuario NOT IN ('admin');
DELETE FROM SEG_SucursalUsuario WHERE IdUsuario NOT IN ('admin');
DELETE FROM FCO_CajaUsuario WHERE IdUsuario NOT IN ('admin') AND IdCaja NOT IN (1);
DELETE FROM FCO_Caja WHERE IdCaja NOT IN (1);
DELETE FROM GSS_UsuarioSucuDocumento WHERE IdUsuario NOT IN ('admin');
DELETE FROM GSS_SucursalDocumento WHERE IdSucursal NOT IN (1);
DELETE FROM GSS_SucursalDocumento WHERE SerieFormato LIKE '%002';

REPLACE INTO ALM_Marca(IdMarca, DescripcionLocal, DescripcionIngles, Persona, Estado, UsuarioCreacion, FechaCreacion) VALUES('0', 'SIN MARCA', 'SIN MARCA', null, 'A', 'admin', NOW() );
REPLACE INTO MST_ClaseLinea(IdLinea, Descripcion, Codigo, Estado, FechaCreacion, UsuarioCreacion) VALUES (0, 'SIN LINEA', 'SIN01', 'A', NOW(), 'admin');
REPLACE INTO MST_ClaseFamilia(IdFamilia, IdLinea, Descripcion, Codigo, Estado, FechaCreacion, UsuarioCreacion) VALUES (0, 0, 'SIN FAMILIA', 'SI00', 'A', NOW(), 'admin');

-- SOLO PARA ELIMINAR LOS DOCUMENTOS DE VENTA:
DELETE FROM FCO_Aplicacion;
DELETE FROM FCO_Cierre;
DELETE FROM FCO_DocRecibo;
DELETE FROM RegistroHistorial;
DELETE FROM SR_Movimiento;
DELETE FROM SR_MovimientoDetalle;
DELETE FROM VTA_Orden;
DELETE FROM VTA_OrdenDetalle;
DELETE FROM VTA_Documento;
DELETE FROM VTA_DocumentoDetalle;
DELETE FROM VTA_DocumentoCuotas;
DELETE FROM VTA_FacturacionElectronica;
DELETE FROM VTA_ProductoFinalDet;
DELETE FROM VTA_ProductoFinal;

UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=1;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=2;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=5;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=6;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=7;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=8;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=9;
UPDATE GSS_SucursalDocumento SET NumeroActual=0 WHERE IdSucursalDocumento=10;

INSERT INTO `MST_ClienteMast` (`IdCliente`, `Clasificacion`, `LineaCredito`, `IngresoMensual`, `Vendedor`, `VendedorCod`, `FormadePago`, `TotalAcumulado`, `TipoServicio`, `NumeroDiasCobranza`, `PagoEfectivoFlag`, `TipoFacturacion`, `TipoVenta`, `FormaFacturacion`, `TipoCliente`, `CentroCosto`, `CodCanal`, `CreditoHold`, `UsuarioModificacion`, `FechaModificacion`, `UsuarioCreacion`, `FechaCreacion`)
VALUES (250, NULL, NULL, NULL, 249, 'admin', NULL, NULL, NULL, NULL, NULL, NULL, '1', NULL, NULL, NULL, '1', 'NO', 'admin', now(), 'admin', now());
INSERT INTO `MST_PersonaMast` (`IdPersona`, `IdCompania`, `ApellidoPaterno`, `ApellidoMaterno`, `Nombres`, `NombreCompleto`, `NombreComercial`, `Contacto`, `TipoDocumento`, `Documento`, `CodigoBarras`, `EsCliente`, `EsProveedor`, `EsEmpleado`, `EsOtro`, `TipoPersona`, `FechaNacimiento`, `CiudadNacimiento`, `Sexo`, `Nacionalidad`, `PaisId`, `PaisDesc`, `EstadoCivil`, `NivelInstruccion`, `Direccion`, `CodigoPostal`, `Provincia`, `Departamento`, `Distrito`, `Telefono`, `Celular`, `Email`, `DireccionWeb`, `Fax`, `DocumentoIdentidad`, `CarnetExtranjeria`, `DocumentoMilitarFA`, `TipoBrevete`, `Brevete`, `Pasaporte`, `EsAgenteRetenedor`, `IdRetencion`, `Estado`, `UsuarioModificacion`, `FechaModificacion`, `UsuarioCreacion`, `FechaCreacion`, `IdUsuario`, `ProveedorGuiasFlag`, `EmpleadoVendedorFlag`)
VALUES (250, 1, 'VARIOS', '', 'CLIENTE', 'CLIENTE VARIOS', NULL, '', 'DNI', '00000000', NULL, 'SI', 'NO', 'NO', 'NO', 'N', '2022-12-17 00:00:00', NULL, 'M', '', '9589', 'PERU', NULL, NULL, 'MZA. H LOTE. 7 SEC. 2 BARRIO 3 - 4TA ETAPA LIMA - LIMA - VILLA EL SALVADOR', NULL, '150100', '150000', '150101', '', '', '', '', NULL, '', NULL, NULL, NULL, NULL, NULL, 0, 0, 'A', 'admin', now(), 'admin', now(), NULL, 'N', 'N');




UPDATE FCO_CajaUsuario SET `IdUsuario` = 'gparedes' WHERE IdUsuario='u-gparedes';
UPDATE FCO_CajaUsuario SET `IdUsuario` = 'gcalle' WHERE IdUsuario='u-gcalle';
UPDATE GSS_UsuarioSucuDocumento SET `IdUsuario` = 'gparedes' WHERE IdUsuario='u-gparedes';
UPDATE GSS_UsuarioSucuDocumento SET `IdUsuario` = 'gcalle' WHERE IdUsuario='u-gcalle';
UPDATE SEG_SucursalUsuario SET `IdUsuario` = 'gparedes' WHERE IdUsuario='u-gparedes';
UPDATE SEG_SucursalUsuario SET `IdUsuario` = 'gcalle' WHERE IdUsuario='u-gcalle';
UPDATE SEG_Usuario SET `IdUsuario` = 'gparedes' WHERE IdUsuario='u-gparedes';
UPDATE SEG_Usuario SET `IdUsuario` = 'gcalle' WHERE IdUsuario='u-gcalle';
UPDATE SEG_UsuarioCompania SET `IdUsuario` = 'gparedes' WHERE IdUsuario='u-gparedes';
UPDATE SEG_UsuarioCompania SET `IdUsuario` = 'gcalle' WHERE IdUsuario='u-gcalle';

------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


MARKETPLACE:
SELECT
  minicodigo COD_INTERTNO_1, IF(descripcion_corto='',nombre,descripcion_corto) DESCRIPCION, 'UNIDAD' UNI_VENTA, 'UNIDAD' UNI_COMPRA, '10' TIPO_IGV,
  marca_desc MARCA, item_tipo_desc LINEA, linea_prod_desc FAMILIA, 'GENERICO' SUB_FAMILIA, '' COD_SUNAT, '' COD_BARRAS, '' PESO,
  ROUND(precio_sol,2) COSTO, ROUND((precio_sol*(1+(porcentaje/100))),2) PRECIO_VENTA,
  '' LOTE, '1' COMPANIA, '' COD_INTERNO_2, '0' STOCK, 'A1101' ALMACEN, '' FECHA, '' PRECIO_2, '' PRECIO_3, numero_parte Part_Number
FROM producto
  LEFT JOIN regla_precios ON producto.item_tipo_id=regla_precios.id
;

*/
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

$archivo = trim( $_REQUEST['archivo'] );

if ( !file_exists( $archivo ) )
{
    pr( "EL nombre del archivo [$archivo] no existe." );
    exit;
}

$inputFileType = PHPExcel_IOFactory::identify( $archivo );
$objReader     = PHPExcel_IOFactory::createReader( $inputFileType );
$objPHPExcel   = $objReader->load( $archivo );
$sheet         = $objPHPExcel->getSheet( 0 );
$highestRow    = $sheet->getHighestRow();
$highestColumn = $sheet->getHighestColumn();

$o_DBConnect = Conexion::getConexion();

//----------------------------------------------------------------------------------------------------------------------------------------------------------
?>
    <form method="POST" name="form1" action="" >
        <input type="hidden" name="Control" value="1">
        <input type="submit" value="GUARDAR" name="">
        <table cellspacing="0" cellspacing="0" border="1">
            <tr>
                <th>Nro</th>
                <th>EXISTE ITEM</th>
                <th>CODIGO</th>
                <th>DESCRIPCION</th>
                <!--<th>DESCRIPCION SISTEMA</th>-->
                <th>STOCK</th>
                <th>COSTO INC IGV</th>
                <th>PRECIO INC IGV</th>
                <th>ALMACEN</th>
                <th>FECHA TRX</th>
                <th>COMPANIA</th>
                <th>SUCURSAL</th>
            </tr>
            <?php
            $s_IdAlmacen  = "";
            $s_IdComania  = "";
            $s_IdSucursal = "";

            $s_FechaOriginal = "";
            $fec_vencimiento = "";

            $s_NombreComania  = "";
            $s_NombreSucursal = "";

            $o_GSS_CompaniaBN = null;

            $i = 1;
            for ( $row = 2; $row <= $highestRow; $row++ )
            {
                $nombre_producto_sistema = "";

                if( trim( $sheet->getCell( "E".$row )->getValue() ) )
                {
                    //$id_excel_prod   = strtoupper( trim( $sheet->getCell( "A".$row )->getValue() ) );
                    //$id_excel         = strtoupper( trim( $sheet->getCell( "A".$row )->getValue() ) );
                    $codigo_producto  = strtoupper( trim( $sheet->getCell( "A".$row )->getValue() ) );
                    $codigo_producto1 = strtoupper( trim( $sheet->getCell( "B".$row )->getValue() ) ); //codigo interno
                    $codigo_producto2 = strtoupper( trim( $sheet->getCell( "C".$row )->getValue() ) ); //codigo interno 2
                    $codigo_producto3 = strtoupper( trim( $sheet->getCell( "D".$row )->getValue() ) ); //Codigo Barras 2
                    $nombre_producto  = strtoupper( trim( $sheet->getCell( "E".$row )->getValue() ) );
                    $stock_producto   = ( trim( $sheet->getCell( "Q".$row )->getValue() ) );
                    $costo_producto   = round( floatval( trim( $sheet->getCell( "O".$row )->getValue() ) ), 2 ); //INCLUDO IGV
                    $precio_final     = round( floatval( trim( $sheet->getCell( "P".$row )->getValue() ) ), 2 ); //SE ASUME QUE EL PRECIO ESTA INCLUIDO EL IGV
                    $cod_almacen      = ( trim( $sheet->getCell( "S".$row )->getValue() ) );
                    $fecha_trx        = ( trim( $sheet->getCell( "T".$row )->getValue() ) );
                    //$fec_vencimiento = ( trim( $sheet->getCell( "I".$row )->getValue() ) );

                    //VALIDACIONES
                    if( $costo_producto > $precio_final )
                    {
                        //pr( "if( $costo_producto > $precio_final ) || El Producto [$codigo_producto] tiene el costo mayor que el precio" );
                    }
                    if( $costo_producto <= 0 )
                    {
                        $costo_producto = round( $precio_final / 2.5, 2 );
                    }

                    //$fec_vencimiento = date( 'Y-m-d', PHPExcel_Shared_Date::ExcelToPHP( $fec_vencimiento ) );
                    $lote_producto   = "000";
                    if( $fecha_trx )
                    {
                        $fecha_trx = date( 'Y-m-d', PHPExcel_Shared_Date::ExcelToPHP( $fecha_trx ) );
                        if( $fec_vencimiento == "" )
                        {
                            $fec_vencimiento = UtilDate::sumarDias( $fecha_trx, 30 );
                        }
                        $fecha_trx = $fecha_trx." ".date( "H:i:s" );
                    }
                    $s_IdAlmacen = $cod_almacen;
                    $s_Exite     = "NO";

                    if( intval( $stock_producto ) > 0 )
                    {
                        //SE PREGUNTA SI YA EXISTE EL PRODUCTO
                        $s_CodigoExiste   = "NO";
                        $s_CodigoProducto = "";
                        $o_ALM_ItemMastBN = null;
                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        if( $codigo_producto )
                        {
                            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $codigo_producto );
                            if( $o_ALM_ItemMastBN )
                            {
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $o_ALM_ItemMastBN->getIdItem();
                            }
                        }
                        if( $codigo_producto1 && !is_null( $o_ALM_ItemMastBN ) )
                        {
                            $o_ALM_ItemMastFN->setCodigoInterno( $codigo_producto1 );
                            $a_ALM_ItemMast   = $o_ALM_ItemMastFN->select();
                            if( $a_ALM_ItemMast )
                            {
                                $o_ALM_ItemMastBN = $a_ALM_ItemMast[0];
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $a_ALM_ItemMast[0]->getIdItem();
                            }
                        }
                        if( $codigo_producto3 && !is_null( $o_ALM_ItemMastBN ) )
                        {
                            $o_ALM_ItemMastFN->setCodigoBarras2( $codigo_producto3 );
                            $a_ALM_ItemMast   = $o_ALM_ItemMastFN->select();
                            if( $a_ALM_ItemMast )
                            {
                                $o_ALM_ItemMastBN = $a_ALM_ItemMast[0];
                                $s_CodigoExiste   = "SI";
                                $s_CodigoProducto = $a_ALM_ItemMast[0]->getIdItem();
                            }
                        }

                        //$o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $codigo_producto ); //BUSCAR POR EL CODIGO DE BARRAS.
                        if( $o_ALM_ItemMastBN )
                        {
                            if( $o_ALM_ItemMastBN->getEstado() == "I" )
                            {
                                continue;
                            }
                            $s_Exite = "SI";
                            //$nombre_producto_sistema = $o_ALM_ItemMastBN->getDescripcionCompleta();
                            $a_DataValores[] = array( "IdItem" => $o_ALM_ItemMastBN->getIdItem(), "Cantidad" => $stock_producto, "Costo" => $costo_producto, "Lote" => $lote_producto, "FechaVenci" => $fec_vencimiento, "PrecioFinal" => $precio_final );
                        }
                        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
                        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $s_IdAlmacen );
                        if( $o_ALM_AlmacenMastBN )
                        {
                            $s_IdSucursal = $o_ALM_AlmacenMastBN->getIdSucursal();
                            $s_IdComania  = $o_ALM_AlmacenMastBN->getIdCompania();

                            $s_NombreComania = $o_ALM_AlmacenMastBN->getObjectCompania()->getDescripcionCorta();
                            $s_NombreSucursal = $o_ALM_AlmacenMastBN->getDescripcionSucursal();
                        }
                        ?>
                        <tr>
                            <td align="center"><?=$i?></td>
                            <td align="center"><?=$s_Exite?></td>
                            <td align="center"><?=$codigo_producto?></td>
                            <td><?=$nombre_producto?></td>
                            <td align="center"><?=$stock_producto?></td>
                            <td align="center"><?=$costo_producto?></td>
                            <td align="center"><?=$precio_final?></td>
                            <td align="center"><?=$cod_almacen?></td>
                            <td align="center"><?=$fecha_trx?></td>
                            <td><?=$s_NombreComania?></td>
                            <td><?=$s_NombreSucursal?></td>
                        </tr>
                        <?php
                    }
                    else
                    {
                        ?>
                        <tr>
                            <td align="center"><?=$i?></td>
                            <td align="center">NO</td>
                            <td><?=$codigo_producto?></td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                        </tr>
                        <?php
                    }
                }
                $i++;
            }
            ?>
        </table>
    </form>

<?php
if( isset( $_POST['Control'] ) )
{
    //$s_IdComania                 = 1; //compania, siempre validar la carga inicial, tambien inicial sesion con el usuario de la misma compania
    $s_FechaOriginal            = $fecha_trx;
    $FechaDocumento             = $fecha_trx;
    $IdTransaccionOperacion     = "I";
    //$s_IdAlmacen                  = "ALM00001"; //ALMACEN ORIGEN --- DINAMICO - se hace el cambio por cada transaccion
    //$s_IdAlmacen                  = $_REQUEST['almacen']; //ALMACEN ORIGEN --- DINAMICO - se hace el cambio por cada transaccion
    $IdTransaccion              = "STI"; //carga inicial
    $AlmacenTraslado            = ""; //ALMACEN DE DESTINO
    $IdTipoDocumento            = "CT";

    $ReferenciaCodDocumento    = "GUI";
    $ReferenciaTipoDocumento    = "GR";
    $ReferenciaSerieDocumento   = "1"; //
    $ReferenciaNumeroDocumento  = "1"; //

    $s_SerieDocumentoFiscal     = str_pad( $ReferenciaSerieDocumento, 4, "0", STR_PAD_LEFT );
    $s_NumeroDocumentoFiscal    = str_pad( $ReferenciaNumeroDocumento, 10, "0", STR_PAD_LEFT );

    $Comentario                 = "CARGA INICIAL"; //

    if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
    {
        $s_FechaSel = date( "Y-m-d" );

        $o_iVentas = new iVentas();
        $o_iVentas->registrarTipoCambio( $s_FechaSel );
    }

    $TipodeCambio = GSS_TipoCambioFN::getStaticTipoCambioVenta();

    $o_Base_ALM_TransaccionCabeceraBN = new ALM_TransaccionCabeceraBN();
    $o_Base_ALM_TransaccionCabeceraBN->setIdTransaccion( $IdTransaccion );
    //$o_Base_ALM_TransaccionCabeceraBN->setAlmacenTraslado( $AlmacenTraslado );
    $o_Base_ALM_TransaccionCabeceraBN->setIdAlmacen( $s_IdAlmacen );
    $o_Base_ALM_TransaccionCabeceraBN->setIdTransaccionOperacion( $IdTransaccionOperacion );
    $o_Base_ALM_TransaccionCabeceraBN->setFechaDocumento( $FechaDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setTipodeCambio( floatval( $TipodeCambio ) );
    $o_Base_ALM_TransaccionCabeceraBN->setMonedaCod( "LO" );
    $o_Base_ALM_TransaccionCabeceraBN->setCodigoCliente( '249' );
    $o_Base_ALM_TransaccionCabeceraBN->setCodigoProveedor( "249" );
    $o_Base_ALM_TransaccionCabeceraBN->setDescripcion( $Comentario );

    $o_Base_ALM_TransaccionCabeceraBN->setReferenciaTipoDocumento( $ReferenciaTipoDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setReferenciaNumeroDocumento( $ReferenciaNumeroDocumento );

    $o_Base_ALM_TransaccionCabeceraBN->setIdCompania( $s_IdComania );
    $o_Base_ALM_TransaccionCabeceraBN->setIdSucursal( $s_IdSucursal );
    $o_Base_ALM_TransaccionCabeceraBN->setIdTipoDocumento( $IdTipoDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setComentario( $Comentario );

    $o_Base_ALM_TransaccionCabeceraBN->setTipoDocumentoFiscal( $ReferenciaTipoDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setCodDocumentoFiscal( $ReferenciaCodDocumento );
    $o_Base_ALM_TransaccionCabeceraBN->setSerieDocumentoFiscal( $s_SerieDocumentoFiscal );
    $o_Base_ALM_TransaccionCabeceraBN->setNumeroDocumentoFiscal( $s_NumeroDocumentoFiscal );
    /////////////////

    $s_Mensaje = "";
    $i_Id      = "X";

    pr( "GUARDAR" );

    $con = Conexion::getConexion();
    $con->begin();
    try
    {
        pr( "---------------------------------------------------------------------------------------------------------------------" );

        $o_ALM_TransaccionCabeceraBN = clone $o_Base_ALM_TransaccionCabeceraBN;

        $a_MovientoDetalle = array();
        foreach ( $a_DataValores as $i_Key => $a_Valores )
        {
            if( floatval( $a_Valores['Costo'] ) <= 0 )
            {
                pr( "No tiene Costo asignado -> ".$a_Valores['IdItem'] );
                continue;
            }

            //ENTONCES AHORA SE ASIGNA EL COSTO Y PRECIO
            $f_MontoCostoIGV = round( floatval( $a_Valores['Costo'] ), 2 );
            $f_MontoCosto    = round( ( $f_MontoCostoIGV / 1.18 ), 2 );

            $b_ControPrecio     = true;
            $f_PrecioVenta      = 0;
            $f_PrecioVentaIGV   = 0;
            $f_TotalIGV         = 0;
            if( floatval( $a_Valores['PrecioFinal'] ) > 0 )
            {
                $f_PrecioVentaIGV = round( floatval( $a_Valores['PrecioFinal'] ), 2 );
                $f_PrecioVenta    = round( ( $f_PrecioVentaIGV  / 1.18 ), 2 );
                $f_TotalIGV       = round( $f_PrecioVentaIGV - $f_PrecioVenta, 2 );
            }
            else
            {
                $b_ControPrecio = false;
            }

            $i_IdUnidadMedidaAsig = ALM_ItemMastFN::getItemUnidadVentaAsignada( $a_Valores['IdItem'] ); //UNI MEDIDA ASIGNADA

            //ahora se actualiza el costo al item
            $o_ALM_ItemMastDP = new ALM_ItemMastDP();
            $o_ALM_ItemMastDP->setIdItem( $a_Valores['IdItem'] );
            $o_ALM_ItemMastDP->setPrecioCosto( $f_MontoCosto );
            $o_ALM_ItemMastDP->setPrecioVenta( $f_MontoCostoIGV );
            //$o_ALM_ItemMastDP->setPrecioUnitarioLocal( round( floatval( $a_Valores['Costo'] ) / 1.18, 4 ) );
            //$o_ALM_ItemMastDP->setPrecioUnitarioDolares( round( floatval( $a_Valores['Costo'] ) / 1.18, 4 ) );
            $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_ItemMastDP->setUsuarioModificacion( "wtaype" );
            $o_ALM_ItemMastDP->update_varios();

            $o_ALM_TransaccionDetalleBN = new ALM_TransaccionDetalleBN();
            $o_ALM_TransaccionDetalleBN->setIdItem( $a_Valores['IdItem'] );
            $o_ALM_TransaccionDetalleBN->setCantidad( intval( $a_Valores['Cantidad'] ) );
            $o_ALM_TransaccionDetalleBN->setPrecioUnitario( $f_MontoCosto );
            $o_ALM_TransaccionDetalleBN->setLote( $a_Valores['Lote'] );
            $o_ALM_TransaccionDetalleBN->setFechaVencimiento( $a_Valores['FechaVenci'] );
            $o_ALM_TransaccionDetalleBN->setFechaVencimientoLote( $a_Valores['FechaVenci'] );
            $o_ALM_TransaccionDetalleBN->setUnidadCodigo( $i_IdUnidadMedidaAsig );

            $o_ALM_TransaccionDetalleBN->setIdTransaccionCab( $IdTransaccion );
            $o_ALM_TransaccionDetalleBN->setFechaDocumentoCab( $FechaDocumento );

            $a_MovientoDetalle[] = $o_ALM_TransaccionDetalleBN;

            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AHORA SE GUARDA EL LOG PARA POSTERIORMENTE RECUPERAR EL PRECIO
            $f_TipoCambio        = $o_ALM_TransaccionCabeceraBN->getTipodeCambio();
            $f_PrecioUnitario    = $f_MontoCosto;
            $f_PrecioUnitarioIGV = $f_MontoCostoIGV;

            if( $o_ALM_TransaccionCabeceraBN->getMonedaCod() == "LO" )
            {
                $f_PrecioUnitarioMN = $f_PrecioUnitario;
                $f_PrecioUnitarioME = round( $f_PrecioUnitario / $f_TipoCambio, 2 );

                $f_PrecioUnitarioIGVMN = $f_PrecioUnitarioIGV;
                $f_PrecioUnitarioIGVME = round( $f_PrecioUnitarioIGV / $f_TipoCambio, 2 );
            }
            if( $o_ALM_TransaccionCabeceraBN->getMonedaCod() == "EX" )
            {
                $f_PrecioUnitarioMN = round( $f_PrecioUnitario * $f_TipoCambio, 2 ) ;
                $f_PrecioUnitarioME = $f_PrecioUnitario;

                $f_PrecioUnitarioIGVMN = round( $f_PrecioUnitarioIGV * $f_TipoCambio, 2 );
                $f_PrecioUnitarioIGVME = $f_PrecioUnitarioIGV;
            }

            $i_IdRequerimientoLog = ALM_RequerimientoDetalleLogFN::recuperarId();

            $o_ALM_RequerimientoDetalleLogDP = new ALM_RequerimientoDetalleLogDP();
            $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoLog( $i_IdRequerimientoLog );
            $o_ALM_RequerimientoDetalleLogDP->setTipo( "TX" );
            $o_ALM_RequerimientoDetalleLogDP->setIdRequerimiento( intval( $o_ALM_TransaccionCabeceraBN->getIdNumeroDocumento() ) );
            $o_ALM_RequerimientoDetalleLogDP->setIdCompania( $s_IdComania );
            $o_ALM_RequerimientoDetalleLogDP->setIdSucursal( $s_IdSucursal );
            $o_ALM_RequerimientoDetalleLogDP->setIdRequerimientoDetalle( ( $i_Key + 1 ) );
            $o_ALM_RequerimientoDetalleLogDP->setIdPersona( intval( $o_ALM_TransaccionCabeceraBN->getCodigoCliente() ) );
            $o_ALM_RequerimientoDetalleLogDP->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
            $o_ALM_RequerimientoDetalleLogDP->setIdMoneda( $o_ALM_TransaccionDetalleBN->getIdMoneda() );
            $o_ALM_RequerimientoDetalleLogDP->setTipoCambio( $f_TipoCambio );
            $o_ALM_RequerimientoDetalleLogDP->setCantidad( $o_ALM_TransaccionDetalleBN->getCantidad() );

            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitario( $f_PrecioUnitario );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioMN( $f_PrecioUnitarioMN );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioME( $f_PrecioUnitarioME );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGV( $f_PrecioUnitarioIGV );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVMN( $f_PrecioUnitarioIGVMN );
            $o_ALM_RequerimientoDetalleLogDP->setPrecioUnitarioIGVME( $f_PrecioUnitarioIGVME );

            $o_ALM_RequerimientoDetalleLogDP->setUsuarioCreacion( "wtaype" );
            $o_ALM_RequerimientoDetalleLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_RequerimientoDetalleLogDP->setUsuarioModificacion( "wtaype" );
            $o_ALM_RequerimientoDetalleLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_ALM_RequerimientoDetalleLogDP->save();
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        }

        $o_ALM_TransaccionCabeceraBN->setArrayMovientoDetalle( $a_MovientoDetalle );

        //pr( $o_ALM_TransaccionCabeceraBN ); exit;

        $o_MovimientoBL = new MovimientoBL();
        $o_MovimientoBL->GuardarMovientoTransaccion( $o_ALM_TransaccionCabeceraBN );

        //AQUI SE VA APROVECHA EN HACER UN PROCEDIMIENTO PARA TOMAR UNA FOTO AL STOCK FISICO POR DIA - 20200813
        $o_ALM_ItemStockDetHisDP = new ALM_ItemStockDetHisDP();
        $o_ALM_ItemStockDetHisDP->setIdCompania( $s_IdComania );
        $o_ALM_ItemStockDetHisDP->setIdSucursal( $s_IdSucursal );
        $o_ALM_ItemStockDetHisDP->setIdFecha( $s_FechaOriginal );
        $o_ALM_ItemStockDetHisDP->deleteCompPeriodo();
        $o_ALM_ItemStockDetHisDP->realizarFotoStockFisico();

        $i_Id = $o_ALM_TransaccionCabeceraBN->getIdTransaccionCabeceraConcat();
        $s_Mensaje .= "Transaccion Id: ".$i_Id."\n";
        pr( $s_Mensaje );

        pr( "---------------------------------------------------------------------------------------------------------------------" );

        $con->commit();
    }
    catch ( Exception $o_Exception )
    {
        $con->rollback();
        pr( $o_Exception );
    }

}