<?php
/*
define( 'SF_ROOT_DIR', realpath( dirname(__FILE__).'/../' ) );
define( 'SF_APP',      'mst' );
define( 'SF_DEBUG',    true );

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'config.php' );
*/

define( 'SF_ROOT_DIR', "../" );
define( 'SF_APP',      'mst' );
define( 'SF_DEBUG',    false );

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );

try
{

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $s_OrdNum           = "M000000051";
    $i_IdOrden          = 51;

    $o_VTA_OrdenBN     = VTA_OrdenFN::findOrdenByNum( $s_OrdNum );
    $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_VTA_OrdenBN->getDocReferenciaId() ); //SE RECUPERA EL COMPROBANTE DEL CLIENTE

    $i_IdPersona        = $o_VTA_OrdenBN->getClienteId();
    $s_IdMoneda         = $o_VTA_OrdenBN->getMonedaCod(); //moneda del recibo
    $i_IdTipoPago       = 1;
    $i_IdBanco          = null;
    $i_IdCuenta         = null;
    $i_TerminoPago      = 0;
    $s_ReciboNumero     = "";
    $s_ReciboFecha      = date( "Y-m-d" );
    $s_FechaVenc        = null;
    $f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
    $s_Descripcion      = "COBRO POR FACTURA";
    $f_Monto            = 50;
    $f_SaldoMonto       = 0;
    $f_MontoSoles       = $f_Monto;
    $f_SaldoMontoSoles  = 0;
    $f_MontoDolar       = round( $f_Monto / $f_TipodeCambio, 2 );
    $f_SaldoMontoDolar  = 0;


    $f_NvoDocuPagado    = $o_VTA_DocumentoBN->getMontoTotal();
    $f_NvoDocuPagadoMN  = $o_VTA_DocumentoBN->getMontoTotal();
    $f_NvoDocuSaldo     = 0;
    $f_NvoDocuSaldoMN   = 0;



    if( $i_IdTipoPago == 1 )
    {
        $i_IdBanco = 15;
        $i_IdCuenta = 10;
    }

    //se recupera info de la moneda del recibo
    $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
    $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $s_IdMoneda );

    //los datos de tipo de pago
    $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
    $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $i_IdTipoPago );

    $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
    $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
    $s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();

    //se busca el cliente
    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

    $s_NumTipoDocCliente = $o_MST_PersonaMastBN->getDocumento();
    $s_TipoDocCliente    = $o_MST_PersonaMastBN->getTipoDocumento();
    $s_NombreCliente     = $o_MST_PersonaMastBN->getNombreCompletoLLeno();

    //ahora se busca el numero de cuenta
    $s_NumeroCuenta = null;
    if( $i_IdCuenta )
    {
        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
        $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $i_IdCuenta );
        $s_NumeroCuenta = $o_MST_CuentaBancariaBN->getNumeroCuenta();
    }

    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $o_FCO_DocReciboDP = new FCO_DocReciboDP();

    //se hace un insert
    //en el caso de una cobranza nueva
    $i_IdDocRecibo = FCO_DocReciboDP::recuperarId();

    $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );

    if( $i_IdTipoPago == 1 )
    {
        $s_ReciboNumero = ( string ) $i_IdDocRecibo;
    }
    $o_FCO_DocReciboDP->setReciboNumero( $s_ReciboNumero );
    $o_FCO_DocReciboDP->setIdCompania( myUser::getUser()->getIdBusiness() );
    $o_FCO_DocReciboDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
    $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago );
    $o_FCO_DocReciboDP->setIdMoneda( $s_IdMoneda );
    $o_FCO_DocReciboDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );
    $o_FCO_DocReciboDP->setIdBanco( $i_IdBanco );
    $o_FCO_DocReciboDP->setIdCuenta( $i_IdCuenta );
    $o_FCO_DocReciboDP->setNumeroCuenta( $s_NumeroCuenta );
    $o_FCO_DocReciboDP->setClaseNombre( $s_ClaseNombre );
    $o_FCO_DocReciboDP->setTipoCambio( $f_TipodeCambio );
    $o_FCO_DocReciboDP->setIdPersona( $i_IdPersona );
    $o_FCO_DocReciboDP->setTipoDocCliente( $s_TipoDocCliente );
    $o_FCO_DocReciboDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
    $o_FCO_DocReciboDP->setNombreCliente( $s_NombreCliente );
    $o_FCO_DocReciboDP->setDescripcion( $s_Descripcion );
    $o_FCO_DocReciboDP->setReciboFecha( $s_ReciboFecha );
    $o_FCO_DocReciboDP->setTerminoPago( $i_TerminoPago );
    $o_FCO_DocReciboDP->setFechaVencimiento( $s_FechaVenc );
    //$o_FCO_DocReciboDP->setFlujoEstado( "PE" ); //PE NDIENTE - AP ROBADO - REC HAZADO
    $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_APROBADO ); //PE NDIENTE - AP ROBADO - REC HAZADO
    $o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
    $o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
    $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO ); //AC TIVO - AN ULADO
    $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_COBRADO );
    $o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );

    $o_FCO_DocReciboDP->setMonto( $f_Monto );
    $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
    $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
    $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
    $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );
    $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );

    $o_FCO_DocReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
    $o_FCO_DocReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
    $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
    $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
    //pr( $o_FCO_DocReciboDP );
    $o_FCO_DocReciboDP->save();
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //AHORA SE REGISTRA LA APLICACION

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //recupero el id de caja y el turno
    $o_FCO_CierreFN = new FCO_CierreFN();
    $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
    $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
    $a_FCO_Cierre = $o_FCO_CierreFN->select();
    if( !$a_FCO_Cierre )
    {
        throw new Exception( "No se aperturo ninguna Caja." );
    }
    if( count( $a_FCO_Cierre ) > 1 )
    {
        throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
    }
    if( count( $a_FCO_Cierre ) == 1 )
    {
        $o_FCO_CierreBN = $a_FCO_Cierre[0];
        $i_IdCaja       = $o_FCO_CierreBN->getIdCaja();
        $i_IdTurno      = $o_FCO_CierreBN->getIdTurno();
        $s_CodVendedor  = $o_FCO_CierreBN->getCodVendedor();
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    $f_MontoAplicar = 50;
    $f_MontoAplicarMN = 50;
    $f_MontoAplicarME = round( $f_MontoAplicar / $f_TipodeCambio, 2 );

    //ahora se guarda la aplicacion
    $i_IdAplicacion = FCO_AplicacionDP::recuperarId();

    $o_FCO_AplicacionDP = new FCO_AplicacionDP();
    $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
    $o_FCO_AplicacionDP->setIdCompania( myUser::getUser()->getIdBusiness() );
    $o_FCO_AplicacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
    $o_FCO_AplicacionDP->setIdCaja( $i_IdCaja );
    $o_FCO_AplicacionDP->setIdTurno( $i_IdTurno );
    $o_FCO_AplicacionDP->setIdBanco( $i_IdBanco );
    $o_FCO_AplicacionDP->setIdCuenta( $i_IdCuenta );
    $o_FCO_AplicacionDP->setIdMoneda( $s_IdMoneda );
    $o_FCO_AplicacionDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );

    $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
    $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
    $o_FCO_AplicacionDP->setClaseNombre( $s_ClaseNombre ); //BANCOS - EFECTIVO - TARJETA - AJUSTES - NC
    $o_FCO_AplicacionDP->setNombreTipo( FCO_AplicacionBN::T_APLICACION_PAGO ); //PAGO - NOTA_CREDITO
    $o_FCO_AplicacionDP->setDescripcion( $s_Descripcion );

    $o_FCO_AplicacionDP->setIdPersona( $i_IdPersona );
    $o_FCO_AplicacionDP->setTipoDocCliente( $s_TipoDocCliente );
    $o_FCO_AplicacionDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
    $o_FCO_AplicacionDP->setNombreCliente( $s_NombreCliente );
    $o_FCO_AplicacionDP->setReciboNumero( $s_ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre
    $o_FCO_AplicacionDP->setIdDocRecibo( $i_IdDocRecibo ); //no esta nullo cuando es un pago normal para un recibo, es nulo cuando se aplica por una nota de cred
    //$o_FCO_AplicacionDP->setIdNumeroDocumento(  ); //cuando nace por una nota de credito se setea el id del comprobante
    $o_FCO_AplicacionDP->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
    $o_FCO_AplicacionDP->setCodDocRef( $o_VTA_DocumentoBN->getDocumentoCod() );
    $o_FCO_AplicacionDP->setSerieNumeroDocRef( $o_VTA_DocumentoBN->getDocumentoSerieNumero() );
    $o_FCO_AplicacionDP->setMontoTotalDocRef( $o_VTA_DocumentoBN->getMontoTotal() );
    $o_FCO_AplicacionDP->setSaldoDocRef( $f_NvoDocuSaldo );
    $o_FCO_AplicacionDP->setFechaDocRef( $o_VTA_DocumentoBN->getFechaDocumento() );
    $o_FCO_AplicacionDP->setFechaDocVenRef( $o_VTA_DocumentoBN->getFechaVencimiento() );
    $o_FCO_AplicacionDP->setIdMonedaRef( $o_VTA_DocumentoBN->getMonedaDocumento() );
    $o_FCO_AplicacionDP->setTipoCambioRef( $o_VTA_DocumentoBN->getTipodeCambio() );
    $o_FCO_AplicacionDP->setCodVendedorRef( $o_VTA_DocumentoBN->getVendedor() );
    $o_FCO_AplicacionDP->setIdAlmacenRef( $o_VTA_DocumentoBN->getIdAlmacen() );
    $o_FCO_AplicacionDP->setTipoCambio( $f_TipodeCambio ); //POR DEFECTO 1 POR SER EN SOLES
    $o_FCO_AplicacionDP->setPeriodo( date( "Ym" ) );
    $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
    $o_FCO_AplicacionDP->setMontoAplicado( $f_MontoAplicar );
    $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoAplicarMN );
    $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoAplicarME );
    $o_FCO_AplicacionDP->setMostrar( "Y" ); //al parecer cuando se hace la reversion en reportes especiales no se muestra
    $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_APLICADO ); //PE NDIENTE - AP LICADO - AN ULADO
    $o_FCO_AplicacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
    $o_FCO_AplicacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
    $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
    $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
    //pr( $o_FCO_AplicacionDP );
    $o_FCO_AplicacionDP->save();
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //ahora se actualiza los saldos del comprobante
    $o_VTA_DocumentoDP = new VTA_DocumentoDP();
    $o_VTA_DocumentoDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
    $o_VTA_DocumentoDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
    $o_VTA_DocumentoDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
    $o_VTA_DocumentoDP->setMontoPagado( $f_NvoDocuPagado );
    $o_VTA_DocumentoDP->setMontoPagadoMN( $f_NvoDocuPagadoMN );
    $o_VTA_DocumentoDP->setMontoSaldo( $f_NvoDocuSaldo );
    $o_VTA_DocumentoDP->setMontoSaldoMN( $f_NvoDocuSaldoMN );
    if( $o_VTA_DocumentoBN->getMontoTotal() == $f_NvoDocuPagado || $o_VTA_DocumentoBN->getMontoPagadoMN() == $f_NvoDocuPagadoMN )
    {
        $o_VTA_DocumentoDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_DocumentoDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
        $o_VTA_DocumentoDP->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
    }
    $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
    $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
    //pr( $o_VTA_DocumentoDP );
    $o_VTA_DocumentoDP->update();
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

}
catch( Exception $exc )
{
    pr( $exc );
}