<?php
define( 'SF_ROOT_DIR', "../" );
define( 'SF_APP',      'mst' );
define( 'SF_DEBUG',    false );

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );

class CatalogoGuiaRemision
{
    static $a_TipoDocumento = array
    (
        1 => array( "CodigoGD" => "FAC", "CodigoSunat" => "01", "Descripcion" => 'Factura' ),
        2 => array( "CodigoGD" => "BOL", "CodigoSunat" => "03", "Descripcion" => 'Boleta de venta' ),
        3 => array( "CodigoGD" => "", "CodigoSunat" => "04", "Descripcion" => 'Liquidación de compra' ),
        4 => array( "CodigoGD" => "", "CodigoSunat" => "05", "Descripcion" => 'Boletos de Transporte Aéreo que emiten las Compañías de Aviación Comercial por el servicio de transporte aéreo regular de pasajeros, emitido de manera manual, mecanizada o por medios electrónicos (BME)' ),
        5 => array( "CodigoGD" => "", "CodigoSunat" => "06", "Descripcion" => 'Carta de porte aéreo' ),
        6 => array( "CodigoGD" => "NCR", "CodigoSunat" => "07", "Descripcion" => 'Nota de crédito' ),
        7 => array( "CodigoGD" => "NDE", "CodigoSunat" => "08", "Descripcion" => 'Nota de débito' ),
        8 => array( "CodigoGD" => "GUR", "CodigoSunat" => "09", "Descripcion" => 'Guía de remisión remitente' ),
        9 => array( "CodigoGD" => "", "CodigoSunat" => "11", "Descripcion" => 'Póliza emitida por las Bolsas de Valores' ),
        10 => array( "CodigoGD" => "", "CodigoSunat" => "12", "Descripcion" => 'Ticket de máquina registradora' ),
        11 => array( "CodigoGD" => "", "CodigoSunat" => "13", "Descripcion" => 'Documento emitido por bancos, instituciones financieras, crediticias y de seguros que se encuentren bajo el control de la Superintendencia de Banca y Seguros' ),
        12 => array( "CodigoGD" => "", "CodigoSunat" => "14", "Descripcion" => 'Recibo servicios públicos' ),
        13 => array( "CodigoGD" => "", "CodigoSunat" => "15", "Descripcion" => 'Boletos emitidos por el servicio de transporte terrestre regular urbano de pasajeros y el ferroviario público de pasajeros prestado en vía férrea local' ),
        14 => array( "CodigoGD" => "", "CodigoSunat" => "16", "Descripcion" => 'Boleto de viaje emitido por las empresas de transporte público interprovincial de pasajeros' ),
        15 => array( "CodigoGD" => "", "CodigoSunat" => "18", "Descripcion" => 'Documentos emitidos por las AFP' ),
        16 => array( "CodigoGD" => "", "CodigoSunat" => "19", "Descripcion" => 'Boleto por atracciones y espectáculos públicos' ),
        17 => array( "CodigoGD" => "", "CodigoSunat" => "20", "Descripcion" => 'Comprobante de retención' ),
        18 => array( "CodigoGD" => "", "CodigoSunat" => "21", "Descripcion" => 'Conocimiento de embarque por el servicio de transporte de carga marítima' ),
        19 => array( "CodigoGD" => "", "CodigoSunat" => "23", "Descripcion" => 'Pólizas de Adjudicación por remate o adjudicación de bienes' ),
        20 => array( "CodigoGD" => "", "CodigoSunat" => "24", "Descripcion" => 'Certificado de pago de regalías emitidas por PERUPETRO S.A.' ),
        21 => array( "CodigoGD" => "", "CodigoSunat" => "28", "Descripcion" => 'Etiquetas por el pago de la Tarifa Unificada de Uso de Aeropuerto – TUUA' ),
        22 => array( "CodigoGD" => "", "CodigoSunat" => "29", "Descripcion" => 'Documentos emitidos por la COFOPRI' ),
        23 => array( "CodigoGD" => "", "CodigoSunat" => "30", "Descripcion" => 'Documentos emitidos por las empresas que desempeñan el rol adquirente en los sistemas de pago mediante tarjetas de crédito y débito, emitidas por bancos e instituciones financieras o crediticias, domiciliados o no en el país.' ),
        24 => array( "CodigoGD" => "GUT", "CodigoSunat" => "31", "Descripcion" => 'Guía de remisión transportista' ),
        25 => array( "CodigoGD" => "", "CodigoSunat" => "32", "Descripcion" => 'Documentos emitidos por recaudadoras de la Garantía de Red Principal' ),
        26 => array( "CodigoGD" => "", "CodigoSunat" => "34", "Descripcion" => 'Documento del Operador' ),
        27 => array( "CodigoGD" => "", "CodigoSunat" => "35", "Descripcion" => 'Documento del Partícipe' ),
        28 => array( "CodigoGD" => "", "CodigoSunat" => "36", "Descripcion" => 'Recibo de Distribución de Gas Natural' ),
        29 => array( "CodigoGD" => "", "CodigoSunat" => "37", "Descripcion" => 'Documentos que emitan los concesionarios del servicio de revisiones técnicas' ),
        30 => array( "CodigoGD" => "", "CodigoSunat" => "40", "Descripcion" => 'Comprobante de Percepción ' ),
        31 => array( "CodigoGD" => "", "CodigoSunat" => "41", "Descripcion" => 'Comprobante de Percepción – Venta interna ( físico - formato impreso)' ),
        32 => array( "CodigoGD" => "", "CodigoSunat" => "42", "Descripcion" => 'Documentos emitidos por los adq. en los sistemas de pago por tarj. de crédito emitidas por ellas mismas' ),
        33 => array( "CodigoGD" => "", "CodigoSunat" => "43", "Descripcion" => 'Boleto de compañías de aviación transporte aéreo no regular' ),
        34 => array( "CodigoGD" => "", "CodigoSunat" => "45", "Descripcion" => 'Documentos emitidos por centros educativos y culturales, universidades, asociaciones y fundaciones' ),
        35 => array( "CodigoGD" => "", "CodigoSunat" => "55", "Descripcion" => 'BVME para transporte ferroviario de pasajeros' ),
        36 => array( "CodigoGD" => "", "CodigoSunat" => "56", "Descripcion" => 'Comprobante de pago SEAE' ),
        37 => array( "CodigoGD" => "", "CodigoSunat" => "71", "Descripcion" => 'Guía de remisión remitente complementaria' ),
        38 => array( "CodigoGD" => "", "CodigoSunat" => "72", "Descripcion" => 'Guía de remisión transportista complementaria' ),
        39 => array( "CodigoGD" => "", "CodigoSunat" => "87", "Descripcion" => 'Nota de crédito especial' ),
        40 => array( "CodigoGD" => "", "CodigoSunat" => "88", "Descripcion" => 'Nota de débito especial' )
    );

    public static function getTipoDocumentoCodSunat( $s_Cod )
    {
        foreach( CatalogoGuiaRemision::$a_TipoDocumento as $i_Key => $a_Data )
        {
            if( $a_Data["CodigoGD"] == $s_Cod )
            {
                return $a_Data['CodigoSunat'];
            }
        }
        return null;
    }


    static $a_TipoDocumentoIdentidad = array
    (
        1 => array( "CodigoGD" => "SIN", "CodigoSunat" => "0", "Descripcion" => "Doc.trib.no.dom.sin.ruc" ),
        2 => array( "CodigoGD" => "DNI", "CodigoSunat" => "1", "Descripcion" => "Doc. Nacional de Identidad" ),
        3 => array( "CodigoGD" => "CEX", "CodigoSunat" => "4", "Descripcion" => "Carnet de extranjería" ),
        4 => array( "CodigoGD" => "RUC", "CodigoSunat" => "6", "Descripcion" => "Registro Único de Contribuyentes" ),
        5 => array( "CodigoGD" => "PAS", "CodigoSunat" => "7", "Descripcion" => "Pasaporte" ),
        6 => array( "CodigoGD" => "CDI", "CodigoSunat" => "A", "Descripcion" => "Ced. Diplomática de identidad" ),
        7 => array( "CodigoGD" => "DIR", "CodigoSunat" => "B", "Descripcion" => "Documento identidad país residencia-no.d" ),
        8 => array( "CodigoGD" => "TIN", "CodigoSunat" => "C", "Descripcion" => "Tax Identification Number - TIN – Doc. Trib PP.NN." ),
        9 => array( "CodigoGD" => "INI", "CodigoSunat" => "D", "Descripcion" => "Identification Number - IN – Doc. Trib. PP. JJ" ),
        10 => array( "CodigoGD" => "TAM", "CodigoSunat" => "E", "Descripcion" => "TAM- Tarjeta Andina de Migración" ),
        11 => array( "CodigoGD" => "PTP", "CodigoSunat" => "F", "Descripcion" => "Permiso Temporal de Permanencia - PTP" ),
        12 => array( "CodigoGD" => "SAL", "CodigoSunat" => "G", "Descripcion" => "Salvoconducto" ),
    );

    public static function getTpDocIdCodigoSunat( $s_Cod )
    {
        foreach( CatalogoGuiaRemision::$a_TipoDocumentoIdentidad as $i_Key => $a_Data )
        {
            if( $a_Data["CodigoGD"] == $s_Cod )
            {
                return $a_Data['CodigoSunat'];
            }
        }
        return null;
    }

    static $a_DocRelacionadoTransMercaderia = array
    (
        1 => array( "CodigoGD" => "FAC", "CodigoSunat" => "01", "Descripcion" => "Factura" ),
        2 => array( "CodigoGD" => "BOL", "CodigoSunat" => "03", "Descripcion" => "Boleta de Venta" ),
        3 => array( "CodigoGD" => "SIN", "CodigoSunat" => "04", "Descripcion" => "Liquidación de Compra" ),
        4 => array( "CodigoGD" => "GUI", "CodigoSunat" => "09", "Descripcion" => "Guía de Remisión Remitente" ),
        5 => array( "CodigoGD" => "SIN", "CodigoSunat" => "12", "Descripcion" => "Ticket o cinta emitido por máquina registradora" ),
        6 => array( "CodigoGD" => "GUT", "CodigoSunat" => "31", "Descripcion" => "Guía de Remisión Transportista" ),
        7 => array( "CodigoGD" => "SIN", "CodigoSunat" => "48", "Descripcion" => "Comprobante de Operaciones – Ley N° 29972" ),
        8 => array( "CodigoGD" => "SIN", "CodigoSunat" => "49", "Descripcion" => "Constancia de Depósito - IVAP (Ley 28211)" ),
        9 => array( "CodigoGD" => "SIN", "CodigoSunat" => "50", "Descripcion" => "Declaración Aduanera de Mercancías" ),
        10 => array( "CodigoGD" => "SIN", "CodigoSunat" => "52", "Descripcion" => "Declaración Simplificada (DS)" ),
        11 => array( "CodigoGD" => "SIN", "CodigoSunat" => "65", "Descripcion" => "Autorización de Circulación para transportar MATPEL – Callao" ),
        12 => array( "CodigoGD" => "SIN", "CodigoSunat" => "66", "Descripcion" => "Autorización de Circulación para transporte de carga y mercancías en Lima Metropolitana" ),
        13 => array( "CodigoGD" => "SIN", "CodigoSunat" => "67", "Descripcion" => "Permiso de Operación Especial para el servicio de transporte de MATPEL - MTC" ),
        14 => array( "CodigoGD" => "SIN", "CodigoSunat" => "68", "Descripcion" => "Habilitación Sanitaria de Transporte Terrestre de Productos Pesqueros y Acuícolas" ),
        15 => array( "CodigoGD" => "SIN", "CodigoSunat" => "69", "Descripcion" => "Permiso / Autorización de operación de transporte de mercancías" ),
        16 => array( "CodigoGD" => "SIN", "CodigoSunat" => "71", "Descripcion" => "Resolución de Adjudicación de bienes – SUNAT" ),
        17 => array( "CodigoGD" => "SIN", "CodigoSunat" => "72", "Descripcion" => "Resolución de Comiso de bienes – SUNAT" ),
        18 => array( "CodigoGD" => "SIN", "CodigoSunat" => "73", "Descripcion" => "Guía de Transporte Forestal o de Fauna - SERFOR" ),
        19 => array( "CodigoGD" => "SIN", "CodigoSunat" => "74", "Descripcion" => "Guía de Tránsito – SUCAMEC" ),
        20 => array( "CodigoGD" => "SIN", "CodigoSunat" => "75", "Descripcion" => "Autorización para operar como empresa de Saneamiento Ambiental – MINSA - " ),
        21 => array( "CodigoGD" => "SIN", "CodigoSunat" => "76", "Descripcion" => "Autorización para manejo y recojo de residuos sólidos peligrosos y no peligrosos" ),
        22 => array( "CodigoGD" => "SIN", "CodigoSunat" => "77", "Descripcion" => "Certificado fitosanitario la movilización de plantas, productos vegetales, y otros artículos reglamentados " ),
        23 => array( "CodigoGD" => "SIN", "CodigoSunat" => "78", "Descripcion" => "Registro Único de Usuarios y Transportistas de Alcohol Etílico" ),
        24 => array( "CodigoGD" => "SIN", "CodigoSunat" => "80", "Descripcion" => "Constancia de Depósito – Detracción" ),
        25 => array( "CodigoGD" => "SIN", "CodigoSunat" => "81", "Descripcion" => "Código de autorización emitida por el SCOP" ),
        26 => array( "CodigoGD" => "SIN", "CodigoSunat" => "82", "Descripcion" => "Declaración jurada de mudanza" )
    );

    public static function getDocRelacionadoCodSunat( $s_Cod ): ?string
    {
        foreach( CatalogoGuiaRemision::$a_DocRelacionadoTransMercaderia as $i_Key => $a_Data )
        {
            if( $a_Data["CodigoGD"] == $s_Cod )
            {
                return $a_Data['CodigoSunat'];
            }
        }
        return null;
    }

    public static function getDocRelacionadoDescripcion( $s_Cod ): ?string
    {
        foreach( CatalogoGuiaRemision::$a_DocRelacionadoTransMercaderia as $i_Key => $a_Data )
        {
            if( $a_Data["CodigoGD"] == $s_Cod )
            {
                return $a_Data['Descripcion'];
            }
        }
        return null;
    }

    static $a_MotivoTraslado = array
    (
        "01" => "Venta",
        "02" => "Compra",
        "03" => "Venta con entrega a terceros",
        "04" => "Traslado entre establecimientos de la misma empresa",
        "05" => "Consignación",
        "06" => "Devolución",
        "07" => "Recojo de bienes transformados",
        "08" => "Importación",
        "09" => "Exportación",
        "13" => "Otros",
        "14" => "Venta sujeta a confirmación del comprador",
        "17" => "Traslado de bienes para transformación",
        "18" => "Traslado emisor itinerante CP"
    );

    public static function getMotivoTrasladoDesc( $s_cod ): ?string
    {
        if( isset( CatalogoGuiaRemision::$a_MotivoTraslado[$s_cod] ) )
        {
            return CatalogoGuiaRemision::$a_MotivoTraslado[$s_cod];
        }
        return null;
    }
}

function concatDatosGuiaRemisionCAB( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN, $TipoGui = "T" ): string
{
    $a_Concat = array();
    $a_Concat[0] = "CAB";
    $a_Concat[1] = "2.1";
    $a_Concat[2] = "2.0";
    $a_Concat[3] = $o_DP_GuiaRemisionHBN->getGuiaSerie()."-".$o_DP_GuiaRemisionHBN->getGuiaNumero();
    $a_Concat[4] = substr( $o_DP_GuiaRemisionHBN->getGuiaFecha(), 0, 10 );
    $a_Concat[5] = substr( $o_DP_GuiaRemisionHBN->getGuiaFecha(), 11, 8 );
    if( $TipoGui == "T" )
    {
        $a_Concat[6] = "09";
    }
    if( $TipoGui == "V" )
    {
        $a_Concat[6] = "31";
    }
    $a_Concat[7] = "";
    $a_Concat[8] = "GR377R";
    $a_Concat[9] = "";
    $a_Concat[10] = "";

    return implode( "|", $a_Concat );
}

function concatNotasAdicionalesNOT( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $s_Comentario = $o_DP_GuiaRemisionHBN->getComentario();
    $a_Comentario = preg_split( "/[\n,]+/", $s_Comentario );
    $a_ConcatSup = array();
    foreach( $a_Comentario as $i_Key => $s_Content )
    {
        $a_Concat = array();
        $a_Concat[0] = "NOT";
        $a_Concat[1] = str_pad( ( $i_Key + 1 ), 3, "0", STR_PAD_LEFT );
        $a_Concat[2] = $s_Content;
        $a_ConcatSup[] = implode( "|", $a_Concat );
    }
    return implode( "\n", $a_ConcatSup );
}

function concatDatosRemitenteREM( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "REM";
    $a_Concat[1] = $o_DP_GuiaRemisionHBN->getEmpresaNumDoc();
    $a_Concat[2] = CatalogoGuiaRemision::getTpDocIdCodigoSunat( $o_DP_GuiaRemisionHBN->getEmpresaTipoDoc() );
    $a_Concat[3] = $o_DP_GuiaRemisionHBN->getEmpresaInfoAdicional();
    $a_Concat[4] = "";
    $a_Concat[5] = $o_DP_GuiaRemisionHBN->getEmpresaDireccion();
    $a_Concat[6] = "SANTA CATALINA";
    $a_Concat[7] = "LIMA";
    $a_Concat[8] = "LIMA";
    $a_Concat[9] = "LA VICTORIA";
    $a_Concat[10] = "PE";
    $a_Concat[11] = "";
    $a_Concat[11] = "";

    return implode( "|", $a_Concat );
}

function concatDocumentoRelacionadoREF( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "REF";
    $a_Concat[1] = $o_DP_GuiaRemisionHBN->getReferenciaNumero();
    $a_Concat[2] = CatalogoGuiaRemision::getDocRelacionadoCodSunat( $o_DP_GuiaRemisionHBN->getReferenciaTipo() );
    $a_Concat[3] =  CatalogoGuiaRemision::getDocRelacionadoDescripcion( $o_DP_GuiaRemisionHBN->getReferenciaTipo() );
    $a_Concat[4] = "";
    $a_Concat[5] = "";

    return implode( "|", $a_Concat );
}

function concatDatosDestinatarioDES( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "DES";
    $a_Concat[1] = $o_DP_GuiaRemisionHBN->getClienteNumDocumento();
    $a_Concat[2] = CatalogoGuiaRemision::getTpDocIdCodigoSunat( $o_DP_GuiaRemisionHBN->getClienteTipoDocumento() );
    $a_Concat[3] =  $o_DP_GuiaRemisionHBN->getClienteNombre();
    $a_Concat[4] = "";
    $a_Concat[5] = "";
    $a_Concat[6] = $o_DP_GuiaRemisionHBN->getDireccionDestino();
    $a_Concat[7] = "";
    $a_Concat[8] = $o_DP_GuiaRemisionHBN->getDepartamentoDestino();
    $a_Concat[9] = $o_DP_GuiaRemisionHBN->getProvinciaDestino();
    $a_Concat[10] = $o_DP_GuiaRemisionHBN->getDistritoDestino();
    $a_Concat[11] = "";

    return implode( "|", $a_Concat );
}

function concatDatosEnvioDEA( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "DEA";
    $a_Concat[1] = "SUNAT_Envio";
    $a_Concat[2] = $o_DP_GuiaRemisionHBN->getMotivoTrasladoId();
    $a_Concat[3] = CatalogoGuiaRemision::getMotivoTrasladoDesc( $o_DP_GuiaRemisionHBN->getMotivoTrasladoId() );
    $a_Concat[4] = "";
    $a_Concat[5] = "";
    $a_Concat[6] = "";
    $a_Concat[7] = $o_DP_GuiaRemisionHBN->getPesoTotal();
    $a_Concat[8] = "KGM";
    $a_Concat[9] = "";
    $a_Concat[10] = $o_DP_GuiaRemisionHBN->getModalidadTransporteId();
    $a_Concat[11] = $o_DP_GuiaRemisionHBN->getFechaIniTraslado();
    $a_Concat[12] = "";
    $a_Concat[13] = "";
    $a_Concat[14] = "";
    $a_Concat[15] = "";
    $a_Concat[16] = "";
    $a_Concat[17] = "";
    $a_Concat[18] = "";
    $a_Concat[19] = "";

    return implode( "|", $a_Concat );
}

function concatDatosTransportistaTPV( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "TPV";
    $a_Concat[1] = $o_DP_GuiaRemisionHBN->getTransportistaDocumentoNumero();
    $a_Concat[2] = CatalogoGuiaRemision::getTpDocIdCodigoSunat( $o_DP_GuiaRemisionHBN->getTransportistaDocumentoTipo() );
    $a_Concat[3] = $o_DP_GuiaRemisionHBN->getTransportistaDenominacion();
    $a_Concat[4] = "";
    $a_Concat[5] = "";
    $a_Concat[6] = "";

    return implode( "|", $a_Concat );
}

function concatDireccionPuntoPartidaDPP( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "DPP";
    $a_Concat[1] = $o_DP_GuiaRemisionHBN->getUbigeoOrigen();
    $a_Concat[2] = $o_DP_GuiaRemisionHBN->getDepartamentoOrigen()." ".$o_DP_GuiaRemisionHBN->getProvinciaOrigen()." ". $o_DP_GuiaRemisionHBN->getDistritoOrigen();
    $a_Concat[3] = "";
    $a_Concat[4] = "";
    $a_Concat[5] = "";
    $a_Concat[6] = "";

    return implode( "|", $a_Concat );
}

function concatDireccionPuntoLlegadaDPL( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $a_Concat = array();
    $a_Concat[0] = "DPL";
    $a_Concat[1] = $o_DP_GuiaRemisionHBN->getUbigeoDestino();
    $a_Concat[2] = $o_DP_GuiaRemisionHBN->getDepartamentoDestino()." ".$o_DP_GuiaRemisionHBN->getProvinciaDestino()." ". $o_DP_GuiaRemisionHBN->getDistritoDestino();
    $a_Concat[3] = "";
    $a_Concat[4] = "";
    $a_Concat[5] = "";
    $a_Concat[6] = "";

    return implode( "|", $a_Concat );
}

function concatGuiaDetalleSerie( $i_Cont, DP_GuiaRemisionDetBN $o_DP_GuiaRemisionDetBN, $s_Series )
{

    $a_Concat[0] = "ITE";
    $a_Concat[1] = $i_Cont;
    $a_Concat[2] = $i_Cont;
    $a_Concat[3] = $o_DP_GuiaRemisionDetBN->getCantidad();
    $a_Concat[4] = $o_DP_GuiaRemisionDetBN->getCodigoUnidadSunat();
    $a_Concat[5] = $o_DP_GuiaRemisionDetBN->getDescripcion();
    $a_Concat[6] = $o_DP_GuiaRemisionDetBN->getIdItem();
    $a_Concat[7] = $o_DP_GuiaRemisionDetBN->getCodigoItemSunat();
    $a_Concat[8]  = $s_Series;
    $a_Concat[9]  = "1234567890001";
    $a_Concat[10] = "GTIN-13";

    return $a_Concat;
}

function concatGuiaDetalleITE( DP_GuiaRemisionHBN $o_DP_GuiaRemisionHBN )
{
    $o_DP_GuiaRemisionDetFN = new DP_GuiaRemisionDetFN();
    $o_DP_GuiaRemisionDetFN->setGuiaRemisionId( $o_DP_GuiaRemisionHBN->getGuiaRemisionId() );
    $a_DP_GuiaRemisionDet = $o_DP_GuiaRemisionDetFN->select();
    //pr( $a_DP_GuiaRemisionDet );

    $i_Cont = 1;
    foreach( $a_DP_GuiaRemisionDet as $i_Key => $o_DP_GuiaRemisionDetBN )
    {
        //PARA INFO ADICIONAL, QUE SERIA LA SERIE...
        $o_DP_GuiaRemisionDetSerieFN = new DP_GuiaRemisionDetSerieFN();
        $o_DP_GuiaRemisionDetSerieFN->setGuiaRemisionId( $o_DP_GuiaRemisionHBN->getGuiaRemisionId() );
        $o_DP_GuiaRemisionDetSerieFN->setGuiaRemisionDetId( $o_DP_GuiaRemisionDetBN->getGuiaRemisionDetId() );
        $a_DP_GuiaRemisionDetSerie = $o_DP_GuiaRemisionDetSerieFN->select();
        $a_Series    = array();
        $s_Series    = "";
        $s_TmpSeries = "";
        foreach( $a_DP_GuiaRemisionDetSerie as $o_DP_GuiaRemisionDetSerieBN )
        {
            $s_TmpSeries .= " ".$o_DP_GuiaRemisionDetSerieBN->getSerieNumero();
            if( strlen( $s_TmpSeries ) > 1000 )
            {
                //pr( strlen( $s_TmpSeries )." | ".count( $a_Series ) );
                $a_Concat = concatGuiaDetalleSerie( $i_Cont, $o_DP_GuiaRemisionDetBN, $s_Series );
                $a_ConcatSup[] = implode( "|", $a_Concat );
                $i_Cont++;
                $a_Series = array();
            }
            $a_Series[]  = $o_DP_GuiaRemisionDetSerieBN->getSerieNumero();
            $s_Series    = implode( " ", $a_Series );
            $s_TmpSeries = $s_Series;
        }
        //pr( strlen( $s_Series )." | ".count( $a_Series ) );
        $a_Concat = concatGuiaDetalleSerie( $i_Cont, $o_DP_GuiaRemisionDetBN, $s_Series );
        $a_ConcatSup[] = implode( "|", $a_Concat );

        $i_Cont++;
    }
    return implode( "\n", $a_ConcatSup );
}

try
{
    $o_Cn = Conexion::getConexion();
    //$o_Cn->begin();

    pr( "GUIA DE REMISION PARA REMITENTE:" );

    $o_DP_GuiaRemisionHFN = new DP_GuiaRemisionHFN();
    $o_DP_GuiaRemisionHBN = $o_DP_GuiaRemisionHFN->selectByPK( 'T00100000015' );

    $a_Txt = array();
    $a_Txt[] = concatDatosGuiaRemisionCAB( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatNotasAdicionalesNOT( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDatosRemitenteREM( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDocumentoRelacionadoREF( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDatosDestinatarioDES( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDatosEnvioDEA( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDatosTransportistaTPV( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDireccionPuntoPartidaDPP( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatDireccionPuntoLlegadaDPL( $o_DP_GuiaRemisionHBN );
    $a_Txt[] = concatGuiaDetalleITE( $o_DP_GuiaRemisionHBN );

    $s_CodSunat = CatalogoGuiaRemision::getTipoDocumentoCodSunat( "GUR" );
    $s_MotivoDesc = CatalogoGuiaRemision::getMotivoTrasladoDesc( $o_DP_GuiaRemisionHBN->getMotivoTrasladoId() );
    $nameFileOne = $s_CodSunat."-".$o_DP_GuiaRemisionHBN->getGuiaSerie()."-".$o_DP_GuiaRemisionHBN->getGuiaNumero()."_".$s_MotivoDesc.".txt";
    pr( $nameFileOne );
    $nameFile = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'web'.DIRECTORY_SEPARATOR."tmp".DIRECTORY_SEPARATOR.$nameFileOne;
    if( file_exists( $nameFile ) )
    {
        unlink( $nameFile );
    }
    $archivo = fopen(  $nameFile, "w" );
    fwrite( $archivo, implode( "\n", $a_Txt ) );
    fclose( $archivo );

    //$o_Cn->commit();
    //$o_Cn->rollback();

}
catch( Exception $exc )
{
    pr( $exc, false );
}