<?php
define( 'SF_ROOT_DIR', "../" );
define( 'SF_APP',      'mst' );
define( 'SF_DEBUG',    true );

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'config'.DIRECTORY_SEPARATOR.'configGlobal.php' );

require_once( SF_ROOT_DIR.DIRECTORY_SEPARATOR.'plugins'.DIRECTORY_SEPARATOR.'vendor_excel'.DIRECTORY_SEPARATOR.'autoload.php' );

use PhpOffice\PhpSpreadsheet\IOFactory;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$nombreDelDocumento = "prueba_excel.xlsx";

$documento = new Spreadsheet();

$documento
    ->getProperties()
    ->setCreator("Aquí va el creador, como cadena")
    ->setLastModifiedBy('Parzibyte') // última vez modificado por
    ->setTitle('Mi primer documento creado con PhpSpreadSheet')
    ->setSubject('El asunto')
    ->setDescription('Este documento fue generado para parzibyte.me')
    ->setKeywords('etiquetas o palabras clave separadas por espacios')
    ->setCategory('La categoría');

$hoja = $documento->getActiveSheet();

$hoja->setTitle("Hoja1");
$hoja->setCellValueByColumnAndRow(1, 1, "Un valor en 1, 1");
$hoja->setCellValue("B2", "Este va en B2");
$hoja->setCellValue("A3", "Parzibyte");

$validation = $hoja->getCell( 'A3' )->getDataValidation();
$validation->setType( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::TYPE_LIST );
$validation->setErrorStyle( \PhpOffice\PhpSpreadsheet\Cell\DataValidation::STYLE_INFORMATION );
$validation->setAllowBlank(false);
$validation->setShowInputMessage(true);
$validation->setShowErrorMessage(true);
$validation->setShowDropDown(true);


$documento->createSheet();

$hoja = $documento->setActiveSheetIndex(1);
$hoja->setTitle("Hoja2");
$hoja->setCellValueByColumnAndRow(5, 5, "prueba por coordenadas 5, 5");
$hoja->setCellValue("B10", "Este va en B10");
$hoja->setCellValue("A30", "Parzibyte");

$documento->createSheet();

$hoja = $documento->setActiveSheetIndex(2);
$hoja->setTitle("Hoja3");
$hoja->setCellValueByColumnAndRow(5, 5, "prueba por coordenadas 5, 5");
$hoja->setCellValue("B10", "Este va en B10");
$hoja->setCellValue("A29", "Willy");
$hoja->setCellValue("A30", "Parzibyte");

$documento->setActiveSheetIndex(0);

header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $nombreDelDocumento . '"');
header('Cache-Control: max-age=0');

$writer = IOFactory::createWriter($documento, 'Xlsx');
$writer->save('php://output');