<?php
/* Busqueda de registros de la tabla VTA_DocumentoDetalle redefinidos por el usuario. */
class VTA_DocumentoDetalleFN extends BaseVTA_DocumentoDetalleFN
{
    /**
     * Recupero el Id + 1
     *
     * @return int
     */
    public static function recuperarId( $IdTipoDocumento, $IdCompania, $NumeroDocumento )
    {
        $s_Sql = "SELECT IF( MAX( Secuencia ) IS NULL, 1, MAX( Secuencia ) + 1 ) i_Id  FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='$IdTipoDocumento' AND IdCompania='$IdCompania' AND NumeroDocumento='$NumeroDocumento';";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        return $o_ResultSet->getInt( 'i_Id' );
    }
    
    public function getCondicionAsignado()
    {
        $s_Sql = "SELECT Condicion FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}' AND Secuencia='{$this->getSecuencia()}'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return $a_Row['Condicion'];
    }

    public function getTipoPrecioAsignado()
    {
        $s_Sql = "SELECT IdTipoPrecio FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}' AND Secuencia='{$this->getSecuencia()}'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return ( $a_Row['IdTipoPrecio'] );
    }

    public function getPrecioUnitarioIncIGVAsignado()
    {
        $s_Sql = "SELECT MontoIncImpuestoUnidad FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}' AND Secuencia='{$this->getSecuencia()}'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return floatval( $a_Row['MontoIncImpuestoUnidad'] );
    }

    public function getIdUnidadMedidaAsignado()
    {
        $s_Sql = "SELECT IdUnidad FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}' AND Secuencia='{$this->getSecuencia()}'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return intval( $a_Row['IdUnidad'] );
    }

    public function getCantidadPedidaAsignado()
    {
        $s_Sql = "SELECT CantidadPedida FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}' AND Secuencia='{$this->getSecuencia()}'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return floatval( $a_Row['CantidadPedida'] );
    }

    public function getIdLoteAsignado()
    {
        $s_Sql = "SELECT Lote FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}' AND Secuencia='{$this->getSecuencia()}'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return $a_Row['Lote'];
    }
    
    public function buscarItemLoteRepetidos()
    {
        $a_VTA_DocumentoDetalleBN = array();
        $s_Sql = "SELECT ItemCodigo, Lote, COUNT(*) CantLotes, VTA_DocumentoDetalle.*
                    FROM VTA_DocumentoDetalle
                    WHERE IdTipoDocumento='{$this->getIdTipoDocumento()}' AND IdCompania='{$this->getIdCompania()}' AND NumeroDocumento='{$this->getNumeroDocumento()}'
                    GROUP BY ItemCodigo, Lote
                    HAVING CantLotes > 1;";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_VTA_DocumentoDetalleBN = $this->insertObjectBN( $a_SQLRow );
            $a_VTA_DocumentoDetalleBN[] = $o_VTA_DocumentoDetalleBN;
        }
        return $a_VTA_DocumentoDetalleBN;
    }
    
    public static function getCantidadTotalPedida( $IdTipoDocumento, $IdCompania, $NumeroDocumento )
    {
        $s_Sql = "SELECT SUM(CantidadPedida) CantPedida FROM VTA_DocumentoDetalle WHERE IdTipoDocumento='$IdTipoDocumento' AND IdCompania='$IdCompania' AND NumeroDocumento='$NumeroDocumento'; ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $o_ResultSet->next();
        $a_Row = $o_ResultSet->getRow();
        return floatval( $a_Row['CantPedida'] );
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function selectresumen( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "
                        IdTipoDocumento, IdCompania, NumeroDocumento, Secuencia, TipoDetalle, ItemCodigo, Lote, Condicion, IdTipoPrecio,
                        Descripcion, SUM(CantidadPedida) CantidadPedida, CantidadEntregada, CantidadUnidadesEntregada, PrecioUnitarioOriginal, PrecioUnitario,
                        PrecioUnitarioFinal, Monto, SUM(MontoFinal) MontoFinal, IGVExoneradoFlag, DespachoUnidadEquivalenteFlag, ImprimirPUFlag,
                        AlmacenCodigo, NumeroPromocion, RefParent, FlujodeCaja, PrecioModificadoFlag, Estado, CentroCosto, UsuarioModificacion,
                        FechaModificacion, UsuarioCreacion, FechaCreacion
            ";
        $s_SQLQuery .= "FROM VTA_DocumentoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        $s_SQLQuery .= " GROUP BY ItemCodigo ";
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";
        //pr( $s_SQLQuery );
        $a_VTA_DocumentoDetalleBN = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        while( $o_ResultSet->next() ) 
        {
            $a_SQLRow = $o_ResultSet->getRow();
            $o_VTA_DocumentoDetalleBN = $this->insertObjectBN( $a_SQLRow );
            $a_VTA_DocumentoDetalleBN[] = $o_VTA_DocumentoDetalleBN;
        }
        return $a_VTA_DocumentoDetalleBN;
    }
    public function selectresumenNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "
                        IdTipoDocumento, IdCompania, NumeroDocumento, Secuencia, TipoDetalle, ItemCodigo, Lote, Condicion, IdTipoPrecio,
                        Descripcion, SUM(CantidadPedida) CantidadPedida, CantidadEntregada, CantidadUnidadesEntregada, PrecioUnitarioOriginal, PrecioUnitario,
                        PrecioUnitarioFinal, Monto, SUM(MontoFinal) MontoFinal, IGVExoneradoFlag, DespachoUnidadEquivalenteFlag, ImprimirPUFlag,
                        AlmacenCodigo, NumeroPromocion, RefParent, FlujodeCaja, PrecioModificadoFlag, Estado, CentroCosto, UsuarioModificacion,
                        FechaModificacion, UsuarioCreacion, FechaCreacion
            ";
        $s_SQLQuery .= "FROM VTA_DocumentoDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        $s_SQLQuery .= " GROUP BY ItemCodigo ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_SQLQuery )->executeQuery();
        $num_rows = $o_ResultSet->getRecordCount();
        return $num_rows;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function activarCamposPorLote()
    {
        $s_Sql = "
                SELECT ManejoxLoteFlag, ManejoxSerieFlag, ManejoxUnidadFlag, EsInventariableFlag, FusionarLoteFlag, EsServicioConDias, UsarDisponibleStock, UsarResevableStock
                FROM VTA_DocumentoDetalle
                LEFT JOIN ALM_ItemMast ON VTA_DocumentoDetalle.ItemCodigo=ALM_ItemMast.IdItem
                WHERE 
                ".$this->buildConsult()."
                AND ManejoxLoteFlag='S';
                 ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        if( $o_ResultSet->getRecordCount() > 0 )
        {
            return true;
        }
        return false;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public static function vista_producto_mas_vendido( $a_Data )
    {
        //pr( $a_Data );
        $s_Where = " AND doc.IdCompania='{$a_Data['IdCompania']}' AND doc.Estado='CE' AND item.IdItemTipo='01' ";
        $s_Where = " AND doc.IdCompania='{$a_Data['IdCompania']}' AND doc.Estado='CE' AND (item.IdItemTipo='01' OR item.IdItemTipo='02') ";
        $s_Where2 = "";

        $s_OrdenBy = "";
        $s_GroupBy = "";

        //if( $a_Data['IdProveedor'] != "" )  { $s_Where .= " AND item.IdPersona='{$a_Data['IdProveedor']}' "; }
        if( $a_Data['ItemCodigo'] != "" )   { $s_Where .= " AND item.IdItem='{$a_Data['ItemCodigo']}' "; }
        if( $a_Data['IdLinea'] != "" )      { $s_Where .= " AND item.IdLinea='{$a_Data['IdLinea']}' "; }
        if( $a_Data['IdFamilia'] != "" )    { $s_Where .= " AND item.IdFamilia='{$a_Data['IdFamilia']}' "; }
        if( $a_Data['IdMarca'] != "" )      { $s_Where .= " AND item.IdMarca='{$a_Data['IdMarca']}' "; }
        if( $a_Data['Vendedor'] != "" )     { $s_Where .= " AND doc.Vendedor='{$a_Data['Vendedor']}' "; }
        if( $a_Data['AlmacenCodigo'] != "" )
        { 
            $s_Where .= " AND doc.IdAlmacen='{$a_Data['AlmacenCodigo']}' "; 
            $s_Where2 = " AND IdAlmacen='{$a_Data['AlmacenCodigo']}' ";
        }
        if( $a_Data['FechaDocumento1'] != "" ){ $s_Where .= " AND doc.FechaDocumento>='{$a_Data['FechaDocumento1']} 00:00:00' "; }
        if( $a_Data['FechaDocumento2'] != "" ){ $s_Where .= " AND doc.FechaDocumento<='{$a_Data['FechaDocumento2']} 23:59:59' "; }

        /*if( $a_Data['CtrlOrdenar'] == "MONTO" )
        {
            $s_Orden = "ORDER BY SumMontoFinal DESC";
        }
        if( $a_Data['CtrlOrdenar'] == "CANTIDAD" )
        {
            $s_Orden = "ORDER BY SumCantidad DESC";
        }*/

        if( $a_Data['Dimension'] == "POR_TOTALES" )
        {
            $s_GroupBy = "GROUP BY item.IdItem";
            $s_OrdenBy = "ORDER BY item.DescripcionCompleta";

            if( arrayClass::existeValorEnArray( "CLIENTE", $a_Data['MostrarColumnas'] ) )
            {
                $s_GroupBy = "GROUP BY doc.ClienteNombre, item.IdItem";
                $s_OrdenBy = "ORDER BY doc.ClienteNombre, item.DescripcionCompleta";
            }
        }

        if( $a_Data['Dimension'] == "POR_MESES" )
        {
            $s_GroupBy = "GROUP BY doc.Periodo, item.IdItem";
            $s_OrdenBy = "ORDER BY doc.Periodo, item.IdItem";

            if( arrayClass::existeValorEnArray( "CLIENTE", $a_Data['MostrarColumnas'] ) )
            {
                $s_GroupBy = "GROUP BY doc.Periodo, doc.ClienteNumero, item.IdItem";
                $s_OrdenBy = "ORDER BY doc.Periodo, doc.ClienteNombre, item.IdItem";
            }
        }

        //doc.Vendedor, per.NombreCompleto,
        //, ( SELECT SUM(StockFisico) FROM ALM_ItemAlmacenStock WHERE IdItem=item.IdItem $s_Where2 ) StockActual
        $s_Sql = " 
SELECT
    doc.ClienteNumero, doc.ClienteNombre, doc.Periodo, doc.Vendedor,
    item.IdItem, item.DescripcionCompleta, linea.Descripcion DescripcionLinea, familia.Descripcion DescripcionFamilia, marca.DescripcionLocal DescripcionMarca,
    AVG(det.CostoUnitarioMN) CostoUnirarioPromedio, SUM(det.CantidadPedida) SumCantidad, SUM(det.MontoIncImpuestoUnidadMN) SumMontoFinal, Count(DISTINCT doc.ClienteNumero) CantCliente
FROM VTA_Documento doc
  LEFT JOIN VTA_DocumentoDetalle det ON doc.IdTipoDocumento=det.IdTipoDocumento AND doc.IdCompania=det.IdCompania AND doc.NumeroDocumento=det.NumeroDocumento
    LEFT JOIN ALM_ItemMast item ON det.ItemCodigo=item.IdItem
      LEFT JOIN MST_ClaseLinea linea ON item.IdLinea=linea.IdLinea
        LEFT JOIN MST_ClaseFamilia familia ON item.IdFamilia=familia.IdFamilia
          LEFT JOIN MST_PersonaMast per ON item.IdPersona=per.IdPersona
            LEFT JOIN ALM_Marca marca ON marca.IdMarca=item.IdMarca
WHERE 1=1
    $s_Where
    $s_GroupBy
    $s_OrdenBy";
        //pr( $s_Sql );
        $a_RowRs = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        while( $o_ResultSet->next() ) 
        {
            if( $a_Data['Dimension'] == "POR_TOTALES" )
            {
                $a_RowRs[] = $o_ResultSet->getRow();
            }

            if( $a_Data['Dimension'] == "POR_MESES" )
            {
                $a_Row = $o_ResultSet->getRow();

                $a_RowRs[] = array( $a_Row['Periodo'] );
            }
        }
        return $a_RowRs;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public static function reporte_venta_detalle( $a_Data )
    {
        //pr( $a_Data );
        $s_Where = " AND doc.IdCompania='{$a_Data['IdCompania']}' AND doc.Estado='CE' AND item.IdItemTipo='01' ";
        $s_Where2 = "";

        $s_OrdenBy = "";
        $s_GroupBy = "";

        //if( $a_Data['IdProveedor'] != "" )  { $s_Where .= " AND item.IdPersona='{$a_Data['IdProveedor']}' "; }
        if( $a_Data['ItemCodigo'] != "" )   { $s_Where .= " AND item.IdItem='{$a_Data['ItemCodigo']}' "; }
        if( $a_Data['IdLinea'] != "" )      { $s_Where .= " AND item.IdLinea='{$a_Data['IdLinea']}' "; }
        if( $a_Data['IdFamilia'] != "" )    { $s_Where .= " AND item.IdFamilia='{$a_Data['IdFamilia']}' "; }
        if( $a_Data['IdMarca'] != "" )      { $s_Where .= " AND item.IdMarca='{$a_Data['IdMarca']}' "; }
        if( $a_Data['Vendedor'] != "" )     { $s_Where .= " AND doc.Vendedor='{$a_Data['Vendedor']}' "; }
        if( $a_Data['AlmacenCodigo'] != "" )
        {
            $s_Where .= " AND doc.IdAlmacen='{$a_Data['AlmacenCodigo']}' ";
            $s_Where2 = " AND IdAlmacen='{$a_Data['AlmacenCodigo']}' ";
        }
        if( $a_Data['FechaDocumento1'] != "" ){ $s_Where .= " AND doc.FechaDocumento>='{$a_Data['FechaDocumento1']} 00:00:00' "; }
        if( $a_Data['FechaDocumento2'] != "" ){ $s_Where .= " AND doc.FechaDocumento<='{$a_Data['FechaDocumento2']} 23:59:59' "; }

        /*if( $a_Data['CtrlOrdenar'] == "MONTO" )
        {
            $s_Orden = "ORDER BY SumMontoFinal DESC";
        }
        if( $a_Data['CtrlOrdenar'] == "CANTIDAD" )
        {
            $s_Orden = "ORDER BY SumCantidad DESC";
        }*/

        if( $a_Data['Dimension'] == "POR_TOTALES" )
        {
            //$s_GroupBy = "GROUP BY item.IdItem";
            $s_OrdenBy = "ORDER BY item.DescripcionCompleta";

            if( arrayClass::existeValorEnArray( "CLIENTE", $a_Data['MostrarColumnas'] ) )
            {
                //$s_GroupBy = "GROUP BY doc.ClienteNombre, item.IdItem";
                //$s_OrdenBy = "ORDER BY doc.ClienteNombre, item.DescripcionCompleta";
            }
        }

        /*if( $a_Data['Dimension'] == "POR_MESES" )
        {
            $s_GroupBy = "GROUP BY doc.Periodo, item.IdItem";
            $s_OrdenBy = "ORDER BY doc.Periodo, item.IdItem";

            if( arrayClass::existeValorEnArray( "CLIENTE", $a_Data['MostrarColumnas'] ) )
            {
                $s_GroupBy = "GROUP BY doc.Periodo, doc.ClienteNumero, item.IdItem";
                $s_OrdenBy = "ORDER BY doc.Periodo, doc.ClienteNombre, item.IdItem";
            }
        }*/

        //doc.Vendedor, per.NombreCompleto,
        //, ( SELECT SUM(StockFisico) FROM ALM_ItemAlmacenStock WHERE IdItem=item.IdItem $s_Where2 ) StockActual
        $s_Sql = " 
SELECT
    doc.NumeroDocumento, LEFT(doc.FechaDocumento,10) FechaDocumento, doc.DocumentoParentCod,
    doc.ClienteNumero, doc.ClienteNombre, doc.Periodo, doc.Vendedor,
    item.IdItem, item.DescripcionCompleta, linea.Descripcion DescripcionLinea, familia.Descripcion DescripcionFamilia, marca.DescripcionLocal DescripcionMarca,
    det.CantidadPedida, orddet.PrecioUnidadIncImpuesto, orddet.OrdenDetalleSubTotalNetoMN, orddet.OrdenDetalleDsctoUnidadMN, orddet.TotalFinalMN
FROM VTA_Documento doc
  LEFT JOIN VTA_DocumentoDetalle det ON doc.IdTipoDocumento=det.IdTipoDocumento AND doc.IdCompania=det.IdCompania AND doc.NumeroDocumento=det.NumeroDocumento
    LEFT JOIN VTA_Orden ord ON doc.DocumentoParentid=ord.OrdenId
      LEFT JOIN VTA_OrdenDetalle orddet ON orddet.OrdenId=ord.OrdenId AND orddet.OrdenDetalleNum=det.Secuencia
    LEFT JOIN ALM_ItemMast item ON det.ItemCodigo=item.IdItem
      LEFT JOIN MST_ClaseLinea linea ON item.IdLinea=linea.IdLinea
        LEFT JOIN MST_ClaseFamilia familia ON item.IdFamilia=familia.IdFamilia
          LEFT JOIN MST_PersonaMast per ON item.IdPersona=per.IdPersona
            LEFT JOIN ALM_Marca marca ON marca.IdMarca=item.IdMarca
WHERE 1=1
    $s_Where
    $s_GroupBy
    $s_OrdenBy";
        //pr( $s_Sql );
        $a_RowRs = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        while( $o_ResultSet->next() )
        {
            if( $a_Data['Dimension'] == "POR_TOTALES" )
            {
                $a_RowRs[] = $o_ResultSet->getRow();
            }

            if( $a_Data['Dimension'] == "POR_MESES" )
            {
                $a_Row = $o_ResultSet->getRow();

                $a_RowRs[] = array( $a_Row['Periodo'] );
            }
        }
        return $a_RowRs;
    }
    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public static function vista_productos_vendidos( $a_Data )
    {
        $s_Where   = " AND doc.IdCompania='{$a_Data['IdCompania']}' AND doc.Estado='CE'  ";
        $s_GroupBy = " ubicacion.IdUbicacion, doc.Vendedor, linea.IdLinea, item.IdItem ";

        if( $a_Data['IdItem'] != "" )         
        {
            $s_Where .= " AND item.IdItem='{$a_Data['IdItem']}' "; 
            if( $a_Data['IdItem'] == "04872" )
            {
                $s_GroupBy .= " , doc.NumeroDocumento ";
            }
        }
        if( $a_Data['IdItemTipo'] != "" )     
        {
            if( is_array( $a_Data['IdItemTipo'] ) )
            {
                $s_Where .= " AND item.IdItemTipo in ('".implode( "','", $a_Data['IdItemTipo'] )."') "; 
            }
            else
            {
                $s_Where .= " AND item.IdItemTipo='{$a_Data['IdItemTipo']}' "; 
            }
            
        }
        if( $a_Data['IdTipoUbicacion'] != "" ){ $s_Where .= " AND ubica.IdTipoUbicacion='{$a_Data['IdTipoUbicacion']}' "; }
        if( $a_Data['IdVendedor'] != "" )     { $s_Where .= " AND doc.Vendedor='{$a_Data['IdVendedor']}' "; }
        if( $a_Data['IdAlmacen'] != "" )      { $s_Where .= " AND doc.IdAlmacen='{$a_Data['IdAlmacen']}' "; }

        /*if( $a_Data['FechaDocumento1'] != "" ){ $s_Where .= " AND apli.FechaAplicacion>='{$a_Data['FechaDocumento1']}' "; }
        if( $a_Data['FechaDocumento2'] != "" ){ $s_Where .= " AND apli.FechaAplicacion<='{$a_Data['FechaDocumento2']}' "; }*/
        if( $a_Data['FechaDocumento1'] != "" ){ $s_Where .= " AND doc.FechaFacturacion>='{$a_Data['FechaDocumento1']}' "; }
        if( $a_Data['FechaDocumento2'] != "" ){ $s_Where .= " AND doc.FechaFacturacion<='{$a_Data['FechaDocumento2']}' "; }

        if( $a_Data['IdTipoPago'] != "" )     { $s_Where .= " AND apli.IdTipoPago = '{$a_Data['IdTipoPago']}' "; }
        if( isset( $a_Data['IdTurno'] ) && $a_Data['IdTurno'] != "" )     { $s_Where .= " AND doc.IdTurno = '{$a_Data['IdTurno']}' "; }

        if( isset( $a_Data['NotIn'] ) )
        {
            if( is_array( $a_Data['NotIn'] ) )
            {
                $s_GroupBy = " doc.Vendedor, linea.IdLinea, item.IdItem ";
                $s_Where .= " AND {$a_Data['NotIn']['Campo']} not in ('{$a_Data['NotIn']['Valor']}') ";
            }
        }

        if( isset( $a_Data['IsNull'] ) )
        {
            $s_Where .= " AND {$a_Data['IsNull']['Campo']} is null ";
        }

        $s_Sql = "
SELECT
    doc.NumeroDocumento, doc.Vendedor, item.IdItem, item.DescripcionCompleta, CONCAT(ubicacion.Nombre,' - ',item.DescripcionCompleta) DescripcionItemUbicacion, linea.Descripcion,
    SUM(det.CantidadPedida) SumCantidad, SUM(det.MontoTotalNeto) SumMontoFinal, Count(DISTINCT doc.ClienteNumero) CantCliente, ubicadet.FechaHoraSalidaReal, ubicadet.IdUbicacion
FROM VTA_Documento doc
    LEFT JOIN VTA_DocumentoDetalle det ON doc.IdTipoDocumento=det.IdTipoDocumento AND doc.IdCompania=det.IdCompania AND doc.NumeroDocumento=det.NumeroDocumento
--        LEFT JOIN FCO_Aplicacion apli ON apli.IdDocNumRef=doc.NumeroDocumento
            LEFT JOIN ALM_ItemMast item ON det.ItemCodigo=item.IdItem
                LEFT JOIN MST_ClaseLinea linea ON item.IdLinea=linea.IdLinea
                    LEFT JOIN MST_ItemUbicacion ubica ON item.IdItem=ubica.IdItem
                      LEFT JOIN SRV_UbicacionClienteH ubicadet on doc.NumeroDocumento=ubicadet.NumeroDocumentoRef
                        LEFT JOIN MST_Ubicacion ubicacion ON ubicacion.IdUbicacion=ubicadet.IdUbicacion
WHERE 1=1
  $s_Where
-- GROUP BY doc.Vendedor, linea.IdLinea, item.IdItem
GROUP BY $s_GroupBy
ORDER BY SumCantidad DESC;
                ";
        //pr( $s_Sql );
        $a_RowRs = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        while( $o_ResultSet->next() ) 
        {
            $a_RowRs[] = $o_ResultSet->getRow();
        }
        return $a_RowRs;
    }

    public static function Grafica_producto_mas_vendido( $a_Data )
    {
        $s_Where = "";
        //$s_Where =  "AND doc.FechaDocumento>= '" .date( "Y-m" ) .  "-01 00:00:00' ";
        //$s_Where =  "AND doc.FechaDocumento>= '" .date( "Y" ) .  "-10-01 00:00:00' ";
        //pr ($s_Where);
        //doc.Vendedor, per.NombreCompleto,
        $s_Sql = "
        SELECT
            item.IdItem, LEFT (item.DescripcionCompleta, 26) DescripcionCompleta, linea.Descripcion, SUM(det.CantidadPedida) SumCantidad, ROUND(SUM(det.MontoTotalNeto),2) AS SumMontoFinal, Count(DISTINCT doc.ClienteNumero) CantCliente,
            ( SELECT SUM(StockFisico) FROM ALM_ItemAlmacenStock WHERE IdItem=item.IdItem ) StockActual
        FROM VTA_Documento doc
          LEFT JOIN VTA_DocumentoDetalle det ON doc.IdTipoDocumento=det.IdTipoDocumento AND doc.IdCompania=det.IdCompania AND doc.NumeroDocumento=det.NumeroDocumento
            LEFT JOIN ALM_ItemMast item ON det.ItemCodigo=item.IdItem
              LEFT JOIN MST_ClaseLinea linea ON item.IdLinea=linea.IdLinea
                LEFT JOIN MST_PersonaMast per ON item.IdPersona=per.IdPersona
                  LEFT JOIN ALM_Marca marca ON marca.IdMarca=item.IdMarca
        WHERE 1=1 $s_Where
             AND doc.IdCompania='1' AND doc.Estado='CE' AND item.IdItemTipo IN ( '02' )  
        GROUP BY item.IdItem
        ORDER BY SumMontoFinal DESC";
        //doc.Vendedor, per.IdPersona, linea.IdLinea,
        //pr ($s_Sql);
        $a_RowRs = array();
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        while( $o_ResultSet->next() )
        {
            $a_RowRs[] = $o_ResultSet->getRow();
        }
        return $a_RowRs;
    }
}
?>