<?php
/* Busqueda de registros de la tabla MST_ListaPrecioCabecera redefinidos por el usuario. */
class MST_ListaPrecioCabeceraFN extends BaseMST_ListaPrecioCabeceraFN
{
    public static function getObjectMnDefault(): MST_ListaPrecioCabeceraBN
    {
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraFN->setIdCompania( myUser::getUser()->getIdCompania() );
        $o_MST_ListaPrecioCabeceraFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $a_MST_ListaPrecioCabecera = $o_MST_ListaPrecioCabeceraFN->select();
        $o_MST_ListaPrecioCabeceraBN = new MST_ListaPrecioCabeceraBN();
        if( $a_MST_ListaPrecioCabecera )
        {
            $o_MST_ListaPrecioCabeceraBN = $a_MST_ListaPrecioCabecera[0];
        }
        return $o_MST_ListaPrecioCabeceraBN;
    }

    public static function getMonedaCodeDefault(): string
    {
        return self::getObjectMnDefault()->getIdMoneda();
    }

    public function buscaListaPrecioAlternativo()
    {
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraFN->addOrderBy( MST_ListaPrecioCabeceraFN::IdListaPreciCab );
        $a_MST_ListaPrecioCabecera = $o_MST_ListaPrecioCabeceraFN->select();
        if( $a_MST_ListaPrecioCabecera )
        {
            return $a_MST_ListaPrecioCabecera[0];
        }
        return null;
    }

    /**
     * @param null $IdCompania
     * @param null $IdSucursal
     * @return MST_ListaPrecioCabeceraBN|null
     * @throws SQLException
     */
    public function selectByPK( $IdCompania = null, $IdSucursal = null )
    {
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        if( $this->getIdListaPreciCab() )
        {
            $o_MST_ListaPrecioCabeceraBN = parent::selectByPK( $this->getIdListaPreciCab() );
        }
        else
        {
            if( is_null( $IdSucursal ) )
            {
                $o_MST_ListaPrecioCabeceraBN = parent::selectByPK( $IdCompania );
            }
            else
            {
                $o_MST_ListaPrecioCabeceraFN->setIdCompania( $IdCompania );
                $o_MST_ListaPrecioCabeceraFN->setIdSucursal( $IdSucursal );
                $a_MST_ListaPrecioCabecera = $o_MST_ListaPrecioCabeceraFN->select();
                if( !$a_MST_ListaPrecioCabecera )
                {
                    $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
                    $o_MST_ListaPrecioCabeceraFN->setIdCompania( $IdCompania );
                    $a_MST_ListaPrecioCabecera = $o_MST_ListaPrecioCabeceraFN->select();
                }
                $o_MST_ListaPrecioCabeceraBN = $a_MST_ListaPrecioCabecera[0];
            }
        }
        return $o_MST_ListaPrecioCabeceraBN;
    }
}
?>