<?php
/* Metodos de acceso a los campos de la tabla VTA_PrsProyectos redefinidos por el usuario */
class VTA_PrsProyectosBN extends BaseVTA_PrsProyectosBN
{
    const ESTADO_PENDIENTE  = "P";
    const ESTADO_ANULADO    = "A";
    const ESTADO_COMPLETADO = "C";

    const ESTADO_DEVOLUCION_PENDIENTE  = "P";
    const ESTADO_DEVOLUCION_COMPLETADO = "C";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                VTA_PrsProyectosBN::ESTADO_PENDIENTE  => "PENDIENTE",
                VTA_PrsProyectosBN::ESTADO_ANULADO    => "ANULADO",
                VTA_PrsProyectosBN::ESTADO_COMPLETADO => "CONCLUIDO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return VTA_PrsProyectosBN::getArrayEstados( $this->getEstado() );
    }

    public static function getArrayDevolucionEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            VTA_OrdenBN::ESTADO_DEVOLUCION_PENDIENTE  => "PENDIENTE",
            VTA_OrdenBN::ESTADO_DEVOLUCION_COMPLETADO => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getDevolucionEstadoDesc()
    {
        return VTA_OrdenBN::getArrayDevolucionEstados( $this->getEstadoDevolucion() );
    }
    
    public function getDepartamentoDesc()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $this->getDepartamento() );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }
    
    public function getProvinciaDesc()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $this->getProvincia() );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }
    
    public function getDistritoDesc()
    {
        $o_MST_UbigeoFN = new MST_UbigeoFN();
        $o_MST_UbigeoBN = $o_MST_UbigeoFN->selectByPK( $this->getDistrito() );
        if( $o_MST_UbigeoBN )
        {
            return $o_MST_UbigeoBN->getDescripcion();
        }
        return "";
    }

    public function getNumeroDevolucionesCab(): int
    {
        $o_SR_DevolucionCabeceraFN = new SR_DevolucionCabeceraFN();
        $o_SR_DevolucionCabeceraFN->setIdProyecto( $this->getIdProyecto() );
        return $o_SR_DevolucionCabeceraFN->selectNumRows();
    }

    public function getCantidadDespachado(): int
    {
        $a_Data = VTA_PrsProyectosFN::getResumenDevolucionPorProyecto( $this->getIdProyecto() );
        return intval( $a_Data['CantidadPedida'] );
    }

    public function getCantidadDevuelto(): int
    {
        $a_Data = VTA_PrsProyectosFN::getResumenDevolucionPorProyecto( $this->getIdProyecto() );
        return intval( $a_Data['CantidadDevuelto'] );
    }

    public function getCantidadPorDevolver(): int
    {
        $a_Data = VTA_PrsProyectosFN::getResumenDevolucionPorProyecto( $this->getIdProyecto() );
        return intval( $a_Data['PorDevolver'] );
    }
}
?>