<?php
/* Metodos de acceso a los campos de la tabla VTA_OrdenDetalle redefinidos por el usuario */
class VTA_OrdenDetalleBN extends BaseVTA_OrdenDetalleBN
{
    const TIPO_PRODUCTO          = "P"; //PRODUCTO
    const TIPO_PRODUCTO_SERVICIO = "S"; //SERVICIO
    const TIPO_PRODUCTO_FINAL    = "F"; //FINAL
    const TIPO_COMENTARIO        = "C"; //COMENTARIO
    const TIPO_DESCUENTO         = "D"; //DESCUENTO

    protected static $OrdenH = array();

    protected $CambioPrecio;
    
    private static function getOrdenCab( $IdOrdenH )
    {
        if ( !isset( static::$OrdenH[$IdOrdenH] ) )
        {
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            static::$OrdenH[$IdOrdenH] = $o_VTA_OrdenFN->selectByPK( $IdOrdenH );
        }
        return static::$OrdenH[$IdOrdenH];
    }

    /**
     * @return VTA_OrdenBN
     */
    public function getObjectOrdenBN()
    {
        $o_VTA_OrdenBN = VTA_OrdenDetalleBN::getOrdenCab( $this->getOrdenId() );
        return $o_VTA_OrdenBN;
    }

    public function getIdConcat()
    {
        return $this->getOrdenId()."_".$this->getOrdenDetalleNum();
    }

    public function getResumenStockPorAlmacen()
    {
        $i_StockFisico = ALM_ItemAlmacenStockFN::getStockFisicoTotal( $this->getItemCod(), $this->getAlmacenCod() );
        return $i_StockFisico;
    }

    public function getObjectItemAlmacen()
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( myUser::getUser()->getIdBusiness(), $this->getItemCod(), $this->getAlmacenCod(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, $this->getLoteNum() );
        if( !$o_ALM_ItemAlmacenStockBN )
        {
            $o_ALM_ItemAlmacenStockBN = new ALM_ItemAlmacenStockBN();
        }
        //pr( $o_ALM_ItemAlmacenStockBN );
        return $o_ALM_ItemAlmacenStockBN;
    }

    public function getMarcaDesc()
    {
        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaBN = $o_ALM_MarcaFN->selectByPK( $this->getObjectItem()->getIdMarca() );
        if( $o_ALM_MarcaBN )
        {
            return $o_ALM_MarcaBN->getDescripcionLocal();
        }
        return "";
    }

    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getItemCod() );
        if( !$o_ALM_ItemMastBN )
        {
            $o_ALM_ItemMastBN = new ALM_ItemMastBN();
        }
        return $o_ALM_ItemMastBN;
    }

    public function getPeso()
    {
        $o_Obj = $this->getObjectItem();
        return $o_Obj->getPesoGramos();
    }
    
    public function getObjectUnidad()
    {
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getIdUnidad() );
        if( !$o_MST_UnidadMastBN )
        {
            $o_MST_UnidadMastBN = new MST_UnidadMastBN();
        }
        return $o_MST_UnidadMastBN;
    }

    public function getPrecioUnitario()
    {
        $o_VTA_OrdenBN = VTA_OrdenDetalleBN::getOrdenCab( $this->getOrdenId() );
        if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenDetallePrecioUnidadMN();
        }
        return $this->getOrdenDetallePrecioUnidad();
    }

    public function getOrdenSubTotalFinal()
    {
        $o_VTA_OrdenBN = VTA_OrdenDetalleBN::getOrdenCab( $this->getOrdenId() );
        if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenDetalleSubTotalVentaMN();
        }
        return $this->getOrdenDetalleSubTotalVenta();
    }
    
    public function getNivelPrecioAsignado()
    {
        $o_VTA_OrdenBN = VTA_OrdenDetalleBN::getOrdenCab( $this->getOrdenId() );
        if( $o_VTA_OrdenBN )
        {
            if( $o_VTA_OrdenBN->getPrecioNivel() )
            {
                return $o_VTA_OrdenBN->getPrecioNivel();
            }
            else
            {
                return "1";
            }
            
        }
        return "";
    }
    
    public function getCostoAlmacen()
    {
        $o_VTA_OrdenBN = VTA_OrdenDetalleBN::getOrdenCab( $this->getOrdenId() );
        
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( myUser::getUser()->getIdBusiness(), $this->getItemCod(), $this->getAlmacenCod(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO, $this->getLoteNum() );

        if( $o_ALM_ItemAlmacenStockBN )
        {
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
            {
                if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                {
                    return $o_ALM_ItemAlmacenStockBN->getPrecioUnitario();
                }
                if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                {
                    //return $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() / $o_VTA_OrdenBN->getMonedaCambioValor();
                    return $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares();
                }
            }
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
            {
                if( $o_VTA_OrdenBN->getMonedaCod() == 'LO' )
                {
                    //return $o_ALM_ItemAlmacenStockBN->getPrecioUnitario() * $o_VTA_OrdenBN->getMonedaCambioValor();
                    return $o_ALM_ItemAlmacenStockBN->getPrecioUnitario();
                }
                if( $o_VTA_OrdenBN->getMonedaCod() == 'EX' )
                {
                    return $o_ALM_ItemAlmacenStockBN->getPrecioUnitarioDolares();
                }
            }
        }
        return 0.00;
    }

    public function getBultos()
    {
        return 0;
    }

    /**
     * @return the $CambioPrecio
     */
    public function getCambioPrecio()
    {
        return $this->CambioPrecio;
    }

    /**
     * @param field_type $CambioPrecio
     */
    public function setCambioPrecio($CambioPrecio)
    {
        $this->CambioPrecio = $CambioPrecio;
    }

    public function getCantidadEscanPorOrden()
    {
        $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
        //$o_SR_PreSerieEscaneoFN->setReferenciaTipo( "OS" );
        $o_SR_PreSerieEscaneoFN->setReferenciaNumero( $this->getObjectOrdenBN()->getOrdenNum() );
        $o_SR_PreSerieEscaneoFN->setProductoId( $this->getItemCod() );
        $i_Count = $o_SR_PreSerieEscaneoFN->selectNumRows();
        if( !$i_Count )
        {
            $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
            //$o_SR_SerieEscaneoFN->setReferenciaTipo( "OS" );
            $o_SR_SerieEscaneoFN->setReferenciaNumero( $this->getObjectOrdenBN()->getOrdenNum() );
            $o_SR_SerieEscaneoFN->setProductoId( $this->getItemCod() );
            $i_Count = $o_SR_SerieEscaneoFN->selectNumRows();
        }
        return $i_Count;
    }
    
    protected $ForzarIdTipoLista;
    public function getForzarIdTipoLista()
    {
        return $this->ForzarIdTipoLista;
    }
    public function setForzarIdTipoLista( $ForzarIdTipoLista )
    {
        $this->ForzarIdTipoLista = $ForzarIdTipoLista;
    }

    protected $Contrasenia;
    public function getContrasenia()
    {
        return $this->Contrasenia;
    }
    public function setContrasenia( $Contrasenia ): void
    {
        $this->Contrasenia = $Contrasenia;
    }

    protected $TipoProcPromo;
    public function getTipoProcPromo()
    {
        return $this->TipoProcPromo;
    }
    public function setTipoProcPromo($TipoProcPromo)
    {
        $this->TipoProcPromo = $TipoProcPromo;
    }

    public function TieneNumeroPromocion()
    {
        if( $this->getDocRefNum() )
        {
            return $this;
        }
        if( !$this->getDocRefNum() )
        {
            if( $this->getOrdenId() && $this->getOrdenDetalleNum() )
            {
                $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                $o_VTA_OrdenDetalleBN = $o_VTA_OrdenDetalleFN->selectByPK( $this->getOrdenId(), $this->getOrdenDetalleNum() );
                if( $o_VTA_OrdenDetalleBN )
                {
                    if( $o_VTA_OrdenDetalleBN->getDocRefNum() )
                    {
                        return $o_VTA_OrdenDetalleBN;
                    }
                }
            }
            if( $this->getOrdenId() && $this->getItemCod() )
            {
                $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                $o_VTA_OrdenDetalleFN->setOrdenId( $this->getOrdenId() );
                //$o_VTA_OrdenDetalleFN->setItemTipo( "P" );
                $o_VTA_OrdenDetalleFN->setItemCod( $this->getItemCod() );
                if( $this->getAlmacenCod() )
                    $o_VTA_OrdenDetalleFN->setAlmacenCod( $this->getAlmacenCod() );
                $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
                if( $a_VTA_OrdenDetalle )
                {
                    $o_VTA_OrdenDetalleBN = $a_VTA_OrdenDetalle[0];
                    if( $o_VTA_OrdenDetalleBN )
                    {
                        if( $o_VTA_OrdenDetalleBN->getDocRefNum() )
                        {
                            return $o_VTA_OrdenDetalleBN;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected $DescuentoUnitario;
    public function getDescuentoUnitario()
    {
        return $this->DescuentoUnitario;
    }
    public function setDescuentoUnitario( $DescuentoUnitario ): void
    {
        $this->DescuentoUnitario = $DescuentoUnitario;
    }

    protected $LimpiarDscto;
    public function getLimpiarDscto()
    {
        return $this->LimpiarDscto;
    }
    public function setLimpiarDscto( $LimpiarDscto ): void
    {
        $this->LimpiarDscto = $LimpiarDscto;
    }
}
?>