<?php
/* Metodos de acceso a los campos de la tabla VTA_Orden redefinidos por el usuario */
class VTA_OrdenBN extends BaseVTA_OrdenBN
{
    //ESTADO
    const ESTADO_ABIERTO  = "O"; //PENDIENTE
    const ESTADO_REVISADO = "R"; //REVISADO
    const ESTADO_CERRADO  = "C"; //PROCESO
    const ESTADO_ANULADO  = "A"; //ANULADO
    const ESTADO_FACTURA  = "F"; //TERMINADO

    const ORDEN_ESTANDAR = 1;
    const ORDEN_MASTER   = 2;
    
    const ESTADO_DEVOLUCION_PENDIENTE  = "P";
    const ESTADO_DEVOLUCION_COMPLETADO = "C";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            self::ESTADO_ABIERTO  => "INGRESO",
            //self::ESTADO_REVISADO => "REVISADO",
            //self::ESTADO_CERRADO  => "PROCESO",
            self::ESTADO_ANULADO  => "ANULADO",
            self::ESTADO_FACTURA  => "SALIDA",
        );
        if( !is_null( $sEstado ) )
        {
            if( isset( $a_sEstado[$sEstado] ) )
            {
                return $a_sEstado[$sEstado];
            }
        }
        return $a_sEstado;
    }
    
    public function getOrdenEstadoDesc()
    {
        return VTA_OrdenBN::getArrayEstados( $this->getOrdenEstado() );
    }
    
    public static function getArrayDevolucionEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                VTA_OrdenBN::ESTADO_DEVOLUCION_PENDIENTE  => "PENDIENTE",
                VTA_OrdenBN::ESTADO_DEVOLUCION_COMPLETADO => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getDevolucionEstadoDesc()
    {
        return VTA_OrdenBN::getArrayDevolucionEstados( $this->getEstadoDevolucion() );
    }
    
    public function getGuiaFechaInicioAlq()
    {
        $s_FechaInicioAlquiler = "";
        $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
        $o_SR_GuiaRemisionHFN->setReferenciaParentId( $this->getOrdenId() );
        $o_SR_GuiaRemisionHFN->addOrderBy( SR_GuiaRemisionHFN::FechaInicioAlq );
        $a_SR_GuiaRemision = $o_SR_GuiaRemisionHFN->select();
        foreach ( $a_SR_GuiaRemision as $o_SR_GuiaRemisionBN )
        {
            $s_FechaInicioAlquiler = $o_SR_GuiaRemisionBN->getFechaInicioAlq();
            break;
        }
        return $s_FechaInicioAlquiler;
    }

    public function getObjectCliente()
    {
        if( $this->getClienteId() )
        {
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getClienteId() );
        }
        else
        {
            $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        }
        return $o_MST_PersonaMastBN;
    }
    
    public function getObjectVehiculoTipo()
    {
        if( $this->getIdVehiculoTipo() )
        {
            $o_CAR_VehiculoTipoFN = new CAR_VehiculoTipoFN();
            $o_CAR_VehiculoTipoBN = $o_CAR_VehiculoTipoFN->selectByPK( $this->getIdVehiculoTipo() );
        }
        else
        {
            $o_CAR_VehiculoTipoBN = new CAR_VehiculoTipoBN();
        }
        return $o_CAR_VehiculoTipoBN;
    }
    
    public function getObjectVendedor()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setIdUsuario( $this->getVendedorOrden() );
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        $o_MST_PersonaMastBN = new MST_PersonaMastBN();
        if( $a_MST_PersonaMast )
        {
            $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
        }
        return $o_MST_PersonaMastBN;
    }
    
    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenCod() );
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getObjectAlmacenDespacho()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenDespacho() );
        if( !$o_ALM_AlmacenMastBN )
        {
            $o_ALM_AlmacenMastBN = new ALM_AlmacenMastBN();
        }
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getObjectPrsProyectos()
    {
        if( $this->getIdProyecto() )
        {
            $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
            $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $this->getIdProyecto() );
            if( !$o_VTA_PrsProyectosBN )
            {
                $o_VTA_PrsProyectosBN = new VTA_PrsProyectosBN();
            }
        }
        else
        {
            $o_VTA_PrsProyectosBN = new VTA_PrsProyectosBN();
        }
        return $o_VTA_PrsProyectosBN;
    }
    
    public function getProyectoNombre()
    {
        return $this->getObjectPrsProyectos()->getNombreProyecto();
    }

    public function getOrdenTipoObject()
    {
        $o_VTA_OrdenTipoFN = new VTA_OrdenTipoFN();
        $o_VTA_OrdenTipoBN = $o_VTA_OrdenTipoFN->selectByPK( $this->getOrdenTipoId() );
        return $o_VTA_OrdenTipoBN;
    }
    
    public function getTipoOrdenDesc()
    {
        $o_VTA_OrdenTipoFN = new VTA_OrdenTipoFN();
        $o_VTA_OrdenTipoBN = $o_VTA_OrdenTipoFN->selectByPK( $this->getOrdenTipoId() );
        return $o_VTA_OrdenTipoBN->getOrdenTipoDescripcion();
    }
    
    public function getOrdenMonedaDesc()
    {
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->getMonedaCod() );
        return $o_GSS_MonedaMastBN->getDescripcion();
    }
    
    public function getMontoAfecto()
    {
        if( $this->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenAfectoMN();
        }
        return $this->getOrdenAfecto();
    }
    
    public function getMontoNoAfecto()
    {
        if( $this->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenInafectoMN();
        }
        return $this->getOrdenInafecto();
    }
    
    public function getMontoImpuestos()
    {
        if( $this->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenImpuestoMN();
        }
        return $this->getOrdenImpuesto();
    }
    
    public function getMontoTotal()
    {
        if( $this->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenNetoMN();
        }
        return $this->getOrdenNeto();
    }
    
    public function getTotalOrdenUtil()
    {
        if( $this->getMonedaCod() == 'LO' )
        {
            return $this->getOrdenAfectoMN() + $this->getOrdenInafectoMN() + $this->getMontoExoneradoMN();
        }
        return $this->getOrdenAfecto() + $this->getOrdenInafecto() + $this->getMontoExonerado();
    }
    
    public function getIdCompania()
    {
        return $this->getCiaCod();
    }

    protected $b_AnularDocumento;
    public function setAnularDocumemtoreferencia( $v )
    {
        $this->b_AnularDocumento = $v;
    }

    public function getAnularDocumemtoreferencia()
    {
        return $this->b_AnularDocumento;
    }
    
    public function getArrayDetalles()
    {
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $this->getOrdenId() );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        return $a_VTA_OrdenDetalle;
    }
    
    public function getArrayDetallesFinal()
    {
        $o_VTA_ProductoFinalFN = new VTA_ProductoFinalFN();
        $o_VTA_ProductoFinalFN->setOrdenId( $this->getOrdenId() );
        $a_VTA_ProductoFinal = $o_VTA_ProductoFinalFN->select();
        return $a_VTA_ProductoFinal;
    }
    
    public function getObjectVTADocumento()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getDocReferenciaId() );
        if( !$o_VTA_DocumentoBN )
        {
            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
        }
        return $o_VTA_DocumentoBN;
    }

    public function getCobranzaEstadoDesc()
    {
        $o_VTA_DocumentoBN = $this->getObjectVTADocumento();
        if( $o_VTA_DocumentoBN )
        {
            return $o_VTA_DocumentoBN->getCobranzaEstadoDesc();
        }
        return "";
    }

    public function getSaldoTotalComprobante()
    {
        $o_VTA_DocumentoBN = $this->getObjectVTADocumento();
        if( $o_VTA_DocumentoBN )
        {
            return floatval( $o_VTA_DocumentoBN->getMontoSaldo() );
        }
        return 0;
    }

    public function getEstadoDespacho()
    {
        $o_SR_MovimientoBN = SR_MovimientoFN::getObjectMovimientoByIdOrden( $this->getOrdenId() );
        if( $o_SR_MovimientoBN )
        {
            return $o_SR_MovimientoBN->getImpresionEstadoDesc();
        }
        return "";
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA DE VALIDEZ DE OFERTA
    public function getObjectValidezOf()
    {
        $o_MST_ValidezOfFN = new MST_ValidezOfFN();
        $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $this->getValidezOrden() );
        return $o_MST_ValidezOfBN;
    }

    public function getValidezOrdenDesc()
    {
        return $this->getObjectValidezOf()->getDescripcion();
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA DE PLAZO DE ENTREGA
    public function getObjectPlazoEnt()
    {
        $o_MST_PlazoEntFN = new MST_PlazoEntFN();
        $o_MST_PlazoEntBN = $o_MST_PlazoEntFN->selectByPK( $this->getPlazaEntregaOrden() );
        return $o_MST_PlazoEntBN;
    }

    public function getPlazoEntregaOrdenDesc()
    {
        return $this->getObjectPlazoEnt()->getDescripcion();
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    /// TABLA DE DIAS DE ALQUILER
    public function getObjectDiasAlq()
    {
        $o_MST_DiasAlqFN = new MST_DiasAlqFN();
        $o_MST_DiasAlqBN = $o_MST_DiasAlqFN->selectByPK( $this->getDiasAlquiler() );
        return $o_MST_DiasAlqBN;
    }

    public function getDiasAlqOrdenDesc()
    {
        return $this->getObjectDiasAlq()->getDescripcion();
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA DE TIPO DE ORDEN - COMERCIAL
    const TIPO_COMERCIAL_VENTA       = 1;
    const TIPO_COMERCIAL_ALQUILER    = 2;
    static $a_DataStatic3 = array
    (
        VTA_OrdenBN::TIPO_COMERCIAL_VENTA => "VENTA", VTA_OrdenBN::TIPO_COMERCIAL_ALQUILER => "ALQUILER - SERVICIOS"
    );
    
    public static function getArrayTipoOrdenComercial( $s_Value = null )
    {
        if( !is_null( $s_Value ) )
        {
            if( isset( VTA_OrdenBN::$a_DataStatic3[$s_Value] ) )
            {
                return VTA_OrdenBN::$a_DataStatic3[$s_Value];
            }
            else
            {
                return "----";
            }
        }
        return VTA_OrdenBN::$a_DataStatic3;
    }
    
    public function getTipoOrdenComercialDesc()
    {
        $s_Valor = !is_null( $this->getOrdenTipoComercialId() ) ? VTA_OrdenBN::getArrayTipoOrdenComercial( $this->getOrdenTipoComercialId() ) : "----";
        return $s_Valor;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //CONDICION DE VENTA
    const CONDICION_VENTA_CON = "CONADE";
    const CONDICION_VENTA_SIN = "SINADE";

    static $a_DataStatic4 = array
    (
            VTA_OrdenBN::CONDICION_VENTA_SIN => "SIN ADELANTO", VTA_OrdenBN::CONDICION_VENTA_CON => "CON ADELANTO"
    );
    
    public static function getArrayCondicionVenta( $s_Value = null )
    {
        if( !is_null( $s_Value ) )
        {
            if( isset( VTA_OrdenBN::$a_DataStatic4[$s_Value] ) )
            {
                return VTA_OrdenBN::$a_DataStatic4[$s_Value];
            }
            else
            {
                return "----";
            }
        }
        return VTA_OrdenBN::$a_DataStatic4;
    }
    
    public function getCondicionVentaDesc()
    {
        $s_Valor = !is_null( $this->getCondicionVenta() ) ? VTA_OrdenBN::getArrayCondicionVenta( $this->getCondicionVenta() ) : "----";
        return $s_Valor;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //TABLA DE CLASIFICACION DE ORDEN
    const TIPO_ACCESORIOS           = 1;
    const TIPO_PRODUCTOS_TERMINADOS = 2;
    const TIPO_OTROS = 3;
    const TIPO_SERTEC = 4;
    static $a_DataStatic5 = array
    (
        VTA_OrdenBN::TIPO_ACCESORIOS => "ACCESORIOS", VTA_OrdenBN::TIPO_PRODUCTOS_TERMINADOS => "PRODUCTOS TERMINADOS", VTA_OrdenBN::TIPO_OTROS => "OTROS", VTA_OrdenBN::TIPO_SERTEC => "SERVICIO TECNICO"
    );
    
    public static function getArrayTipoClasificacion( $s_Value = null )
    {
        if( !is_null( $s_Value ) )
        {
            if( isset( VTA_OrdenBN::$a_DataStatic5[$s_Value] ) )
            {
                return VTA_OrdenBN::$a_DataStatic5[$s_Value];
            }
            else
            {
                return "----";
            }
        }
        return VTA_OrdenBN::$a_DataStatic5;
    }
    
    public function getTipoClasificacionDesc()
    {
        $s_Valor = !is_null( $this->getOrdenTipoClasificacionId() ) ? VTA_OrdenBN::getArrayTipoClasificacion( $this->getOrdenTipoClasificacionId() ) : "----";
        return $s_Valor;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    public function getConcatComercialClasificacion()
    {
        return $this->getTipoOrdenComercialDesc()." - ".$this->getTipoClasificacionDesc();
    }
    
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    public function esGravadaConImpuesto()
    {
        //sunat_transaction | NUBEFACT
        switch ( $this->getFactRegla() )
        {
            case "EXP": //2 = EXPORTACIÓN
                return false;
            break;
            case "MER": //1 = VENTA INTERNA
                return true;
            break;
        }
        
    }

    public function esExoneradodeIGV(  )
    {
        if( $this->getOrdenExoneradoFlag() == "Y" )
        {
            return true;
        }
        return false;
    }
}
?>