<?php
/* Metodos de acceso a los campos de la tabla VTA_FacturacionElectronica redefinidos por el usuario */
class VTA_FacturacionElectronicaBN extends BaseVTA_FacturacionElectronicaBN
{
    //ESTADO
    const ESTADO_PENDIENTE = "P";
    const ESTADO_ENVIADO   = "E";
    const ESTADO_ERROR     = "X";
    const ESTADO_ANULADO   = "A";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            self::ESTADO_PENDIENTE => "PENDIENTE",
            self::ESTADO_ENVIADO   => "ENVIADO",
            self::ESTADO_ERROR     => "ERROR",
            self::ESTADO_ANULADO   => "ANULADO"
        );
        if( !is_null( $sEstado ) )
        {
            if( isset( $a_sEstado[$sEstado] ) )
            {
                return $a_sEstado[$sEstado];
            }
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return VTA_FacturacionElectronicaBN::getArrayEstados( $this->getEstado() );
    }

    public function getEstadoWebDesc()
    {
        return VTA_DocumentoBN::getArrayEstados( $this->getEstadoWeb() );
    }

    public function getSerieNumero()
    {
        return $this->getSerie()."-".$this->getNumero();
    }

    public function getFechaDocumentoRec()
    {
        return substr( $this->getFechaEmision(), 0, 10 );
    }

    public function getMonedaDesc()
    {
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->getTipoMoneda() );
        
        return $o_GSS_MonedaMastBN->getDescripcion();
    }
}
?>