<?php
/* M�todos de acceso a los campos de la tabla VTA_DocumentoDetalle redefinidos por el usuario */
class VTA_DocumentoDetalleBN extends BaseVTA_DocumentoDetalleBN
{
    //ESTADO
    const ESTADO_PREPARACION   = "P";
    const ESTADO_CANCELADO     = "N";
    const ESTADO_CERRADO       = "C";
    const ESTADO_ANULADO       = "A";
    
    const TIPO_DETALLE            = "P"; //PRODUCTO
    const TIPO_DETALLE_COMENTARIO = "C"; //COMENTARIO
    const TIPO_DETALLE_DESCUENTO  = "D"; //DESCUENTO
    const TIPO_DETALLE_SERVICIO   = "S"; //SERVICIO
    
    const ITEM_ZZDSCTO          = "ZZDSCTO";

    protected static $Object = array();

    private static function getObjectSingleton( $IdTipoDocumento, $IdCompania, $NumeroDocumento )
    {
        $Id = $IdTipoDocumento."_".$IdCompania."_".$NumeroDocumento;
        if ( !isset( static::$Object[$Id] ) )
        {
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            //$o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $this->getIdTipoDocumento(), $this->getIdCompania(), $this->getNumeroDocumento() );
            static::$Object[$Id] = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        }
        return static::$Object[$Id];
    }

    public function getObjectDocumentoBN()
    {
        $o_VTA_DocumentoBN = VTA_DocumentoDetalleBN::getObjectSingleton( $this->getIdTipoDocumento(), $this->getIdCompania(), $this->getNumeroDocumento() );
        return $o_VTA_DocumentoBN;
    }
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                        self::ESTADO_PREPARACION => "PREPARACION",
                        self::ESTADO_CANCELADO   => "CANCELADO",
                        self::ESTADO_CERRADO     => "CERRADO",
                        self::ESTADO_ANULADO     => "ANULADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getIdConcat()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdTipoDocumento()."_".$this->getIdCompania()."_".$this->getNumeroDocumento()."_".$this->getSecuencia();
        }
        return null;
    }

    public function getObjectDocumentoCab()
    {
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $this->getIdTipoDocumento(), $this->getIdCompania(), $this->getNumeroDocumento() );
        if( !$o_VTA_DocumentoBN )
        {
            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
        }
        return $o_VTA_DocumentoBN;
    }

    public function getVendedor()
    {
        return $this->getObjectDocumentoCab()->getVendedor();
    }

    public function getClienteNombre()
    {
        return $this->getObjectDocumentoCab()->getClienteNombre();
    }

    public function getClienteDireccion()
    {
        return $this->getObjectDocumentoCab()->getClienteDireccion();
    }

    public function getClienteDistrito()
    {
        return $this->getObjectDocumentoCab()->getClientereferencia();
    }

    public function getLoteAliasPr()
    {
        if( is_null( $this->getLoteAlias() ) || $this->getLoteAlias() == "" )
        {
            return $this->getLote();
        }
        return $this->getLoteAlias();
    }
    
    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenCodigo() );
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getObjectItemAlmacen()
    {
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        $o_ALM_ItemAlmacenStockBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $this->getIdCompania(), $this->getItemCodigo(), $this->getAlmacenCodigo(), ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO , $this->getLote() );
        if( !$o_ALM_ItemAlmacenStockBN )
        {
            $o_ALM_ItemAlmacenStockBN = new ALM_ItemAlmacenStockBN();
        }
        return $o_ALM_ItemAlmacenStockBN;
    }

    public function getResumenStockPorAlmacen()
    {
        $i_StockFisico = ALM_ItemAlmacenStockFN::getStockFisicoTotal( $this->getItemCodigo(), $this->getAlmacenCodigo() );
        return $i_StockFisico;
    }

    public function getAlmcenStockDisponible()
    {
        $o_ALM_ItemAlmacenStockBN = $this->getObjectItemAlmacen();
        return $o_ALM_ItemAlmacenStockBN->getStockDisponible();
    }
    
    public function getStockFisico()
    {
        $f_StockFisico = 0;
        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
        //$o_ALM_ItemAlmacenStockFN->setIdCompania( $this->getIdCompania() );
        $o_ALM_ItemAlmacenStockFN->setIdAlmacen( $this->getAlmacenCodigo() );
        $o_ALM_ItemAlmacenStockFN->setIdItem( $this->getItemCodigo() );
        $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();
        if( count( $a_ALM_ItemAlmacenStock ) == 1 )
        {
            $f_StockFisico = $a_ALM_ItemAlmacenStock[0]->getStockFisico();
        }
        else
        {
            foreach( $a_ALM_ItemAlmacenStock as $o_ALM_ItemAlmacenStockBN )
            {
                $f_StockFisico = $f_StockFisico + $o_ALM_ItemAlmacenStockBN->getStockFisico();
            }
        }
        return $f_StockFisico;
    }
    
    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getItemCodigo() );
        if( !$o_ALM_ItemMastBN )
        {
            $o_ALM_ItemMastBN = new ALM_ItemMastBN();
        }
        return $o_ALM_ItemMastBN;
    }

    public function getPeso()
    {
        $o_Obj = $this->getObjectItem();
        return $o_Obj->getPesoGramos();
    }

    public function getObjectTipoAfectacionIGV()
    {
        $o_MST_TipoAfectacionIGVFN = new MST_TipoAfectacionIGVFN();
        $o_MST_TipoAfectacionIGVBN = $o_MST_TipoAfectacionIGVFN->selectByPK( $this->getTipoIGV() );
        return $o_MST_TipoAfectacionIGVBN;
    }
    
    public function getItemUnidadVentaAsignada()
    {
        $o_Obj = $this->getObjectItem();
        if( $o_Obj )
        {
            return $this->getObjectItem()->getUnidadVenta();
        }
        return "-";
    }

    public function getItemCantidadMedidaAsignada()
    {
        $o_Obj = $this->getObjectItem();
        if( $o_Obj )
        {
            return $this->getObjectItem()->getCantidadUnidad();
        }
        return "-";
    }

    public function getObjectUnidad()
    {
        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $this->getIdUnidad() );
        if( !$o_MST_UnidadMastBN )
        {
            $o_MST_UnidadMastBN = new MST_UnidadMastBN();
        }
        return $o_MST_UnidadMastBN;
    }

    public function TieneNumeroPromocion()
    {
        if( $this->getNumeroPromocion() )
        {
            return true;
        }
        if( !$this->getNumeroPromocion() )
        {
            $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
            $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $this->getIdTipoDocumento(), $this->getIdCompania(), $this->getNumeroDocumento(), $this->getSecuencia() );
            if( $o_VTA_DocumentoDetalleBN )
            {
                if( $o_VTA_DocumentoDetalleBN->getNumeroPromocion() )
                {
                    return true;
                }
            }
        }
        return false;
    }

    public function getStockDisponiblePromocionGrupal()
    {
        $o_MKT_PromocionCabFN = new MKT_PromocionCabFN();
        $o_MKT_PromocionCabBN = $o_MKT_PromocionCabFN->selectByPK( $this->getRefParent() );
        if( $o_MKT_PromocionCabBN )
        {
            return $o_MKT_PromocionCabBN->getCantidadPromo() - $o_MKT_PromocionCabBN->getCantidadFacturado();
        }
        return 0;
    }
    
    public function getSeriesEscaneadasxIdMov( $s_IdMov )
    {
        $s_Sql = "
                    SELECT SR_Serie.SerieNumero
                    FROM SR_Movimiento
                      LEFT JOIN SR_MovimientoDetalle ON SR_Movimiento.MovimientoId=SR_MovimientoDetalle.MovimientoId
                        LEFT JOIN SR_SerieEscaneo ON SR_MovimientoDetalle.MovimientoDetalleId=SR_SerieEscaneo.MovimientoDetalleId
                          LEFT JOIN SR_Serie ON SR_SerieEscaneo.SerieId=SR_Serie.SerieId
                    WHERE 1=1
                    AND SR_Movimiento.MovimientoId='$s_IdMov'
                    AND SR_MovimientoDetalle.ProductoId='{$this->getItemCodigo()}'
                    ;
                ";
        $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
        $a_Series = array();
        while( $o_ResultSet->next() ) 
        {
            $a_Row = $o_ResultSet->getRow();
            $a_Series[] = $a_Row['SerieNumero'];
        }
        
        return $a_Series;
    }

    public function getCodigoBarrasItem()
    {
        return $this->getObjectItem()->getCodigoBarras();
    }
    
    public function getProveedorItem()
    {
        return $this->getObjectItem()->getProveedorDesc();
    }
    
    public function getLineaItem()
    {
        return $this->getObjectItem()->getDescripcionLinea();
    }
    
    public function getAlmacenDesc()
    {
        if( $this->getObjectAlmacen() )
        {
            return $this->getObjectAlmacen()->getDescripcionLocal();
        }
        return "";
    }

    public function getStockAlmacen()
    {
        if( $this->getObjectItemAlmacen() )
        {
            return $this->getObjectItemAlmacen()->getStockActual();
        }
        return "0";
    }
    
    public function getPrecionUnitarioDocumento()
    {
        if( $this->getObjectDocumentoCab()->getMonedaDocumento() == "LO" )
        {
            return $this->getPrecioUnitarioMN();
        }
        return $this->getPrecioUnitario();
    }
    
    public function getPrecioSubTotalDocumento()
    {
        if( $this->getObjectDocumentoCab()->getMonedaDocumento() == "LO" )
        {
            return $this->getMontoSubTotalMN();
        }
        return $this->getMontoSubTotal();
    }
    
    public function getImpuestoTotalDocumento()
    {
        if( $this->getObjectDocumentoCab()->getMonedaDocumento() == "LO" )
        {
            return $this->getMontoSubTotalImpuestoMN();
        }
        return $this->getMontoSubTotalImpuesto();
    }

    public function getCantidadEscanPorOrden()
    {
        $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
        $o_SR_PreSerieEscaneoFN->setReferenciaTipo( $this->getIdTipoDocumento() );
        $o_SR_PreSerieEscaneoFN->setReferenciaNumero( $this->getNumeroDocumento() );
        $o_SR_PreSerieEscaneoFN->setProductoId( $this->getItemCodigo() );
        $i_Count = $o_SR_PreSerieEscaneoFN->selectNumRows();
        if( !$i_Count )
        {
            $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
            $o_SR_SerieEscaneoFN->setReferenciaTipo( $this->getIdTipoDocumento() );
            $o_SR_SerieEscaneoFN->setReferenciaNumero( $this->getNumeroDocumento() );
            $o_SR_SerieEscaneoFN->setProductoId( $this->getItemCodigo() );
            $i_Count = $o_SR_SerieEscaneoFN->selectNumRows();
        }
        return $i_Count;
    }
    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    
    protected $CodigoBarrasIns;
    /**
     * @return the $CodigoBarrasIns
     */
    public function getCodigoBarrasIns()
    {
        return $this->CodigoBarrasIns;
    }

    /**
     * @param field_type $CodigoBarrasIns
     */
    public function setCodigoBarrasIns($CodigoBarrasIns)
    {
        $this->CodigoBarrasIns = $CodigoBarrasIns;
    }

    protected $b_CambioPrecio;
    public function setCambioPrecioFlag( $v )
    {
        $this->b_CambioPrecio = $v;
    }
    public function getCambioPrecioFlag()
    {
        return $this->b_CambioPrecio;
    }
    
    protected $o_ObjectParentCab;
    public function setObjectParentCab( $v )
    {
        $this->o_ObjectParentCab = $v;
    }
    public function getObjectParentCab()
    {
        return $this->o_ObjectParentCab;
    }
    
    protected $IdTransaccionOperacion;
    public function getIdTransaccionOperacion()
    {
        return $this->IdTransaccionOperacion;
    }
    public function setIdTransaccionOperacion( $IdTransaccionOperacion )
    {
        $this->IdTransaccionOperacion = $IdTransaccionOperacion;
    }
    
    protected $IdSucursal;
    public function setIdSucursal( $v )
    {
        $this->IdSucursal = $v;
    }
    public function getIdSucursal()
    {
        return $this->IdSucursal;
    }
    
    protected $i_ValorEspecial;
    public function setValorEspecial( $v )
    {
        $this->i_ValorEspecial = $v;
    }
    public function getValorEspecial()
    {
        return $this->i_ValorEspecial;
    }
    
    protected $b_LoteVarios;
    public function getLoteVarios()
    {
        return $this->b_LoteVarios;
    }
    public function setLoteVarios( $b_LoteVarios )
    {
        $this->b_LoteVarios = $b_LoteVarios;
        return $this;
    }

    protected $TipoProcPromo;
    public function getTipoProcPromo()
    {
        return $this->TipoProcPromo;
    }
    public function setTipoProcPromo($TipoProcPromo)
    {
        $this->TipoProcPromo = $TipoProcPromo;
    }
    
    protected $CantidadaDescontar = 0;
    public function getCantidadaDescontar()
    {
        return $this->CantidadaDescontar;
    }
    public function setCantidadaDescontar( $CantidadaDescontar )
    {
        $this->CantidadaDescontar = $CantidadaDescontar;
    }

    
}
?>