<?php
/* Metodos de acceso a los campos de la tabla STE_ServicioTecnico redefinidos por el usuario */
class STE_ServicioTecnicoBN extends BaseSTE_ServicioTecnicoBN
{
    const ESTADO_RECEPCIONADO   = "1";
    const ESTADO_DIAGNOSTICO    = "2";
    const ESTADO_DIAGNOSTICO_C  = "3";
    const ESTADO_APROB_REPARA   = "4";
    const ESTADO_REPARACION     = "5";
    const ESTADO_LISTO_ENTREGA  = "6";
    const ESTADO_ENTREGADO      = "7";
    const ESTADO_RECHAZADO      = "8";
    const ESTADO_ANULADO        = "9";

    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            STE_ServicioTecnicoBN::ESTADO_RECEPCIONADO  => "RECEPCIONADO",
            STE_ServicioTecnicoBN::ESTADO_DIAGNOSTICO   => "EN DIAGNOSTICO",
            STE_ServicioTecnicoBN::ESTADO_DIAGNOSTICO_C => "DIAGNOSTICO CERRADO",
            STE_ServicioTecnicoBN::ESTADO_APROB_REPARA  => "REPERACION APROBADO",
            STE_ServicioTecnicoBN::ESTADO_REPARACION    => "EN REPARACION",
            STE_ServicioTecnicoBN::ESTADO_LISTO_ENTREGA => "REPARACION CERRADO",
            STE_ServicioTecnicoBN::ESTADO_ENTREGADO     => "ENTREGADO",
            STE_ServicioTecnicoBN::ESTADO_RECHAZADO     => "RECHAZADO",
            STE_ServicioTecnicoBN::ESTADO_ANULADO       => "ANULADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return STE_ServicioTecnicoBN::getArrayEstados( $this->getEstado() );
    }

    const SERVICIO_TECNICO   = 1;
    const SERVICIO_ADICIONAL = 2;

    public static function getArrayTipoServicio( $s_Estado = null )
    {
        $a_Estado = array
        (
            STE_ServicioTecnicoBN::SERVICIO_TECNICO   => "SERVICIO TECNICO",
            STE_ServicioTecnicoBN::SERVICIO_ADICIONAL => "SERVICIO ADICIONAL"
        );
        if( !is_null( $s_Estado ) )
        {
            return $a_Estado[$s_Estado];
        }
        return $a_Estado;
    }

    public function getTipoServicioDesc()
    {
        if( $this->getEstado() )
        {
            return STE_ServicioTecnicoBN::getArrayTipoServicio( $this->getTipoServicio() );
        }
        return "";
    }

    public function getObjectTipoGarantia()
    {
        $o_MST_TipoGarantiaFN = new MST_TipoGarantiaFN();
        $o_MST_TipoGarantiaBN = $o_MST_TipoGarantiaFN->selectByPK( $this->getTipoGarantiaId() );
        if( !$o_MST_TipoGarantiaBN )
        {
            $o_MST_TipoGarantiaBN = new MST_TipoGarantiaBN();
        }
        return $o_MST_TipoGarantiaBN;
    }

    public function getDiagnosticoCobranzaEstadoDesc()
    {
        return VTA_DocumentoBN::getArrayCobranzaEstados( $this->getDiagnosticoCobranzaEstado() );
    }

    public function getReparacionCobranzaEstadoDesc()
    {
        return VTA_DocumentoBN::getArrayCobranzaEstados( $this->getReparacionCobranzaEstado() );
    }
}
?>