<?php
/* Metodos de acceso a los campos de la tabla SR_Movimiento redefinidos por el usuario */
class SR_MovimientoBN extends BaseSR_MovimientoBN
{
    protected $MovimientoDetalleArray;
    protected $MovimientoDetalleObject;
    
    const ESTADO_ANULADO    = "A";
    const ESTADO_PENDIENTE  = "P";
    const ESTADO_COMPLETADO = "C";

    const ESTADO_IMP_N = "N";
    const ESTADO_IMP_C = "C";
    
    const APROBACION_PENDIENTE  = "P";
    const APROBACION_REVISADO   = "R";
    const APROBACION_COMPLETADO = "A";
    
    public static function getArrayprobacionEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
                SR_MovimientoBN::APROBACION_PENDIENTE  => "PENDIENTE",
                SR_MovimientoBN::APROBACION_REVISADO   => "REVISADO",
                SR_MovimientoBN::APROBACION_COMPLETADO => "APROBADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getAprobacionEstadoDesc()
    {
        return SR_MovimientoBN::getArrayprobacionEstados( $this->getEstadoAprob() );
    }
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            SR_MovimientoBN::ESTADO_ANULADO    => "ANULADO",
            SR_MovimientoBN::ESTADO_PENDIENTE  => "PENDIENTE",
            SR_MovimientoBN::ESTADO_COMPLETADO => "TERMINADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return SR_MovimientoBN::getArrayEstados( $this->getEstado() );
    }

    public static function getArrayImpresionEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            SR_MovimientoBN::ESTADO_IMP_N => "PENDIENTE",
            SR_MovimientoBN::ESTADO_IMP_C => "COMPLETADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        return $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacen() );
    }

    public function getAlmacenDesc()
    {
        return $this->getObjectAlmacen()->getDescripcionLocal();
    }

    public function getImpresionEstadoDesc()
    {
        return SR_MovimientoBN::getArrayImpresionEstados( $this->getImpresionEstado() );
    }

    /**
     * @return the $MovimientoDetalleArray
     */
    public function getMovimientoDetalleArray()
    {
        return $this->MovimientoDetalleArray;
    }

    /**
     * @param field_type $MovimientoDetalleArray
     */
    public function setMovimientoDetalleArray($MovimientoDetalleArray)
    {
        $this->MovimientoDetalleArray = $MovimientoDetalleArray;
    }
    
    /**
     * @return mixed
     */
    public function getMovimientoDetalleObject()
    {
        return $this->MovimientoDetalleObject;
    }

    /**
     * @param mixed $MovimientoDetalleObject
     *
     * @return self
     */
    public function setMovimientoDetalleObject($MovimientoDetalleObject)
    {
        $this->MovimientoDetalleObject = $MovimientoDetalleObject;

        return $this;
    }

    //metodos personalizados

    public function getBuscarDocPorRefernciaUno()
    {
        list( $s_DocSerie, $s_DocNumero ) = explode( "-", $this->getReferenciaNumero() );

        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoFN->setNumeroDocumento( $this->getReferenciaId() );
        $o_VTA_DocumentoFN->setDocumentoCod( $this->getReferenciaTipo() );
        $o_VTA_DocumentoFN->setDocumentoSerie( $s_DocSerie );
        $o_VTA_DocumentoFN->setDocumentoNumero( $s_DocNumero );
        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->select_one();
        if( $o_VTA_DocumentoBN )
        {
            return $o_VTA_DocumentoBN;
        }
        return null;
    }

    public function getObjectOrden()
    {
        $s_NumDoc = $this->getReferenciaNumero();
        switch ( $this->getReferenciaTipo() )
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':

                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $s_NumDoc );
                if( !$o_VTA_DocumentoBN->getNumeroDocumento() )
                {
                    $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_NumDoc );
                    return $o_VTA_OrdenBN;
                }
                else
                {
                    return $o_VTA_DocumentoBN->getObjectOrden();
                }

            break;
        }
    }

    public function getNumeroOrdenReferencia()
    {
        return $this->getObjectOrden()->getOrdenNum();
    }

    public function getObjectComprobante()
    {
        $s_NumDoc = $this->getReferenciaId();
        switch ( $this->getReferenciaTipo() )
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':

                return VTA_DocumentoFN::selectByDocumentNumber( $s_NumDoc );

            break;
        }
    }

    public function getNumeroComprobanteReferencia()
    {
        return $this->getObjectComprobante()->getNumeroComprobante();
    }

    public function getObjectDocumentoReferencia()
    {
        $s_NumDoc = $this->getReferenciaNumero();

        switch ( $this->getReferenciaTipo() ) 
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':

                return $this->getObjectOrden();

            break;
            case "OC":
                $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), $s_NumDoc );
                return $o_COM_OrdenCompraCabeceraBN;
            break;
        }

        if( $this->getTipoMovimiento() == "VTA" && $this->getReferenciaTipo() != "OS" )
        {
            $o_VTA_DocumentoBN = $this->getBuscarDocPorRefernciaUno();
            if( $o_VTA_DocumentoBN )
            {
                return $o_VTA_DocumentoBN;
            }
        }

        return null;
    }

    public function getConcatComercialClasificacion()
    {
        $s_NumDoc = $this->getReferenciaNumero();
        
        switch ( $this->getReferenciaTipo() )
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':
                $o_VTA_OrdenBN = $this->getObjectOrden();
                return $o_VTA_OrdenBN->getConcatComercialClasificacion();
                break;
            case "OC":
                $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), $s_NumDoc );
                return $o_COM_OrdenCompraCabeceraBN->getNombreProveedor();
            break;
        }
        
        if( $this->getTipoMovimiento() == "VTA" && $this->getReferenciaTipo() != "OS" )
        {
            $o_VTA_DocumentoBN = $this->getBuscarDocPorRefernciaUno();
            if( $o_VTA_DocumentoBN )
            {
                return $o_VTA_DocumentoBN->getClienteNombre();
            }
        }
        return "";
    }
    
    public function getDocumentoCliente()
    {
        $s_NumDoc = $this->getReferenciaNumero();
        
        switch ( $this->getReferenciaTipo() )
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':
                $o_VTA_OrdenBN = $this->getObjectOrden();
                return $o_VTA_OrdenBN->getClienteDocNum();
                break;
            case "OC":
                $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), $s_NumDoc );
                return $o_COM_OrdenCompraCabeceraBN->getNombreProveedor();
                break;
        }
        
        if( $this->getTipoMovimiento() == "VTA" && $this->getReferenciaTipo() != "OS" )
        {
            $o_VTA_DocumentoBN = $this->getBuscarDocPorRefernciaUno();
            if( $o_VTA_DocumentoBN )
            {
                return $o_VTA_DocumentoBN->getClienteNombre();
            }
        }
        return "";
    }
    
    public function getNombreCliente()
    {
        $s_NumDoc = $this->getReferenciaNumero();
        switch ( $this->getReferenciaTipo() )
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':

                $o_VTA_OrdenBN = $this->getObjectOrden();
                return $o_VTA_OrdenBN->getClienteNombre();

            break;
            case "OC":

                $o_COM_OrdenCompraCabeceraFN = new COM_OrdenCompraCabeceraFN();
                $o_COM_OrdenCompraCabeceraBN = $o_COM_OrdenCompraCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), $s_NumDoc );
                return $o_COM_OrdenCompraCabeceraBN->getNombreProveedor();

            break;
        }

        if( $this->getTipoMovimiento() == "VTA" && $this->getReferenciaTipo() != "OS" )
        {
            $o_VTA_DocumentoBN = $this->getBuscarDocPorRefernciaUno();
            if( $o_VTA_DocumentoBN )
            {
                return $o_VTA_DocumentoBN->getClienteNombre();
            }
        }

        return "";
    }

    public function getDocumentoReferencia()
    {
        $s_NumDoc = $this->getReferenciaNumero();

        switch ( $this->getReferenciaTipo() ) 
        {
            case 'NV':
            case 'FC':
            case 'BV':
            case 'OS':
                $o_VTA_DocumentoBN = $this->getObjectComprobante();
                if( $o_VTA_DocumentoBN )
                {
                    return $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero();
                }
                return "";
            break;
            case "OC":
            break;
        }

        if( $this->getTipoMovimiento() == "VTA" && $this->getReferenciaTipo() != "OS" )
        {
            $o_VTA_DocumentoBN = $this->getBuscarDocPorRefernciaUno();
            if( $o_VTA_DocumentoBN )
            {
                return $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero();
            }
        }
        
        return "";
    }

    public function getReferenciaNumeroSecuencia()
    {
        //return $this->getReferenciaNumero()."-".$this->getReferenciaSecuencia();
        return $this->getReferenciaNumero();
    }

    const CTRL_ESTADO_SERIE_NOEXISTE  = "X";
    const CTRL_ESTADO_SERIE_TERMINADO = "T";
    const CTRL_ESTADO_SERIE_PENDIENTE = "P";

    public static function getArrayControlEstadoSerie( $s_TipoTrans = null )
    {
        $a_TipoTrans = array
        (
            SR_MovimientoBN::CTRL_ESTADO_SERIE_NOEXISTE    => "NO TIENE",
            SR_MovimientoBN::CTRL_ESTADO_SERIE_TERMINADO   => "TERMINADO",
            SR_MovimientoBN::CTRL_ESTADO_SERIE_PENDIENTE   => "PENDIENTE"
        );
        if( !is_null( $s_TipoTrans ) )
        {
            return $a_TipoTrans[$s_TipoTrans];
        }
        return $a_TipoTrans;
    }

    public function getArrayMovimientoDetalle()
    {
        $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
        $o_SR_MovimientoDetalleFN->setMovimientoId( $s_MovimientoId );
        if( $this->s_IdItem )
        {
            $o_SR_MovimientoDetalleFN->setProductoId( $this->s_IdItem );
        }
        return $o_SR_MovimientoDetalleFN->select();
    }

    public function getObjectMovimientoDetalle( $s_IdItem )
    {
        $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
        $o_SR_MovimientoDetalleFN->setMovimientoId( $this->getMovimientoId() );
        $o_SR_MovimientoDetalleFN->setProductoId( $s_IdItem );
        $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();
        if( $a_SR_MovimientoDetalle )
        {
            if( count( $a_SR_MovimientoDetalle ) == 1 )
            {
                return $a_SR_MovimientoDetalle[0];
            }
        }
        return null;
    }

    public function getCantidadPedida()
    {
        $a_Data = SR_MovimientoFN::getArrayResumenCantidadPorDetalles( $this->getMovimientoId() );
        return intval( $a_Data['CantidadPedida'] );
    }

    public function getCantidadEntregada()
    {
        $a_Data = SR_MovimientoFN::getArrayResumenCantidadPorDetalles( $this->getMovimientoId() );
        return intval( $a_Data['CantidadRecibida'] );
    }

    public function getCantidadPorEntregar()
    {
        $a_Data = SR_MovimientoFN::getArrayResumenCantidadPorDetalles( $this->getMovimientoId() );
        return intval( $a_Data['CantidadPorEntregar'] );
    }
}