<?php
/* Metodos de acceso a los campos de la tabla SEG_Usuario redefinidos por el usuario */
class SEG_UsuarioBN extends BaseSEG_UsuarioBN
{
    public function getIdConcat()
    {
        return $this->getIdUsuario()."_".$this->getIdCompania();
    }

    public function getObjectRol()
    {
        $o_SEG_RolFN = new SEG_RolFN();
        $o_SEG_RolBN = $o_SEG_RolFN->selectByPK( $this->getIdRol() );
        return $o_SEG_RolBN;
    }

    public function getRolDescripcion()
    {
        $o_SEG_RolBN = $this->getObjectRol();
        if( $o_SEG_RolBN )
        {
            return $this->getObjectRol()->getRolDescripcion();
        }
        return "";
    }
    
    public function getObjectCompania()
    {
        $o_GSS_CompaniaBN = new GSS_CompaniaBN();
        if( $this->getIdCompania() )
        {
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        }
        return $o_GSS_CompaniaBN;
    }

    public function getEstadoDesc()
    {
        $s_Tipo = "";
        switch( $this->getDeshabilitadoFlg() )
        {
            case "Y":
                $s_Tipo = "INACTIVO";
            break;
            case "N":
                $s_Tipo = "ACTIVO";
            break;
        }

        return $s_Tipo;
    }

    public function getTipoUsoUsuario()
    {
        $s_Tipo = "";
        switch( $this->getEnUso() )
        {
            case "Y":
                $s_Tipo = "OPERATIVO";
            break;
            case "N":
                $s_Tipo = "BLOQUEADO";
            break;
            case "X":
                $s_Tipo = "INABILITADO";
            break;
        }

        return $s_Tipo;
    }

    public function getUsuarioImagenPr()
    {
        $s_DirImagen = parent::getUsuarioImagen();
        if( !$s_DirImagen )
        {
            $s_DirImagen = "".Constantes::ROOT_DIR_APP."web/images/perfil/perfil.jpg";
        }
        return $s_DirImagen;
    }
}
?>