<?php
/* Metodos de acceso a los campos de la tabla MST_Ubicacion redefinidos por el usuario */
class MST_UbicacionBN extends BaseMST_UbicacionBN
{
    public function getParentPiso()
    {
        if( $this->getIdUbicacionPertenece() )
        {
            $o_MST_UbicacionBN = $this->getObjectPiso();
            return $o_MST_UbicacionBN->getNombre();
        }
        return "";
    }

    public function getTipoUbicacionNombre()
    {
        return $this->getObjectTipoUbicacion()->getNombre();
    }

    public function getCategoriaUbicacionDescripcion()
    {
        return $this->getObjectCategoria()->getDescripcion();
    }

    public function getObjectPiso()
    {
        $o_MST_UbicacionFN = new MST_UbicacionFN();
        $o_MST_UbicacionBN = $o_MST_UbicacionFN->selectByPK( $this->getIdUbicacionPertenece() );
        return $o_MST_UbicacionBN;
    }

    public function getObjectTipoUbicacion()
    {
        $o_MST_TipoUbicacionFN = new MST_TipoUbicacionFN();
        return $o_MST_TipoUbicacionFN->selectByPK( $this->getIdTipoUbicacion() );
    }

    public function getObjectCategoria()
    {
        $o_MST_CategoriaHabitacionMastFN = new MST_CategoriaHabitacionMastFN();
        $o_MST_CategoriaHabitacionMastBN = $o_MST_CategoriaHabitacionMastFN->selectByPK( $this->getIdCategoria() );
        return $o_MST_CategoriaHabitacionMastBN;
    }

    public function getBucarItemsPorParamUnicacion()
    {
        $a_ALM_ItemMast = ALM_ItemMastFN::buscarItemPorParamUbicacion( $this->getIdCategoria(), $this->getIdTipoUbicacion() );
        if( count( $a_ALM_ItemMast )  == 1 )
        {
            return $a_ALM_ItemMast[0];
        }
        return $a_ALM_ItemMast;
    }

    protected $FiltroEstado = array();
    public function addEstadoFiltro( $str )
    {
        $this->FiltroEstado[] = $str;
    }
    public function getEstadosFiltro()
    {
        return $this->FiltroEstado;
    }

    protected $IdUbicacionEstado;
    public function getIdUbicacionEstado()
    {
        return $this->IdUbicacionEstado;
    }
    public function setIdUbicacionEstado( $IdUbicacionEstado )
    {
        $this->IdUbicacionEstado = $IdUbicacionEstado;
    }
}
?>