<?php
/* M�todos de acceso a los campos de la tabla GSS_ParametroMast redefinidos por el usuario */
class GSS_ParametroMastBN extends BaseGSS_ParametroMastBN
{
    public function getIdParametro()
    {
        if( $this->getIdCompania() )
        {
            return $this->getIdCompania()."**".$this->getIdAplicacionCodigo()."**".$this->getIdParametroClave();
        }
        return null;
    }
    
    public function getTipodeDatoDesc()
    {
 		switch ( $this->getTipodeDatoFlag() )
        {
        	case 'N': $valor = "Numerico"; break;
        	case 'T': $valor = "Texto";    break;
        	case 'D': $valor = "Fecha"; break;
            case 'B': $valor = "Condicional"; break;
        }
        return $valor;
    }

    public function getIdValorParametro()
    {
        switch( $this->getTipodeDatoFlag() )
        {
            case 'N': $valor = $this->getNumero(); break;
            case 'T': $valor = $this->getTexto();  break;
            case 'D': $valor = $this->getFecha();  break;
            case 'B': 
                $s_Value = $this->getTexto();
                if( $s_Value == "NO" || $s_Value == "N" )
                {
                    return false;
                }
                if( $s_Value == "SI" || $s_Value == "S" || $s_Value == "Y" )
                {
                    return true;
                }
                $i_Value = $this->getNumero();
                if( $i_Value )
                {
                    return true;
                }
                if( !$i_Value )
                {
                    return false;
                }
                return false;
            break;
        }
        return $valor;
    }
     
    public function setIdValorParametro($valor){
     		switch ($this->getTipodeDatoFlag()){
            	case 'N': $valor = $this->setNumero((float)$valor);break;
            	case 'T': $valor = $this->setTexto($valor);break;
            	case 'D': $valor = $this->setTexto($valor);break;
            }
            return $valor;
    }

    
}
?>