<?php
/* Metodos de acceso a los campos de la tabla CP_Obligaciones redefinidos por el usuario */
class CP_ObligacionesBN extends BaseCP_ObligacionesBN
{
    //ESTADO
    const ESTADO_PENDIENTE = "PE"; //PENDIENTE
    const ESTADO_CANCELADO = "AN"; //ANULADO
    const ESTADO_VALIDADO  = "VA"; //VALIDADO

    public static function getArrayEstados( $sEstado = null )
    {
        //VA validado | AN anulado | PE pendiente
        $a_sEstado = array
        (
            self::ESTADO_PENDIENTE => "PENDIENTE",
            self::ESTADO_CANCELADO => "ANULADO",
            self::ESTADO_VALIDADO  => "VALIDADO",
        );
        if( !is_null( $sEstado ) )
        {
            if( isset( $a_sEstado[$sEstado] ) )
            {
                return $a_sEstado[$sEstado];
            }
        }
        return $a_sEstado;
    }

    public function getEstadoDesc()
    {
        return CP_ObligacionesBN::getArrayEstados( $this->getEstado() );
    }

    const ESTADO_PAG_PENDIENTE = "PE";
    const ESTADO_PAG_COBRADO   = "CO";

    public static function getArrayPagadoEstados( $sEstado = null )
    {
        $a_sEstado = array
        (
            CP_ObligacionesBN::ESTADO_PAG_PENDIENTE => "PENDIENTE",
            CP_ObligacionesBN::ESTADO_PAG_COBRADO   => "PAGADO"
        );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }

    public function getPagadoEstadoDesc()
    {
        return CP_ObligacionesBN::getArrayPagadoEstados( $this->getEstadoPagado() );
    }

    public function getObjectTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        if( !$o_VTA_TipoDocumentoBN )
        {
            $o_VTA_TipoDocumentoBN = new VTA_TipoDocumentoBN();
        }
        return $o_VTA_TipoDocumentoBN;
    }

    public function getSunatTipoDocumentoProv()
    {
        return MST_PersonaMastBN::getArrayTipoDocumento( $this->getProveedorDocTipo() );
    }

    public function getObjectMoneda()
    {
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->getIdMoneda() );
        return $o_GSS_MonedaMastBN;
    }

    public function getTipoDocumentoDesc()
    {
        return $this->getObjectTipoDocumento()->getDescripcionLocal();
    }

    public function getTipoDocumentoCod()
    {
        return $this->getObjectTipoDocumento()->getTipoDocumentoCod();
    }

    public function getMonedaDesc()
    {
        return $this->getObjectMoneda()->getDescripcion();
    }

    public function getObjectComprobanteTipoDocumento()
    {
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getComprobanteTipoRefId() );
        if( !$o_VTA_TipoDocumentoBN )
        {
            $o_VTA_TipoDocumentoBN = new VTA_TipoDocumentoBN();
        }
        return $o_VTA_TipoDocumentoBN;
    }

    public function getComprobanteTipoDocumentoCod()
    {
        return $this->getObjectComprobanteTipoDocumento()->getTipoDocumentoCod();
    }

    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public function getMontoTotalSiEsSoles()
    {
        if( $this->getIdMoneda() == "LO" )
        {
            return $this->getMontoTotal();
        }
        return "";
    }

    public function getMontoTotalSiEsDolares()
    {
        if( $this->getIdMoneda() == "EX" )
        {
            return $this->getMontoTotal();
        }
        return "";
    }

    public function getMontoPagadoSiEsSoles()
    {
        if( $this->getIdMoneda() == "LO" )
        {
            return $this->getMontoPagado();
        }
        return "";
    }

    public function getMontoPagadoSiEsDolares()
    {
        if( $this->getIdMoneda() == "EX" )
        {
            return $this->getMontoPagado();
        }
        return "";
    }

    public function getMontoSaldoSiEsSoles()
    {
        if( $this->getIdMoneda() == "LO" )
        {
            return $this->getMontoSaldo();
        }
        return "";
    }

    public function getMontoSaldoSiEsDolares()
    {
        if( $this->getIdMoneda() == "EX" )
        {
            return $this->getMontoSaldo();
        }
        return "";
    }

    public function getComprobanteSerieDocRef()
    {
        return substr( $this->getComprobanteSerieNumeroRef(), 0, 4 );
    }

    public function getComprobanteNumeroDocRef()
    {
        return substr( $this->getComprobanteSerieNumeroRef(), 6, 10 );
    }

}
?>