<?php
/* Metodos de acceso a los campos de la tabla ALM_TransferenciaCabecera redefinidos por el usuario */
class ALM_TransferenciaCabeceraBN extends BaseALM_TransferenciaCabeceraBN
{
    //ESTADO
    const ESTADO_POR_APROBAR   = "PA";
    const ESTADO_PREPARACION   = "PR";
    const ESTADO_ANULADO       = "AN";
    const ESTADO_COMPLETADO    = "CO";
    const ESTADO_RECHAZADO     = "RE";
    
    //OPERACIONES
    const TIPO_TRANSACCION_SALIDA  = "ITO";
    const TIPO_TRANSACCION_INGRESO = "ITE";
    
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
                            (
                                ALM_TransferenciaCabeceraBN::ESTADO_POR_APROBAR => "POR APROBAR",
                                ALM_TransferenciaCabeceraBN::ESTADO_PREPARACION => "PREPARACION",
                                ALM_TransferenciaCabeceraBN::ESTADO_ANULADO     => "ANULADO",
                                ALM_TransferenciaCabeceraBN::ESTADO_RECHAZADO   => "RECHAZADO",
                                ALM_TransferenciaCabeceraBN::ESTADO_COMPLETADO  => "COMPLETADO",
                            );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getFechaDocumentoPer()
    {
        return substr( $this->getFechaDocumento(), 0 ,10 );
    }
    
    public function getDocReferencia()
    {
        $s_DocReferencia = "";
        if( $this->getReferenciaTipoDocumento() )
        {
            //$s_DocReferencia .= $this->getReferenciaTipoDocumento();
        }
        if( $this->getReferenciaSerieDocumento() )
        {
            $s_DocReferencia .= $this->getReferenciaSerieDocumento()."-";
        }
        if( $this->getReferenciaNumeroDocumento() )
        {
            $s_DocReferencia .= $this->getReferenciaNumeroDocumento();
        }
        return $s_DocReferencia;
    }
    
    public function getEstadoDesc()
    {
        return ALM_TransferenciaCabeceraBN::getArrayEstados( $this->getEstado() );
    }
    
    public function getTipoDocumentoDescripcion()
    {
        $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
        $o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPK( $this->getIdTipoDocumento() );
        return $o_ALM_TipoDocumentoBN->getDescripcion();
    }
    
    public function getTipoTransaccionDescripcion()
    {
        $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
        $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $this->getIdTransaccion() );
        return $o_ALM_TransaccionMastBN->getDescripcionLocal();
    }
    
    public function getAlmacenOrigenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getAlmacenDestinoDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenTraslado() );
        if( !$o_ALM_AlmacenMastBN )
        {
            $o_ALM_AlmacenMastBN = new ALM_AlmacenMastBN();
        }
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getTipoDocumentoRefDesc()
    {
        if( $this->getReferenciaTipoDocumento() )
        {
            $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
            $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $this->getReferenciaTipoDocumento() );
        }
        else
        {
            $o_VTA_TipoDocumentoBN = new VTA_TipoDocumentoBN();
        }
        return $o_VTA_TipoDocumentoBN->getDescripcionLocal();
    }
    
    public function getArrayObjetosDetalles()
    {
        $o_ALM_TransferenciaDetalleFN = new ALM_TransferenciaDetalleFN();
        $o_ALM_TransferenciaDetalleFN->setIdTransferencia( $this->getIdTransferencia() );
        $o_ALM_TransferenciaDetalleFN->setEstado( "A" );
        //$o_ALM_TransferenciaDetalleFN->addCondition( ALM_TransferenciaDetalleFN::Estado, "=", "A" );
        $a_ALM_TransferenciaDetalle = $o_ALM_TransferenciaDetalleFN->select();
        if( $a_ALM_TransferenciaDetalle ) 
        {
            return $a_ALM_TransferenciaDetalle;
        }
        return array();
    }
    
    public function getDireccionAlmacenOrigen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_ALM_AlmacenMastBN->getIdSucursal() );
        return $o_GSS_SucursalBN->getDireccion();
    }
    
    public function getDireccionAlmacenDestino()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenTraslado() );
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_ALM_AlmacenMastBN->getIdSucursal() );
        return $o_GSS_SucursalBN->getDireccion();
    }

    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN;
    }

    public function getObjectAlmacenDestino()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getAlmacenTraslado() );
        return $o_ALM_AlmacenMastBN;
    }
    
    public function getObjectChofer()
    {
        if( $this->getIdChofer() )
        {
            $o_TR_ChoferFN = new TR_ChoferFN();
            $o_TR_ChoferBN = $o_TR_ChoferFN->selectByPK( $this->getIdChofer() );
        }
        else
        {
            $o_TR_ChoferBN = new TR_ChoferBN();
        }
        return $o_TR_ChoferBN;
    }
    
    public function getObjectVehiculo()
    {
        if( $this->getIdVehiculo() )
        {
            $o_TR_VehiculoFN = new TR_VehiculoFN();
            $o_TR_VehiculoBN = $o_TR_VehiculoFN->selectByPK( $this->getIdVehiculo() );
        }
        else
        {
            $o_TR_VehiculoBN = new TR_VehiculoBN();
        }
        return $o_TR_VehiculoBN;
    }
}
?>