<?php
/* Metodos de acceso a los campos de la tabla ALM_ReservaItemStock redefinidos por el usuario */
class ALM_ReservaItemStockBN extends BaseALM_ReservaItemStockBN
{
    protected $IdCondicion;
    protected $IdUniadMedidaAsig;
    
    /**
     * @return the $IdCondicion
     */
    public function getIdCondicion()
    {
        return $this->IdCondicion;
    }

    /**
     * @param field_type $IdCondicion
     */
    public function setIdCondicion($IdCondicion)
    {
        $this->IdCondicion = $IdCondicion;
    }

    public function getIdUniadMedidaAsignada()
    {
        return $this->IdUniadMedidaAsig;
    }

    public function setIdUniadMedidaAsignada($IdUniadMedida)
    {
        $this->IdUniadMedidaAsig = $IdUniadMedida;
    }

    public function getObjectAlmacen()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN;
    }

    public function getObjectItem()
    {
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->getIdItem() );
        return $o_ALM_ItemMastBN;
    }

    public function getObjectDocumento()
    {
        $o_VTA_DocumentoFN = VTA_DocumentoFN::selectByDocumentNumber( $this->getReservaRefNumero() );
        return $o_VTA_DocumentoFN;
    }

    public function getObjectDocumentoDetalle()
    {
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $this->getReservaDocTipo(), $this->getIdCompania(), $this->getReservaRefNumero(), $this->getReservaSecuencia() );
        if( !$o_VTA_DocumentoDetalleBN )
        {
            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
        }
        return $o_VTA_DocumentoDetalleBN;
    }

    public function getObjectUbicacionClienteDet()
    {
        $o_SRV_UbicacionClienteDetBN = SRV_UbicacionClienteDetFN::buscarPorNumeroDocumento( $this->getReservaRefNumero() );
        return $o_SRV_UbicacionClienteDetBN;
    }

    public function getDocumentoClienteNombre()
    {
        if( $this->getReservaDocTipo() == "ORD" )
        {
            $o_DocumentoBN = VTA_OrdenFN::findOrdenByNum( $this->getReservaDocNumero() );
        }
        else
        {
            $o_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getReservaRefNumero() );
        }
        return $o_DocumentoBN->getClienteNombre();
    }
}