<?php
/* Metodos de acceso a los campos de la tabla ALM_RequerimientoCabecera redefinidos por el usuario */
class ALM_RequerimientoCabeceraBN extends BaseALM_RequerimientoCabeceraBN
{
    //ESTADO
    const REQUERIMIENTO_PREPARACION   = "P";
    const REQUERIMIENTO_ANULADO       = "X";
    const REQUERIMIENTO_APROBADO      = "A";
    const REQUERIMIENTO_COMPLETADO    = "C";
    
    const TIPO_REQUERIMIENTO_LOG     = "RE";
    
    public static function getArrayEstados( $sEstado = null )
    {
        $a_sEstado = array
                            (
                                ALM_RequerimientoCabeceraBN::REQUERIMIENTO_PREPARACION => "PREPARACION",
                                ALM_RequerimientoCabeceraBN::REQUERIMIENTO_ANULADO     => "ANULADO",
                                ALM_RequerimientoCabeceraBN::REQUERIMIENTO_APROBADO    => "APROBADO",
                                ALM_RequerimientoCabeceraBN::REQUERIMIENTO_COMPLETADO  => "COMPLETADO"
                            );
        if( !is_null( $sEstado ) )
        {
            return $a_sEstado[$sEstado];
        }
        return $a_sEstado;
    }
    
    public function getEstadoDesc()
    {
        return ALM_RequerimientoCabeceraBN::getArrayEstados( $this->getEstado() );
    }    
    
    public function getCompaniaDesc()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        return $o_GSS_CompaniaBN->getDescripcionCorta();
    }
    
    public function getSucursalDesc()
    {
        $o_GSS_SucursalFN = new GSS_SucursalFN();
        $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
        if( $o_GSS_SucursalBN )
        {
            return $o_GSS_SucursalBN->getDescripcion();
        }
        return "";
    }
    
    public function getAlmacenDesc()
    {
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getIdAlmacen() );
        return $o_ALM_AlmacenMastBN->getDescripcionLocal();
    }
    
    public function getProveedorDes()
    {
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->getIdPersona() );
        if( $o_MST_PersonaMastBN )
        {
            return $o_MST_PersonaMastBN->getNombreCompleto();
        }
        return "";
    }
}
?>