<?php
class TransaccionBL
{
    public function guardarTransacciones( ALM_TransaccionCabeceraBN $o_ALM_TransaccionCabeceraBN )
    {
        $a_ALM_TransaccionDetalle = $o_ALM_TransaccionCabeceraBN->getArrayMovientoDetalle();
        foreach ( $a_ALM_TransaccionDetalle as $i_Key => $o_ALM_TransaccionDetalleBN )
        {
            $o_ALM_TransaccionDetalleBN->setObjectTransaccionCabecera( $o_ALM_TransaccionCabeceraBN );
            $this->guardarTransaccion( $o_ALM_TransaccionDetalleBN );
        }
        return true;
    }
    
    public function guardarTransaccion( $o_ALM_TransaccionDetalleBN )
    {
        try 
        {
            $con = Conexion::getConexion();
            $con->begin();

            $this->validarValoresxDefecto( $o_ALM_TransaccionDetalleBN );
            $this->registrarLote( $o_ALM_TransaccionDetalleBN );

            $o_ALM_TransaccionDetalleDP = new ALM_TransaccionDetalleDP( $o_ALM_TransaccionDetalleBN );
            $o_ALM_TransaccionDetalleDP->save();
            
            $con->commit();
            return true;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "Tr: ".$o_Exception->getMessage() );
        }
    }
    
    private function validarValoresxDefecto( ALM_TransaccionDetalleBN $o_ALM_TransaccionDetalleBN )
    {
        //SE BUSCA EL OBJETO ITEM
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_ALM_TransaccionDetalleBN->getIdItem() );
        ///////////////////////////////////////////////
        
        $o_ALM_TransaccionDetalleBN->setDescripcionItem( addslashes( $o_ALM_ItemMastBN->getDescripcionCompleta() ) );
        $o_ALM_TransaccionDetalleBN->setCantidadDoble( utilMath::fnround( $o_ALM_TransaccionDetalleBN->getCantidadDoble(), 0 ) );
        //////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        //VALORES POR DEFECTO
        $i_Id = ALM_TransaccionDetalleFN::recuperarId( $o_ALM_TransaccionDetalleBN->getIdCompania(), $o_ALM_TransaccionDetalleBN->getIdTipoDocumento(), $o_ALM_TransaccionDetalleBN->getIdNumeroDocumento() );
        //$o_ALM_TransaccionDetalleBN->setIdCondicion( ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO );
        $o_ALM_TransaccionDetalleBN->setIdSecuencia( ( int ) $i_Id );
        $o_ALM_TransaccionDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_ALM_TransaccionDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
    }

    public function registrarLote( ALM_TransaccionDetalleBN $o_ALM_TransaccionDetalleBN )
    {
        $o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionDetalleBN->getObjectTransaccionCabecera();

        if( ALM_TransaccionCabeceraBN::TIPO_INGRESO == $o_ALM_TransaccionDetalleBN->getIdCondicion() )
        {
            $o_ALM_LoteFN = new ALM_LoteFN();
            //$o_ALM_LoteFN->setIdCompania(  );
            //$o_ALM_LoteFN->setIdSucursal(  );
            $o_ALM_LoteFN->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
            $o_ALM_LoteFN->setLoteNumero( $o_ALM_TransaccionDetalleBN->getLote() );
            $a_ALM_Lote = $o_ALM_LoteFN->select();

            if( !$a_ALM_Lote )
            {
                //se registra el lote
                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_ALM_TransaccionCabeceraBN->getCodigoProveedor() );
                if( $o_MST_PersonaMastBN )
                {
                    $i_IdLote = ALM_LoteDP::recuperarId();

                    $o_ALM_LoteBN = new ALM_LoteBN();
                    $o_ALM_LoteBN->setIdLote( $i_IdLote );
                    $o_ALM_LoteBN->setIdCompania( $o_ALM_TransaccionDetalleBN->getIdCompania() );
                    $o_ALM_LoteBN->setIdSucursal( $o_ALM_TransaccionDetalleBN->getIdSucursal() );
                    $o_ALM_LoteBN->setIdItem( $o_ALM_TransaccionDetalleBN->getIdItem() );
                    $o_ALM_LoteBN->setProductoDescripcion( $o_ALM_TransaccionDetalleBN->getDescripcionItem() );
                    $o_ALM_LoteBN->setLoteNumero( $o_ALM_TransaccionDetalleBN->getLote() );
                    $o_ALM_LoteBN->setFechaVencimiento( $o_ALM_TransaccionDetalleBN->getFechaVencimiento() );
                    $o_ALM_LoteBN->setFechaOrigen( date( "Y-m-d" ) );
                    $o_ALM_LoteBN->setDescripcion( $o_ALM_TransaccionCabeceraBN->getDescripcion() );
                    $o_ALM_LoteBN->setEstado( "A" );
                    $o_ALM_LoteBN->setProveedorId( $o_MST_PersonaMastBN->getIdPersona() );
                    $o_ALM_LoteBN->setProveedorNombre( $o_MST_PersonaMastBN->getNombreCompleto() );
                    $o_ALM_LoteBN->setAnio( UtilDate::getFormatDate( $o_ALM_TransaccionDetalleBN->getFechaVencimiento(), "Y" ) );
                    $o_ALM_LoteBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_LoteBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_LoteBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_LoteBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                    $o_ALM_LoteDP = new ALM_LoteDP( $o_ALM_LoteBN );
                    $o_ALM_LoteDP->save();
                }
            }
        }
    }

}