<?php
class SerieDetalleBL
{
    public function registrarPreSerie( SR_PreSerieBN $o_SR_PreSerieBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            //validamos que el movimiento cabacera este en un estado pendiente
            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $o_SR_PreSerieBN->getMovimientoId() );
            if( !$o_SR_MovimientoBN )
            {
                throw new Exception( "El Movimiento de Serie no existe." );
            }
            if( $o_SR_MovimientoBN->getEstado() != "P" )
            {
                //throw new Exception( "El Movimiento de Serie tiene un estado diferente, no se puede continuar." );
            }

            $i_SerieId = "";
            $a_SR_PreSerie = null;
            //ahora valido que el numero de serie sea unico
            if( $o_SR_MovimientoBN->getOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                $o_SR_SerieFN = new SR_SerieFN();
                $o_SR_SerieFN->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
                $a_SR_Serie = $o_SR_SerieFN->select();
                if( $a_SR_Serie )
                {
                    throw new Exception( "El Numero de Serie ya se encuentra registrado en el Sistema" );
                }
                
                $o_SR_PreSerieFN = new SR_PreSerieFN();
                $o_SR_PreSerieFN->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
                $a_SR_PreSerie = $o_SR_PreSerieFN->select();
                if( $a_SR_PreSerie )
                {
                    throw new Exception( "El Numero de Serie ya se encuentra escaneado." );
                }

                if( !$a_SR_PreSerie )
                {
                    //si no se encuentra se registra, por ser una serie nueva
                    $i_SerieId = SR_PreSerieDP::generarId();
                    $o_SR_PreSerieDP = new SR_PreSerieDP();
                    $o_SR_PreSerieDP->setSerieId( $i_SerieId );
                    $o_SR_PreSerieDP->setMovimientoId( $o_SR_PreSerieBN->getMovimientoId() );
                    $o_SR_PreSerieDP->setProductoId( $o_SR_PreSerieBN->getProductoId() );
                    $o_SR_PreSerieDP->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
                    $o_SR_PreSerieDP->setOperacion( $o_SR_MovimientoBN->getOperacion() );
                    $o_SR_PreSerieDP->setAlmacen( $o_SR_PreSerieBN->getAlmacen() );
                    $o_SR_PreSerieDP->setReferenciaTipo( $o_SR_PreSerieBN->getReferenciaTipo() );
                    $o_SR_PreSerieDP->setReferenciaNumero( $o_SR_PreSerieBN->getReferenciaNumero() );
                    $o_SR_PreSerieDP->setComentario( $o_SR_PreSerieBN->getComentario() );
                    $o_SR_PreSerieDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                    $o_SR_PreSerieDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                    //pr( $o_SR_PreSerieDP );
                    $o_SR_PreSerieDP->save();
                }
                else
                {
                    $i_SerieId = $a_SR_PreSerie[0]->getSerieId();
                }
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////

            if( $o_SR_MovimientoBN->getOperacion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
            {
                $o_SR_SerieFN = new SR_SerieFN();
                $o_SR_SerieFN->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
                //$o_SR_SerieFN->setProductoId( $o_SR_PreSerieBN->getProductoId() );
                //$o_SR_SerieFN->setUltimaOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                //$o_SR_SerieFN->setAlmacen( $o_SR_PreSerieBN->getAlmacen() );
                //$o_SR_SerieFN->setEstado( "3" );
                $a_SR_Serie = $o_SR_SerieFN->select();

                if( !$a_SR_Serie )
                {
                    throw new Exception( "La serie no se encuentra registrada." );
                }
                if( count( $a_SR_Serie ) > 1 )
                {
                    throw new Exception( "Se presenta incongruencia de datos, por favor comuniquese con su soporte de Sistema." );
                }

                if( $a_SR_Serie )
                {
                    if( $a_SR_Serie[0]->getEstado() == "4" )
                    {
                        throw new Exception( "La serie no se encuentra disponible." );
                    }
                    $i_SerieId = $a_SR_Serie[0]->getSerieId();
                    $o_SR_PreSerieBN->setProductoId( $a_SR_Serie[0]->getProductoId() );
                }
            }

            //ahora registramos el escaneo
            $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
            $o_SR_MovimientoDetalleFN->setMovimientoId( $o_SR_PreSerieBN->getMovimientoId() );
            $o_SR_MovimientoDetalleFN->setProductoId( $o_SR_PreSerieBN->getProductoId() );
            $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();

            if( count( $a_SR_MovimientoDetalle ) > 1 )
            {
                throw new Exception( "Se presenta incongruencia de datos, por favor comuniquese con su soporte de Sistema." );
            }
            
            if( $a_SR_MovimientoDetalle )
            {
                $o_SR_MovimientoDetalleBN = $a_SR_MovimientoDetalle[0];

                //validamos la cantidad maxima de referencia
                $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
                $o_SR_PreSerieEscaneoFN->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                $o_SR_PreSerieEscaneoFN->setProductoId( $o_SR_PreSerieBN->getProductoId() );
                $i_Cnt = $o_SR_PreSerieEscaneoFN->selectNumRows();

                if( ( $i_Cnt + 1 ) > $o_SR_MovimientoDetalleBN->getCantidad() )
                {
                    throw new Exception( "Ya llego al limite de la cantidad de Referencia." );
                }
                
                //entonces buscamos para evitar duplicidad
                $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
                $o_SR_PreSerieEscaneoBN = $o_SR_PreSerieEscaneoFN->selectByPK( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId(), $i_SerieId );
                
                if( $o_SR_PreSerieEscaneoBN )
                {
                    throw new Exception( "La Serie ya se encuentra escaneado." );
                }
                
                //aqui se registra el escaneo de la serie
                if( !$o_SR_PreSerieEscaneoBN )
                {
                    $o_SR_PreSerieEscaneoDP = new SR_PreSerieEscaneoDP();
                    $o_SR_PreSerieEscaneoDP->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                    $o_SR_PreSerieEscaneoDP->setSerieId( $i_SerieId );
                    $o_SR_PreSerieEscaneoDP->setProductoId( $o_SR_PreSerieBN->getProductoId() );
                    $o_SR_PreSerieEscaneoDP->setFecha( date( "Y-m-d H:i:s" ) );
                    $o_SR_PreSerieEscaneoDP->setOperacion( $o_SR_PreSerieBN->getOperacion() );
                    $o_SR_PreSerieEscaneoDP->setAlmacen( $o_SR_PreSerieBN->getAlmacen() );
                    $o_SR_PreSerieEscaneoDP->setReferenciaTipo( $o_SR_PreSerieBN->getReferenciaTipo() );
                    $o_SR_PreSerieEscaneoDP->setReferenciaNumero( $o_SR_PreSerieBN->getReferenciaNumero() );
                    $o_SR_PreSerieEscaneoDP->setComentario( $o_SR_PreSerieBN->getComentario() );
                    $o_SR_PreSerieEscaneoDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                    $o_SR_PreSerieEscaneoDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                    $o_SR_PreSerieEscaneoDP->save();
                    
                    //ahora se actualiza la cantidad escaneado
                    $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
                    $o_SR_PreSerieEscaneoFN->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                    $o_SR_PreSerieEscaneoFN->setProductoId( $o_SR_PreSerieBN->getProductoId() );
                    
                    $i_Cnt = $o_SR_PreSerieEscaneoFN->selectNumRows();
                    
                    $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP();
                    $o_SR_MovimientoDetalleDP->setMovimientoId( $o_SR_MovimientoDetalleBN->getMovimientoId() );
                    $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                    $o_SR_MovimientoDetalleDP->setCantidadEscaneada( intval( $i_Cnt ) );
                    $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDetalleDP->update();
                }
            }
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "PRE-SR/: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    public function eliminarPreSerieEscaneo( SR_PreSerieEscaneoBN $o_SR_PreSerieEscaneoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            if( $o_SR_PreSerieEscaneoBN->getSerieId() && $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() )
            {
                if( $o_SR_PreSerieEscaneoBN->getOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                {
                    //se eliminar la pre-serie
                    $o_SR_PreSerieDP = new SR_PreSerieDP();
                    $o_SR_PreSerieDP->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
                    $o_SR_PreSerieDP->delete();
                }
                
                //se eliminar el pre-escaneo
                $o_SR_PreSerieEscaneoDP = new SR_PreSerieEscaneoDP();
                $o_SR_PreSerieEscaneoDP->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
                $o_SR_PreSerieEscaneoDP->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
                $o_SR_PreSerieEscaneoDP->delete();
            }

            if( !$o_SR_PreSerieEscaneoBN->getSerieId() && $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() )
            {
                if( $o_SR_PreSerieEscaneoBN->getOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                {
                    $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
                    $o_SR_PreSerieEscaneoFN->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
                    $a_SR_PreSerieEscaneo = $o_SR_PreSerieEscaneoFN->select();
                    if( $a_SR_PreSerieEscaneo )
                    {
                        foreach ( $a_SR_PreSerieEscaneo as $o_SR_PreSerieEscaneoBN )
                        {
                            //se eliminar la pre-serie
                            $o_SR_PreSerieDP = new SR_PreSerieDP();
                            $o_SR_PreSerieDP->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
                            $o_SR_PreSerieDP->delete();
                        }
                    }
                    //se eliminar el pre-escaneo
                    $o_SR_PreSerieEscaneoDP = new SR_PreSerieEscaneoDP();
                    $o_SR_PreSerieEscaneoDP->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
                    $o_SR_PreSerieEscaneoDP->delete_all();
                }
            }

            if( $o_SR_PreSerieEscaneoBN->getMovimientoId() )
            {
                $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
                $o_SR_MovimientoDetalleFN->setMovimientoId( $o_SR_PreSerieEscaneoBN->getMovimientoId() );
                $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();                
            }

            if( $o_SR_PreSerieEscaneoBN->getOperacion() == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
            {
                if( !$o_SR_PreSerieEscaneoBN->getSerieId() )
                {
                    if( $a_SR_MovimientoDetalle )
                    {
                        foreach ( $a_SR_MovimientoDetalle as $o_SR_MovimientoDetalleBN )
                        {
                            //se eliminar el pre-escaneo
                            $o_SR_PreSerieEscaneoDP = new SR_PreSerieEscaneoDP();
                            $o_SR_PreSerieEscaneoDP->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                            $o_SR_PreSerieEscaneoDP->delete_all();
                        }
                    }
                }
            }
            
            //se procede a calcuar los totoales de escaneo
            if( $o_SR_PreSerieEscaneoBN->getMovimientoId() )
            {
                if( $a_SR_MovimientoDetalle )
                {
                    $i_Total = 0;
                    foreach ( $a_SR_MovimientoDetalle as $o_SR_MovimientoDetalleBN )
                    {
                        //ahora se actualiza la cantidad escaneado
                        $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
                        $o_SR_PreSerieEscaneoFN->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                        //$o_SR_PreSerieEscaneoFN->setProductoId( $o_SR_PreSerieEscaneoBN->getProductoId() );
                        $i_Cnt = intval( $o_SR_PreSerieEscaneoFN->selectNumRows() );

                        $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP();
                        $o_SR_MovimientoDetalleDP->setMovimientoId( $o_SR_PreSerieEscaneoBN->getMovimientoId() );
                        $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                        //$o_SR_MovimientoDetalleDP->setCantidad( intval( $this->CanDeta ) );
                        $o_SR_MovimientoDetalleDP->setCantidadEscaneada( $i_Cnt );
                        $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                        $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_MovimientoDetalleDP->update();

                        //$i_Total = $i_Total + $i_Cnt;
                    }

                    //aqui se puede proceder a actualizar la cabecera
                }
            }
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "PRE-SR/: ".$o_Exception->getMessage() );
            
        }
        return true;
        
    }
}