<?php
class SerieBL
{
    public function validarMovimientoH( SR_MovimientoBN &$o_SR_MovimientoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            $i_ReferenciaSecuencia = 1;
            
            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoFN->setTipoMovimiento( $o_SR_MovimientoBN->getTipoMovimiento() );
            $o_SR_MovimientoFN->setOperacion( $o_SR_MovimientoBN->getOperacion() );
            $o_SR_MovimientoFN->setAlmacen( $o_SR_MovimientoBN->getAlmacen() );
            $o_SR_MovimientoFN->setReferenciaTipo( $o_SR_MovimientoBN->getReferenciaTipo() );
            $o_SR_MovimientoFN->setReferenciaNumero( $o_SR_MovimientoBN->getReferenciaNumero() );
            //$o_SR_MovimientoFN->setReferenciaFecha( $o_SR_MovimientoBN->getReferenciaFecha() );
            $o_SR_MovimientoFN->setEstado( "C" );
            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
            if( $a_SR_Movimiento )
            {
                return true;
                $i_ReferenciaSecuencia = count( $a_SR_Movimiento ) + 1;
            }
            
            $o_SR_MovimientoFN->setEstado( "P" );
            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
            if( !$a_SR_Movimiento )
            {
                //aqui se podria guardar la cabecera
                //guardamos la cabecera
                $i_MovimientoId = SR_MovimientoDP::generarId();
                
                $o_SR_MovimientoDP = new SR_MovimientoDP( $o_SR_MovimientoBN );
                $o_SR_MovimientoDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_SR_MovimientoDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_SR_MovimientoDP->setMovimientoId( $i_MovimientoId );
                $o_SR_MovimientoDP->setFecha( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setReferenciaSecuencia( $i_ReferenciaSecuencia );
                $o_SR_MovimientoDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_SR_MovimientoDP->save();
            }
            else 
            {
                $i_MovimientoId = $a_SR_Movimiento[0]->getMovimientoId();

                $o_SR_MovimientoDP = new SR_MovimientoDP( $o_SR_MovimientoBN );
                $o_SR_MovimientoDP->setMovimientoId( $i_MovimientoId );
                $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_SR_MovimientoDP->update();
            }

            $o_SR_MovimientoBN->setMovimientoId( $i_MovimientoId );
            
            //ahora el detalle
            $a_SR_MovimientoDetalle = $o_SR_MovimientoBN->getMovimientoDetalleArray();
            foreach ( $a_SR_MovimientoDetalle as $o_SR_MovimientoDetalleBN )
            {
                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_SR_MovimientoDetalleBN->getProductoId() );

                if( $o_ALM_ItemMastBN->getObjectTipoItem()->getTransacciondelSistemaFlag() )
                {
                    $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
                    $o_SR_MovimientoDetalleFN->setMovimientoId( $i_MovimientoId );
                    $o_SR_MovimientoDetalleFN->setProductoId( $o_SR_MovimientoDetalleBN->getProductoId() );
                    $a_TMP_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();

                    if( !$a_TMP_SR_MovimientoDetalle )
                    {
                        $i_IdDet = SR_MovimientoDetalleDP::generarId();

                        $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP( $o_SR_MovimientoDetalleBN );
                        $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $i_IdDet );
                        $o_SR_MovimientoDetalleDP->setMovimientoId( $i_MovimientoId );
                        $o_SR_MovimientoDetalleDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                        $o_SR_MovimientoDetalleDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                        $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                        $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_MovimientoDetalleDP->save();

                        $o_SR_MovimientoDetalleBN->setMovimientoDetalleId( $i_IdDet );
                    }
                    else
                    {
                        $a_TMP_SR_MovimientoDetalleBN = $a_TMP_SR_MovimientoDetalle[0];

                        $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP();
                        $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $a_TMP_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                        $o_SR_MovimientoDetalleDP->setCantidad( $o_SR_MovimientoDetalleBN->getCantidad() );
                        $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                        $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:".( date( "s" ) + 1 ) ) );
                        $o_SR_MovimientoDetalleDP->update();
                    }
                }
            }
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "SR/H: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function realizarTransaccionH( SR_MovimientoBN $o_SR_MovimientoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            if( !$o_SR_MovimientoBN )
            {
                throw new Exception( "Se necesita el Movimiento Cabecera." );
            }

            $o_TMP_MovimientoDetalleBN = $o_SR_MovimientoBN->getMovimientoDetalleObject();

            $s_IniScanCab = "";
            $s_FinScanCab = "";

            //ahora se busca los detalles del movimiento de serie
            $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
            $o_SR_MovimientoDetalleFN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
            $o_SR_MovimientoDetalleFN->setProductoId( $o_TMP_MovimientoDetalleBN->getProductoId() );
            $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();

            if( $a_SR_MovimientoDetalle )
            {
                foreach ( $a_SR_MovimientoDetalle as $i_KeyCab => $o_SR_MovimientoDetalleBN ) 
                {
                    $i_Cantidada     = $o_SR_MovimientoDetalleBN->getCantidad();
                    $i_CantidadEscan = $o_SR_MovimientoDetalleBN->getCantidadEscaneada();
                    
                    $s_IniScanDet = "";
                    $s_FinScanDet = "";

                    //ahora se busca los pre-escaneo para su cierre
                    $o_SR_PreSerieEscaneoFN = new SR_PreSerieEscaneoFN();
                    $o_SR_PreSerieEscaneoFN->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                    $a_SR_PreSerieEscaneo = $o_SR_PreSerieEscaneoFN->select();

                    if( $a_SR_PreSerieEscaneo )
                    {
                        //validacion por cantidad escaneada
                        $i_CantidadEscan2 = count( $a_SR_PreSerieEscaneo );
                        if( $i_CantidadEscan != $i_CantidadEscan2 )
                        {
                            throw new Exception( "Incongruencia de Datos: Se encontro diferencia en el Pre-Escaneo [cnt<>count]." );
                        }
                        
                        if( $i_Cantidada != $i_CantidadEscan )
                        {
                            throw new Exception( "La Cantidad Escaneada no es igual a la cantidad Pedida." );
                        }
                        
                        $i_CantidadEscaneada = 0;
                        foreach ( $a_SR_PreSerieEscaneo as $i_Key => $o_SR_PreSerieEscaneoBN ) 
                        {
                            $s_Operacion = $o_SR_PreSerieEscaneoBN->getOperacion();

                            $s_FinScanDet = $o_SR_PreSerieEscaneoBN->getFecha();
                            if( $i_Key == 0 )
                            {
                                $s_IniScanDet = $o_SR_PreSerieEscaneoBN->getFecha();
                            }
                            
                            //ahora se busca el pre-serie, y dependiento de la operacion se hace save, update
                            if( $s_Operacion == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                            {
                                $o_SR_PreSerieFN = new SR_PreSerieFN();
                                $o_SR_PreSerieBN = $o_SR_PreSerieFN->selectByPK( $o_SR_PreSerieEscaneoBN->getSerieId() );    
                                if( $o_SR_PreSerieBN )
                                {
                                    $i_SerieId = SR_SerieDP::generarId();

                                    //se mueve en la tabla de serie principal
                                    $o_SR_SerieDP = new SR_SerieDP();
                                    $o_SR_SerieDP->setSerieId( $i_SerieId );
                                    $o_SR_SerieDP->setMovimientoId( $o_SR_PreSerieBN->getMovimientoId() );
                                    $o_SR_SerieDP->setProductoId( $o_SR_PreSerieBN->getProductoId() );
                                    $o_SR_SerieDP->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
                                    $o_SR_SerieDP->setAlmacen( $o_SR_PreSerieBN->getAlmacen() );
                                    $o_SR_SerieDP->setUltimaOperacion( $o_SR_PreSerieBN->getOperacion() );
                                    $o_SR_SerieDP->setEstado( "3" );
                                    $o_SR_SerieDP->setReferenciaTipo( $o_SR_PreSerieBN->getReferenciaTipo() );
                                    $o_SR_SerieDP->setReferenciaNumero( $o_SR_PreSerieBN->getReferenciaNumero() );
                                    $o_SR_SerieDP->setComentario( $o_SR_PreSerieBN->getComentario() );
                                    $o_SR_SerieDP->setUsuarioRegistro( $o_SR_PreSerieBN->getUsuarioRegistro() );
                                    $o_SR_SerieDP->setFechaRegistro( $o_SR_PreSerieBN->getFechaRegistro() );
                                    $o_SR_SerieDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                    $o_SR_SerieDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    $o_SR_SerieDP->save();

                                    //se borra la serie de pre
                                    $o_SR_PreSerieDP = new SR_PreSerieDP();
                                    $o_SR_PreSerieDP->setSerieId( $o_SR_PreSerieBN->getSerieId() );
                                    $o_SR_PreSerieDP->delete();
                                }
                            }
                            if( $s_Operacion == ALM_TransaccionCabeceraBN::TIPO_SALIDA )
                            {
                                //aqui se actualiza la serie real con la operacion salida
                                $o_SR_SerieFN = new SR_SerieFN();
                                $o_SR_SerieBN = $o_SR_SerieFN->selectByPK( $o_SR_PreSerieEscaneoBN->getSerieId() );
                                if( $o_SR_SerieBN )
                                {
                                    
                                    $o_SR_SerieDP = new SR_SerieDP();
                                    $o_SR_SerieDP->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
                                    $o_SR_SerieDP->setUltimaOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                                    $o_SR_SerieDP->setEstado( "4" );
                                    $o_SR_SerieDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                    $o_SR_SerieDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    $o_SR_SerieDP->update();
                                    
                                    $i_SerieId = $o_SR_PreSerieEscaneoBN->getSerieId();                                        
                                }
                            }

                            //se procede a guardar lo escaneado en la tabla final
                            $o_SR_SerieEscaneoDP = new SR_SerieEscaneoDP();
                            $o_SR_SerieEscaneoDP->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
                            $o_SR_SerieEscaneoDP->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                            $o_SR_SerieEscaneoDP->setSerieId( $i_SerieId );
                            $o_SR_SerieEscaneoDP->setProductoId( $o_SR_PreSerieEscaneoBN->getProductoId() );
                            $o_SR_SerieEscaneoDP->setFecha( $o_SR_PreSerieEscaneoBN->getFecha() );
                            $o_SR_SerieEscaneoDP->setOperacion( $o_SR_PreSerieEscaneoBN->getOperacion() );
                            $o_SR_SerieEscaneoDP->setAlmacen( $o_SR_PreSerieEscaneoBN->getAlmacen() );
                            $o_SR_SerieEscaneoDP->setReferenciaTipo( $o_SR_PreSerieEscaneoBN->getReferenciaTipo() );
                            $o_SR_SerieEscaneoDP->setReferenciaNumero( $o_SR_PreSerieEscaneoBN->getReferenciaNumero() );
                            $o_SR_SerieEscaneoDP->setComentario( $o_SR_PreSerieEscaneoBN->getComentario() );
                            $o_SR_SerieEscaneoDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                            $o_SR_SerieEscaneoDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                            $o_SR_SerieEscaneoDP->save();
                            //////////////////////////////////////////////////////////////////////////////////////

                            //////////////////////////////////////////////////////////////////////////////////////
                            //ahora se borrar el pre-escaneo por ser temporal
                            $o_SR_PreSerieEscaneoDP = new SR_PreSerieEscaneoDP();
                            $o_SR_PreSerieEscaneoDP->setMovimientoDetalleId( $o_SR_PreSerieEscaneoBN->getMovimientoDetalleId() );
                            $o_SR_PreSerieEscaneoDP->setSerieId( $o_SR_PreSerieEscaneoBN->getSerieId() );
                            $o_SR_PreSerieEscaneoDP->delete();
                            //////////////////////////////////////////////////////////////////////////////////////

                            $i_CantidadEscaneada++;
                        }

                        //se actualiza el inicio y fin de escaneo en el detalle
                        $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP();
                        $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                        $o_SR_MovimientoDetalleDP->setInicioEscaneo( $s_IniScanDet );
                        $o_SR_MovimientoDetalleDP->setFinEscaneo( $s_FinScanDet );
                        $o_SR_MovimientoDetalleDP->setCantidadEscaneada( $i_CantidadEscaneada );
                        $o_SR_MovimientoDetalleDP->setPorSerie( "CO" );
                        $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                        $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_MovimientoDetalleDP->update();

                        if( $i_KeyCab == 0 )
                        {
                            $s_IniScanCab = $s_IniScanDet;
                        }
                        $s_FinScanCab = $s_FinScanDet;
                    }
                    else 
                    {
                        throw new Exception( "No se encontro Series para el Producto [{$o_SR_MovimientoDetalleBN->getProductoId()}]." );
                    }
                }

                //AQUI SE TIENE QUE CAMBIAR EL ESTADO -> COMPLETADO
                //SIEMPRE Y CUANDO NO TENGA PENDIENTES EN PRE-ESCANEO
                $i_ContaCO = 0;
                $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
                $o_SR_MovimientoDetalleFN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();
                $i_ContaRow = count( $a_SR_MovimientoDetalle );
                $a_InicioEscan = array();
                $a_FinEscan    = array();
                foreach ( $a_SR_MovimientoDetalle as $i_KeyCab => $o_SR_MovimientoDetalleBN )
                {
                    $a_InicioEscan[] = $o_SR_MovimientoDetalleBN->getInicioEscaneo();
                    $a_FinEscan[]    = $o_SR_MovimientoDetalleBN->getFinEscaneo();

                    if( $o_SR_MovimientoDetalleBN->getPorSerie() == "CO" )
                    {
                        $i_ContaCO++;
                    }
                }

                if( $i_ContaCO == $i_ContaRow )
                {
                    //ahora se cambia el estado de Pendiente a Completo
                    sort( $a_InicioEscan );
                    rsort( $a_FinEscan );
                    $o_SR_MovimientoDP = new SR_MovimientoDP();
                    $o_SR_MovimientoDP->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                    $o_SR_MovimientoDP->setEstado( "C" );
                    $o_SR_MovimientoDP->setInicioEscaneo( $a_InicioEscan[0] );
                    $o_SR_MovimientoDP->setFinEscaneo( $a_FinEscan[0] );
                    $o_SR_MovimientoDP->setControlEstadoSerie( "C" );
                    $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_SR_MovimientoDP->update();
                }
            }
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            throw new Exception( "SR/H: ".$o_Exception->getMessage() );
        }

        return true;
    }

    public function realizarAnulacionTransaccionH( SR_MovimientoBN $o_SR_MovimientoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            if( !$o_SR_MovimientoBN )
            {
                throw new Exception( "Se necesita el Movimiento Cabecera." );
            }
            
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE REGISTRA NUEVO CABECERA DE INGRESO POR LA ANULACION
            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
            $o_SR_MovimientoFN->setReferenciaTipo( $o_SR_MovimientoBN->getReferenciaTipo() );
            $o_SR_MovimientoFN->setReferenciaNumero( $o_SR_MovimientoBN->getReferenciaNumero() );
            //$o_SR_MovimientoFN->setReferenciaFecha( $o_SR_MovimientoBN->getReferenciaFecha() );
            $o_SR_MovimientoFN->setEstado( "C" );
            $a_SR_Movimiento = $o_SR_MovimientoFN->select();
            
            if( !$a_SR_Movimiento )
            {
                $i_MovimientoId = SR_MovimientoDP::generarId();
                $o_SR_MovimientoDP = new SR_MovimientoDP( $o_SR_MovimientoBN );
                $o_SR_MovimientoDP->setMovimientoId( $i_MovimientoId );
                $o_SR_MovimientoDP->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                $o_SR_MovimientoDP->setFecha( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setInicioEscaneo( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setFinEscaneo( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setReferenciaSecuencia( $o_SR_MovimientoBN->getReferenciaSecuencia() + 1 );
                $o_SR_MovimientoDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_SR_MovimientoDP->save();
            }
            else
            {
                $i_MovimientoId = $a_SR_Movimiento[0]->getMovimientoId();
            }
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_TMP_MovimientoDetalleBN = $o_SR_MovimientoBN->getMovimientoDetalleObject();

            //ahora se busca los detalles del movimiento de serie
            $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
            $o_SR_MovimientoDetalleFN->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
            $o_SR_MovimientoDetalleFN->setProductoId( $o_TMP_MovimientoDetalleBN->getProductoId() );
            $a_SR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();
            
            if( $a_SR_MovimientoDetalle )
            {
                $o_SR_MovimientoDetalleBN = $a_SR_MovimientoDetalle[0];
                
                $o_SR_MovimientoDetalleFN = new SR_MovimientoDetalleFN();
                $o_SR_MovimientoDetalleFN->setMovimientoId( $i_MovimientoId );
                $o_SR_MovimientoDetalleFN->setProductoId( $o_SR_MovimientoDetalleBN->getProductoId() );
                $a_TMPSR_MovimientoDetalle = $o_SR_MovimientoDetalleFN->select();
                if( !$a_TMPSR_MovimientoDetalle )
                {
                   $i_IdDet = SR_MovimientoDetalleDP::generarId();
                   $o_SR_MovimientoDetalleDP = new SR_MovimientoDetalleDP( $o_SR_MovimientoDetalleBN );
                   $o_SR_MovimientoDetalleDP->setMovimientoDetalleId( $i_IdDet );
                   $o_SR_MovimientoDetalleDP->setMovimientoId( $i_MovimientoId );
                   $o_SR_MovimientoDetalleDP->setInicioEscaneo( date( "Y-m-d H:i:s" ) );
                   $o_SR_MovimientoDetalleDP->setFinEscaneo( date( "Y-m-d H:i:s" ) );
                   $o_SR_MovimientoDetalleDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                   $o_SR_MovimientoDetalleDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                   $o_SR_MovimientoDetalleDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                   $o_SR_MovimientoDetalleDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                   $o_SR_MovimientoDetalleDP->save();
                }
                else
                {
                    $i_IdDet = $a_TMPSR_MovimientoDetalle[0]->getMovimientoDetalleId();
                }

                //ahora se busca serie escaneo
                $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
                $o_SR_SerieEscaneoFN->setMovimientoDetalleId( $o_SR_MovimientoDetalleBN->getMovimientoDetalleId() );
                $o_SR_SerieEscaneoFN->setProductoId( $o_TMP_MovimientoDetalleBN->getProductoId() );
                $a_SR_SerieEscaneo = $o_SR_SerieEscaneoFN->select();
                if( $a_SR_SerieEscaneo )
                {
                    foreach ( $a_SR_SerieEscaneo as $o_SR_SerieEscaneoBN ) 
                    {
                        $o_SR_SerieDP = new SR_SerieDP();
                        $o_SR_SerieDP->setSerieId( $o_SR_SerieEscaneoBN->getSerieId() );
                        $o_SR_SerieDP->setUltimaOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                        $o_SR_SerieDP->setEstado( "A" );
                        $o_SR_SerieDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_SR_SerieDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_SR_SerieDP->update();
                        
                        //se procede a guardar lo escaneado en la tabla final
                        $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
                        $o_TMPSR_SerieEscaneoBN = $o_SR_SerieEscaneoFN->selectByPK( $i_IdDet, $o_SR_SerieEscaneoBN->getSerieId() );
                        if( !$o_TMPSR_SerieEscaneoBN )
                        {
                            $o_SR_SerieEscaneoDP = new SR_SerieEscaneoDP();
                            $o_SR_SerieEscaneoDP->setMovimientoDetalleId( $i_IdDet );
                            $o_SR_SerieEscaneoDP->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                            $o_SR_SerieEscaneoDP->setSerieId( $o_SR_SerieEscaneoBN->getSerieId() );
                            $o_SR_SerieEscaneoDP->setProductoId( $o_SR_SerieEscaneoBN->getProductoId() );
                            $o_SR_SerieEscaneoDP->setFecha( date( "Y-m-d H:i:s" ) );
                            $o_SR_SerieEscaneoDP->setOperacion( ALM_TransaccionCabeceraBN::TIPO_INGRESO );
                            $o_SR_SerieEscaneoDP->setAlmacen( $o_SR_SerieEscaneoBN->getAlmacen() );
                            $o_SR_SerieEscaneoDP->setReferenciaTipo( $o_SR_SerieEscaneoBN->getReferenciaTipo() );
                            $o_SR_SerieEscaneoDP->setReferenciaNumero( $o_SR_SerieEscaneoBN->getReferenciaNumero() );
                            $o_SR_SerieEscaneoDP->setComentario( $o_SR_SerieEscaneoBN->getComentario() );
                            $o_SR_SerieEscaneoDP->setUsuarioRegistro( myUser::getUser()->getUserId() );
                            $o_SR_SerieEscaneoDP->setFechaRegistro( date( "Y-m-d H:i:s" ) );
                            $o_SR_SerieEscaneoDP->save();
                        }
                    }
                }

                //ahora se cambia el estado de Anulado
                /*$o_SR_MovimientoDP = new SR_MovimientoDP();
                $o_SR_MovimientoDP->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
                $o_SR_MovimientoDP->setEstado( "A" );
                $o_SR_MovimientoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_SR_MovimientoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_SR_MovimientoDP->update();*/
            }

            $con->commit();

        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "SR/H: ".$o_Exception->getMessage() );
        }

        return true;
    }
}