<?php
class OrdenVentaDetalleBL
{
    protected $o_VTA_DocumentoDetalleBN;
    private function setDocumentoDetalleHisBN( $v )
    {
        $this->o_VTA_DocumentoDetalleBN = $v;
    }
    private function getDocumentoDetalleHisBN()
    {
        return $this->o_VTA_DocumentoDetalleBN;
    }
    
    private function registrarHistorial( $TipoProc, $o_VTA_DocumentoDetalleBN )
    {
        //se agrega el procedimiento del log
        $o_RegistroHistorialDP = new RegistroHistorialDP();
        $o_RegistroHistorialDP->setTabla( "VTA_DocumentoDetalleBN" );
        $o_RegistroHistorialDP->setIdDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        $o_RegistroHistorialDP->setIdCampo( ( string ) $o_VTA_DocumentoDetalleBN->getSecuencia() );
        $o_RegistroHistorialDP->setCampoValor( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        $o_RegistroHistorialDP->setModulo( "DOCUMENTO_DET" );
        switch ( $TipoProc ) 
        {
            case "I":
                $o_RegistroHistorialDP->setCampoDescripcion( "NUEVO ITEM" );
                $o_RegistroHistorialDP->setValorAnterior( "0" );
                $o_RegistroHistorialDP->setValorNuevo( "0" );
            break;
            case "U":
                $o_Tmp_VTA_DocumentoDetalleBN = $this->getDocumentoDetalleHisBN();

                if( $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida() != $o_VTA_DocumentoDetalleBN->getCantidadPedida() )
                {
                    $o_RegistroHistorialDP->setCampoDescripcion( "ACT CANTIDAD" );
                    $o_RegistroHistorialDP->setValorAnterior( ( string ) $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida() );
                    $o_RegistroHistorialDP->setValorNuevo( ( string ) $o_VTA_DocumentoDetalleBN->getCantidadPedida() );
                }

                if( $o_Tmp_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() != $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() )
                {
                    $o_RegistroHistorialDP->setCampoDescripcion( "ACT PRECIO" );
                    $o_RegistroHistorialDP->setValorAnterior( ( string ) $o_Tmp_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() );
                    $o_RegistroHistorialDP->setValorNuevo( ( string ) $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() );
                }
            break;
            case "D":
                $o_Tmp_VTA_DocumentoDetalleBN = $this->getDocumentoDetalleHisBN();

                $o_RegistroHistorialDP->setCampoDescripcion( "ELIMINAR ITEM" );
                $o_RegistroHistorialDP->setValorAnterior( "0" );
                $o_RegistroHistorialDP->setValorNuevo( "0" );
            break;
        }
        $o_RegistroHistorialDP->save();
    }

    public function iniciarGuardarDetallesPorOrden( VTA_DocumentoBN $o_VTA_DocumentoBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            if( $o_VTA_DocumentoBN->getTipoVenta() != "ANT" )
            {
                //CUANDO NO ES ANTICIPO
                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $o_VTA_DocumentoBN->getDocumentoParentId() );

                $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
                $o_VTA_OrdenDetalleFN->setOrdenId( $o_VTA_DocumentoBN->getDocumentoParentId() );
                $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
                if( $a_VTA_OrdenDetalle )
                {
                    foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN ) 
                    {
                        //validaciones
                        $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPorCostoGeneral( $o_VTA_OrdenDetalleBN->getItemCod() );
                        if( $o_MST_ListaPrecioDetalleBN )
                        {
                            if( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidadMN() <= $o_MST_ListaPrecioDetalleBN->getPrecioCosto() )
                            {
                                //throw new Exception( "El Producto [{$o_VTA_OrdenDetalleBN->getItemCod()}] tiene un Precio menor o igual que el costo." );
                            }
                        }
                        if( $o_VTA_OrdenDetalleBN->getItemTipo() == VTA_OrdenDetalleBN::TIPO_PRODUCTO )
                        {
                            if( $o_VTA_OrdenDetalleBN->getTotalFinal() <= 0 )
                            {
                                throw new Exception( "Se encontro un detalle con el monto total a 0" );
                            }
                        }
                        /////////////////////////////////////////////////////////

                        $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
    
                        $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                        $o_VTA_DocumentoDetalleBN->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                        $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                        $o_VTA_DocumentoDetalleBN->setSecuencia( $o_VTA_OrdenDetalleBN->getOrdenDetalleNum() );
                        $o_VTA_DocumentoDetalleBN->setTipoDetalle( $o_VTA_OrdenDetalleBN->getItemTipo() );
                        $o_VTA_DocumentoDetalleBN->setItemCodigo( $o_VTA_OrdenDetalleBN->getItemCod() );
                        $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_OrdenDetalleBN->getAlmacenCod() );
                        $o_VTA_DocumentoDetalleBN->setLote( $o_VTA_OrdenDetalleBN->getLoteNum() );
                        $o_VTA_DocumentoDetalleBN->setCondicion( "1" );
                        $o_VTA_DocumentoDetalleBN->setIdUnidad( $o_VTA_OrdenDetalleBN->getIdUnidad() );
                        $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_VTA_OrdenDetalleBN->getIdItemTipo() );
                        $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioNivel() );
                        $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_VTA_OrdenDetalleBN->getOrdenDetalleDescripcion() ) );
                        $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto cuando se trata de una orden de venta

                        $o_VTA_DocumentoDetalleBN->setTipoIGV( "1" );
                        $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                        if( $o_VTA_OrdenDetalleBN->getOrdenDetalleAfectoImpuesto() == "N" )
                        {
                            $o_VTA_DocumentoDetalleBN->setTipoIGV( "11" );
                            $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                        }

                        if( $o_VTA_OrdenBN->esExoneradodeIGV() )
                        {
                            $o_VTA_DocumentoDetalleBN->setTipoIGV( "9" );
                            $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "Y" );
                        }
            
                        $o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuesto() );
                        $o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuestoMN() );
                        $o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() );
                        $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad() );
                        $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidadMN() );
    
                        $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad() );
                        $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidadMN() );
                        $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto() );
                        $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuestoMN() );

                        $o_VTA_DocumentoDetalleBN->setMontoDescuento( $o_VTA_OrdenDetalleBN->getOrdenDetalleDsctoUnidad() );
                        $o_VTA_DocumentoDetalleBN->setMontoDescuentoMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleDsctoUnidadMN() );
                        $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $o_VTA_OrdenDetalleBN->getSubtotalFinal() );
                        $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $o_VTA_OrdenDetalleBN->getSubtotalFinalMN() );
                        $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinal() );
                        $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinalMN() );
                        $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $o_VTA_OrdenDetalleBN->getTotalFinal() );
                        $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $o_VTA_OrdenDetalleBN->getTotalFinalMN() );
    
                        $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        
                        $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                        $o_VTA_DocumentoDetalleDP->save();
    
                        if( $o_VTA_OrdenDetalleBN->getObjectOrdenBN()->getOrdenTipoObject()->getOrdenTipoPrefijo() != "M" )
                        {
                            //se elimina la reserva por la orden
                            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
                            $o_CotizacionesDetalleBL->iniciarReservaStockAlmacen( $o_VTA_OrdenDetalleBN, "D" );
        
                            //ahora se cambia la reserva al detalle de la factura
                            $this->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "I" );
                        }
    
                        //validaciones extras
                        $this->validacionesExtrasPorCompania( $o_VTA_DocumentoDetalleBN );
                    }
                }
                else
                {
                    $b_Control = true;
                    //primero buscamos la orden de venta
                    $o_VTA_OrdenFN = new VTA_OrdenFN();
                    $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $o_VTA_DocumentoBN->getDocumentoParentId() );

                    if( $o_VTA_OrdenBN )
                    {
                        //el tipo de cambio de la cabecera
                        $f_TipoCob = $o_VTA_OrdenBN->getMonedaCambioValor();
                        
                        //ahora recupero la moneda de la Orden de Venta
                        $s_OrdenMonedaCod = $o_VTA_OrdenBN->getMonedaCod();
                        
                        //se pregunta el control de impuesto por cabecera de la cotizacion
                        $b_ControlImpuesto = $o_VTA_OrdenBN->esGravadaConImpuesto();
                        
                        //para recuperar la moneda del sistema
                        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
                        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
                        if( !$o_MST_ListaPrecioCabeceraBN )
                        {
                            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
                        }
                        
                        if( $o_VTA_OrdenBN->getOrdenTipoClasificacionId() == VTA_OrdenBN::TIPO_PRODUCTOS_TERMINADOS )
                        {
                            $a_OrdenDetalle = $o_VTA_OrdenBN->getArrayDetallesFinal();
                            if( $a_OrdenDetalle)
                            {
                                foreach ( $a_OrdenDetalle as $o_VTA_ProductoFinalBN )
                                {
                                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                    //VALIDACIONES
                                    if( $o_VTA_ProductoFinalBN->getTotalaPagar() <= 0 )
                                    {
                                        throw new Exception( "Se encontro un detalle con el monto total a 0" );
                                    }
                                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                                    $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                                    
                                    $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                                    $o_VTA_DocumentoDetalleBN->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                                    $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                                    $o_VTA_DocumentoDetalleBN->setSecuencia( intval( $o_VTA_ProductoFinalBN->getSecuencia() ) );
                                    $o_VTA_DocumentoDetalleBN->setTipoDetalle( "P" );
                                    $o_VTA_DocumentoDetalleBN->setItemCodigo( $o_VTA_ProductoFinalBN->getIdItem() );
                                    $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_ProductoFinalBN->getIdAlmacen() );
                                    $o_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                                    $o_VTA_DocumentoDetalleBN->setCondicion( "1" );
                                    $o_VTA_DocumentoDetalleBN->setIdUnidad( $o_VTA_ProductoFinalBN->getIdUnidad() );
                                    $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_VTA_ProductoFinalBN->getIdItemTipo() );
                                    $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                                    $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_VTA_ProductoFinalBN->getDetalleDescripcion() ) );
                                    $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto cuando se trata de una orden de venta
                                    $o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_VTA_ProductoFinalBN->getCantidad() );
                                    
                                    $f_PrecioUnitario           = $o_VTA_ProductoFinalBN->getPrecioUnitario();
                                    $f_PrecioUnitarioMN         = $o_VTA_ProductoFinalBN->getPrecioUnitario();
                                    $f_ImpuestoUnitario         = $o_VTA_ProductoFinalBN->getImpuestoUnitario();
                                    $f_ImpuestoUnitarioMN       = $o_VTA_ProductoFinalBN->getImpuestoUnitario();
                                    $f_PrecioUnitarioConIGV     = $o_VTA_ProductoFinalBN->getPrecioUnitarioConIGV();
                                    $f_PrecioUnitarioConIGVMN   = $o_VTA_ProductoFinalBN->getPrecioUnitarioConIGV();

                                    $f_DsctoTotal           = $o_VTA_ProductoFinalBN->getDsctoTotal();
                                    $f_DsctoTotalMN         = $o_VTA_ProductoFinalBN->getDsctoTotal();
                                    $f_BaseImponible        = $o_VTA_ProductoFinalBN->getBaseImponible();
                                    $f_BaseImponibleMN      = $o_VTA_ProductoFinalBN->getBaseImponible();
                                    $f_ImpuestoConDscto     = $o_VTA_ProductoFinalBN->getImpuestoConDscto();
                                    $f_ImpuestoConDsctoMN   = $o_VTA_ProductoFinalBN->getImpuestoConDscto();
                                    $f_TotalaPagar          = $o_VTA_ProductoFinalBN->getTotalaPagar();
                                    $f_TotalaPagarMN        = $o_VTA_ProductoFinalBN->getTotalaPagar();
                                    
                                    $o_VTA_DocumentoDetalleBN->setTipoIGV( "1" );
                                    $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );

                                    if( !$b_ControlImpuesto )
                                    {
                                        $o_VTA_DocumentoDetalleBN->setTipoIGV( "11" );
                                        $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "Y" );
                                    }

                                    if( $o_VTA_OrdenBN->esExoneradodeIGV() )
                                    {
                                        $o_VTA_DocumentoDetalleBN->setTipoIGV( "9" );
                                        $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "Y" );
                                    }
                                    
                                    if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
                                    {
                                        if( $s_OrdenMonedaCod == "EX" )
                                        {
                                            $f_PrecioUnitarioMN         = round( $f_PrecioUnitario * $f_TipoCob, 2 );
                                            $f_PrecioUnitarioConIGVMN   = round( $f_PrecioUnitarioConIGV * $f_TipoCob, 2 );
                                            $f_ImpuestoUnitarioMN       = $f_PrecioUnitarioConIGVMN - $f_PrecioUnitarioMN;

                                            $f_DsctoTotalMN             = round( $f_DsctoTotal * $f_TipoCob, 2 );
                                            $f_BaseImponibleMN          = round( $f_BaseImponible * $f_TipoCob, 2 );
                                            $f_TotalaPagarMN            = round( $f_TotalaPagar * $f_TipoCob, 2 );
                                            $f_ImpuestoConDsctoMN       = $f_TotalaPagarMN - $f_BaseImponibleMN;
                                        }
                                    }
                                    
                                    //$o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuesto() );
                                    //$o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuestoMN() );
                                    
                                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $f_PrecioUnitario );
                                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $f_PrecioUnitarioMN );
                                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $f_ImpuestoUnitario );
                                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $f_ImpuestoUnitarioMN );
                                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_PrecioUnitarioConIGV );
                                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_PrecioUnitarioConIGVMN );

                                    $o_VTA_DocumentoDetalleBN->setMontoDescuento( $f_DsctoTotal );
                                    $o_VTA_DocumentoDetalleBN->setMontoDescuentoMN( $f_DsctoTotalMN );
                                    $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $f_BaseImponible );
                                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $f_BaseImponibleMN );
                                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( $f_ImpuestoConDscto );
                                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( $f_ImpuestoConDsctoMN );
                                    $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $f_TotalaPagar );
                                    $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $f_TotalaPagarMN );
                                    
                                    $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                    $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                    $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                    $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    
                                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                                    $o_VTA_DocumentoDetalleDP->save();
                                }
                                $b_Control = false;
                            }
                        }
                    }
                    
                    if( $b_Control )
                    {
                        throw new Exception( "No se encontro Detalles en la Orden de Venta para asociar al Documento." );
                    }
                }
            }
            else
            {
                //AQUI INGRESA CUANDO ES ANTICIPO
                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $o_VTA_DocumentoBN->getDocumentoParentId() );

                $s_IdItemAnticipo = GSS_ParametroMastFN::getValorPorTipo( "FACTURACION", "COD_ANTICIPO" );
                
                $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItemAnticipo );
                
                $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                
                $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleBN->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                
                $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoBN->getIdTipoDocumento(), $o_VTA_DocumentoBN->getIdCompania(), $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleBN->setSecuencia( $i_Id );
                
                $o_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_OrdenDetalleBN::TIPO_PRODUCTO_SERVICIO );
                $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_IdItemAnticipo );
                $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_DocumentoBN->getAlmacenDespacho() );
                $o_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                $o_VTA_DocumentoDetalleBN->setCondicion( "1" );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( ( int ) $o_ALM_ItemMastBN->getUnidadVenta() );
                $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
                $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_ALM_ItemMastBN->getDescripcionCompleta() )." - COTIZACION ".$o_VTA_OrdenBN->getOrdenNum() );
                
                $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto cuando se trata de una orden de venta
                
                $o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( 0 );
                $o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( 0 );
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
                $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $o_VTA_DocumentoBN->getMontoSubTotal() );
                $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $o_VTA_DocumentoBN->getMontoSubTotalMN() );
                
                $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $o_VTA_DocumentoBN->getMontoImpuestos() );
                $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $o_VTA_DocumentoBN->getMontoImpuestoMN() );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $o_VTA_DocumentoBN->getMontoTotal() );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $o_VTA_DocumentoBN->getMontoTotalMN() );
                
                $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $o_VTA_DocumentoBN->getMontoSubTotal() );
                $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $o_VTA_DocumentoBN->getMontoSubTotalMN() );
                $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( $o_VTA_DocumentoBN->getMontoImpuestos() );
                $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( $o_VTA_DocumentoBN->getMontoImpuestoMN() );
                $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $o_VTA_DocumentoBN->getMontoTotal() );
                $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $o_VTA_DocumentoBN->getMontoTotalMN() );
                
                $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                
                $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                $o_VTA_DocumentoDetalleDP->save();
            }
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "F|D-O: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function asignarPrecioUnitario( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PROCEDIMIENTO ESPECIAL PARA AGREGAR COMENTARIO -> 2019-12-28
        if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
        {
            return true;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //AHORA SE BUSCA EL PRECIO - se hace el cambio en PUNO - JULIACA
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $s_IdItem           = $o_VTA_DocumentoDetalleBN->getItemCodigo();
        $i_IdTipoPrecio     = "1";
        $i_IdUnidadAsignado = $o_VTA_DocumentoDetalleBN->getIdUnidad(); //unidad de medida seleccionada
        //aqui se agrega un procedimiento personalizado por la unidad de medida [PUNO][JULIACA]
        //la conversion por la unidad asignada por unidad en la ficha
        //primero se tiene que saber cual es la unida de medida del item seleccionada en la ficha
        $f_CantidadAsiganada   = $o_VTA_DocumentoDetalleBN->getItemCantidadMedidaAsignada();
        $f_CantidadEquivalente = 0;
        //ahora la unidad de medida establecida para la venta
        $i_UnidadVentaAsiganada = $o_VTA_DocumentoDetalleBN->getItemUnidadVentaAsignada();
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        $o_VTA_DocumentoDetalleFN->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );

        if( $o_VTA_DocumentoDetalleBN->getSecuencia() )
        {
            //$o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_VTA_DocumentoDetalleFN->getCantidadPedidaAsignado() );
            if( !$o_VTA_DocumentoDetalleBN->getIdUnidad() )
            {
                $i_IdUnidadAsignado = $o_VTA_DocumentoDetalleFN->getIdUnidadMedidaAsignado();
            }
        }

        if( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() )
        {
            $i_IdTipoPrecio = $o_VTA_DocumentoDetalleBN->getIdTipoPrecio();
        }
        else 
        {
            //SE RECUPERA LA CONDICION
            $i_TipoPrecioAsignado = $o_VTA_DocumentoDetalleFN->getTipoPrecioAsignado();
            if( $i_TipoPrecioAsignado )
            {
                if( !$o_VTA_DocumentoDetalleBN->getIdTipoPrecio() )
                {
                    $i_IdTipoPrecio = $i_TipoPrecioAsignado;
                }
            }
        }

        $o_VTA_DocumentoDetalleBN->setCondicion( '1' );
        $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( $i_IdTipoPrecio );

        //para recuperar la moneda del sistema
        $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
        $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
        if( !$o_MST_ListaPrecioCabeceraBN )
        {
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //aqui se pregunta que la unidad de medida del item es igual a la seteada
        $b_ControlConversion = true;
        if( $i_IdUnidadAsignado == $i_UnidadVentaAsiganada )
        {
            $b_ControlConversion = false;
        }
        else
        {
            //aqui es un conversion, y ahora se revisar que si es docena o algo parecido
            $o_SEL_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_IdUnidadAsignado ); //unidad de medida seleccionada
            if ( $o_SEL_MST_UnidadMastBN->getUnidadEquivalenteFlag() && !$o_SEL_MST_UnidadMastBN->getUsoFraccionFlag() && !$o_SEL_MST_UnidadMastBN->getEsUnidadMinimaFlag() ) 
            {
                $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $i_IdUnidadAsignado );
                $f_CantidadEquivalente = $a_MST_UnidadConversionMast[0]->getCantidadEquivalente();
            }
        }

        //aqui se mueve la validacion de control de conversion, por que si el precios esta
        //personalizado, se tiene que eliminar
        if( $i_IdUnidadAsignado != $o_VTA_DocumentoDetalleFN->getIdUnidadMedidaAsignado() )
        {
            if( $i_IdTipoPrecio == "P" )
            {
                $i_IdTipoPrecio = '1';
                $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( $i_IdTipoPrecio );
            }
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        if( $o_VTA_DocumentoDetalleBN->getCambioPrecioFlag() )
        {
            $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();

            if( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() != "P" )
            {
                //si se trata de un cambio de precio eligiendo un tipo
                //para recuperar el precio asociado
                $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal(), $s_IdItem, $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() );
                if( !$o_MST_ListaPrecioDetalleBN )
                {
                    $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem, $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() );
                }
            }
        }
        else
        {
            //para recuperar el precio asociado
            $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
            $o_MST_ListaPrecioDetalleBN = $o_MST_ListaPrecioDetalleFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal(), $s_IdItem, $i_IdTipoPrecio );
            if( !$o_MST_ListaPrecioDetalleBN )
            {
                $o_MST_ListaPrecioDetalleBN = MST_ListaPrecioDetalleFN::buscarPrecioGeneral( $s_IdItem, $i_IdTipoPrecio );
            }
            if( !$o_MST_ListaPrecioDetalleBN )
            {
                $o_MST_ListaPrecioDetalleBN = new MST_ListaPrecioDetalleBN();
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $o_VTA_DocumentoDetalleFN->getPrecioUnitarioIncIGVAsignado() ); //se asigna el tipo de precio de la tabla detalles
            }
        }

        //el tipo de cambio
        $f_TipoCob = GSS_TipoCambioFN::getStaticTipoCambioCobranza(); //EN EL FUTURO PODRIA SER EL TIPO DE CAMBIO GUARDADO EN LA ORDEN CABECERA
        
        //ahora recupero la moneda de la Orden de Venta
        $s_OrdenMonedaCod = $o_VTA_DocumentoDetalleBN->getObjectDocumentoCab()->getMonedaDocumento();

        if( $o_MST_ListaPrecioDetalleBN )
        {
            $o_VTA_DocumentoDetalleBN->setPorcentajeImpuesto( 18 );
            if( !$o_VTA_DocumentoDetalleBN->getTipoIgv() )
            {
                $o_VTA_DocumentoDetalleBN->setTipoIgv( "1" ); //Gravado - Operación Onerosa
            }

            //////////////////////////////////////////////////////////////////////////////////////////
            //SE RECUPERA VALOR DE IGV ACTUAL
            /*
            $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
            $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, 'AL', 'IGV' );
            $f_ValorIGV = floatval( $o_GSS_ParametroMastBN->getNumero() ); //0.18
            $f_ValorIGVMasUno = floatval( $o_GSS_ParametroMastBN->getNumero() ) + 1;  //1.18
            */
            $f_ValorIGV = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
            $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
            //////////////////////////////////////////////////////////////////////////////////////////

            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
            {

                if( $s_OrdenMonedaCod == "LO" )
                {
                    if( $o_VTA_DocumentoDetalleBN->getCambioPrecioFlag() )
                    {
                        if( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() == "P" )
                        {
                            $f_MontoIncImpuestoUnidad  = $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad();
                        }
                        else
                        {
                            $f_MontoIncImpuestoUnidad  = $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV();
                        }
                    }
                    else
                    {
                        if( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() == "P" )
                        {
                            $f_MontoIncImpuestoUnidad  = $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad();
                        }
                        else
                        {
                            $f_MontoIncImpuestoUnidad  = $o_MST_ListaPrecioDetalleBN->getPrecioVentaIGV();
                        }
                    }

                    $f_PrecioUnitario          = round( $f_MontoIncImpuestoUnidad / $f_ValorIGVMasUno, 13 );

                    $f_MontoImpuestoUnidad     = round( $f_PrecioUnitario * $f_ValorIGV, 13 );
                    $f_MontoImpuestoUnidad     = round( $f_MontoImpuestoUnidad, 2 );

                    $f_PrecioUnitario          = round( $f_PrecioUnitario, 2 );
                    
                    if( $b_ControlConversion )
                    {
                        if( $o_VTA_DocumentoDetalleBN->getIdTipoPrecio() == "P" )
                        {
                            //$f_MontoIncImpuestoUnidad = $f_MontoIncImpuestoUnidad;
                        }
                        else
                        {
                            $f_MontoIncImpuestoUnidad  = round( $f_MontoIncImpuestoUnidad / $f_CantidadAsiganada, 2 );
                            if( $f_CantidadEquivalente )
                            {
                                $f_MontoIncImpuestoUnidad = $f_MontoIncImpuestoUnidad * $f_CantidadEquivalente;
                            }
                        }

                        $f_PrecioUnitario         = round( $f_MontoIncImpuestoUnidad / $f_ValorIGVMasUno, 13 );

                        $f_MontoImpuestoUnidad    = round( $f_PrecioUnitario * $f_ValorIGV, 13 );
                        $f_MontoImpuestoUnidad    = round( $f_MontoImpuestoUnidad, 2 );

                        $f_PrecioUnitario         = round( $f_PrecioUnitario, 2 );
                    }
                    
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $f_PrecioUnitario );
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $f_PrecioUnitario );
                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $f_MontoImpuestoUnidad );
                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $f_MontoImpuestoUnidad );
                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_MontoIncImpuestoUnidad );
                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_MontoIncImpuestoUnidad );
                }
                if( $s_OrdenMonedaCod == "EX" )
                {
                    $PrecioUnitarioSoles = floatval( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() );
                    $PrecioUnitarioME = utilMath::fnround( $PrecioUnitarioSoles / $f_TipoCob, 2 );
                    
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $PrecioUnitarioSoles );
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $PrecioUnitarioME );
                }
            }
            
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
            {
                if( $s_OrdenMonedaCod == "LO" )
                {
                    $PrecioUnitarioSoles = utilMath::fnround( floatval( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() ) * $f_TipoCob, 2 );
                    
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $PrecioUnitarioSoles );
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $PrecioUnitarioSoles );
                }
                if( $s_OrdenMonedaCod == "EX" )
                {
                    $PrecioUnitarioSoles = utilMath::fnround( floatval( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() ) * $f_TipoCob, 2 );
                    $PrecioUnitarioME    = floatval( $o_MST_ListaPrecioDetalleBN->getPrecioVenta() );
                    
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $PrecioUnitarioSoles );
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $PrecioUnitarioME );
                }
            }
        }
        else
        {
            throw new Exception( "No se encontro Lista de Precio para el Item [$s_IdItem]" );
        }
    }

    public function validacionPorUnidadMedida( VTA_DocumentoDetalleBN &$o_VTA_DocumentoDetalleBN )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PROCEDIMIENTO ESPECIAL PARA AGREGAR COMENTARIO -> 2019-12-28
        if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
        {
            return true;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //si no tiene cantidad asignada, se asume la cantidad registrada
        if( !$o_VTA_DocumentoDetalleBN->getCantidadPedida() )
        {
            if( $o_VTA_DocumentoDetalleBN->getSecuencia() )
            {
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );

                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_VTA_DocumentoDetalleFN->getCantidadPedidaAsignado() );
            }
        }

        $f_CantidadPedida     = $o_VTA_DocumentoDetalleBN->getCantidadPedida();

        $i_IdUnidadMedidaAsig = $o_VTA_DocumentoDetalleBN->getIdUnidad(); //unidad de medida seleccionada
        $i_IdUnidadMedidadMin = 58; //se tiene que cambiar a dinamico // puede quedar // aqui se tiene que buscar la unidad minima
        $f_ItemCantidadMedida = $o_VTA_DocumentoDetalleBN->getItemCantidadMedidaAsignada(); //es la cantidad por caja
        //ahora la unidad de medida establecida para la venta
        $i_UnidadVentaAsiganada = intval( $o_VTA_DocumentoDetalleBN->getItemUnidadVentaAsignada() ); //id unidad asignada en la ficha del item
        $o_SEL_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_IdUnidadMedidaAsig ); //unidad de medida seleccionada
        //$o_ASI_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_IdUnidadMedidaAsig );   //unidad de medida asignada
        
        //si la unidad de medida es la minima se cambia por defecto
        //es un plan de contingencia
        if ( $o_SEL_MST_UnidadMastBN->getEsUnidadMinimaFlag() ) 
        {
            $i_IdUnidadMedidadMin = intval( $o_SEL_MST_UnidadMastBN->getIdUnidad() );
            $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidadMin );

            //if( $f_CantidadPedida < 1 )
            if( $f_CantidadPedida < 0 )
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidadMin );
                return false;
            }

            if( is_float( $f_CantidadPedida ) )
            {
                
                //$i_CantidadPedida = floor( $f_CantidadPedida );
                $i_CantidadPedida = floatval( $f_CantidadPedida );
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $i_CantidadPedida );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidadMin );
                return false;
            }

            return false;
        }

        $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $i_UnidadVentaAsiganada );
        if( $a_MST_UnidadConversionMast )
        {
            foreach ( $a_MST_UnidadConversionMast as $key => $o_MST_UnidadConversionMastBN ) 
            {
                $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                $o_TmpMST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $o_MST_UnidadConversionMastBN->getIdUnidadEquivalente() );
                if( $o_TmpMST_UnidadMastBN->getEsUnidadMinimaFlag() )
                {
                    $i_IdUnidadMedidadMin = intval( $o_TmpMST_UnidadMastBN->getIdUnidad() );
                    break;
                }
            }
        }
        else
        {
            throw new Exception( "El Item [".$o_VTA_DocumentoDetalleBN->getItemCodigo()."] no tiene configurado la Unidad de Medida en Conversiones." );
        }

        /*if( $i_UnidadVentaAsiganada == 58 )
        {
            $o_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
        }*/

        //se hace la conversion
        if( $i_IdUnidadMedidadMin != $i_IdUnidadMedidaAsig )
        //if( $i_UnidadVentaAsiganada != $i_IdUnidadMedidaAsig )
        {
            //ahora se busca la unidad minima

            $o_ASI_MST_UnidadMastBN = MST_UnidadMastFN::select_one( $i_UnidadVentaAsiganada ); //unidad de medida seleccionada
            
            //si es diferente se busca el costo
            $StockDisponible = $o_VTA_DocumentoDetalleBN->getAlmcenStockDisponible();
            $StockReservado  = 0;
            if( $o_VTA_DocumentoDetalleBN->getSecuencia() )
            {
                $o_ALM_ReservaItemStockBN = ALM_ReservaItemStockFN::getObjectReservaItemxDocDetalle( $o_VTA_DocumentoDetalleBN );
                if( !$o_ALM_ReservaItemStockBN )
                {
                    throw new Exception( "No se encontro la Referencia del Documento de Reserva." );
                }
                $StockReservado = $o_ALM_ReservaItemStockBN->getReservaCantidad();
            }

            $StockDispoTotal = $StockDisponible + $StockReservado;

            //if( $i_IdUnidadMedidaAsig == 59 )
            if( $o_ASI_MST_UnidadMastBN->getUnidadEquivalenteFlag() && $o_ASI_MST_UnidadMastBN->getUsoFraccionFlag() ) //es una unidad como caja
            {
                $f_ItemCantidadMedida = $o_VTA_DocumentoDetalleBN->getItemCantidadMedidaAsignada(); //es la cantidad por caja

            }
            elseif ( $o_ASI_MST_UnidadMastBN->getUnidadEquivalenteFlag() && !$o_ASI_MST_UnidadMastBN->getUsoFraccionFlag() && !$o_ASI_MST_UnidadMastBN->getEsUnidadMinimaFlag() )  //aqui puede ser la unidad de medida como docena
            {
                $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $i_UnidadVentaAsiganada );
                $f_ItemCantidadMedida = $a_MST_UnidadConversionMast[0]->getCantidadEquivalente();
            }

            //primera validacion - por caja
            $f_CantidadPedidaConv = round( $StockDispoTotal / $f_ItemCantidadMedida, 2 ); //cantidad total disponible incluyendo lo reservado, en caja
            if( $f_CantidadPedidaConv < 1 ) 
            {
                //se piensa que es menor a una caja, entonces se convierte en unidades
                //si es menor se tiene que transformar en unidades
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $StockDisponible );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidadMin );
                return false;
            }
            if( $f_CantidadPedidaConv >= $f_CantidadPedida ) //si la cantidad pedida es menor
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $f_CantidadPedida );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidaAsig );
                return false;
            }
            if( $f_CantidadPedida > $f_CantidadPedidaConv ) //si la cantidad pedida es mayor
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $f_CantidadPedidaConv );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidaAsig );
                return false;
            }
            $f_CantidadPedidaConv = round( $f_ItemCantidadMedida * $f_CantidadPedida, 2 ); //estoy conviertiendo a unidades, y conparar con la cantidad disponible
            if( $StockDisponible < $f_CantidadPedidaConv )
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $StockDisponible );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidadMedidadMin );
                return false;
            }
        }

        //aqui quiere decir que si se trata de la unidad de medida minima
        if( $i_IdUnidadMedidaAsig == 58 )
        {
            if( $f_CantidadPedida < 1 )
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
                return false;
            }
            if( is_float( $f_CantidadPedida ) )
            {
                $i_CantidadPedida = floor( $f_CantidadPedida );
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $i_CantidadPedida );
                $o_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
                return false;
            }
        }

        return true;
    }

    public function iniciarProceso( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //procedimiento especial para promociones
        if( $o_VTA_DocumentoDetalleBN->TieneNumeroPromocion() )
        {
            $o_VTA_DocumentoDetalleBN->setTipoProcPromo( "UPDATE" );
            return $this->iniciarProcesoPromocionGrupal( $o_VTA_DocumentoDetalleBN );
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $this->validarIngresoPorCodigoBarras( $o_VTA_DocumentoDetalleBN );

            //$this->asignarPrecioUnitario( $o_VTA_DocumentoDetalleBN );

            $b_Result = $this->validarDetalleExisteItem( $o_VTA_DocumentoDetalleBN );

            //ahora se agrega una validacion por la unidad de medida [PUNO - JULIACA]
            $b_Resultado = $this->validacionPorUnidadMedida( $o_VTA_DocumentoDetalleBN );
            //ahora se asiga el precio
            $this->asignarPrecioUnitario( $o_VTA_DocumentoDetalleBN );
            if( !$b_Resultado )
            {
                //$this->asignarPrecioUnitario( $o_VTA_DocumentoDetalleBN );
            }

            //VALIDACIONES EN GENERAL
            $o_OrdenVentaDetalleValidBL = new OrdenVentaDetalleValidBL();
            $o_OrdenVentaDetalleValidBL->iniciarValidaciones( $o_VTA_DocumentoDetalleBN );
            /////////////////////////

            if( $b_Result )
            {
                $b_Result = $this->actualizarLinea( $o_VTA_DocumentoDetalleBN );
            }
            else
            {
                $this->validacionesExtrasPorCompania( $o_VTA_DocumentoDetalleBN );
                $b_Result = $this->agregarLinea( $o_VTA_DocumentoDetalleBN );
            }

            //$this->iniciarProcesoPromocion( $o_VTA_DocumentoDetalleBN );

            $this->actualizarMontosCabcecera( $o_VTA_DocumentoDetalleBN );
            
            //exit;
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "I|P: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    public function iniciarCambioPrecio( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        //SE PUEDE INICIAR PROCESOS DE VALIDACION PARA EL CAMBIO DE PRECIO
        $o_VTA_DocumentoDetalleBN->setCambioPrecioFlag( true );
        $this->iniciarProceso( $o_VTA_DocumentoDetalleBN );
        return true;
    }
    
    public function actualizarLinea( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            //usleep( 100 );
            $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            
            $this->validacionesPorDetalles( $o_VTA_DocumentoDetalleBN );
            
            $this->validarValoresxDefecto( $o_VTA_DocumentoDetalleBN );
            
            $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
            $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_VTA_DocumentoDetalleDP->update();

            //$this->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "U" );
            
            $this->registrarHistorial( "U", $o_VTA_DocumentoDetalleBN );

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "O|V-ACT: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    public function agregarLinea( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            if( !$o_VTA_DocumentoDetalleBN->getSecuencia() )
            {
                $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $i_Id );
            }
            $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            
            
            $this->validacionesPorDetalles( $o_VTA_DocumentoDetalleBN );
            
            $this->validarValoresxDefecto( $o_VTA_DocumentoDetalleBN );
            
            //POR LOS ITEM QUE TIENE VARIOS LOTES, SE TIENE QUE SELECCIONAR:
            if( $o_VTA_DocumentoDetalleBN->getLoteVarios() )
            {
                //$o_VTA_DocumentoDetalleBN->setLote( null );
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //un procedimiento nuevo [2019-03-16 from Juliaca]
            //se agrega la unidad de medida del item
            //$o_VTA_DocumentoDetalleBN->setIdUnidad( intval( $o_VTA_DocumentoDetalleBN->getItemUnidadVentaAsignada() ) );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
            $o_VTA_DocumentoDetalleDP->save();
            
            //$this->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "I" );
            
            $this->registrarHistorial( "I", $o_VTA_DocumentoDetalleBN );
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "O|V-INS: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    public function eliminarLinea( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoDetalleBN->getSecuencia() );
        if( !$o_Tmp_VTA_DocumentoDetalleBN )
        {
            throw new Exception( "No se encontro referencia de la linea." );
        }

        $this->setDocumentoDetalleHisBN( $o_Tmp_VTA_DocumentoDetalleBN );

        if( $o_Tmp_VTA_DocumentoDetalleBN->TieneNumeroPromocion() )
        {
            $o_Tmp_VTA_DocumentoDetalleBN->setTipoProcPromo( "DELETE" );
            return $this->iniciarProcesoPromocionGrupal( $o_Tmp_VTA_DocumentoDetalleBN );
        }

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
            $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
            $o_VTA_DocumentoDetalleDP->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
            $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
            $o_VTA_DocumentoDetalleDP->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
            $o_VTA_DocumentoDetalleDP->delete();
                
            VTA_DocumentoDP::actualizarCabaceraMontos( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() ) );
            
            //$this->iniciarReservaStockAlmacen( $o_Tmp_VTA_DocumentoDetalleBN, "D" );
            
            $this->registrarHistorial( "D", $o_Tmp_VTA_DocumentoDetalleBN );
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "CT|V-DLT: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    public function actualizarMontosCabcecera( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        VTA_DocumentoDP::actualizarCabaceraMontos( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoDetalleBN->getAlmacenCodigo() );
    }

    public function iniciarProcesoPromocionGrupal( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        pr( $o_VTA_DocumentoDetalleBN ); exit;
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();
            
            if( $o_VTA_DocumentoDetalleBN->getTipoProcPromo() == "INSERT" )
            {
                //aqui el id de referencia es crucial
                $o_MKT_PromocionCabFN = new MKT_PromocionCabFN();
                $o_MKT_PromocionCabBN = $o_MKT_PromocionCabFN->selectByPK( $o_VTA_DocumentoDetalleBN->getRefParent() );
                if( !$o_MKT_PromocionCabBN )
                {
                    throw new Exception( "La Promocion en Referencia no existe." );
                }

                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //validacion de registro doble
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE );
                $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_MKT_PromocionCabBN->getCodigoPromo() );
                $o_VTA_DocumentoDetalleFN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                if( $a_VTA_DocumentoDetalle )
                {
                    throw new Exception( "La promcion ".$o_MKT_PromocionCabBN->getDescripcionPromo()." ya se encuentra registrada. " );
                    
                    $o_Tmp_VTA_DocumentoDetalleBN = $a_VTA_DocumentoDetalle[0];

                    $i_Secuencia      = $o_Tmp_VTA_DocumentoDetalleBN->getSecuencia();
                    $s_Lote           = $o_Tmp_VTA_DocumentoDetalleBN->getLote();
                    $f_CantidadPedida = $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida();
                    $f_CantidadPedida = $f_CantidadPedida + 1;
                    $o_VTA_DocumentoDetalleBN->setSecuencia( $i_Secuencia );
                    $o_VTA_DocumentoDetalleBN->setCantidadPedida( $f_CantidadPedida );
                    $o_VTA_DocumentoDetalleBN->setLote( $s_Lote );

                    goto GOTO_UPDATE;
                }
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                //aqui se inserta una nueva promocion con sus detalles
                $o_Tmp_VTA_DocumentoDetalleBN = clone $o_VTA_DocumentoDetalleBN;

                $o_Tmp_VTA_DocumentoDetalleBN->setPrecioUnitario( $o_MKT_PromocionCabBN->getPrecioSinIGVPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( $o_MKT_PromocionCabBN->getPrecioSinIGVPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( $o_MKT_PromocionCabBN->getMontoIGVPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( $o_MKT_PromocionCabBN->getMontoIGVPromo() );

                $o_Tmp_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $o_MKT_PromocionCabBN->getPrecioConIGVPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $o_MKT_PromocionCabBN->getPrecioConIGVPromo() );

                $o_Tmp_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                $o_Tmp_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                $o_Tmp_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
                $o_Tmp_VTA_DocumentoDetalleBN->setCondicion( "1" );
                $o_Tmp_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                $o_Tmp_VTA_DocumentoDetalleBN->setTipoIGV( "1" );
                $o_Tmp_VTA_DocumentoDetalleBN->setPorcentajeImpuesto( 18 );
                $o_Tmp_VTA_DocumentoDetalleBN->setDescripcion( $o_MKT_PromocionCabBN->getDescripcionPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
                $o_Tmp_VTA_DocumentoDetalleBN->setItemCodigo( $o_MKT_PromocionCabBN->getCodigoPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE );
                $o_Tmp_VTA_DocumentoDetalleBN->setNumeroPromocion( $o_MKT_PromocionCabBN->getCodigoPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d" ) );
                $o_Tmp_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );

                $this->validarValoresxDefecto( $o_Tmp_VTA_DocumentoDetalleBN ); //asigna precio final con impuestos

                $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_Tmp_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $i_Id );

                $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_Tmp_VTA_DocumentoDetalleBN );
                $o_VTA_DocumentoDetalleDP->save();

                //ahora actualizamos los detalles de la promocion
                $o_MKT_ItemPromocionFN = new MKT_ItemPromocionFN();
                $o_MKT_ItemPromocionFN->setIdPromoCab( $o_VTA_DocumentoDetalleBN->getRefParent() );
                $a_MKT_ItemPromocion = $o_MKT_ItemPromocionFN->select();

                foreach ( $a_MKT_ItemPromocion as $o_MKT_ItemPromocionBN ) 
                {
                    $o_Tmp_VTA_DocumentoDetalleBN = clone $o_VTA_DocumentoDetalleBN;

                    $o_Tmp_VTA_DocumentoDetalleBN->setPrecioUnitario( 0 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( 0 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( 0 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( 0 );

                    $o_Tmp_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( 0 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( 0 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                    $o_Tmp_VTA_DocumentoDetalleBN->setTipoIGV( "10" );
                    $o_Tmp_VTA_DocumentoDetalleBN->setPorcentajeImpuesto( 0 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                    $o_Tmp_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
                    $o_Tmp_VTA_DocumentoDetalleBN->setCondicion( "1" );
                    $o_Tmp_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "S" );
                    $o_Tmp_VTA_DocumentoDetalleBN->setTipoDetalle( $o_MKT_ItemPromocionBN->getTipoDetalle() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setDescripcion( $o_MKT_ItemPromocionBN->getDescripcionItem() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setCantidadPedida( $o_MKT_ItemPromocionBN->getCantidad() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setItemCodigo( $o_MKT_ItemPromocionBN->getIdItem() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setNumeroPromocion( $o_MKT_PromocionCabBN->getCodigoPromo() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto
                    $o_Tmp_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d" ) );
                    $o_Tmp_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );

                    $this->validarValoresxDefecto( $o_Tmp_VTA_DocumentoDetalleBN ); //asigna precio final con impuestos

                    $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $i_Id );

                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_Tmp_VTA_DocumentoDetalleBN );
                    $o_VTA_DocumentoDetalleDP->save();

                    $this->iniciarReservaStockAlmacen( $o_Tmp_VTA_DocumentoDetalleBN, "I" );
                }
            }

            if( $o_VTA_DocumentoDetalleBN->getTipoProcPromo() == "DELETE" )
            {
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoDetalleBN->getSecuencia() );
                if( !$o_Tmp_VTA_DocumentoDetalleBN )
                {
                    throw new Exception( "No se encontro referencia de la linea." );
                }

                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setNumeroPromocion( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();

                foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN ) 
                {
                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                    $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                    $o_VTA_DocumentoDetalleDP->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                    $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                    $o_VTA_DocumentoDetalleDP->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                    $o_VTA_DocumentoDetalleDP->delete();
                    if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE )
                    {
                        if( $o_VTA_DocumentoDetalleBN->getObjectItem()->SiUsarReservableStock() )  
                        {
                            $this->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "D" );
                        }
                    }
                }
            }

            if( $o_VTA_DocumentoDetalleBN->getTipoProcPromo() == "UPDATE" )
            {
                GOTO_UPDATE:
                
                $i_CantidadPedida = $o_VTA_DocumentoDetalleBN->getCantidadPedida();

                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoDetalleBN->getSecuencia() );

                $o_MKT_ItemPromocionFN = new MKT_ItemPromocionFN();
                $o_MKT_ItemPromocionFN->setIdPromoCab( $o_Tmp_VTA_DocumentoDetalleBN->getRefParent() );
                $a_MKT_ItemPromocion = $o_MKT_ItemPromocionFN->select();

                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setNumeroPromocion( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN ) 
                {
                    $b_Control = false;
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //validacion para no exeder la cantidad de la promocion
                    if ( substr( $o_VTA_DocumentoDetalleBN->getItemCodigo(), 0, 1 ) == "#" || substr( $o_VTA_DocumentoDetalleBN->getItemCodigo(), 0, 2 ) == "PK" || substr( $o_VTA_DocumentoDetalleBN->getItemCodigo(), 0, 2 ) == "PR"  )  //promocion grupal
                    {
                        $f_StockDisponible = $o_VTA_DocumentoDetalleBN->getStockDisponiblePromocionGrupal();
                        if( $i_CantidadPedida > $f_StockDisponible )
                        {
                            throw new Exception( "La Promocion no tiene la cantidad sufiente." );
                        }
                        $b_Control = true;
                    }
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    if( $b_Control )
                    {
                        $o_VTA_DocumentoDetalleBN->setCantidadPedida( $i_CantidadPedida );
                    }
                    else
                    {
                        $o_MKT_ItemPromocionFN = new MKT_ItemPromocionFN();
                        //$o_MKT_ItemPromocionFN->setDebug( true );
                        $o_MKT_ItemPromocionFN->setIdPromoCab( $o_Tmp_VTA_DocumentoDetalleBN->getRefParent() );
                        $o_MKT_ItemPromocionFN->setIdItem( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
                        $a_MKT_ItemPromocion = $o_MKT_ItemPromocionFN->select();
                        if( $a_MKT_ItemPromocion )
                        {
                            $o_MKT_ItemPromocionBN = $a_MKT_ItemPromocion[0];
                            $o_VTA_DocumentoDetalleBN->setCantidadPedida( $i_CantidadPedida * $o_MKT_ItemPromocionBN->getCantidad() );
                        }
                    }

                    $this->validarValoresxDefecto( $o_VTA_DocumentoDetalleBN ); //asigna precio final con impuestos

                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                    $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleDP->update();

                    if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE )
                    {
                        if( $o_VTA_DocumentoDetalleBN->getObjectItem()->SiUsarReservableStock() )  
                        {
                            $this->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "U" );
                        }
                    }
                }
            }

            $this->actualizarMontosCabcecera( $o_Tmp_VTA_DocumentoDetalleBN );

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            throw new Exception( "O|V-IPPG: ".$o_Exception->getMessage() );
        }
        return true;
    }

    public function descontarStockPromociones( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        /*//validaciones por promociones 2019-12-13
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        //$o_VTA_DocumentoDetalleFN->setNumeroPromocion( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();

        if( $a_VTA_DocumentoDetalle )
        {
            foreach ( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN ) 
            {
                //aqui se puede evaluar el procedimientos a realizar por la condicion
                if ( substr( $o_VTA_DocumentoDetalleBN->getItemCodigo(), 0, 1 ) == "#" )  //promocion grupal
                {
                    $i_CantidadPedida = $o_VTA_DocumentoDetalleBN->getCantidadPedida();

                    $o_MKT_PromocionCabFN = new MKT_PromocionCabFN();
                    $o_MKT_PromocionCabBN = $o_MKT_PromocionCabFN->selectByPK( $o_VTA_DocumentoDetalleBN->getRefParent() );
                    if( $o_MKT_PromocionCabBN )
                    {
                        $i_CantidadFacturado    = $o_MKT_PromocionCabBN->getCantidadFacturado();
                        $i_NvoCantidadFacturado = $i_CantidadFacturado + $i_CantidadPedida;

                        $o_MKT_PromocionCabDP = new MKT_PromocionCabDP();
                        $o_MKT_PromocionCabDP->setIdPromoCab( $o_MKT_PromocionCabBN->getIdPromoCab() );
                        $o_MKT_PromocionCabDP->setCantidadFacturado( intval( $i_NvoCantidadFacturado ) );
                        $o_MKT_PromocionCabDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_MKT_PromocionCabDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_MKT_PromocionCabDP->update();
                        usleep( 500 );
                    }
                    else
                    {
                        throw new Exception( "La referencia hacia la promocion, no tiene relacion." );
                    }
                }
            }
        }*/
    }
    
    public function iniciarProcesoPromocion( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        $o_PR_ListaItemBN = new PR_ListaItemBN();
        $o_PR_ListaItemBN->setIdItem( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        $o_PR_ListaItemBN->setIdSucursal( $o_VTA_DocumentoDetalleBN->getIdSucursal() );
        $o_GrupoPromocionDetBL = new GrupoPromocionDetBL();
        $a_PR_ListaItem = $o_GrupoPromocionDetBL->buscarPromocionAsociada( $o_PR_ListaItemBN );
        if( $a_PR_ListaItem )
        {
            $o_Tmp_VTA_DocumentoDetalleBN = clone $o_VTA_DocumentoDetalleBN;
            foreach ( $a_PR_ListaItem as $i_key => $o_PR_ListaItemBN )
            {
                $f_BufferDscto = $o_PR_ListaItemBN->getBufferDscto() * -1;
                
                $o_Tmp_VTA_DocumentoDetalleBN->setPrecioUnitario( $f_BufferDscto );
                
                $this->validarValoresxDefecto( $o_Tmp_VTA_DocumentoDetalleBN ); //asigna precio final con impuestos
                
                $o_Tmp_VTA_DocumentoDetalleBN->setItemCodigo( VTA_DocumentoDetalleBN::ITEM_ZZDSCTO );
                $o_Tmp_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE_DESCUENTO );
                $o_Tmp_VTA_DocumentoDetalleBN->setNumeroPromocion( $o_PR_ListaItemBN->getIdPrGrupo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setRefParent( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                //$o_Tmp_VTA_DocumentoDetalleBN->setDescripcion( "#".$o_PR_ListaItemBN->getIdPrGrupo()." - ". $o_PR_ListaItemBN->getDescripcionPromo() );
                $o_Tmp_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_PR_ListaItemBN->getDescripcionPromo() ) );
                
                //AHORA BUSCAMOS LA PROMOCION PARA DECIDIR SI INSERTAMOS O ACTUALIZAMOS
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_Tmp_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_Tmp_VTA_DocumentoDetalleBN->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE_DESCUENTO );
                $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_Tmp_VTA_DocumentoDetalleBN->getItemCodigo() );
                $o_VTA_DocumentoDetalleFN->setLote( $o_Tmp_VTA_DocumentoDetalleBN->getLote() );
                $o_VTA_DocumentoDetalleFN->setNumeroPromocion( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() );
                $o_VTA_DocumentoDetalleFN->setRefParent( $o_Tmp_VTA_DocumentoDetalleBN->getRefParent() );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                if( $a_VTA_DocumentoDetalle )
                {
                    if( $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida() != $a_VTA_DocumentoDetalle[0]->getCantidadPedida() )
                    {
                        $o_Tmp_VTA_DocumentoDetalleBN->setSecuencia( $a_VTA_DocumentoDetalle[0]->getSecuencia() );
                        $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_Tmp_VTA_DocumentoDetalleBN );
                        $o_VTA_DocumentoDetalleDP->update();
                    }
                }
                else
                {
                    $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                    $o_Tmp_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $i_Id );
                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_Tmp_VTA_DocumentoDetalleBN );
                    $o_VTA_DocumentoDetalleDP->save();
                }
            }
        }
    }
    
    public function iniciarProcesoPromocionManual( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $s_Descripcion = $o_VTA_DocumentoDetalleBN->getDescripcion();
            $f_Valor       = $o_VTA_DocumentoDetalleBN->getValorEspecial();
            $f_PorDscto    = $f_Valor / 100;
            
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
            if( $o_VTA_DocumentoBN )
            {
                $f_MontoAfecto     = $o_VTA_DocumentoBN->getMontoAfecto();
                $f_MontoNoAfecto   = $o_VTA_DocumentoBN->getMontoNoAfecto();
                $f_MontoTotalaProm = $f_MontoAfecto + $f_MontoNoAfecto;
                
                $f_MontoDscto = utilMath::fnround( $f_MontoTotalaProm * $f_PorDscto, 2 );
                
                $f_BufferDscto = $f_MontoDscto * -1;
                
                $o_VTA_DocumentoDetalleBN->setPrecioUnitario( $f_BufferDscto );
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
                
                $o_VTA_DocumentoDetalleBN->setItemCodigo( VTA_DocumentoDetalleBN::ITEM_ZZDSCTO );
                $o_VTA_DocumentoDetalleBN->setNumeroPromocion( VTA_DocumentoDetalleBN::ITEM_ZZDSCTO );
                //$o_VTA_DocumentoDetalleBN->setRefParent( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                //$o_VTA_DocumentoDetalleBN->setDescripcion( "#".$o_PR_ListaItemBN->getIdPrGrupo()." - ". $o_PR_ListaItemBN->getDescripcionPromo() );
                
                $this->validarValoresxDefecto( $o_VTA_DocumentoDetalleBN );
                
                $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $s_Descripcion ) );
                $o_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE_DESCUENTO );
                
                //AHORA BUSCAMOS LA PROMOCION IGUAL PARA ELIMINARLO
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE_DESCUENTO );
                $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
                $o_VTA_DocumentoDetalleFN->setLote( $o_VTA_DocumentoDetalleBN->getLote() );
                $o_VTA_DocumentoDetalleFN->setNumeroPromocion( $o_VTA_DocumentoDetalleBN->getNumeroPromocion() );
                //$o_VTA_DocumentoDetalleFN->setRefParent( $o_VTA_DocumentoDetalleBN->getRefParent() );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                if( $a_VTA_DocumentoDetalle )
                {
                    //$o_Tmp_VTA_DocumentoDetalleBN->setSecuencia( $a_VTA_DocumentoDetalle[0]->getSecuencia() );
                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $a_VTA_DocumentoDetalle[0] );
                    $o_VTA_DocumentoDetalleDP->delete();
                }
                
                $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $i_Id );
                $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                $o_VTA_DocumentoDetalleDP->save();
                
                //VTA_DocumentoDP::actualizarCabaceraMontos( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoBN->getIdAlmacen() );
                $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_DocumentoBN->getIdAlmacen() );
                $this->actualizarMontosCabcecera( $o_VTA_DocumentoDetalleBN );
            }
            
            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( "O|V-IPRM: ".$o_Exception->getMessage() );
        }
        return true;
    }
    
    private function validarDetalleExisteItem( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        //POR POLITICA, SI SE ENCUENTRA ITEM SE SUMA
        if( $o_VTA_DocumentoDetalleBN->getSecuencia() )
        {
            //se agrego este procedimiento por el cambio de soporte para varios lotes
            /////////////////////////////////////////////////////////////
            $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
            $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoDetalleBN->getSecuencia() );
            if( $o_Tmp_VTA_DocumentoDetalleBN )
            {
                $this->setDocumentoDetalleHisBN( $o_Tmp_VTA_DocumentoDetalleBN );
                $o_VTA_DocumentoDetalleBN->setLote( $o_Tmp_VTA_DocumentoDetalleBN->getLote() );
                $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_Tmp_VTA_DocumentoDetalleBN->getAlmacenCodigo() );
            }
            /////////////////////////////////////////////////////////////
            return true;
        }
        
        //AHORA SE BUSCA EL ITEM EN EL DETALLE, SI SE ENCUENTRA SE SUMA MAS 1, ES COMO UNA VALIDACION DE QUE NO SE REPITA EL ITEM
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        $o_VTA_DocumentoDetalleFN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE );
        $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        $o_VTA_DocumentoDetalleFN->setLote( $o_VTA_DocumentoDetalleBN->getLote() );
        $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
        if( $a_VTA_DocumentoDetalle )
        {
            $o_Tmp_VTA_DocumentoDetalleBN = $a_VTA_DocumentoDetalle[0];

            //se agrega una validacion, que no este asociado a una promocion - 2020-03-24
            if( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() )
            {
                throw new Exception( "El Item ".$o_Tmp_VTA_DocumentoDetalleBN->getDescripcion()." ya se encuentra asociado a una promocion." );
            }
            
            $o_VTA_DocumentoDetalleBN->setSecuencia( $o_Tmp_VTA_DocumentoDetalleBN->getSecuencia() );
            $o_VTA_DocumentoDetalleBN->setLote( $o_Tmp_VTA_DocumentoDetalleBN->getLote() );
            $o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida() );
            $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_Tmp_VTA_DocumentoDetalleBN->getAlmacenCodigo() );
            
            if( $o_VTA_DocumentoDetalleBN->getCambioPrecioFlag() )
            {
                return true;
            }
            
            $i_Secuencia      = $o_Tmp_VTA_DocumentoDetalleBN->getSecuencia();
            $s_Lote           = $o_Tmp_VTA_DocumentoDetalleBN->getLote();
            $f_CantidadPedida = $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida();
            $f_CantidadPedida = $f_CantidadPedida + 1;
            $o_VTA_DocumentoDetalleBN->setSecuencia( $i_Secuencia );
            $o_VTA_DocumentoDetalleBN->setCantidadPedida( $f_CantidadPedida );
            $o_VTA_DocumentoDetalleBN->setLote( $s_Lote );
            return true;
        }
        /////////////////////////////////////////////////////////////////////
        return false;
    }
    
    public function validarIngresoPorCodigoBarras( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        //AQUI VALIDAMOS EL INGRESO DIRECTO SOLO POR EL ITEM, PERO TIENE QUE SER NUEVO
        if( !$o_VTA_DocumentoDetalleBN->getSecuencia() && $o_VTA_DocumentoDetalleBN->getLote() && $o_VTA_DocumentoDetalleBN->getItemCodigo() /*&& !$o_VTA_DocumentoDetalleBN->getCodigoBarrasIns()*/ )
        {
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_TMP_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_DocumentoDetalleBN->getItemCodigo() );

            if( $o_TMP_ALM_ItemMastBN )
            {
                if( !$o_TMP_ALM_ItemMastBN->getCodigoBarras() )
                {
                    //throw new Exception( "El Item {$o_TMP_ALM_ItemMastBN->getIdItem()} no tiene Codigo de Barras asignado." );
                }
                if( $o_TMP_ALM_ItemMastBN->getEstado() != "A" )
                {
                    throw new Exception( "El Item {$o_TMP_ALM_ItemMastBN->getIdItem()} no se encuentra Activo." );
                }
                $o_VTA_DocumentoDetalleBN->setCodigoBarrasIns( $o_TMP_ALM_ItemMastBN->getCodigoBarras() );
            }
        }

        /*if( !$o_VTA_DocumentoDetalleBN->getCodigoBarrasIns() )
        {
            return true;
        }*/

        if( $o_VTA_DocumentoDetalleBN->getSecuencia() )
        {
            return true;
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PROCEDIMIENTO ESPECIAL PARA AGREGAR COMENTARIO -> 2019-12-28
        if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
        {
            return true;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //$s_CodigoBarras = $o_VTA_DocumentoDetalleBN->getCodigoBarrasIns();
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        //$o_ALM_ItemMastFN->setCodigoBarras( $s_CodigoBarras );
        //$o_ALM_ItemMastFN->setIdItem( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        //$a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        //if( $a_ALM_ItemMast )
        if( $o_ALM_ItemMastBN )
        {
            //$o_ALM_ItemMastBN = $a_ALM_ItemMast[0];
        
            $IdItem         = $o_ALM_ItemMastBN->getIdItem();
            $NoAfecImpuesto = $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag();
            $o_VTA_DocumentoDetalleBN->setItemCodigo( $IdItem );
            $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( $NoAfecImpuesto );
            
            if( !$o_VTA_DocumentoDetalleBN->getCantidadPedida() )
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
            }
        
            //SE RECUPERA EL LOTE, Y SE PONE EL PRIMERO POR DEFECTO
            if( $o_ALM_ItemMastBN->SiManejaLote() )
            {
                if( !$o_VTA_DocumentoDetalleBN->getLote() )
                {
                    $a_ALM_ItemAlmacenStock = ALM_ItemAlmacenStockFN::recuperarLotes( $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getAlmacenCodigo(), $o_VTA_DocumentoDetalleBN->getItemCodigo() );
                    if( $a_ALM_ItemAlmacenStock )
                    {
                        $a_NoInLote       = array();
                        $b_ControlFndLote = true;
                        foreach ( $a_ALM_ItemAlmacenStock as $i_Key => $o_ALM_ItemAlmacenStockBN )
                        {

                            //$f_StockActual = $o_ALM_ItemAlmacenStockBN->getStockActual();
                            $f_StockDisponible = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
                            $IdLote            = $o_ALM_ItemAlmacenStockBN->getIdLote();
                            
                            $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                            $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                            $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                            $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                            $o_VTA_DocumentoDetalleFN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE );
                            $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
                            $o_VTA_DocumentoDetalleFN->setLote( $IdLote );
                            $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                            
                            if( $a_VTA_DocumentoDetalle )
                            {
                                $o_Tmp_VTA_DocumentoDetalleBN = $a_VTA_DocumentoDetalle[0];

                                //se agrega una validacion, que no este asociado a una promocion - 2020-03-24
                                if( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() )
                                {
                                    throw new Exception( "El Item ".$o_Tmp_VTA_DocumentoDetalleBN->getDescripcion()." ya se encuentra asociado a una promocion." );
                                }
                                
                                $f_CantidadPedida = $o_Tmp_VTA_DocumentoDetalleBN->getCantidadPedida();
                                $f_CantidadPedida = $f_CantidadPedida + 1;
                                
                                if( $f_CantidadPedida <= $f_StockDisponible )
                                {
                                    $o_VTA_DocumentoDetalleBN->setLote( $IdLote );
                                    $o_VTA_DocumentoDetalleBN->setLoteAlias( $IdLote );
                                    $b_ControlFndLote = false;
                                    break;
                                }
                                else 
                                {
                                    $a_NoInLote[] = $IdLote;
                                }
                            }
                        }
                        if( $b_ControlFndLote )
                        {
                            reset( $a_ALM_ItemAlmacenStock );
                            foreach ( $a_ALM_ItemAlmacenStock as $i_Key => $o_ALM_ItemAlmacenStockBN )
                            {
                                //$f_StockActual = $o_ALM_ItemAlmacenStockBN->getStockActual();
                                $f_StockDisponible = $o_ALM_ItemAlmacenStockBN->getStockDisponible();
                                $IdLote            = $o_ALM_ItemAlmacenStockBN->getIdLote();
                                
                                if( in_array( $IdLote, $a_NoInLote )  )
                                {
                                    continue;
                                }
                                
                                if( $f_StockDisponible > 0 )
                                {
                                    $o_VTA_DocumentoDetalleBN->setLote( $IdLote );
                                    $o_VTA_DocumentoDetalleBN->setLoteAlias( $IdLote );
                                    break;
                                }
                            }
                            if( !$o_VTA_DocumentoDetalleBN->getLote() )
                            {
                                $o_VTA_DocumentoDetalleBN->setLote( $IdLote );
                                $o_VTA_DocumentoDetalleBN->setLoteAlias( $IdLote );
                            }
                        }
                        if( count( $a_ALM_ItemAlmacenStock ) > 1 )
                        {
                            $o_VTA_DocumentoDetalleBN->setLoteVarios( true );
                        }
                    }
                }
            }
            else
            {
                $o_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
            }
            //$PrecioUnitario = 0.00;
        }
        else
        {
            throw new Exception( "No se encontro el codigode Barras." );
        }
    }
    
    public function validarValoresxDefecto( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PROCEDIMIENTO ESPECIAL PARA AGREGAR COMENTARIO -> 2019-12-28
        if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
        {
            return true;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //VALIDACIONES
        $f_CantidadPedida     = $o_VTA_DocumentoDetalleBN->getCantidadPedida();
        //////////////
        ///
        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        if( $o_ALM_ItemMastBN )
        {
            $DescripcionCompleta        = $o_ALM_ItemMastBN->getDescripcionCompleta();
            $NoAfectoImpuestoVentasFlag = $o_ALM_ItemMastBN->getNoAfectoImpuestoVentasFlag();
            //aqui se agrega un procedimiento - 2020-01-18
            //en el campo nuevo - tipo de item
            $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
        }
        
        if( $o_VTA_DocumentoDetalleBN->getDescripcion() )
        {
            $DescripcionCompleta = $o_VTA_DocumentoDetalleBN->getDescripcion();
        }
        
        $o_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE );
        $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $DescripcionCompleta ) );
        //$o_VTA_DocumentoDetalleBN->setMonto( 0.00 );
        if( !$o_VTA_DocumentoDetalleBN->getCondicion() )
        {
            $o_VTA_DocumentoDetalleBN->setCondicion( ALM_TransaccionDetalleBN::CONDICION_POR_DEFECTO );
        }
        if( !$o_VTA_DocumentoDetalleBN->getIGVExoneradoFlag() )
        {
            $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( $NoAfectoImpuestoVentasFlag );
        }
        else 
        {
            $NoAfectoImpuestoVentasFlag = $o_VTA_DocumentoDetalleBN->getIGVExoneradoFlag();
        }

        if( !$o_VTA_DocumentoDetalleBN->getEstado() )
        {
            $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto
        }
        
        $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $f_CantidadPedida * $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() );
        $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $f_CantidadPedida * $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidadMN() );
        $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( 0.00 );
        $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( 0.00 );
        $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $f_CantidadPedida * $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad() );
        $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $f_CantidadPedida * $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidadMN() );

        if( $NoAfectoImpuestoVentasFlag == "N" || $NoAfectoImpuestoVentasFlag == "0" )
        {
            //////////////////////////////////////////////////////////////////////////////////////////
            //SE RECUPERA VALOR DE IGV ACTUAL
            /*$o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
            $o_GSS_ParametroMastBN = $o_GSS_ParametroMastFN->selectByPK( -1, 'AL', 'IGV' );
            $f_ValorIGV = floatval( $o_GSS_ParametroMastBN->getNumero() );
            $f_ValorIGVMasUno = floatval( $o_GSS_ParametroMastBN->getNumero() ) + 1;*/
            $f_ValorIGV = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
            $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
            //////////////////////////////////////////////////////////////////////////////////////////
            
            $f_MontoIncImpuestoUnidad   = $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad();
            $f_MontoIncImpuestoUnidadMN = $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidadMN();

            $f_MontoTotalNeto   = $f_MontoIncImpuestoUnidad * $f_CantidadPedida;
            $f_MontoTotalNetoMN = $f_MontoIncImpuestoUnidadMN * $f_CantidadPedida;

            $f_MontoSubTotal   = round( $f_MontoTotalNeto / $f_ValorIGVMasUno, 2 );
            $f_MontoSubTotalMN = round( $f_MontoTotalNetoMN / $f_ValorIGVMasUno, 2 );

            $f_MontoSubTotalImpuesto   = round( $f_MontoTotalNeto - $f_MontoSubTotal, 2 );
            $f_MontoSubTotalImpuestoMN = round( $f_MontoTotalNetoMN - $f_MontoSubTotalMN, 2 );
            //$f_MontoSubTotalImpuesto   = round( $f_MontoSubTotalImpuesto, 2 );
            //$f_MontoSubTotalImpuestoMN = round( $f_MontoSubTotalImpuestoMN, 2 );

            //$f_MontoSubTotal   = round( $f_MontoSubTotal, 2 );
            //$f_MontoSubTotalMN = round( $f_MontoSubTotalMN, 2 );

            $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( $f_MontoTotalNeto );
            $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( $f_MontoTotalNetoMN );
            $o_VTA_DocumentoDetalleBN->setMontoSubTotal( $f_MontoSubTotal );
            $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( $f_MontoSubTotalMN );
            $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( $f_MontoSubTotalImpuesto );
            $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( $f_MontoSubTotalImpuestoMN );
        }
    }
    
    public function validacionesPorDetalles( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PROCEDIMIENTO ESPECIAL PARA AGREGAR COMENTARIO -> 2019-12-28
        if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
        {
            return true;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        //aqui pregunto si no esta la cantidad pedida y existe secuencia, utilizo la que esta seteado
        if( $o_VTA_DocumentoDetalleBN->getSecuencia() )        
        {
            $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
            $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
            $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
            $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
            $o_VTA_DocumentoDetalleFN->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );

            if( !$o_VTA_DocumentoDetalleBN->getCantidadPedida() )
            {
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_VTA_DocumentoDetalleFN->getCantidadPedidaAsignado() );
            }

            if( !$o_VTA_DocumentoDetalleBN->getLote() )
            {
                $o_VTA_DocumentoDetalleBN->setLote( $o_VTA_DocumentoDetalleFN->getIdLoteAsignado() );
            }

            if( !$o_VTA_DocumentoDetalleBN->getAlmacenCodigo() )
            {
                $IdAlmacen = VTA_DocumentoFN::getAlmacenAsignado( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $IdAlmacen );
            }

            $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
            $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento(), $o_VTA_DocumentoDetalleBN->getIdCompania(), $o_VTA_DocumentoDetalleBN->getNumeroDocumento(), $o_VTA_DocumentoDetalleBN->getSecuencia() );

            $this->setDocumentoDetalleHisBN( $o_Tmp_VTA_DocumentoDetalleBN );
        }

        //Parametros:
        $IdCompania      = $o_VTA_DocumentoDetalleBN->getIdCompania();
        $IdItem          = $o_VTA_DocumentoDetalleBN->getItemCodigo();
        $ItemDesc        = $o_VTA_DocumentoDetalleBN->getDescripcion();
        $IdAlmacen       = $o_VTA_DocumentoDetalleBN->getAlmacenCodigo();
        $IdCondicion     = ALM_ItemAlmacenStockBN::CONDICION_POR_DEFECTO;
        $IdLote          = is_null( $o_VTA_DocumentoDetalleBN->getLote() ) ? ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO : $o_VTA_DocumentoDetalleBN->getLote();
        $CantidadPedida  = $o_VTA_DocumentoDetalleBN->getCantidadPedida();
        $StockDisponible = $o_VTA_DocumentoDetalleBN->getAlmcenStockDisponible();
        $StockReservado  = 0;

        //validacion por unidad de medida
        if( !$o_VTA_DocumentoDetalleBN->getIdUnidad() )
        {
            throw new Exception( "El Item [ $IdItem ][ $ItemDesc ] no tiene una Unidad de Medida Seleccionada. " );
        }

        if( $o_VTA_DocumentoDetalleBN->getSecuencia() )
        {
            $o_ALM_ReservaItemStockBN = ALM_ReservaItemStockFN::getObjectReservaItemxDocDetalle( $o_VTA_DocumentoDetalleBN );
            if( $o_ALM_ReservaItemStockBN )
            {
                $StockReservado = $o_ALM_ReservaItemStockBN->getReservaCantidad();
            }
        }

        $StockDispoTotal = $StockDisponible + $StockReservado;
        //VALIDACIONES:

        //POR PRECIO
        if( $o_VTA_DocumentoDetalleBN->getPrecioUnitario() <= 0 )
        {
            $o_VTA_DocumentoBN = $o_VTA_DocumentoDetalleBN->getObjectDocumentoCab();
            $b_Control = true;
            if( $o_VTA_DocumentoBN->getTipoVenta() == VTA_DocumentoBN::TIPO_VENTA_TRANSFERENCIA )
            {
                $b_Control = false;
            }
            if( $b_Control )
            {
                if( !$o_VTA_DocumentoDetalleBN->getNumeroPromocion() )
                {
                    throw new Exception( "No se puede Facturar con un detalle sin precio." );
                }
            }
        }

        if( $o_VTA_DocumentoDetalleBN->getCantidadPedida() == 0 )
        {
            throw new Exception( "La Cantidad 0 no esta permitido Item [$IdItem]." );
        }

        //POR STOCK
        //SE PREGUNTAO, SI EL SISTEMA USA IMPRESION DE GUIA PARA REALIZAR LAS TRANSACCIONES DE VENTAS, DE LO CONTRARIO LAS SALIDAS SE HACE DESDE LA FACTURACION
        //if( !GSS_ParametroMastFN::getValorPorTipo( "VT", "GUIA_REM" ) )
        if( !myUser::getUser()->getObjectCompania()->getOpeDsctoStockEnGuiaR() )
        {
            /*if( Constantes::CONS_VTA_VALIDAR_STOCK )
            {
                if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE )
                {
                    if( $o_VTA_DocumentoDetalleBN->getObjectItem()->SiUsarDisponibleStock() )
                    {
                    /*
                    $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
                    $o_ALM_ItemAlmacenStockValBN = $o_ALM_ItemAlmacenStockFN->selectByPK( $IdCompania, $IdItem, $IdAlmacen, $IdCondicion, $IdLote );
                    if( !$o_ALM_ItemAlmacenStockValBN )
                    {
                        throw new Exception( "No se encontro Stock para Item." );
                    }
                    */
                    ////////////////
                    //se valida con el fisico, cuando no este activo la orden
                    //if( !GSS_ParametroMastFN::getValorPorTipo( "VT", "ORDEN_VENTA" ) )
                    //{
                        /*if( $CantidadPedida > $StockDispoTotal )
                        {
                            throw new Exception( "El Codigo [$IdItem] tiene una Cantidad mayor al Stock." );
                        }*/
                    //}
                    ///
                    /*}
                }
            }*/
        }

        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //ahora se agrega una validacion por promociones 2019-12-13
        //se especifico que para ver tipos de promociones se lo va setear a la condicion, en este ejemplo la condicion es 1, para otras promo seria condicion 2 o 3, se define mas adelante
        if ( substr( $o_VTA_DocumentoDetalleBN->getItemCodigo(), 0, 1 ) == "#" )  //promocion grupal
        {
            $f_StockDisponible = $o_VTA_DocumentoDetalleBN->getStockDisponiblePromocionGrupal();
            if( $CantidadPedida > $f_StockDisponible )
            {
                throw new Exception( "La Promocion no tiene la cantidad sufiente." );
            }
        }
        //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        return true;
    }
    
    private function validacionesExtrasPorCompania( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN )
    {
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        $i_NumRow = $o_VTA_DocumentoDetalleFN->selectNumRows();
        if ( $i_NumRow >= 11 )
        {
            //throw new Exception( "Solo se permite como maximo 11 lineas para el Documento." );
        }
    }

    public function iniciarReservaStockAlmacen( VTA_DocumentoDetalleBN $o_VTA_DocumentoDetalleBN, $TipoProc = null )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //PROCEDIMIENTO ESPECIAL PARA AGREGAR COMENTARIO -> 2019-12-28
        if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
        {
            return true;
        }
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        if( !$o_VTA_DocumentoDetalleBN->getObjectItem()->SiUsarReservableStock() )
        {
            return true;
        }
        
        //ahora que se agregao unidad de medida x caja [PUNO][JULIACA]
        //entonces se tiene que saber que la minima unidad de medida es UNIDAD
        //la reserva es por la minima unidad de medida, osea UNIDAD
        //si viene por caja se busca la conversion
        $f_CantidadPedida          = $o_VTA_DocumentoDetalleBN->getCantidadPedida();
        $i_IdUnidadMedidadMin      = 58; //se tiene que cambiar a dinamico
        $i_IdUnidadMedidaAsig      = $o_VTA_DocumentoDetalleBN->getIdUnidad(); //se tiene que cambiar a dinamico
        //$i_ItemUnidadVentaAsignada = $o_VTA_DocumentoDetalleBN->getItemUnidadVentaAsignada(); //la unidad de medida asignada en la ficha
        //$f_ItemCantidadMedida = $o_VTA_DocumentoDetalleBN->getItemCantidadMedidaAsignada();
        //$f_ItemCantidadMedida = 1;

        $o_MST_UnidadMastFN = new MST_UnidadMastFN();
        $o_MST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $i_IdUnidadMedidaAsig );
        if( !$o_MST_UnidadMastBN )
        {
            throw new Exception( "La Unidad de Medida no fue Seleccionada!, para el Item [".$o_VTA_DocumentoDetalleBN->getItemCodigo()."] " );
        }
        //se hace la conversion
        if( !$o_MST_UnidadMastBN->getEsUnidadMinimaFlag() )
        {
            if( !$o_MST_UnidadMastBN->getUnidadEquivalenteFlag() )
            {
                throw new Exception( "Se debe de revisar la Configuracion de la Unidad de Medida para [".$o_MST_UnidadMastBN->getDescripcionCorta()."] " );
            }

            //ahora se busca la unidad minima
            $o_UnidadMedidaBN  = null; //variable para la minima unidad de medida
            $i_CantEquivalente = null; //variable para cantidad para multiplicar

            $o_MST_UnidadConversionMastFN = new MST_UnidadConversionMastFN();
            $o_MST_UnidadConversionMastFN->setIdUnidad( $i_IdUnidadMedidaAsig );
            $a_MST_UnidadConversionMast = $o_MST_UnidadConversionMastFN->select();
            foreach ( $a_MST_UnidadConversionMast as $key => $o_MST_UnidadConversionMastBN ) 
            {
                $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                $o_TmpMST_UnidadMastBN = $o_MST_UnidadMastFN->selectByPK( $o_MST_UnidadConversionMastBN->getIdUnidadEquivalente() );
                if( $o_TmpMST_UnidadMastBN->getEsUnidadMinimaFlag() )
                {
                    $o_UnidadMedidaBN  = $o_TmpMST_UnidadMastBN;
                    if( $o_MST_UnidadConversionMastBN->getCantidadEquivalente() )
                    {
                        $i_CantEquivalente = $o_MST_UnidadConversionMastBN->getCantidadEquivalente();
                    }
                    break;
                }
            }
            if( !$o_UnidadMedidaBN )
            {
                throw new Exception( "Revisar la configuracion de la Unidad Medida [".$o_MST_UnidadMastBN->getDescripcionCorta()."]. No se encontro la Minima Conversion para la  Unidad de Medida." );                        
            }
            if( is_null( $i_CantEquivalente ) )
            {
                $o_ALM_ItemMastBN = ALM_ItemMastFN::getObjectItem( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
                if( $o_ALM_ItemMastBN->getCantidadUnidad() )
                {
                    $i_CantEquivalente = $o_ALM_ItemMastBN->getCantidadUnidad();
                }
                else
                {
                    $a_MST_UnidadConversionMast = MST_UnidadMastFN::find_uni_eq( $i_IdUnidadMedidaAsig );
                    $i_CantEquivalente = $a_MST_UnidadConversionMast[0]->getCantidadEquivalente();
                }
            }

            $f_CantidadPedida = $i_CantEquivalente * $f_CantidadPedida;

        }

        $IdLote = is_null( $o_VTA_DocumentoDetalleBN->getLote() ) ? ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO : $o_VTA_DocumentoDetalleBN->getLote();
        $o_ALM_ReservaItemStockBN = new ALM_ReservaItemStockBN();
        $o_ALM_ReservaItemStockBN->setTipoOperacion( $TipoProc );
        $o_ALM_ReservaItemStockBN->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
        $o_ALM_ReservaItemStockBN->setIdAlmacen( $o_VTA_DocumentoDetalleBN->getAlmacenCodigo() );
        $o_ALM_ReservaItemStockBN->setIdCondicion( "0" );
        $o_ALM_ReservaItemStockBN->setIdItem( $o_VTA_DocumentoDetalleBN->getItemCodigo() );
        $o_ALM_ReservaItemStockBN->setIdLote( $IdLote );
        $o_ALM_ReservaItemStockBN->setReservaDocTipo( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
        $o_ALM_ReservaItemStockBN->setReservaDocNumero( $o_VTA_DocumentoDetalleBN->getObjectDocumentoBN()->getDocumentoTipoSerieNumero() );
        $o_ALM_ReservaItemStockBN->setReservaRefNumero( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
        $o_ALM_ReservaItemStockBN->setReservaSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
        $o_ALM_ReservaItemStockBN->setReservaCantidad( $f_CantidadPedida );
        $o_ALM_ReservaItemStockBN->setIdUniadMedidaAsignada( $i_IdUnidadMedidaAsig );
        $o_ALM_ReservaItemStockBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
        $o_ALM_ReservaItemStockBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
        $o_ALM_ReservaItemStockBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
        $o_ALM_ReservaItemStockBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );

        $o_ReservaItemStockBL = new ReservaItemStockBL();
        $o_ReservaItemStockBL->inincarProcesoReservaItemStock( $o_ALM_ReservaItemStockBN );

        return true;
    }

    public function validacionPorfacturacion()
    {
        
    }
}