<?php
class InventarioBL
{
    public function importarProductosDesdeWS( $a_DataItem )
    {
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            foreach( $a_DataItem as $o_ALM_ItemMastBN )
            {
                //$o_ALM_ItemMastBN = new ALM_ItemMastBN();

                //////////////////////////////////////////////////////////////////////////////////////////
                //SE RECUPERA VALOR DE IGV ACTUAL
                $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
                $f_ValorIGVMasUno = $f_ValorIGV + 1;                                     //1.18

                $o_ALM_ItemMastBN->setPrecioCosto( round( $o_ALM_ItemMastBN->getPrecioCosto() * $f_ValorIGVMasUno, 2 ) );
                $o_ALM_ItemMastBN->setPrecioVenta1( round( $o_ALM_ItemMastBN->getPrecioVenta1() * $f_ValorIGVMasUno, 2 ) );
                //////////////////////////////////////////////////////////////////////////////////////////

                //BUSCAMOS LA UNIDAD DE MEDIDA
                $o_MST_UnidadMastFN = new MST_UnidadMastFN();
                $o_MST_UnidadMastFN->setDescripcionCorta( $o_ALM_ItemMastBN->getUnidadMedidaVentaDesc() );
                $a_MST_UnidadMast = $o_MST_UnidadMastFN->select();
                if( $a_MST_UnidadMast )
                {
                    //$s_UnidadMedidaVentaDesc = $a_MST_UnidadMast[0]->getDescripcionCorta();
                    $s_IdUnidad              = $a_MST_UnidadMast[0]->getIdUnidad();

                    $o_ALM_ItemMastBN->setUnidadVenta( $s_IdUnidad );
                    $o_ALM_ItemMastBN->setUnidadCompra( $s_IdUnidad ); //POR AHORA ES POR DEFECTO
                }
                else
                {
                    throw new Exception( "No se encontro coincidencia para unidad de medida de la venta." );
                }

                //VALIDACION POR LA MARCA
                $o_ALM_MarcaFN = new ALM_MarcaFN();
                $o_ALM_MarcaFN->setDescripcionLocal( $o_ALM_ItemMastBN->getMarcaDescripcion() );
                $a_ALM_Marca = $o_ALM_MarcaFN->select();
                if( !$a_ALM_Marca )
                {
                    $o_ALM_MarcaDP = new ALM_MarcaDP();
                    $o_ALM_MarcaDP->setDescripcionLocal( $o_ALM_ItemMastBN->getMarcaDescripcion() );
                    $o_ALM_MarcaDP->setDescripcionIngles( "" );
                    $o_ALM_MarcaDP->setEstado( "A" );
                    $o_ALM_MarcaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_MarcaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_MarcaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_MarcaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                    $i_IdMarca = ALM_MarcaDP::recuperarId();
                    $o_ALM_MarcaDP->setIdMarca( ( string ) $i_IdMarca );
                    $o_ALM_MarcaDP->save();

                    $o_ALM_ItemMastBN->setIdMarca( ( string ) $i_IdMarca );
                }
                else
                {
                    $o_ALM_ItemMastBN->setIdMarca( ( string ) $a_ALM_Marca[0]->getIdMarca() );
                }

                //VALIDACION DE LINEA
                $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
                $o_MST_ClaseLineaFN->setDescripcion( $o_ALM_ItemMastBN->getLineaDescripcion() );
                $a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
                if( $a_MST_ClaseLinea )
                {
                    $i_IdLinea = $a_MST_ClaseLinea[0]->getIdLinea();
                    $o_ALM_ItemMastBN->setIdLinea( $i_IdLinea );
                }
                else
                {
                    $o_MST_ClaseLineaDP = new MST_ClaseLineaDP();
                    $o_MST_ClaseLineaDP->setDescripcion( $o_ALM_ItemMastBN->getLineaDescripcion() );
                    $o_MST_ClaseLineaDP->setEstado( "A" );
                    $o_MST_ClaseLineaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_ClaseLineaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_MST_ClaseLineaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_ClaseLineaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                    $i_IdLinea = MST_ClaseLineaFN::recuperarId();
                    $Codigo    = substr( $o_ALM_ItemMastBN->getLineaDescripcion(), 0, 3 ).$i_IdLinea;
                    $o_MST_ClaseLineaDP->setCodigo( $Codigo );
                    $o_MST_ClaseLineaDP->setIdLinea( $i_IdLinea );
                    $o_MST_ClaseLineaDP->save();

                    $o_ALM_ItemMastBN->setIdLinea( $i_IdLinea );
                }

                //VALIDACION DE FAMILIA
                $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
                if( $i_IdLinea )
                {
                    $o_MST_ClaseFamiliaFN->setIdLinea( $i_IdLinea );
                }
                $o_MST_ClaseFamiliaFN->setDescripcion( $o_ALM_ItemMastBN->getFamiliaDescripcion() );
                $a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
                if( $a_MST_ClaseFamilia )
                {
                    $i_IdFamilia = $a_MST_ClaseFamilia[0]->getIdFamilia();
                    $o_ALM_ItemMastBN->setIdFamilia( $i_IdFamilia );
                }
                else
                {
                    $o_MST_ClaseFamiliaDP = new MST_ClaseFamiliaDP();
                    $o_MST_ClaseFamiliaDP->setIdLinea( $i_IdLinea );
                    $o_MST_ClaseFamiliaDP->setDescripcion( $o_ALM_ItemMastBN->getFamiliaDescripcion() );
                    $o_MST_ClaseFamiliaDP->setEstado( "A" );
                    $o_MST_ClaseFamiliaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_ClaseFamiliaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_MST_ClaseFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_MST_ClaseFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                    $i_IdFamilia = MST_ClaseFamiliaFN::recuperarIdFamilia( $i_IdLinea );
                    $Codigo      = substr( $o_ALM_ItemMastBN->getFamiliaDescripcion(), 0, 2 ).$i_IdFamilia;
                    $o_MST_ClaseFamiliaDP->setCodigo( $Codigo );
                    $o_MST_ClaseFamiliaDP->setIdFamilia( $i_IdFamilia );
                    $o_MST_ClaseFamiliaDP->save();

                    $o_ALM_ItemMastBN->setIdFamilia( $i_IdFamilia );
                }

                //AHORA SE BUSCA LA SUB-FAMILIA
                if( $o_ALM_ItemMastBN->getSubFamiliaDescripcion() )
                {
                    $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
                    if( $i_IdLinea )
                    {
                        $o_MST_ClaseSubFamiliaFN->setIdLinea( $i_IdLinea );
                    }
                    if( $i_IdFamilia )
                    {
                        $o_MST_ClaseSubFamiliaFN->setIdFamilia( $i_IdFamilia );
                    }
                    $o_MST_ClaseSubFamiliaFN->setDescripcion( $o_ALM_ItemMastBN->getSubFamiliaDescripcion() );
                    $a_MST_ClaseSubFamilia = $o_MST_ClaseSubFamiliaFN->select();
                    if( $a_MST_ClaseSubFamilia )
                    {
                        $i_IdSubFamilia = $a_MST_ClaseSubFamilia[0]->getIdSubFamilia();
                        $o_ALM_ItemMastBN->setIdSubFamilia( $i_IdSubFamilia );
                    }
                    else
                    {
                        $o_MST_ClaseSubFamiliaDP = new MST_ClaseSubFamiliaDP();
                        $o_MST_ClaseSubFamiliaDP->setIdLinea( $i_IdLinea );
                        $o_MST_ClaseSubFamiliaDP->setIdFamilia( $i_IdFamilia );
                        $o_MST_ClaseSubFamiliaDP->setDescripcion( $o_ALM_ItemMastBN->getSubFamiliaDescripcion() );
                        $o_MST_ClaseSubFamiliaDP->setEstado( "A" );
                        $o_MST_ClaseSubFamiliaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_MST_ClaseSubFamiliaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_MST_ClaseSubFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_MST_ClaseSubFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                        $i_IdSubFamilia = MST_ClaseSubFamiliaFN::recuperarIdSubFamilia( $i_IdLinea, $i_IdFamilia );
                        $Codigo         = substr( $o_ALM_ItemMastBN->getSubFamiliaDescripcion(), 0, 2 ).$i_IdSubFamilia;
                        $o_MST_ClaseSubFamiliaDP->setCodigo( $Codigo );
                        $o_MST_ClaseSubFamiliaDP->setIdSubfamilia( $i_IdSubFamilia );
                        $o_MST_ClaseSubFamiliaDP->save();

                        $o_ALM_ItemMastBN->setIdSubFamilia( $i_IdSubFamilia );
                    }
                }

                //SE BUSCA EL CODIGO DE SUNAT
                $o_MST_ItemFiscalFN = new MST_ItemFiscalFN();
                $o_MST_ItemFiscalFN->setCodigoFiscal( $o_ALM_ItemMastBN->getCodigoSunat() );
                $a_MST_ItemFiscal = $o_MST_ItemFiscalFN->select();
                if( $a_MST_ItemFiscal )
                {
                    $o_ALM_ItemMastBN->setIdItemFiscal( $a_MST_ItemFiscal[0]->getIdItemFiscal() );
                }

                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //RANGO PARA SOLO UN PRECIO
                $i_IdRangoSelect = $o_ALM_ItemMastBN->getIdRangoVenta();
                if( $o_ALM_ItemMastBN->getIdRangoVenta() == 1 )
                {

                    //CONFIGURACION PARA SOLO 1 PRECIO
                    $a_RangoDetalle = array( 1 => array( "MINIMO" => 0.1, "MAXIMO" => 999999 ) );
                }
                else
                {
                    //SE CONFIGURA PARA TRES PRECIOS
                    $a_RangoDetalle = array( 2 => array( "MINIMO" => 0.1, "MAXIMO" => 5 ), 3 => array( "MINIMO" => 6, "MAXIMO" => 10 ), 4 => array( "MINIMO" => 11, "MAXIMO" => 15 ) );
                }
                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                $o_ALM_ItemMastBN->setEsParaVenta( "SI" );
                $o_ALM_ItemMastBN->setIdRangoVenta( $i_IdRangoSelect );

                $o_ALM_ItemMastDP = new ALM_ItemMastDP( $o_ALM_ItemMastBN );
                if( !$o_ALM_ItemMastBN->getIdItem() )
                {
                    //nuevo item
                    //SE RECUPERA CORRELATIVO ITEM
                    $IdItem = ALM_ItemMastFN::recuperarId();
                    $o_ALM_ItemMastDP->setIdItem( $IdItem );
                    $o_ALM_ItemMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_ALM_ItemMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_ItemMastDP->save();

                    $o_ALM_ItemMastBN->setIdItem( $IdItem );
                    //pr( "es nuevo [$IdItem] [{$o_ALM_ItemMastBN->getCodigoInterno()}] " );
                }
                else
                {
                    //se actualiza
                    //pr( "ya existe [{$o_ALM_ItemMastBN->getIdItem()}] [{$o_ALM_ItemMastBN->getCodigoInterno()}]" );
                    $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ALM_ItemMastDP->update();
                }

                //AHORA SE ACTIVA LA UNIDAD DE MEDIDA SELECCIONADA
                $o_MST_UnidadMastDP = new MST_UnidadMastDP();
                $o_MST_UnidadMastDP->setIdUnidad( $o_ALM_ItemMastBN->getUnidadVenta() );
                $o_MST_UnidadMastDP->setEstado( "A" );
                $o_MST_UnidadMastDP->setFechaModificacion( date( "Y-m-d H:i.s" ) );
                $o_MST_UnidadMastDP->setUsuarioModificacion( "wtaype" );
                $o_MST_UnidadMastDP->update();

                //ENTONCES AHORA SE ASIGNA EL COSTO Y PRECIO
                if( $o_ALM_ItemMastBN->getControlPrecios() )
                {
                    //SE BUSCA LOS DETALLES
                    $i_Pr = 1;
                    foreach( $a_RangoDetalle as $i_IdRangoDetalle => $a_Data )
                    {
                        //SE ACTUALIZA EL RANGO
                        $o_MST_RangoDetalleDP = new MST_RangoDetalleDP();
                        $o_MST_RangoDetalleDP->setIdRangoDetalle( $i_IdRangoDetalle );
                        $o_MST_RangoDetalleDP->setMinimo( $a_Data['MINIMO'] );
                        $o_MST_RangoDetalleDP->setMaximo( $a_Data['MAXIMO'] );
                        $o_MST_RangoDetalleDP->setUsuarioModificacion( "wtaype" );
                        $o_MST_RangoDetalleDP->setFechaModificacion( date( "Y-m-d H:i.s" ) );
                        $o_MST_RangoDetalleDP->update();

                        //AHORA SE BUSCA EL RANGO CON LOS DATOS CORRECTOS
                        $o_MST_RangoDetalleFN = new MST_RangoDetalleFN();
                        $o_MST_RangoDetalleBN = $o_MST_RangoDetalleFN->selectByPK( $i_IdRangoDetalle );

                        $s_NombreMetodoPrecio = "getPrecioVenta".$i_Pr;

                        $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                        $o_MST_ListaPrecioDetalleFN->setIdCompania( 1 );
                        $o_MST_ListaPrecioDetalleFN->setIdSucursal( 1 );
                        $o_MST_ListaPrecioDetalleFN->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
                        $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 1 ); //POR DEFECTO
                        $o_MST_ListaPrecioDetalleFN->setIdRango( $i_IdRangoSelect );
                        $o_MST_ListaPrecioDetalleFN->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
                        $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();

                        $f_MontoCosto    = 0;
                        $f_MontoCostoIGV = 0;
                        if( $o_ALM_ItemMastBN->getPrecioCosto() > 0 )
                        {
                            $f_MontoCosto    = round( ( $o_ALM_ItemMastBN->getPrecioCosto() / $f_ValorIGVMasUno ), 2 );
                            $f_MontoCostoIGV = $o_ALM_ItemMastBN->getPrecioCosto();
                        }

                        $f_PrecioVentaIGV = $o_ALM_ItemMastBN->$s_NombreMetodoPrecio();
                        $f_PrecioVenta    = round( ( $f_PrecioVentaIGV / $f_ValorIGVMasUno ), 2 );
                        $f_TotalIGV       = round( $f_PrecioVentaIGV - $f_PrecioVenta, 2 );

                        $o_DefaultDP = new MST_ListaPrecioDetalleDP();
                        $o_DefaultDP->setIdCompania( 1 );
                        $o_DefaultDP->setIdSucursal( 1 );
                        $o_DefaultDP->setIdListaPreciCab( 1 );
                        $o_DefaultDP->setIdItem( $o_ALM_ItemMastBN->getIdItem() );
                        $o_DefaultDP->setIdTipoLista( 1 );
                        $o_DefaultDP->setIdRango( $i_IdRangoSelect );
                        $o_DefaultDP->setIdRangoDetalle( $o_MST_RangoDetalleBN->getIdRangoDetalle() );
                        $o_DefaultDP->setIdTipoPrecio( "1" );
                        if( $f_MontoCosto > 0 )
                        {
                            $o_DefaultDP->setPrecioCosto( $f_MontoCosto );
                            $o_DefaultDP->setPrecioCostoIGV( $f_MontoCostoIGV );
                        }
                        $o_DefaultDP->setPrecioVenta( $f_PrecioVenta );
                        $o_DefaultDP->setMontoIGV( $f_TotalIGV );
                        $o_DefaultDP->setPrecioVentaIGV( $f_PrecioVentaIGV );
                        $o_DefaultDP->setMontoDescuento( 0 );
                        $o_DefaultDP->setPorcentajeDescuento( 0 );
                        $o_DefaultDP->setDescuentoFlag( "N" );
                        $o_DefaultDP->setEstado( "A" );

                        if( $a_MST_ListaPrecioDetalle )
                        {
                            //update
                            $i_IdDet = $a_MST_ListaPrecioDetalle[0]->getIdListaPreciDet();
                            $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                            $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_DefaultDP->update();
                        }
                        else
                        {
                            //insert
                            $i_IdDet = MST_ListaPrecioDetalleDP::recuperarId();

                            $o_DefaultDP->setIdListaPreciDet( $i_IdDet );

                            $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            $o_DefaultDP->save();
                        }

                        $i_Pr++;
                    }
                }

                $o_ALM_ItemMastBN->setIdCompania( 1 ); //POR DEFECTO
                $o_ALM_ItemMastBN->setIdSucursal( 1 ); //POR DEFECTO
                $o_ALM_ItemMastBN->setIdAlmacen( "A1101" ); //POR DEFECTO
                $o_ALM_ItemMastBN->setIdLote( ALM_TransaccionDetalleBN::LOTE_POR_DEFECTO );
                $o_ValidacionxItemBL = new ValidacionxItemBL();
                $o_ValidacionxItemBL->iniciarValidacionAlmacenStock( $o_ALM_ItemMastBN ); //MEJOR SE PREGUNTA DESDE LA CREACION DEL ITEM

                //pr( $o_ALM_ItemMastBN );
            }

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            throw new Exception( $o_Exception->getMessage() );
        }
    }
}