<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_Vendedor.xml */
/* Generado: 2022-04-18 21:15:09 */

/* Busqueda de registros de la tabla VTA_Vendedor. */
abstract class BaseVTA_VendedorFN extends VTA_VendedorBN
{
    /* Declaracion de constantes */
    const IdPersona = "VTA_Vendedor.IdPersona";
    const PorcentajeDscto = "VTA_Vendedor.PorcentajeDscto";
    const IdUsuario = "VTA_Vendedor.IdUsuario";
    const Estado = "VTA_Vendedor.Estado";
    const FechaCreacion = "VTA_Vendedor.FechaCreacion";
    const UsuarioCreacion = "VTA_Vendedor.UsuarioCreacion";
    const FechaModificacion = "VTA_Vendedor.FechaModificacion";
    const UsuarioModificacion = "VTA_Vendedor.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_Vendedor.IdPersona AS IdPersona, ";
        $s_SQLQuery .= "VTA_Vendedor.PorcentajeDscto AS PorcentajeDscto, ";
        $s_SQLQuery .= "VTA_Vendedor.IdUsuario AS IdUsuario, ";
        $s_SQLQuery .= "VTA_Vendedor.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_Vendedor.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_Vendedor.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_Vendedor.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "VTA_Vendedor.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_VendedorBN */
    public function setByBN( VTA_VendedorBN $o_VTA_VendedorBN )
    {
        if ( !is_null( $o_VTA_VendedorBN->getIdPersona() ) )
        {
            $this->setIdPersona( $o_VTA_VendedorBN->getIdPersona() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getPorcentajeDscto() ) )
        {
            $this->setPorcentajeDscto( $o_VTA_VendedorBN->getPorcentajeDscto() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getIdUsuario() ) )
        {
            $this->setIdUsuario( $o_VTA_VendedorBN->getIdUsuario() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_VendedorBN->getEstado() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_VendedorBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_VendedorBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_VendedorBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_VendedorBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_VendedorBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return VTA_VendedorBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdPersona )
    {
        if( is_null( $i_IdPersona ) ){ $i_IdPersona = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_Vendedor ";
        $s_SQLQuery .= "WHERE IdPersona = ".$i_IdPersona." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_VendedorBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_VendedorBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_VendedorBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPersona() ) ) $s_SQLQuery .= "VTA_Vendedor.IdPersona = ".$this->getIdPersona()." AND ";
        if ( !is_null( $this->getPorcentajeDscto() ) ) $s_SQLQuery .= "VTA_Vendedor.PorcentajeDscto = ".$this->getPorcentajeDscto()." AND ";
        if ( !is_null( $this->getIdUsuario() ) ) $s_SQLQuery .= "VTA_Vendedor.IdUsuario = '".$this->getIdUsuario()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_Vendedor.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_Vendedor.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_Vendedor.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_Vendedor.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_Vendedor.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_Vendedor WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_VendedorBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_Vendedor WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_VendedorBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_VendedorBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_VendedorBN[] = $o_VTA_VendedorBN;
            }
        }
        return $a_VTA_VendedorBN;
    }

    /* Devuelve un objeto VTA_VendedorBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_Vendedor )
    {
        $o_VTA_VendedorBN = new VTA_VendedorBN();
        if ( !is_null( $a_VTA_Vendedor['IdPersona'] ) ) $o_VTA_VendedorBN->setIdPersona( ( integer ) $a_VTA_Vendedor['IdPersona'] );
        if ( !is_null( $a_VTA_Vendedor['PorcentajeDscto'] ) ) $o_VTA_VendedorBN->setPorcentajeDscto( ( float ) $a_VTA_Vendedor['PorcentajeDscto'] );
        if ( !is_null( $a_VTA_Vendedor['IdUsuario'] ) ) $o_VTA_VendedorBN->setIdUsuario( $a_VTA_Vendedor['IdUsuario'] );
        if ( !is_null( $a_VTA_Vendedor['Estado'] ) ) $o_VTA_VendedorBN->setEstado( $a_VTA_Vendedor['Estado'] );
        if ( !is_null( $a_VTA_Vendedor['FechaCreacion'] ) ) $o_VTA_VendedorBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_Vendedor['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Vendedor['UsuarioCreacion'] ) ) $o_VTA_VendedorBN->setUsuarioCreacion( $a_VTA_Vendedor['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_Vendedor['FechaModificacion'] ) ) $o_VTA_VendedorBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_Vendedor['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Vendedor['UsuarioModificacion'] ) ) $o_VTA_VendedorBN->setUsuarioModificacion( $a_VTA_Vendedor['UsuarioModificacion'] );
        return $o_VTA_VendedorBN;
    }
}
?>