<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_OrdenDetalle.xml */
/* Generado: 2022-11-25 23:55:08 */

/* Busqueda de registros de la tabla VTA_OrdenDetalle. */
abstract class BaseVTA_OrdenDetalleFN extends VTA_OrdenDetalleBN
{
    /* Declaracion de constantes */
    const OrdenId = "VTA_OrdenDetalle.OrdenId";
    const OrdenDetalleNum = "VTA_OrdenDetalle.OrdenDetalleNum";
    const ItemTipo = "VTA_OrdenDetalle.ItemTipo";
    const ItemCod = "VTA_OrdenDetalle.ItemCod";
    const AlmacenCod = "VTA_OrdenDetalle.AlmacenCod";
    const LoteNum = "VTA_OrdenDetalle.LoteNum";
    const FechaVencimiento = "VTA_OrdenDetalle.FechaVencimiento";
    const IdUnidad = "VTA_OrdenDetalle.IdUnidad";
    const IdItemTipo = "VTA_OrdenDetalle.IdItemTipo";
    const OrdenDetalleDescripcion = "VTA_OrdenDetalle.OrdenDetalleDescripcion";
    const OrdenDetallePrecioNivel = "VTA_OrdenDetalle.OrdenDetallePrecioNivel";
    const CostoUnidadIncImpuesto = "VTA_OrdenDetalle.CostoUnidadIncImpuesto";
    const CostoUnidadIncImpuestoMN = "VTA_OrdenDetalle.CostoUnidadIncImpuestoMN";
    const OrdenDetallePrecioUnidad = "VTA_OrdenDetalle.OrdenDetallePrecioUnidad";
    const OrdenDetallePrecioUnidadMN = "VTA_OrdenDetalle.OrdenDetallePrecioUnidadMN";
    const OrdenDetalleDsctoUnidad = "VTA_OrdenDetalle.OrdenDetalleDsctoUnidad";
    const OrdenDetalleDsctoUnidadMN = "VTA_OrdenDetalle.OrdenDetalleDsctoUnidadMN";
    const OrdenDetallePorcDscto = "VTA_OrdenDetalle.OrdenDetallePorcDscto";
    const OrdenDetalleAfectoImpuesto = "VTA_OrdenDetalle.OrdenDetalleAfectoImpuesto";
    const OrdenDetalleImpuestoUnidad = "VTA_OrdenDetalle.OrdenDetalleImpuestoUnidad";
    const OrdenDetalleImpuestoUnidadMN = "VTA_OrdenDetalle.OrdenDetalleImpuestoUnidadMN";
    const PrecioUnidadIncImpuesto = "VTA_OrdenDetalle.PrecioUnidadIncImpuesto";
    const PrecioUnidadIncImpuestoMN = "VTA_OrdenDetalle.PrecioUnidadIncImpuestoMN";
    const OrdenDetalleCantidad = "VTA_OrdenDetalle.OrdenDetalleCantidad";
    const OrdenDetalleSubTotalVenta = "VTA_OrdenDetalle.OrdenDetalleSubTotalVenta";
    const OrdenDetalleSubTotalVentaMN = "VTA_OrdenDetalle.OrdenDetalleSubTotalVentaMN";
    const OrdenDetalleSubTotalImpuesto = "VTA_OrdenDetalle.OrdenDetalleSubTotalImpuesto";
    const OrdenDetalleSubTotalImpuestoMN = "VTA_OrdenDetalle.OrdenDetalleSubTotalImpuestoMN";
    const OrdenDetalleSubTotalNeto = "VTA_OrdenDetalle.OrdenDetalleSubTotalNeto";
    const OrdenDetalleSubTotalNetoMN = "VTA_OrdenDetalle.OrdenDetalleSubTotalNetoMN";
    const SubtotalFinal = "VTA_OrdenDetalle.SubtotalFinal";
    const SubtotalFinalMN = "VTA_OrdenDetalle.SubtotalFinalMN";
    const SubtotalIGVFinal = "VTA_OrdenDetalle.SubtotalIGVFinal";
    const SubtotalIGVFinalMN = "VTA_OrdenDetalle.SubtotalIGVFinalMN";
    const TotalFinal = "VTA_OrdenDetalle.TotalFinal";
    const TotalFinalMN = "VTA_OrdenDetalle.TotalFinalMN";
    const DocRefTipoCod = "VTA_OrdenDetalle.DocRefTipoCod";
    const DocRefNum = "VTA_OrdenDetalle.DocRefNum";
    const DocRefId = "VTA_OrdenDetalle.DocRefId";
    const OrdenDetalleObs = "VTA_OrdenDetalle.OrdenDetalleObs";
    const OrdenDetalleEstado = "VTA_OrdenDetalle.OrdenDetalleEstado";
    const UsuarioCreacion = "VTA_OrdenDetalle.UsuarioCreacion";
    const FechaCreacion = "VTA_OrdenDetalle.FechaCreacion";
    const UsuarioModificacion = "VTA_OrdenDetalle.UsuarioModificacion";
    const FechaModificacion = "VTA_OrdenDetalle.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_OrdenDetalle.OrdenId AS OrdenId, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleNum AS OrdenDetalleNum, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.ItemTipo AS ItemTipo, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.ItemCod AS ItemCod, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.AlmacenCod AS AlmacenCod, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.LoteNum AS LoteNum, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.IdItemTipo AS IdItemTipo, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleDescripcion AS OrdenDetalleDescripcion, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePrecioNivel AS OrdenDetallePrecioNivel, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.CostoUnidadIncImpuesto AS CostoUnidadIncImpuesto, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.CostoUnidadIncImpuestoMN AS CostoUnidadIncImpuestoMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePrecioUnidad AS OrdenDetallePrecioUnidad, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePrecioUnidadMN AS OrdenDetallePrecioUnidadMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleDsctoUnidad AS OrdenDetalleDsctoUnidad, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleDsctoUnidadMN AS OrdenDetalleDsctoUnidadMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePorcDscto AS OrdenDetallePorcDscto, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleAfectoImpuesto AS OrdenDetalleAfectoImpuesto, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleImpuestoUnidad AS OrdenDetalleImpuestoUnidad, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleImpuestoUnidadMN AS OrdenDetalleImpuestoUnidadMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.PrecioUnidadIncImpuesto AS PrecioUnidadIncImpuesto, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.PrecioUnidadIncImpuestoMN AS PrecioUnidadIncImpuestoMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleCantidad AS OrdenDetalleCantidad, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalVenta AS OrdenDetalleSubTotalVenta, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalVentaMN AS OrdenDetalleSubTotalVentaMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalImpuesto AS OrdenDetalleSubTotalImpuesto, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalImpuestoMN AS OrdenDetalleSubTotalImpuestoMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalNeto AS OrdenDetalleSubTotalNeto, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalNetoMN AS OrdenDetalleSubTotalNetoMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalFinal AS SubtotalFinal, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalFinalMN AS SubtotalFinalMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalIGVFinal AS SubtotalIGVFinal, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalIGVFinalMN AS SubtotalIGVFinalMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.TotalFinal AS TotalFinal, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.TotalFinalMN AS TotalFinalMN, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.DocRefTipoCod AS DocRefTipoCod, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.DocRefNum AS DocRefNum, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.DocRefId AS DocRefId, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleObs AS OrdenDetalleObs, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleEstado AS OrdenDetalleEstado, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_OrdenDetalle.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_OrdenDetalleBN */
    public function setByBN( VTA_OrdenDetalleBN $o_VTA_OrdenDetalleBN )
    {
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenId() ) )
        {
            $this->setOrdenId( $o_VTA_OrdenDetalleBN->getOrdenId() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleNum() ) )
        {
            $this->setOrdenDetalleNum( $o_VTA_OrdenDetalleBN->getOrdenDetalleNum() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getItemTipo() ) )
        {
            $this->setItemTipo( $o_VTA_OrdenDetalleBN->getItemTipo() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getItemCod() ) )
        {
            $this->setItemCod( $o_VTA_OrdenDetalleBN->getItemCod() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getAlmacenCod() ) )
        {
            $this->setAlmacenCod( $o_VTA_OrdenDetalleBN->getAlmacenCod() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getLoteNum() ) )
        {
            $this->setLoteNum( $o_VTA_OrdenDetalleBN->getLoteNum() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_VTA_OrdenDetalleBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_VTA_OrdenDetalleBN->getIdUnidad() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getIdItemTipo() ) )
        {
            $this->setIdItemTipo( $o_VTA_OrdenDetalleBN->getIdItemTipo() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleDescripcion() ) )
        {
            $this->setOrdenDetalleDescripcion( $o_VTA_OrdenDetalleBN->getOrdenDetalleDescripcion() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioNivel() ) )
        {
            $this->setOrdenDetallePrecioNivel( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioNivel() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuesto() ) )
        {
            $this->setCostoUnidadIncImpuesto( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuesto() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuestoMN() ) )
        {
            $this->setCostoUnidadIncImpuestoMN( $o_VTA_OrdenDetalleBN->getCostoUnidadIncImpuestoMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad() ) )
        {
            $this->setOrdenDetallePrecioUnidad( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidad() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidadMN() ) )
        {
            $this->setOrdenDetallePrecioUnidadMN( $o_VTA_OrdenDetalleBN->getOrdenDetallePrecioUnidadMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleDsctoUnidad() ) )
        {
            $this->setOrdenDetalleDsctoUnidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleDsctoUnidad() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleDsctoUnidadMN() ) )
        {
            $this->setOrdenDetalleDsctoUnidadMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleDsctoUnidadMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetallePorcDscto() ) )
        {
            $this->setOrdenDetallePorcDscto( $o_VTA_OrdenDetalleBN->getOrdenDetallePorcDscto() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleAfectoImpuesto() ) )
        {
            $this->setOrdenDetalleAfectoImpuesto( $o_VTA_OrdenDetalleBN->getOrdenDetalleAfectoImpuesto() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad() ) )
        {
            $this->setOrdenDetalleImpuestoUnidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidad() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidadMN() ) )
        {
            $this->setOrdenDetalleImpuestoUnidadMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleImpuestoUnidadMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto() ) )
        {
            $this->setPrecioUnidadIncImpuesto( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuesto() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuestoMN() ) )
        {
            $this->setPrecioUnidadIncImpuestoMN( $o_VTA_OrdenDetalleBN->getPrecioUnidadIncImpuestoMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() ) )
        {
            $this->setOrdenDetalleCantidad( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVenta() ) )
        {
            $this->setOrdenDetalleSubTotalVenta( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVenta() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() ) )
        {
            $this->setOrdenDetalleSubTotalVentaMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalVentaMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalImpuesto() ) )
        {
            $this->setOrdenDetalleSubTotalImpuesto( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalImpuesto() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalImpuestoMN() ) )
        {
            $this->setOrdenDetalleSubTotalImpuestoMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalImpuestoMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalNeto() ) )
        {
            $this->setOrdenDetalleSubTotalNeto( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalNeto() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalNetoMN() ) )
        {
            $this->setOrdenDetalleSubTotalNetoMN( $o_VTA_OrdenDetalleBN->getOrdenDetalleSubTotalNetoMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getSubtotalFinal() ) )
        {
            $this->setSubtotalFinal( $o_VTA_OrdenDetalleBN->getSubtotalFinal() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getSubtotalFinalMN() ) )
        {
            $this->setSubtotalFinalMN( $o_VTA_OrdenDetalleBN->getSubtotalFinalMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinal() ) )
        {
            $this->setSubtotalIGVFinal( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinal() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinalMN() ) )
        {
            $this->setSubtotalIGVFinalMN( $o_VTA_OrdenDetalleBN->getSubtotalIGVFinalMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getTotalFinal() ) )
        {
            $this->setTotalFinal( $o_VTA_OrdenDetalleBN->getTotalFinal() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getTotalFinalMN() ) )
        {
            $this->setTotalFinalMN( $o_VTA_OrdenDetalleBN->getTotalFinalMN() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getDocRefTipoCod() ) )
        {
            $this->setDocRefTipoCod( $o_VTA_OrdenDetalleBN->getDocRefTipoCod() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getDocRefNum() ) )
        {
            $this->setDocRefNum( $o_VTA_OrdenDetalleBN->getDocRefNum() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getDocRefId() ) )
        {
            $this->setDocRefId( $o_VTA_OrdenDetalleBN->getDocRefId() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleObs() ) )
        {
            $this->setOrdenDetalleObs( $o_VTA_OrdenDetalleBN->getOrdenDetalleObs() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getOrdenDetalleEstado() ) )
        {
            $this->setOrdenDetalleEstado( $o_VTA_OrdenDetalleBN->getOrdenDetalleEstado() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_OrdenDetalleBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_OrdenDetalleBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_OrdenDetalleBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_OrdenDetalleBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_OrdenDetalleBN->getFechaModificacion() );
        }
    }

    /**
    * @return VTA_OrdenDetalleBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_OrdenId, $i_OrdenDetalleNum )
    {
        if( is_null( $i_OrdenId ) ){ $i_OrdenId = -1; } 
        if( is_null( $i_OrdenDetalleNum ) ){ $i_OrdenDetalleNum = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenDetalle ";
        $s_SQLQuery .= "WHERE OrdenId = ".$i_OrdenId." ";
        $s_SQLQuery .= "AND OrdenDetalleNum = ".$i_OrdenDetalleNum." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_OrdenDetalleBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_OrdenDetalleBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_OrdenDetalleBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getOrdenId() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenId = ".$this->getOrdenId()." AND ";
        if ( !is_null( $this->getOrdenDetalleNum() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleNum = ".$this->getOrdenDetalleNum()." AND ";
        if ( !is_null( $this->getItemTipo() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.ItemTipo = '".$this->getItemTipo()."' AND ";
        if ( !is_null( $this->getItemCod() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.ItemCod = '".$this->getItemCod()."' AND ";
        if ( !is_null( $this->getAlmacenCod() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.AlmacenCod = '".$this->getAlmacenCod()."' AND ";
        if ( !is_null( $this->getLoteNum() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.LoteNum = '".$this->getLoteNum()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.IdUnidad = ".$this->getIdUnidad()." AND ";
        if ( !is_null( $this->getIdItemTipo() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.IdItemTipo = '".$this->getIdItemTipo()."' AND ";
        if ( !is_null( $this->getOrdenDetalleDescripcion() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleDescripcion = '".$this->getOrdenDetalleDescripcion()."' AND ";
        if ( !is_null( $this->getOrdenDetallePrecioNivel() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePrecioNivel = '".$this->getOrdenDetallePrecioNivel()."' AND ";
        if ( !is_null( $this->getCostoUnidadIncImpuesto() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.CostoUnidadIncImpuesto = ".$this->getCostoUnidadIncImpuesto()." AND ";
        if ( !is_null( $this->getCostoUnidadIncImpuestoMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.CostoUnidadIncImpuestoMN = ".$this->getCostoUnidadIncImpuestoMN()." AND ";
        if ( !is_null( $this->getOrdenDetallePrecioUnidad() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePrecioUnidad = ".$this->getOrdenDetallePrecioUnidad()." AND ";
        if ( !is_null( $this->getOrdenDetallePrecioUnidadMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePrecioUnidadMN = ".$this->getOrdenDetallePrecioUnidadMN()." AND ";
        if ( !is_null( $this->getOrdenDetalleDsctoUnidad() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleDsctoUnidad = ".$this->getOrdenDetalleDsctoUnidad()." AND ";
        if ( !is_null( $this->getOrdenDetalleDsctoUnidadMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleDsctoUnidadMN = ".$this->getOrdenDetalleDsctoUnidadMN()." AND ";
        if ( !is_null( $this->getOrdenDetallePorcDscto() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetallePorcDscto = ".$this->getOrdenDetallePorcDscto()." AND ";
        if ( !is_null( $this->getOrdenDetalleAfectoImpuesto() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleAfectoImpuesto = '".$this->getOrdenDetalleAfectoImpuesto()."' AND ";
        if ( !is_null( $this->getOrdenDetalleImpuestoUnidad() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleImpuestoUnidad = ".$this->getOrdenDetalleImpuestoUnidad()." AND ";
        if ( !is_null( $this->getOrdenDetalleImpuestoUnidadMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleImpuestoUnidadMN = ".$this->getOrdenDetalleImpuestoUnidadMN()." AND ";
        if ( !is_null( $this->getPrecioUnidadIncImpuesto() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.PrecioUnidadIncImpuesto = ".$this->getPrecioUnidadIncImpuesto()." AND ";
        if ( !is_null( $this->getPrecioUnidadIncImpuestoMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.PrecioUnidadIncImpuestoMN = ".$this->getPrecioUnidadIncImpuestoMN()." AND ";
        if ( !is_null( $this->getOrdenDetalleCantidad() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleCantidad = ".$this->getOrdenDetalleCantidad()." AND ";
        if ( !is_null( $this->getOrdenDetalleSubTotalVenta() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalVenta = ".$this->getOrdenDetalleSubTotalVenta()." AND ";
        if ( !is_null( $this->getOrdenDetalleSubTotalVentaMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalVentaMN = ".$this->getOrdenDetalleSubTotalVentaMN()." AND ";
        if ( !is_null( $this->getOrdenDetalleSubTotalImpuesto() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalImpuesto = ".$this->getOrdenDetalleSubTotalImpuesto()." AND ";
        if ( !is_null( $this->getOrdenDetalleSubTotalImpuestoMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalImpuestoMN = ".$this->getOrdenDetalleSubTotalImpuestoMN()." AND ";
        if ( !is_null( $this->getOrdenDetalleSubTotalNeto() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalNeto = ".$this->getOrdenDetalleSubTotalNeto()." AND ";
        if ( !is_null( $this->getOrdenDetalleSubTotalNetoMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleSubTotalNetoMN = ".$this->getOrdenDetalleSubTotalNetoMN()." AND ";
        if ( !is_null( $this->getSubtotalFinal() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalFinal = ".$this->getSubtotalFinal()." AND ";
        if ( !is_null( $this->getSubtotalFinalMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalFinalMN = ".$this->getSubtotalFinalMN()." AND ";
        if ( !is_null( $this->getSubtotalIGVFinal() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalIGVFinal = ".$this->getSubtotalIGVFinal()." AND ";
        if ( !is_null( $this->getSubtotalIGVFinalMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.SubtotalIGVFinalMN = ".$this->getSubtotalIGVFinalMN()." AND ";
        if ( !is_null( $this->getTotalFinal() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.TotalFinal = ".$this->getTotalFinal()." AND ";
        if ( !is_null( $this->getTotalFinalMN() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.TotalFinalMN = ".$this->getTotalFinalMN()." AND ";
        if ( !is_null( $this->getDocRefTipoCod() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.DocRefTipoCod = '".$this->getDocRefTipoCod()."' AND ";
        if ( !is_null( $this->getDocRefNum() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.DocRefNum = '".$this->getDocRefNum()."' AND ";
        if ( !is_null( $this->getDocRefId() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.DocRefId = ".$this->getDocRefId()." AND ";
        if ( !is_null( $this->getOrdenDetalleObs() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleObs = '".$this->getOrdenDetalleObs()."' AND ";
        if ( !is_null( $this->getOrdenDetalleEstado() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.OrdenDetalleEstado = '".$this->getOrdenDetalleEstado()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_OrdenDetalle.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_OrdenDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_OrdenDetalleBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_OrdenDetalle WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_OrdenDetalleBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_OrdenDetalleBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_OrdenDetalleBN[] = $o_VTA_OrdenDetalleBN;
            }
        }
        return $a_VTA_OrdenDetalleBN;
    }

    /* Devuelve un objeto VTA_OrdenDetalleBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_OrdenDetalle )
    {
        $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenId'] ) ) $o_VTA_OrdenDetalleBN->setOrdenId( ( integer ) $a_VTA_OrdenDetalle['OrdenId'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleNum'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( ( integer ) $a_VTA_OrdenDetalle['OrdenDetalleNum'] );
        if ( !is_null( $a_VTA_OrdenDetalle['ItemTipo'] ) ) $o_VTA_OrdenDetalleBN->setItemTipo( $a_VTA_OrdenDetalle['ItemTipo'] );
        if ( !is_null( $a_VTA_OrdenDetalle['ItemCod'] ) ) $o_VTA_OrdenDetalleBN->setItemCod( $a_VTA_OrdenDetalle['ItemCod'] );
        if ( !is_null( $a_VTA_OrdenDetalle['AlmacenCod'] ) ) $o_VTA_OrdenDetalleBN->setAlmacenCod( $a_VTA_OrdenDetalle['AlmacenCod'] );
        if ( !is_null( $a_VTA_OrdenDetalle['LoteNum'] ) ) $o_VTA_OrdenDetalleBN->setLoteNum( $a_VTA_OrdenDetalle['LoteNum'] );
        if ( !is_null( $a_VTA_OrdenDetalle['FechaVencimiento'] ) ) $o_VTA_OrdenDetalleBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_VTA_OrdenDetalle['FechaVencimiento'], "Y-m-d" ) );
        if ( !is_null( $a_VTA_OrdenDetalle['IdUnidad'] ) ) $o_VTA_OrdenDetalleBN->setIdUnidad( ( integer ) $a_VTA_OrdenDetalle['IdUnidad'] );
        if ( !is_null( $a_VTA_OrdenDetalle['IdItemTipo'] ) ) $o_VTA_OrdenDetalleBN->setIdItemTipo( $a_VTA_OrdenDetalle['IdItemTipo'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleDescripcion'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleDescripcion( $a_VTA_OrdenDetalle['OrdenDetalleDescripcion'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetallePrecioNivel'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( $a_VTA_OrdenDetalle['OrdenDetallePrecioNivel'] );
        if ( !is_null( $a_VTA_OrdenDetalle['CostoUnidadIncImpuesto'] ) ) $o_VTA_OrdenDetalleBN->setCostoUnidadIncImpuesto( ( float ) $a_VTA_OrdenDetalle['CostoUnidadIncImpuesto'] );
        if ( !is_null( $a_VTA_OrdenDetalle['CostoUnidadIncImpuestoMN'] ) ) $o_VTA_OrdenDetalleBN->setCostoUnidadIncImpuestoMN( ( float ) $a_VTA_OrdenDetalle['CostoUnidadIncImpuestoMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetallePrecioUnidad'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidad( ( float ) $a_VTA_OrdenDetalle['OrdenDetallePrecioUnidad'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetallePrecioUnidadMN'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( ( float ) $a_VTA_OrdenDetalle['OrdenDetallePrecioUnidadMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleDsctoUnidad'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleDsctoUnidad( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleDsctoUnidad'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleDsctoUnidadMN'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleDsctoUnidadMN( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleDsctoUnidadMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetallePorcDscto'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetallePorcDscto( ( float ) $a_VTA_OrdenDetalle['OrdenDetallePorcDscto'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleAfectoImpuesto'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleAfectoImpuesto( $a_VTA_OrdenDetalle['OrdenDetalleAfectoImpuesto'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleImpuestoUnidad'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidad( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleImpuestoUnidad'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleImpuestoUnidadMN'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidadMN( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleImpuestoUnidadMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['PrecioUnidadIncImpuesto'] ) ) $o_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( ( float ) $a_VTA_OrdenDetalle['PrecioUnidadIncImpuesto'] );
        if ( !is_null( $a_VTA_OrdenDetalle['PrecioUnidadIncImpuestoMN'] ) ) $o_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuestoMN( ( float ) $a_VTA_OrdenDetalle['PrecioUnidadIncImpuestoMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleCantidad'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleCantidad'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleSubTotalVenta'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleSubTotalVenta( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleSubTotalVenta'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleSubTotalVentaMN'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleSubTotalVentaMN( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleSubTotalVentaMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleSubTotalImpuesto'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleSubTotalImpuesto( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleSubTotalImpuesto'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleSubTotalImpuestoMN'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleSubTotalImpuestoMN( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleSubTotalImpuestoMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleSubTotalNeto'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleSubTotalNeto( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleSubTotalNeto'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleSubTotalNetoMN'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleSubTotalNetoMN( ( float ) $a_VTA_OrdenDetalle['OrdenDetalleSubTotalNetoMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['SubtotalFinal'] ) ) $o_VTA_OrdenDetalleBN->setSubtotalFinal( ( float ) $a_VTA_OrdenDetalle['SubtotalFinal'] );
        if ( !is_null( $a_VTA_OrdenDetalle['SubtotalFinalMN'] ) ) $o_VTA_OrdenDetalleBN->setSubtotalFinalMN( ( float ) $a_VTA_OrdenDetalle['SubtotalFinalMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['SubtotalIGVFinal'] ) ) $o_VTA_OrdenDetalleBN->setSubtotalIGVFinal( ( float ) $a_VTA_OrdenDetalle['SubtotalIGVFinal'] );
        if ( !is_null( $a_VTA_OrdenDetalle['SubtotalIGVFinalMN'] ) ) $o_VTA_OrdenDetalleBN->setSubtotalIGVFinalMN( ( float ) $a_VTA_OrdenDetalle['SubtotalIGVFinalMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['TotalFinal'] ) ) $o_VTA_OrdenDetalleBN->setTotalFinal( ( float ) $a_VTA_OrdenDetalle['TotalFinal'] );
        if ( !is_null( $a_VTA_OrdenDetalle['TotalFinalMN'] ) ) $o_VTA_OrdenDetalleBN->setTotalFinalMN( ( float ) $a_VTA_OrdenDetalle['TotalFinalMN'] );
        if ( !is_null( $a_VTA_OrdenDetalle['DocRefTipoCod'] ) ) $o_VTA_OrdenDetalleBN->setDocRefTipoCod( $a_VTA_OrdenDetalle['DocRefTipoCod'] );
        if ( !is_null( $a_VTA_OrdenDetalle['DocRefNum'] ) ) $o_VTA_OrdenDetalleBN->setDocRefNum( $a_VTA_OrdenDetalle['DocRefNum'] );
        if ( !is_null( $a_VTA_OrdenDetalle['DocRefId'] ) ) $o_VTA_OrdenDetalleBN->setDocRefId( ( integer ) $a_VTA_OrdenDetalle['DocRefId'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleObs'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleObs( $a_VTA_OrdenDetalle['OrdenDetalleObs'] );
        if ( !is_null( $a_VTA_OrdenDetalle['OrdenDetalleEstado'] ) ) $o_VTA_OrdenDetalleBN->setOrdenDetalleEstado( $a_VTA_OrdenDetalle['OrdenDetalleEstado'] );
        if ( !is_null( $a_VTA_OrdenDetalle['UsuarioCreacion'] ) ) $o_VTA_OrdenDetalleBN->setUsuarioCreacion( $a_VTA_OrdenDetalle['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_OrdenDetalle['FechaCreacion'] ) ) $o_VTA_OrdenDetalleBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_OrdenDetalle['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_OrdenDetalle['UsuarioModificacion'] ) ) $o_VTA_OrdenDetalleBN->setUsuarioModificacion( $a_VTA_OrdenDetalle['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_OrdenDetalle['FechaModificacion'] ) ) $o_VTA_OrdenDetalleBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_OrdenDetalle['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_OrdenDetalleBN;
    }
}
?>