<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_FacturacionElectronica.xml */
/* Generado: 2024-08-24 23:31:56 */

/* Busqueda de registros de la tabla VTA_FacturacionElectronica. */
abstract class BaseVTA_FacturacionElectronicaFN extends VTA_FacturacionElectronicaBN
{
    /* Declaracion de constantes */
    const FactElecId = "VTA_FacturacionElectronica.FactElecId";
    const IdCompania = "VTA_FacturacionElectronica.IdCompania";
    const IdSucursal = "VTA_FacturacionElectronica.IdSucursal";
    const Tipo = "VTA_FacturacionElectronica.Tipo";
    const Serie = "VTA_FacturacionElectronica.Serie";
    const Numero = "VTA_FacturacionElectronica.Numero";
    const FechaEmision = "VTA_FacturacionElectronica.FechaEmision";
    const FechaVencimiento = "VTA_FacturacionElectronica.FechaVencimiento";
    const TipoComprobante = "VTA_FacturacionElectronica.TipoComprobante";
    const TipoComprobanteDesc = "VTA_FacturacionElectronica.TipoComprobanteDesc";
    const SerieNum = "VTA_FacturacionElectronica.SerieNum";
    const CodCliente = "VTA_FacturacionElectronica.CodCliente";
    const ClienteNom = "VTA_FacturacionElectronica.ClienteNom";
    const ClienteTipoDoc = "VTA_FacturacionElectronica.ClienteTipoDoc";
    const ClienteDocNum = "VTA_FacturacionElectronica.ClienteDocNum";
    const ClienteDireccion = "VTA_FacturacionElectronica.ClienteDireccion";
    const ClienteEmail = "VTA_FacturacionElectronica.ClienteEmail";
    const ClienteEmail1 = "VTA_FacturacionElectronica.ClienteEmail1";
    const ClienteEmail2 = "VTA_FacturacionElectronica.ClienteEmail2";
    const TipoMoneda = "VTA_FacturacionElectronica.TipoMoneda";
    const TipoCambio = "VTA_FacturacionElectronica.TipoCambio";
    const PorcentajeIGV = "VTA_FacturacionElectronica.PorcentajeIGV";
    const MontoDescuento = "VTA_FacturacionElectronica.MontoDescuento";
    const MontoDescuentoLinea = "VTA_FacturacionElectronica.MontoDescuentoLinea";
    const MontoAnticipo = "VTA_FacturacionElectronica.MontoAnticipo";
    const MontoExonerado = "VTA_FacturacionElectronica.MontoExonerado";
    const MontoAfecto = "VTA_FacturacionElectronica.MontoAfecto";
    const MontoInafecto = "VTA_FacturacionElectronica.MontoInafecto";
    const SubTotal = "VTA_FacturacionElectronica.SubTotal";
    const Impuesto = "VTA_FacturacionElectronica.Impuesto";
    const MontoTotal = "VTA_FacturacionElectronica.MontoTotal";
    const EstadoWeb = "VTA_FacturacionElectronica.EstadoWeb";
    const Estado = "VTA_FacturacionElectronica.Estado";
    const FechaAnulacion = "VTA_FacturacionElectronica.FechaAnulacion";
    const Enlace = "VTA_FacturacionElectronica.Enlace";
    const AceptadaxSunat = "VTA_FacturacionElectronica.AceptadaxSunat";
    const SunatDescripcion = "VTA_FacturacionElectronica.SunatDescripcion";
    const SunatNote = "VTA_FacturacionElectronica.SunatNote";
    const SunatResponseCode = "VTA_FacturacionElectronica.SunatResponseCode";
    const SunatSoapError = "VTA_FacturacionElectronica.SunatSoapError";
    const PDFResult = "VTA_FacturacionElectronica.PDFResult";
    const XMLResult = "VTA_FacturacionElectronica.XMLResult";
    const CDRResult = "VTA_FacturacionElectronica.CDRResult";
    const CodigoHashQR = "VTA_FacturacionElectronica.CodigoHashQR";
    const CodigoHash = "VTA_FacturacionElectronica.CodigoHash";
    const Errors = "VTA_FacturacionElectronica.Errors";
    const CodigoError = "VTA_FacturacionElectronica.CodigoError";
    const CodigoErrorDesc = "VTA_FacturacionElectronica.CodigoErrorDesc";
    const AnuNumero = "VTA_FacturacionElectronica.AnuNumero";
    const AnuEnlace = "VTA_FacturacionElectronica.AnuEnlace";
    const AnuSunatTicketNumero = "VTA_FacturacionElectronica.AnuSunatTicketNumero";
    const AnuMotivo = "VTA_FacturacionElectronica.AnuMotivo";
    const AnuAceptadaPorSunat = "VTA_FacturacionElectronica.AnuAceptadaPorSunat";
    const AnuSunatDescripcion = "VTA_FacturacionElectronica.AnuSunatDescripcion";
    const AnuSunatNote = "VTA_FacturacionElectronica.AnuSunatNote";
    const AnuSunatResponseCode = "VTA_FacturacionElectronica.AnuSunatResponseCode";
    const AnuSunatSoapError = "VTA_FacturacionElectronica.AnuSunatSoapError";
    const AnuPDFResult = "VTA_FacturacionElectronica.AnuPDFResult";
    const AnuXMLResult = "VTA_FacturacionElectronica.AnuXMLResult";
    const AnuCDRResult = "VTA_FacturacionElectronica.AnuCDRResult";
    const AnuKey = "VTA_FacturacionElectronica.AnuKey";
    const DataJson = "VTA_FacturacionElectronica.DataJson";
    const UsuarioCreacion = "VTA_FacturacionElectronica.UsuarioCreacion";
    const FechaCreacion = "VTA_FacturacionElectronica.FechaCreacion";
    const UsuarioModificacion = "VTA_FacturacionElectronica.UsuarioModificacion";
    const FechaModificacion = "VTA_FacturacionElectronica.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_FacturacionElectronica.FactElecId AS FactElecId, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Tipo AS Tipo, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Serie AS Serie, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Numero AS Numero, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.FechaEmision AS FechaEmision, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.TipoComprobante AS TipoComprobante, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.TipoComprobanteDesc AS TipoComprobanteDesc, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.SerieNum AS SerieNum, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.CodCliente AS CodCliente, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteNom AS ClienteNom, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteTipoDoc AS ClienteTipoDoc, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteDocNum AS ClienteDocNum, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteDireccion AS ClienteDireccion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteEmail AS ClienteEmail, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteEmail1 AS ClienteEmail1, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteEmail2 AS ClienteEmail2, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.TipoMoneda AS TipoMoneda, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.TipoCambio AS TipoCambio, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.PorcentajeIGV AS PorcentajeIGV, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoDescuento AS MontoDescuento, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoDescuentoLinea AS MontoDescuentoLinea, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoAnticipo AS MontoAnticipo, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoExonerado AS MontoExonerado, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoAfecto AS MontoAfecto, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoInafecto AS MontoInafecto, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.SubTotal AS SubTotal, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Impuesto AS Impuesto, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.EstadoWeb AS EstadoWeb, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.FechaAnulacion AS FechaAnulacion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Enlace AS Enlace, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AceptadaxSunat AS AceptadaxSunat, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.SunatDescripcion AS SunatDescripcion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.SunatNote AS SunatNote, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.SunatResponseCode AS SunatResponseCode, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.SunatSoapError AS SunatSoapError, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.PDFResult AS PDFResult, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.XMLResult AS XMLResult, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.CDRResult AS CDRResult, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoHashQR AS CodigoHashQR, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoHash AS CodigoHash, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.Errors AS Errors, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoError AS CodigoError, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoErrorDesc AS CodigoErrorDesc, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuNumero AS AnuNumero, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuEnlace AS AnuEnlace, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatTicketNumero AS AnuSunatTicketNumero, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuMotivo AS AnuMotivo, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuAceptadaPorSunat AS AnuAceptadaPorSunat, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatDescripcion AS AnuSunatDescripcion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatNote AS AnuSunatNote, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatResponseCode AS AnuSunatResponseCode, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatSoapError AS AnuSunatSoapError, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuPDFResult AS AnuPDFResult, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuXMLResult AS AnuXMLResult, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuCDRResult AS AnuCDRResult, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.AnuKey AS AnuKey, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.DataJson AS DataJson, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_FacturacionElectronica.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_FacturacionElectronicaBN */
    public function setByBN( VTA_FacturacionElectronicaBN $o_VTA_FacturacionElectronicaBN )
    {
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getFactElecId() ) )
        {
            $this->setFactElecId( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_VTA_FacturacionElectronicaBN->getIdCompania() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_VTA_FacturacionElectronicaBN->getIdSucursal() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getTipo() ) )
        {
            $this->setTipo( $o_VTA_FacturacionElectronicaBN->getTipo() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSerie() ) )
        {
            $this->setSerie( $o_VTA_FacturacionElectronicaBN->getSerie() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getNumero() ) )
        {
            $this->setNumero( $o_VTA_FacturacionElectronicaBN->getNumero() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getFechaEmision() ) )
        {
            $this->setFechaEmision( $o_VTA_FacturacionElectronicaBN->getFechaEmision() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getTipoComprobante() ) )
        {
            $this->setTipoComprobante( $o_VTA_FacturacionElectronicaBN->getTipoComprobante() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getTipoComprobanteDesc() ) )
        {
            $this->setTipoComprobanteDesc( $o_VTA_FacturacionElectronicaBN->getTipoComprobanteDesc() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSerieNum() ) )
        {
            $this->setSerieNum( $o_VTA_FacturacionElectronicaBN->getSerieNum() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getCodCliente() ) )
        {
            $this->setCodCliente( $o_VTA_FacturacionElectronicaBN->getCodCliente() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteNom() ) )
        {
            $this->setClienteNom( $o_VTA_FacturacionElectronicaBN->getClienteNom() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc() ) )
        {
            $this->setClienteTipoDoc( $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteDocNum() ) )
        {
            $this->setClienteDocNum( $o_VTA_FacturacionElectronicaBN->getClienteDocNum() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteDireccion() ) )
        {
            $this->setClienteDireccion( $o_VTA_FacturacionElectronicaBN->getClienteDireccion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteEmail() ) )
        {
            $this->setClienteEmail( $o_VTA_FacturacionElectronicaBN->getClienteEmail() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteEmail1() ) )
        {
            $this->setClienteEmail1( $o_VTA_FacturacionElectronicaBN->getClienteEmail1() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getClienteEmail2() ) )
        {
            $this->setClienteEmail2( $o_VTA_FacturacionElectronicaBN->getClienteEmail2() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getTipoMoneda() ) )
        {
            $this->setTipoMoneda( $o_VTA_FacturacionElectronicaBN->getTipoMoneda() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getTipoCambio() ) )
        {
            $this->setTipoCambio( $o_VTA_FacturacionElectronicaBN->getTipoCambio() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getPorcentajeIGV() ) )
        {
            $this->setPorcentajeIGV( $o_VTA_FacturacionElectronicaBN->getPorcentajeIGV() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoDescuento() ) )
        {
            $this->setMontoDescuento( $o_VTA_FacturacionElectronicaBN->getMontoDescuento() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoDescuentoLinea() ) )
        {
            $this->setMontoDescuentoLinea( $o_VTA_FacturacionElectronicaBN->getMontoDescuentoLinea() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoAnticipo() ) )
        {
            $this->setMontoAnticipo( $o_VTA_FacturacionElectronicaBN->getMontoAnticipo() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoExonerado() ) )
        {
            $this->setMontoExonerado( $o_VTA_FacturacionElectronicaBN->getMontoExonerado() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoAfecto() ) )
        {
            $this->setMontoAfecto( $o_VTA_FacturacionElectronicaBN->getMontoAfecto() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoInafecto() ) )
        {
            $this->setMontoInafecto( $o_VTA_FacturacionElectronicaBN->getMontoInafecto() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSubTotal() ) )
        {
            $this->setSubTotal( $o_VTA_FacturacionElectronicaBN->getSubTotal() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getImpuesto() ) )
        {
            $this->setImpuesto( $o_VTA_FacturacionElectronicaBN->getImpuesto() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_VTA_FacturacionElectronicaBN->getMontoTotal() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getEstadoWeb() ) )
        {
            $this->setEstadoWeb( $o_VTA_FacturacionElectronicaBN->getEstadoWeb() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_FacturacionElectronicaBN->getEstado() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getFechaAnulacion() ) )
        {
            $this->setFechaAnulacion( $o_VTA_FacturacionElectronicaBN->getFechaAnulacion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getEnlace() ) )
        {
            $this->setEnlace( $o_VTA_FacturacionElectronicaBN->getEnlace() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() ) )
        {
            $this->setAceptadaxSunat( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSunatDescripcion() ) )
        {
            $this->setSunatDescripcion( $o_VTA_FacturacionElectronicaBN->getSunatDescripcion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSunatNote() ) )
        {
            $this->setSunatNote( $o_VTA_FacturacionElectronicaBN->getSunatNote() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSunatResponseCode() ) )
        {
            $this->setSunatResponseCode( $o_VTA_FacturacionElectronicaBN->getSunatResponseCode() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getSunatSoapError() ) )
        {
            $this->setSunatSoapError( $o_VTA_FacturacionElectronicaBN->getSunatSoapError() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getPDFResult() ) )
        {
            $this->setPDFResult( $o_VTA_FacturacionElectronicaBN->getPDFResult() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getXMLResult() ) )
        {
            $this->setXMLResult( $o_VTA_FacturacionElectronicaBN->getXMLResult() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getCDRResult() ) )
        {
            $this->setCDRResult( $o_VTA_FacturacionElectronicaBN->getCDRResult() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getCodigoHashQR() ) )
        {
            $this->setCodigoHashQR( $o_VTA_FacturacionElectronicaBN->getCodigoHashQR() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getCodigoHash() ) )
        {
            $this->setCodigoHash( $o_VTA_FacturacionElectronicaBN->getCodigoHash() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getErrors() ) )
        {
            $this->setErrors( $o_VTA_FacturacionElectronicaBN->getErrors() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getCodigoError() ) )
        {
            $this->setCodigoError( $o_VTA_FacturacionElectronicaBN->getCodigoError() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getCodigoErrorDesc() ) )
        {
            $this->setCodigoErrorDesc( $o_VTA_FacturacionElectronicaBN->getCodigoErrorDesc() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuNumero() ) )
        {
            $this->setAnuNumero( $o_VTA_FacturacionElectronicaBN->getAnuNumero() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuEnlace() ) )
        {
            $this->setAnuEnlace( $o_VTA_FacturacionElectronicaBN->getAnuEnlace() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuSunatTicketNumero() ) )
        {
            $this->setAnuSunatTicketNumero( $o_VTA_FacturacionElectronicaBN->getAnuSunatTicketNumero() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuMotivo() ) )
        {
            $this->setAnuMotivo( $o_VTA_FacturacionElectronicaBN->getAnuMotivo() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuAceptadaPorSunat() ) )
        {
            $this->setAnuAceptadaPorSunat( $o_VTA_FacturacionElectronicaBN->getAnuAceptadaPorSunat() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuSunatDescripcion() ) )
        {
            $this->setAnuSunatDescripcion( $o_VTA_FacturacionElectronicaBN->getAnuSunatDescripcion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuSunatNote() ) )
        {
            $this->setAnuSunatNote( $o_VTA_FacturacionElectronicaBN->getAnuSunatNote() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuSunatResponseCode() ) )
        {
            $this->setAnuSunatResponseCode( $o_VTA_FacturacionElectronicaBN->getAnuSunatResponseCode() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuSunatSoapError() ) )
        {
            $this->setAnuSunatSoapError( $o_VTA_FacturacionElectronicaBN->getAnuSunatSoapError() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuPDFResult() ) )
        {
            $this->setAnuPDFResult( $o_VTA_FacturacionElectronicaBN->getAnuPDFResult() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuXMLResult() ) )
        {
            $this->setAnuXMLResult( $o_VTA_FacturacionElectronicaBN->getAnuXMLResult() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuCDRResult() ) )
        {
            $this->setAnuCDRResult( $o_VTA_FacturacionElectronicaBN->getAnuCDRResult() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getAnuKey() ) )
        {
            $this->setAnuKey( $o_VTA_FacturacionElectronicaBN->getAnuKey() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getDataJson() ) )
        {
            $this->setDataJson( $o_VTA_FacturacionElectronicaBN->getDataJson() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_FacturacionElectronicaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_FacturacionElectronicaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_FacturacionElectronicaBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_FacturacionElectronicaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_FacturacionElectronicaBN->getFechaModificacion() );
        }
    }

    /**
    * @return VTA_FacturacionElectronicaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_FactElecId )
    {
        if( is_null( $i_FactElecId ) ){ $i_FactElecId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_FacturacionElectronica ";
        $s_SQLQuery .= "WHERE FactElecId = ".$i_FactElecId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_FacturacionElectronicaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_FacturacionElectronicaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_FacturacionElectronicaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getFactElecId() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.FactElecId = ".$this->getFactElecId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getSerie() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Serie = '".$this->getSerie()."' AND ";
        if ( !is_null( $this->getNumero() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Numero = '".$this->getNumero()."' AND ";
        if ( !is_null( $this->getFechaEmision() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.FechaEmision = '".$this->getFechaEmision()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getTipoComprobante() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.TipoComprobante = '".$this->getTipoComprobante()."' AND ";
        if ( !is_null( $this->getTipoComprobanteDesc() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.TipoComprobanteDesc = '".$this->getTipoComprobanteDesc()."' AND ";
        if ( !is_null( $this->getSerieNum() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.SerieNum = '".$this->getSerieNum()."' AND ";
        if ( !is_null( $this->getCodCliente() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.CodCliente = '".$this->getCodCliente()."' AND ";
        if ( !is_null( $this->getClienteNom() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteNom = '".$this->getClienteNom()."' AND ";
        if ( !is_null( $this->getClienteTipoDoc() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteTipoDoc = '".$this->getClienteTipoDoc()."' AND ";
        if ( !is_null( $this->getClienteDocNum() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteDocNum = '".$this->getClienteDocNum()."' AND ";
        if ( !is_null( $this->getClienteDireccion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteDireccion = '".$this->getClienteDireccion()."' AND ";
        if ( !is_null( $this->getClienteEmail() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteEmail = '".$this->getClienteEmail()."' AND ";
        if ( !is_null( $this->getClienteEmail1() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteEmail1 = '".$this->getClienteEmail1()."' AND ";
        if ( !is_null( $this->getClienteEmail2() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.ClienteEmail2 = '".$this->getClienteEmail2()."' AND ";
        if ( !is_null( $this->getTipoMoneda() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.TipoMoneda = '".$this->getTipoMoneda()."' AND ";
        if ( !is_null( $this->getTipoCambio() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.TipoCambio = ".$this->getTipoCambio()." AND ";
        if ( !is_null( $this->getPorcentajeIGV() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.PorcentajeIGV = ".$this->getPorcentajeIGV()." AND ";
        if ( !is_null( $this->getMontoDescuento() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoDescuento = ".$this->getMontoDescuento()." AND ";
        if ( !is_null( $this->getMontoDescuentoLinea() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoDescuentoLinea = ".$this->getMontoDescuentoLinea()." AND ";
        if ( !is_null( $this->getMontoAnticipo() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoAnticipo = ".$this->getMontoAnticipo()." AND ";
        if ( !is_null( $this->getMontoExonerado() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoExonerado = ".$this->getMontoExonerado()." AND ";
        if ( !is_null( $this->getMontoAfecto() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoAfecto = ".$this->getMontoAfecto()." AND ";
        if ( !is_null( $this->getMontoInafecto() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoInafecto = ".$this->getMontoInafecto()." AND ";
        if ( !is_null( $this->getSubTotal() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.SubTotal = ".$this->getSubTotal()." AND ";
        if ( !is_null( $this->getImpuesto() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Impuesto = ".$this->getImpuesto()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getEstadoWeb() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.EstadoWeb = '".$this->getEstadoWeb()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaAnulacion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.FechaAnulacion = '".$this->getFechaAnulacion()."' AND ";
        if ( !is_null( $this->getEnlace() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Enlace = '".$this->getEnlace()."' AND ";
        if ( !is_null( $this->getAceptadaxSunat() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AceptadaxSunat = '".$this->getAceptadaxSunat()."' AND ";
        if ( !is_null( $this->getSunatDescripcion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.SunatDescripcion = '".$this->getSunatDescripcion()."' AND ";
        if ( !is_null( $this->getSunatNote() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.SunatNote = '".$this->getSunatNote()."' AND ";
        if ( !is_null( $this->getSunatResponseCode() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.SunatResponseCode = '".$this->getSunatResponseCode()."' AND ";
        if ( !is_null( $this->getSunatSoapError() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.SunatSoapError = '".$this->getSunatSoapError()."' AND ";
        if ( !is_null( $this->getPDFResult() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.PDFResult = '".$this->getPDFResult()."' AND ";
        if ( !is_null( $this->getXMLResult() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.XMLResult = '".$this->getXMLResult()."' AND ";
        if ( !is_null( $this->getCDRResult() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.CDRResult = '".$this->getCDRResult()."' AND ";
        if ( !is_null( $this->getCodigoHashQR() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoHashQR = '".$this->getCodigoHashQR()."' AND ";
        if ( !is_null( $this->getCodigoHash() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoHash = '".$this->getCodigoHash()."' AND ";
        if ( !is_null( $this->getErrors() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.Errors = '".$this->getErrors()."' AND ";
        if ( !is_null( $this->getCodigoError() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoError = '".$this->getCodigoError()."' AND ";
        if ( !is_null( $this->getCodigoErrorDesc() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.CodigoErrorDesc = '".$this->getCodigoErrorDesc()."' AND ";
        if ( !is_null( $this->getAnuNumero() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuNumero = ".$this->getAnuNumero()." AND ";
        if ( !is_null( $this->getAnuEnlace() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuEnlace = '".$this->getAnuEnlace()."' AND ";
        if ( !is_null( $this->getAnuSunatTicketNumero() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatTicketNumero = '".$this->getAnuSunatTicketNumero()."' AND ";
        if ( !is_null( $this->getAnuMotivo() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuMotivo = '".$this->getAnuMotivo()."' AND ";
        if ( !is_null( $this->getAnuAceptadaPorSunat() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuAceptadaPorSunat = '".$this->getAnuAceptadaPorSunat()."' AND ";
        if ( !is_null( $this->getAnuSunatDescripcion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatDescripcion = '".$this->getAnuSunatDescripcion()."' AND ";
        if ( !is_null( $this->getAnuSunatNote() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatNote = '".$this->getAnuSunatNote()."' AND ";
        if ( !is_null( $this->getAnuSunatResponseCode() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatResponseCode = '".$this->getAnuSunatResponseCode()."' AND ";
        if ( !is_null( $this->getAnuSunatSoapError() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuSunatSoapError = '".$this->getAnuSunatSoapError()."' AND ";
        if ( !is_null( $this->getAnuPDFResult() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuPDFResult = '".$this->getAnuPDFResult()."' AND ";
        if ( !is_null( $this->getAnuXMLResult() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuXMLResult = '".$this->getAnuXMLResult()."' AND ";
        if ( !is_null( $this->getAnuCDRResult() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuCDRResult = '".$this->getAnuCDRResult()."' AND ";
        if ( !is_null( $this->getAnuKey() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.AnuKey = '".$this->getAnuKey()."' AND ";
        if ( !is_null( $this->getDataJson() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.DataJson = '".$this->getDataJson()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_FacturacionElectronica.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_FacturacionElectronica WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_FacturacionElectronicaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_FacturacionElectronica WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_FacturacionElectronicaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_FacturacionElectronicaBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_FacturacionElectronicaBN[] = $o_VTA_FacturacionElectronicaBN;
            }
        }
        return $a_VTA_FacturacionElectronicaBN;
    }

    /* Devuelve un objeto VTA_FacturacionElectronicaBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_FacturacionElectronica )
    {
        $o_VTA_FacturacionElectronicaBN = new VTA_FacturacionElectronicaBN();
        if ( !is_null( $a_VTA_FacturacionElectronica['FactElecId'] ) ) $o_VTA_FacturacionElectronicaBN->setFactElecId( ( integer ) $a_VTA_FacturacionElectronica['FactElecId'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['IdCompania'] ) ) $o_VTA_FacturacionElectronicaBN->setIdCompania( ( integer ) $a_VTA_FacturacionElectronica['IdCompania'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['IdSucursal'] ) ) $o_VTA_FacturacionElectronicaBN->setIdSucursal( ( integer ) $a_VTA_FacturacionElectronica['IdSucursal'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['Tipo'] ) ) $o_VTA_FacturacionElectronicaBN->setTipo( $a_VTA_FacturacionElectronica['Tipo'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['Serie'] ) ) $o_VTA_FacturacionElectronicaBN->setSerie( $a_VTA_FacturacionElectronica['Serie'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['Numero'] ) ) $o_VTA_FacturacionElectronicaBN->setNumero( $a_VTA_FacturacionElectronica['Numero'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['FechaEmision'] ) ) $o_VTA_FacturacionElectronicaBN->setFechaEmision( utilTimestamp::getTimestamp( $a_VTA_FacturacionElectronica['FechaEmision'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_FacturacionElectronica['FechaVencimiento'] ) ) $o_VTA_FacturacionElectronicaBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_VTA_FacturacionElectronica['FechaVencimiento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_FacturacionElectronica['TipoComprobante'] ) ) $o_VTA_FacturacionElectronicaBN->setTipoComprobante( $a_VTA_FacturacionElectronica['TipoComprobante'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['TipoComprobanteDesc'] ) ) $o_VTA_FacturacionElectronicaBN->setTipoComprobanteDesc( $a_VTA_FacturacionElectronica['TipoComprobanteDesc'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['SerieNum'] ) ) $o_VTA_FacturacionElectronicaBN->setSerieNum( $a_VTA_FacturacionElectronica['SerieNum'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['CodCliente'] ) ) $o_VTA_FacturacionElectronicaBN->setCodCliente( $a_VTA_FacturacionElectronica['CodCliente'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteNom'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteNom( $a_VTA_FacturacionElectronica['ClienteNom'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteTipoDoc'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteTipoDoc( $a_VTA_FacturacionElectronica['ClienteTipoDoc'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteDocNum'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteDocNum( $a_VTA_FacturacionElectronica['ClienteDocNum'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteDireccion'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteDireccion( $a_VTA_FacturacionElectronica['ClienteDireccion'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteEmail'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteEmail( $a_VTA_FacturacionElectronica['ClienteEmail'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteEmail1'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteEmail1( $a_VTA_FacturacionElectronica['ClienteEmail1'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['ClienteEmail2'] ) ) $o_VTA_FacturacionElectronicaBN->setClienteEmail2( $a_VTA_FacturacionElectronica['ClienteEmail2'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['TipoMoneda'] ) ) $o_VTA_FacturacionElectronicaBN->setTipoMoneda( $a_VTA_FacturacionElectronica['TipoMoneda'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['TipoCambio'] ) ) $o_VTA_FacturacionElectronicaBN->setTipoCambio( ( float ) $a_VTA_FacturacionElectronica['TipoCambio'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['PorcentajeIGV'] ) ) $o_VTA_FacturacionElectronicaBN->setPorcentajeIGV( ( float ) $a_VTA_FacturacionElectronica['PorcentajeIGV'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoDescuento'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoDescuento( ( float ) $a_VTA_FacturacionElectronica['MontoDescuento'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoDescuentoLinea'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoDescuentoLinea( ( float ) $a_VTA_FacturacionElectronica['MontoDescuentoLinea'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoAnticipo'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoAnticipo( ( float ) $a_VTA_FacturacionElectronica['MontoAnticipo'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoExonerado'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoExonerado( ( float ) $a_VTA_FacturacionElectronica['MontoExonerado'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoAfecto'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoAfecto( ( float ) $a_VTA_FacturacionElectronica['MontoAfecto'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoInafecto'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoInafecto( ( float ) $a_VTA_FacturacionElectronica['MontoInafecto'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['SubTotal'] ) ) $o_VTA_FacturacionElectronicaBN->setSubTotal( ( float ) $a_VTA_FacturacionElectronica['SubTotal'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['Impuesto'] ) ) $o_VTA_FacturacionElectronicaBN->setImpuesto( ( float ) $a_VTA_FacturacionElectronica['Impuesto'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['MontoTotal'] ) ) $o_VTA_FacturacionElectronicaBN->setMontoTotal( ( float ) $a_VTA_FacturacionElectronica['MontoTotal'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['EstadoWeb'] ) ) $o_VTA_FacturacionElectronicaBN->setEstadoWeb( $a_VTA_FacturacionElectronica['EstadoWeb'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['Estado'] ) ) $o_VTA_FacturacionElectronicaBN->setEstado( $a_VTA_FacturacionElectronica['Estado'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['FechaAnulacion'] ) ) $o_VTA_FacturacionElectronicaBN->setFechaAnulacion( utilTimestamp::getTimestamp( $a_VTA_FacturacionElectronica['FechaAnulacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_FacturacionElectronica['Enlace'] ) ) $o_VTA_FacturacionElectronicaBN->setEnlace( $a_VTA_FacturacionElectronica['Enlace'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AceptadaxSunat'] ) ) $o_VTA_FacturacionElectronicaBN->setAceptadaxSunat( $a_VTA_FacturacionElectronica['AceptadaxSunat'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['SunatDescripcion'] ) ) $o_VTA_FacturacionElectronicaBN->setSunatDescripcion( $a_VTA_FacturacionElectronica['SunatDescripcion'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['SunatNote'] ) ) $o_VTA_FacturacionElectronicaBN->setSunatNote( $a_VTA_FacturacionElectronica['SunatNote'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['SunatResponseCode'] ) ) $o_VTA_FacturacionElectronicaBN->setSunatResponseCode( $a_VTA_FacturacionElectronica['SunatResponseCode'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['SunatSoapError'] ) ) $o_VTA_FacturacionElectronicaBN->setSunatSoapError( $a_VTA_FacturacionElectronica['SunatSoapError'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['PDFResult'] ) ) $o_VTA_FacturacionElectronicaBN->setPDFResult( $a_VTA_FacturacionElectronica['PDFResult'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['XMLResult'] ) ) $o_VTA_FacturacionElectronicaBN->setXMLResult( $a_VTA_FacturacionElectronica['XMLResult'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['CDRResult'] ) ) $o_VTA_FacturacionElectronicaBN->setCDRResult( $a_VTA_FacturacionElectronica['CDRResult'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['CodigoHashQR'] ) ) $o_VTA_FacturacionElectronicaBN->setCodigoHashQR( $a_VTA_FacturacionElectronica['CodigoHashQR'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['CodigoHash'] ) ) $o_VTA_FacturacionElectronicaBN->setCodigoHash( $a_VTA_FacturacionElectronica['CodigoHash'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['Errors'] ) ) $o_VTA_FacturacionElectronicaBN->setErrors( $a_VTA_FacturacionElectronica['Errors'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['CodigoError'] ) ) $o_VTA_FacturacionElectronicaBN->setCodigoError( $a_VTA_FacturacionElectronica['CodigoError'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['CodigoErrorDesc'] ) ) $o_VTA_FacturacionElectronicaBN->setCodigoErrorDesc( $a_VTA_FacturacionElectronica['CodigoErrorDesc'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuNumero'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuNumero( ( integer ) $a_VTA_FacturacionElectronica['AnuNumero'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuEnlace'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuEnlace( $a_VTA_FacturacionElectronica['AnuEnlace'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuSunatTicketNumero'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuSunatTicketNumero( $a_VTA_FacturacionElectronica['AnuSunatTicketNumero'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuMotivo'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuMotivo( $a_VTA_FacturacionElectronica['AnuMotivo'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuAceptadaPorSunat'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuAceptadaPorSunat( $a_VTA_FacturacionElectronica['AnuAceptadaPorSunat'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuSunatDescripcion'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuSunatDescripcion( $a_VTA_FacturacionElectronica['AnuSunatDescripcion'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuSunatNote'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuSunatNote( $a_VTA_FacturacionElectronica['AnuSunatNote'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuSunatResponseCode'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuSunatResponseCode( $a_VTA_FacturacionElectronica['AnuSunatResponseCode'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuSunatSoapError'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuSunatSoapError( $a_VTA_FacturacionElectronica['AnuSunatSoapError'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuPDFResult'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuPDFResult( $a_VTA_FacturacionElectronica['AnuPDFResult'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuXMLResult'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuXMLResult( $a_VTA_FacturacionElectronica['AnuXMLResult'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuCDRResult'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuCDRResult( $a_VTA_FacturacionElectronica['AnuCDRResult'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['AnuKey'] ) ) $o_VTA_FacturacionElectronicaBN->setAnuKey( $a_VTA_FacturacionElectronica['AnuKey'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['DataJson'] ) ) $o_VTA_FacturacionElectronicaBN->setDataJson( $a_VTA_FacturacionElectronica['DataJson'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['UsuarioCreacion'] ) ) $o_VTA_FacturacionElectronicaBN->setUsuarioCreacion( $a_VTA_FacturacionElectronica['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['FechaCreacion'] ) ) $o_VTA_FacturacionElectronicaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_FacturacionElectronica['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_FacturacionElectronica['UsuarioModificacion'] ) ) $o_VTA_FacturacionElectronicaBN->setUsuarioModificacion( $a_VTA_FacturacionElectronica['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_FacturacionElectronica['FechaModificacion'] ) ) $o_VTA_FacturacionElectronicaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_FacturacionElectronica['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_FacturacionElectronicaBN;
    }
}
?>