<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_Documento.xml */
/* Generado: 2022-08-20 00:12:28 */

/* Busqueda de registros de la tabla VTA_Documento. */
abstract class BaseVTA_DocumentoFN extends VTA_DocumentoBN
{
    /* Declaracion de constantes */
    const IdTipoDocumento = "VTA_Documento.IdTipoDocumento";
    const IdCompania = "VTA_Documento.IdCompania";
    const NumeroDocumento = "VTA_Documento.NumeroDocumento";
    const Sucursal = "VTA_Documento.Sucursal";
    const IdAlmacen = "VTA_Documento.IdAlmacen";
    const AlmacenDespacho = "VTA_Documento.AlmacenDespacho";
    const IdFormaPago = "VTA_Documento.IdFormaPago";
    const FormaPagoCod = "VTA_Documento.FormaPagoCod";
    const TerminoPago = "VTA_Documento.TerminoPago";
    const IdCierre = "VTA_Documento.IdCierre";
    const IdCaja = "VTA_Documento.IdCaja";
    const IdTurno = "VTA_Documento.IdTurno";
    const IdProyecto = "VTA_Documento.IdProyecto";
    const IdMotivo = "VTA_Documento.IdMotivo";
    const DocumentoCod = "VTA_Documento.DocumentoCod";
    const DocumentoSerie = "VTA_Documento.DocumentoSerie";
    const DocumentoNumero = "VTA_Documento.DocumentoNumero";
    const NumeroComprobante = "VTA_Documento.NumeroComprobante";
    const Periodo = "VTA_Documento.Periodo";
    const FechaDocumento = "VTA_Documento.FechaDocumento";
    const FechaVencimiento = "VTA_Documento.FechaVencimiento";
    const DocumentoParentId = "VTA_Documento.DocumentoParentId";
    const DocumentoParentCod = "VTA_Documento.DocumentoParentCod";
    const ClienteNumero = "VTA_Documento.ClienteNumero";
    const ClienteTipoDoc = "VTA_Documento.ClienteTipoDoc";
    const ClienteRUC = "VTA_Documento.ClienteRUC";
    const ClienteNombre = "VTA_Documento.ClienteNombre";
    const ClienteDireccionSecuencia = "VTA_Documento.ClienteDireccionSecuencia";
    const ClienteDireccion = "VTA_Documento.ClienteDireccion";
    const ClienteReferencia = "VTA_Documento.ClienteReferencia";
    const ClienteContacto = "VTA_Documento.ClienteContacto";
    const Departamento = "VTA_Documento.Departamento";
    const Provincia = "VTA_Documento.Provincia";
    const Distrito = "VTA_Documento.Distrito";
    const Ubigeo = "VTA_Documento.Ubigeo";
    const TipoFacturacion = "VTA_Documento.TipoFacturacion";
    const OrdenCompraRef = "VTA_Documento.OrdenCompraRef";
    const TipoVenta = "VTA_Documento.TipoVenta";
    const Vendedor = "VTA_Documento.Vendedor";
    const DetraccionTipoId = "VTA_Documento.DetraccionTipoId";
    const DetraccionPorcentaje = "VTA_Documento.DetraccionPorcentaje";
    const DetraccionMedPagoId = "VTA_Documento.DetraccionMedPagoId";
    const DetraccionTotal = "VTA_Documento.DetraccionTotal";
    const EsAgenteRetenedor = "VTA_Documento.EsAgenteRetenedor";
    const RetencionTipoId = "VTA_Documento.RetencionTipoId";
    const RetencionBaseImponible = "VTA_Documento.RetencionBaseImponible";
    const RetencionPorcentaje = "VTA_Documento.RetencionPorcentaje";
    const RetencionTotal = "VTA_Documento.RetencionTotal";
    const TipodeCambio = "VTA_Documento.TipodeCambio";
    const MonedaDocumento = "VTA_Documento.MonedaDocumento";
    const MontoSubTotal = "VTA_Documento.MontoSubTotal";
    const MontoSubTotalMN = "VTA_Documento.MontoSubTotalMN";
    const MontoAfecto = "VTA_Documento.MontoAfecto";
    const MontoAfectoMN = "VTA_Documento.MontoAfectoMN";
    const MontoNoAfecto = "VTA_Documento.MontoNoAfecto";
    const MontoNoAfectoMN = "VTA_Documento.MontoNoAfectoMN";
    const MontoExonerado = "VTA_Documento.MontoExonerado";
    const MontoExoneradoMN = "VTA_Documento.MontoExoneradoMN";
    const MontoGratuito = "VTA_Documento.MontoGratuito";
    const MontoGratuitoMN = "VTA_Documento.MontoGratuitoMN";
    const MontoImpuestos = "VTA_Documento.MontoImpuestos";
    const MontoImpuestoMN = "VTA_Documento.MontoImpuestoMN";
    const MontoDescuentos = "VTA_Documento.MontoDescuentos";
    const MontoDescuentosMN = "VTA_Documento.MontoDescuentosMN";
    const MontoDescuentoLinea = "VTA_Documento.MontoDescuentoLinea";
    const MontoDescuentoLineaMN = "VTA_Documento.MontoDescuentoLineaMN";
    const MontoAnticipo = "VTA_Documento.MontoAnticipo";
    const MontoAnticipoMN = "VTA_Documento.MontoAnticipoMN";
    const MontoRedondeo = "VTA_Documento.MontoRedondeo";
    const MontoRedondeoMN = "VTA_Documento.MontoRedondeoMN";
    const MontoTotal = "VTA_Documento.MontoTotal";
    const MontoTotalMN = "VTA_Documento.MontoTotalMN";
    const MontoPagado = "VTA_Documento.MontoPagado";
    const MontoPagadoMN = "VTA_Documento.MontoPagadoMN";
    const MontoSaldo = "VTA_Documento.MontoSaldo";
    const MontoSaldoMN = "VTA_Documento.MontoSaldoMN";
    const FechaFacturacion = "VTA_Documento.FechaFacturacion";
    const FechaAprobacion = "VTA_Documento.FechaAprobacion";
    const NotaCreditoDocumento = "VTA_Documento.NotaCreditoDocumento";
    const NotaDebitoDocumento = "VTA_Documento.NotaDebitoDocumento";
    const ImpresionPendienteFlag = "VTA_Documento.ImpresionPendienteFlag";
    const FechaImpresion = "VTA_Documento.FechaImpresion";
    const ImpresionGuiaRemFlag = "VTA_Documento.ImpresionGuiaRemFlag";
    const FechaImpresionGuiRem = "VTA_Documento.FechaImpresionGuiRem";
    const NumeroRefAdicional1 = "VTA_Documento.NumeroRefAdicional1";
    const FechaRefAdicional1 = "VTA_Documento.FechaRefAdicional1";
    const Comentario = "VTA_Documento.Comentario";
    const AnulacionComentario = "VTA_Documento.AnulacionComentario";
    const CanalVenta = "VTA_Documento.CanalVenta";
    const FechaCobranza = "VTA_Documento.FechaCobranza";
    const CobranzaEstado = "VTA_Documento.CobranzaEstado";
    const Estado = "VTA_Documento.Estado";
    const Comision = "VTA_Documento.Comision";
    const UsuarioModificacion = "VTA_Documento.UsuarioModificacion";
    const FechaModificacion = "VTA_Documento.FechaModificacion";
    const UsuarioCreacion = "VTA_Documento.UsuarioCreacion";
    const FechaCreacion = "VTA_Documento.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_Documento.IdTipoDocumento AS IdTipoDocumento, ";
        $s_SQLQuery .= "VTA_Documento.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "VTA_Documento.NumeroDocumento AS NumeroDocumento, ";
        $s_SQLQuery .= "VTA_Documento.Sucursal AS Sucursal, ";
        $s_SQLQuery .= "VTA_Documento.IdAlmacen AS IdAlmacen, ";
        $s_SQLQuery .= "VTA_Documento.AlmacenDespacho AS AlmacenDespacho, ";
        $s_SQLQuery .= "VTA_Documento.IdFormaPago AS IdFormaPago, ";
        $s_SQLQuery .= "VTA_Documento.FormaPagoCod AS FormaPagoCod, ";
        $s_SQLQuery .= "VTA_Documento.TerminoPago AS TerminoPago, ";
        $s_SQLQuery .= "VTA_Documento.IdCierre AS IdCierre, ";
        $s_SQLQuery .= "VTA_Documento.IdCaja AS IdCaja, ";
        $s_SQLQuery .= "VTA_Documento.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "VTA_Documento.IdProyecto AS IdProyecto, ";
        $s_SQLQuery .= "VTA_Documento.IdMotivo AS IdMotivo, ";
        $s_SQLQuery .= "VTA_Documento.DocumentoCod AS DocumentoCod, ";
        $s_SQLQuery .= "VTA_Documento.DocumentoSerie AS DocumentoSerie, ";
        $s_SQLQuery .= "VTA_Documento.DocumentoNumero AS DocumentoNumero, ";
        $s_SQLQuery .= "VTA_Documento.NumeroComprobante AS NumeroComprobante, ";
        $s_SQLQuery .= "VTA_Documento.Periodo AS Periodo, ";
        $s_SQLQuery .= "VTA_Documento.FechaDocumento AS FechaDocumento, ";
        $s_SQLQuery .= "VTA_Documento.FechaVencimiento AS FechaVencimiento, ";
        $s_SQLQuery .= "VTA_Documento.DocumentoParentId AS DocumentoParentId, ";
        $s_SQLQuery .= "VTA_Documento.DocumentoParentCod AS DocumentoParentCod, ";
        $s_SQLQuery .= "VTA_Documento.ClienteNumero AS ClienteNumero, ";
        $s_SQLQuery .= "VTA_Documento.ClienteTipoDoc AS ClienteTipoDoc, ";
        $s_SQLQuery .= "VTA_Documento.ClienteRUC AS ClienteRUC, ";
        $s_SQLQuery .= "VTA_Documento.ClienteNombre AS ClienteNombre, ";
        $s_SQLQuery .= "VTA_Documento.ClienteDireccionSecuencia AS ClienteDireccionSecuencia, ";
        $s_SQLQuery .= "VTA_Documento.ClienteDireccion AS ClienteDireccion, ";
        $s_SQLQuery .= "VTA_Documento.ClienteReferencia AS ClienteReferencia, ";
        $s_SQLQuery .= "VTA_Documento.ClienteContacto AS ClienteContacto, ";
        $s_SQLQuery .= "VTA_Documento.Departamento AS Departamento, ";
        $s_SQLQuery .= "VTA_Documento.Provincia AS Provincia, ";
        $s_SQLQuery .= "VTA_Documento.Distrito AS Distrito, ";
        $s_SQLQuery .= "VTA_Documento.Ubigeo AS Ubigeo, ";
        $s_SQLQuery .= "VTA_Documento.TipoFacturacion AS TipoFacturacion, ";
        $s_SQLQuery .= "VTA_Documento.OrdenCompraRef AS OrdenCompraRef, ";
        $s_SQLQuery .= "VTA_Documento.TipoVenta AS TipoVenta, ";
        $s_SQLQuery .= "VTA_Documento.Vendedor AS Vendedor, ";
        $s_SQLQuery .= "VTA_Documento.DetraccionTipoId AS DetraccionTipoId, ";
        $s_SQLQuery .= "VTA_Documento.DetraccionPorcentaje AS DetraccionPorcentaje, ";
        $s_SQLQuery .= "VTA_Documento.DetraccionMedPagoId AS DetraccionMedPagoId, ";
        $s_SQLQuery .= "VTA_Documento.DetraccionTotal AS DetraccionTotal, ";
        $s_SQLQuery .= "VTA_Documento.EsAgenteRetenedor AS EsAgenteRetenedor, ";
        $s_SQLQuery .= "VTA_Documento.RetencionTipoId AS RetencionTipoId, ";
        $s_SQLQuery .= "VTA_Documento.RetencionBaseImponible AS RetencionBaseImponible, ";
        $s_SQLQuery .= "VTA_Documento.RetencionPorcentaje AS RetencionPorcentaje, ";
        $s_SQLQuery .= "VTA_Documento.RetencionTotal AS RetencionTotal, ";
        $s_SQLQuery .= "VTA_Documento.TipodeCambio AS TipodeCambio, ";
        $s_SQLQuery .= "VTA_Documento.MonedaDocumento AS MonedaDocumento, ";
        $s_SQLQuery .= "VTA_Documento.MontoSubTotal AS MontoSubTotal, ";
        $s_SQLQuery .= "VTA_Documento.MontoSubTotalMN AS MontoSubTotalMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoAfecto AS MontoAfecto, ";
        $s_SQLQuery .= "VTA_Documento.MontoAfectoMN AS MontoAfectoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoNoAfecto AS MontoNoAfecto, ";
        $s_SQLQuery .= "VTA_Documento.MontoNoAfectoMN AS MontoNoAfectoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoExonerado AS MontoExonerado, ";
        $s_SQLQuery .= "VTA_Documento.MontoExoneradoMN AS MontoExoneradoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoGratuito AS MontoGratuito, ";
        $s_SQLQuery .= "VTA_Documento.MontoGratuitoMN AS MontoGratuitoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoImpuestos AS MontoImpuestos, ";
        $s_SQLQuery .= "VTA_Documento.MontoImpuestoMN AS MontoImpuestoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoDescuentos AS MontoDescuentos, ";
        $s_SQLQuery .= "VTA_Documento.MontoDescuentosMN AS MontoDescuentosMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoDescuentoLinea AS MontoDescuentoLinea, ";
        $s_SQLQuery .= "VTA_Documento.MontoDescuentoLineaMN AS MontoDescuentoLineaMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoAnticipo AS MontoAnticipo, ";
        $s_SQLQuery .= "VTA_Documento.MontoAnticipoMN AS MontoAnticipoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoRedondeo AS MontoRedondeo, ";
        $s_SQLQuery .= "VTA_Documento.MontoRedondeoMN AS MontoRedondeoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoTotal AS MontoTotal, ";
        $s_SQLQuery .= "VTA_Documento.MontoTotalMN AS MontoTotalMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoPagado AS MontoPagado, ";
        $s_SQLQuery .= "VTA_Documento.MontoPagadoMN AS MontoPagadoMN, ";
        $s_SQLQuery .= "VTA_Documento.MontoSaldo AS MontoSaldo, ";
        $s_SQLQuery .= "VTA_Documento.MontoSaldoMN AS MontoSaldoMN, ";
        $s_SQLQuery .= "VTA_Documento.FechaFacturacion AS FechaFacturacion, ";
        $s_SQLQuery .= "VTA_Documento.FechaAprobacion AS FechaAprobacion, ";
        $s_SQLQuery .= "VTA_Documento.NotaCreditoDocumento AS NotaCreditoDocumento, ";
        $s_SQLQuery .= "VTA_Documento.NotaDebitoDocumento AS NotaDebitoDocumento, ";
        $s_SQLQuery .= "VTA_Documento.ImpresionPendienteFlag AS ImpresionPendienteFlag, ";
        $s_SQLQuery .= "VTA_Documento.FechaImpresion AS FechaImpresion, ";
        $s_SQLQuery .= "VTA_Documento.ImpresionGuiaRemFlag AS ImpresionGuiaRemFlag, ";
        $s_SQLQuery .= "VTA_Documento.FechaImpresionGuiRem AS FechaImpresionGuiRem, ";
        $s_SQLQuery .= "VTA_Documento.NumeroRefAdicional1 AS NumeroRefAdicional1, ";
        $s_SQLQuery .= "VTA_Documento.FechaRefAdicional1 AS FechaRefAdicional1, ";
        $s_SQLQuery .= "VTA_Documento.Comentario AS Comentario, ";
        $s_SQLQuery .= "VTA_Documento.AnulacionComentario AS AnulacionComentario, ";
        $s_SQLQuery .= "VTA_Documento.CanalVenta AS CanalVenta, ";
        $s_SQLQuery .= "VTA_Documento.FechaCobranza AS FechaCobranza, ";
        $s_SQLQuery .= "VTA_Documento.CobranzaEstado AS CobranzaEstado, ";
        $s_SQLQuery .= "VTA_Documento.Estado AS Estado, ";
        $s_SQLQuery .= "VTA_Documento.Comision AS Comision, ";
        $s_SQLQuery .= "VTA_Documento.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "VTA_Documento.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "VTA_Documento.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_Documento.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_DocumentoBN */
    public function setByBN( VTA_DocumentoBN $o_VTA_DocumentoBN )
    {
        if ( !is_null( $o_VTA_DocumentoBN->getIdTipoDocumento() ) )
        {
            $this->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNumeroDocumento() ) )
        {
            $this->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getSucursal() ) )
        {
            $this->setSucursal( $o_VTA_DocumentoBN->getSucursal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdAlmacen() ) )
        {
            $this->setIdAlmacen( $o_VTA_DocumentoBN->getIdAlmacen() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getAlmacenDespacho() ) )
        {
            $this->setAlmacenDespacho( $o_VTA_DocumentoBN->getAlmacenDespacho() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdFormaPago() ) )
        {
            $this->setIdFormaPago( $o_VTA_DocumentoBN->getIdFormaPago() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFormaPagoCod() ) )
        {
            $this->setFormaPagoCod( $o_VTA_DocumentoBN->getFormaPagoCod() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTerminoPago() ) )
        {
            $this->setTerminoPago( $o_VTA_DocumentoBN->getTerminoPago() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdCierre() ) )
        {
            $this->setIdCierre( $o_VTA_DocumentoBN->getIdCierre() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdCaja() ) )
        {
            $this->setIdCaja( $o_VTA_DocumentoBN->getIdCaja() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_VTA_DocumentoBN->getIdTurno() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdProyecto() ) )
        {
            $this->setIdProyecto( $o_VTA_DocumentoBN->getIdProyecto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getIdMotivo() ) )
        {
            $this->setIdMotivo( $o_VTA_DocumentoBN->getIdMotivo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoCod() ) )
        {
            $this->setDocumentoCod( $o_VTA_DocumentoBN->getDocumentoCod() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoSerie() ) )
        {
            $this->setDocumentoSerie( $o_VTA_DocumentoBN->getDocumentoSerie() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoNumero() ) )
        {
            $this->setDocumentoNumero( $o_VTA_DocumentoBN->getDocumentoNumero() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNumeroComprobante() ) )
        {
            $this->setNumeroComprobante( $o_VTA_DocumentoBN->getNumeroComprobante() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getPeriodo() ) )
        {
            $this->setPeriodo( $o_VTA_DocumentoBN->getPeriodo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaDocumento() ) )
        {
            $this->setFechaDocumento( $o_VTA_DocumentoBN->getFechaDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaVencimiento() ) )
        {
            $this->setFechaVencimiento( $o_VTA_DocumentoBN->getFechaVencimiento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoParentId() ) )
        {
            $this->setDocumentoParentId( $o_VTA_DocumentoBN->getDocumentoParentId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDocumentoParentCod() ) )
        {
            $this->setDocumentoParentCod( $o_VTA_DocumentoBN->getDocumentoParentCod() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteNumero() ) )
        {
            $this->setClienteNumero( $o_VTA_DocumentoBN->getClienteNumero() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteTipoDoc() ) )
        {
            $this->setClienteTipoDoc( $o_VTA_DocumentoBN->getClienteTipoDoc() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteRUC() ) )
        {
            $this->setClienteRUC( $o_VTA_DocumentoBN->getClienteRUC() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteNombre() ) )
        {
            $this->setClienteNombre( $o_VTA_DocumentoBN->getClienteNombre() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteDireccionSecuencia() ) )
        {
            $this->setClienteDireccionSecuencia( $o_VTA_DocumentoBN->getClienteDireccionSecuencia() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteDireccion() ) )
        {
            $this->setClienteDireccion( $o_VTA_DocumentoBN->getClienteDireccion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteReferencia() ) )
        {
            $this->setClienteReferencia( $o_VTA_DocumentoBN->getClienteReferencia() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getClienteContacto() ) )
        {
            $this->setClienteContacto( $o_VTA_DocumentoBN->getClienteContacto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDepartamento() ) )
        {
            $this->setDepartamento( $o_VTA_DocumentoBN->getDepartamento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getProvincia() ) )
        {
            $this->setProvincia( $o_VTA_DocumentoBN->getProvincia() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDistrito() ) )
        {
            $this->setDistrito( $o_VTA_DocumentoBN->getDistrito() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getUbigeo() ) )
        {
            $this->setUbigeo( $o_VTA_DocumentoBN->getUbigeo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTipoFacturacion() ) )
        {
            $this->setTipoFacturacion( $o_VTA_DocumentoBN->getTipoFacturacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getOrdenCompraRef() ) )
        {
            $this->setOrdenCompraRef( $o_VTA_DocumentoBN->getOrdenCompraRef() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTipoVenta() ) )
        {
            $this->setTipoVenta( $o_VTA_DocumentoBN->getTipoVenta() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getVendedor() ) )
        {
            $this->setVendedor( $o_VTA_DocumentoBN->getVendedor() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionTipoId() ) )
        {
            $this->setDetraccionTipoId( $o_VTA_DocumentoBN->getDetraccionTipoId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionPorcentaje() ) )
        {
            $this->setDetraccionPorcentaje( $o_VTA_DocumentoBN->getDetraccionPorcentaje() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionMedPagoId() ) )
        {
            $this->setDetraccionMedPagoId( $o_VTA_DocumentoBN->getDetraccionMedPagoId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getDetraccionTotal() ) )
        {
            $this->setDetraccionTotal( $o_VTA_DocumentoBN->getDetraccionTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getEsAgenteRetenedor() ) )
        {
            $this->setEsAgenteRetenedor( $o_VTA_DocumentoBN->getEsAgenteRetenedor() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionTipoId() ) )
        {
            $this->setRetencionTipoId( $o_VTA_DocumentoBN->getRetencionTipoId() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionBaseImponible() ) )
        {
            $this->setRetencionBaseImponible( $o_VTA_DocumentoBN->getRetencionBaseImponible() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionPorcentaje() ) )
        {
            $this->setRetencionPorcentaje( $o_VTA_DocumentoBN->getRetencionPorcentaje() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getRetencionTotal() ) )
        {
            $this->setRetencionTotal( $o_VTA_DocumentoBN->getRetencionTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getTipodeCambio() ) )
        {
            $this->setTipodeCambio( $o_VTA_DocumentoBN->getTipodeCambio() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMonedaDocumento() ) )
        {
            $this->setMonedaDocumento( $o_VTA_DocumentoBN->getMonedaDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSubTotal() ) )
        {
            $this->setMontoSubTotal( $o_VTA_DocumentoBN->getMontoSubTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSubTotalMN() ) )
        {
            $this->setMontoSubTotalMN( $o_VTA_DocumentoBN->getMontoSubTotalMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAfecto() ) )
        {
            $this->setMontoAfecto( $o_VTA_DocumentoBN->getMontoAfecto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAfectoMN() ) )
        {
            $this->setMontoAfectoMN( $o_VTA_DocumentoBN->getMontoAfectoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoNoAfecto() ) )
        {
            $this->setMontoNoAfecto( $o_VTA_DocumentoBN->getMontoNoAfecto() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoNoAfectoMN() ) )
        {
            $this->setMontoNoAfectoMN( $o_VTA_DocumentoBN->getMontoNoAfectoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoExonerado() ) )
        {
            $this->setMontoExonerado( $o_VTA_DocumentoBN->getMontoExonerado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoExoneradoMN() ) )
        {
            $this->setMontoExoneradoMN( $o_VTA_DocumentoBN->getMontoExoneradoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoGratuito() ) )
        {
            $this->setMontoGratuito( $o_VTA_DocumentoBN->getMontoGratuito() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoGratuitoMN() ) )
        {
            $this->setMontoGratuitoMN( $o_VTA_DocumentoBN->getMontoGratuitoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoImpuestos() ) )
        {
            $this->setMontoImpuestos( $o_VTA_DocumentoBN->getMontoImpuestos() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoImpuestoMN() ) )
        {
            $this->setMontoImpuestoMN( $o_VTA_DocumentoBN->getMontoImpuestoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoDescuentos() ) )
        {
            $this->setMontoDescuentos( $o_VTA_DocumentoBN->getMontoDescuentos() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoDescuentosMN() ) )
        {
            $this->setMontoDescuentosMN( $o_VTA_DocumentoBN->getMontoDescuentosMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoDescuentoLinea() ) )
        {
            $this->setMontoDescuentoLinea( $o_VTA_DocumentoBN->getMontoDescuentoLinea() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoDescuentoLineaMN() ) )
        {
            $this->setMontoDescuentoLineaMN( $o_VTA_DocumentoBN->getMontoDescuentoLineaMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAnticipo() ) )
        {
            $this->setMontoAnticipo( $o_VTA_DocumentoBN->getMontoAnticipo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoAnticipoMN() ) )
        {
            $this->setMontoAnticipoMN( $o_VTA_DocumentoBN->getMontoAnticipoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoRedondeo() ) )
        {
            $this->setMontoRedondeo( $o_VTA_DocumentoBN->getMontoRedondeo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoRedondeoMN() ) )
        {
            $this->setMontoRedondeoMN( $o_VTA_DocumentoBN->getMontoRedondeoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoTotal() ) )
        {
            $this->setMontoTotal( $o_VTA_DocumentoBN->getMontoTotal() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoTotalMN() ) )
        {
            $this->setMontoTotalMN( $o_VTA_DocumentoBN->getMontoTotalMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoPagado() ) )
        {
            $this->setMontoPagado( $o_VTA_DocumentoBN->getMontoPagado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoPagadoMN() ) )
        {
            $this->setMontoPagadoMN( $o_VTA_DocumentoBN->getMontoPagadoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSaldo() ) )
        {
            $this->setMontoSaldo( $o_VTA_DocumentoBN->getMontoSaldo() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getMontoSaldoMN() ) )
        {
            $this->setMontoSaldoMN( $o_VTA_DocumentoBN->getMontoSaldoMN() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaFacturacion() ) )
        {
            $this->setFechaFacturacion( $o_VTA_DocumentoBN->getFechaFacturacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaAprobacion() ) )
        {
            $this->setFechaAprobacion( $o_VTA_DocumentoBN->getFechaAprobacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNotaCreditoDocumento() ) )
        {
            $this->setNotaCreditoDocumento( $o_VTA_DocumentoBN->getNotaCreditoDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNotaDebitoDocumento() ) )
        {
            $this->setNotaDebitoDocumento( $o_VTA_DocumentoBN->getNotaDebitoDocumento() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getImpresionPendienteFlag() ) )
        {
            $this->setImpresionPendienteFlag( $o_VTA_DocumentoBN->getImpresionPendienteFlag() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaImpresion() ) )
        {
            $this->setFechaImpresion( $o_VTA_DocumentoBN->getFechaImpresion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getImpresionGuiaRemFlag() ) )
        {
            $this->setImpresionGuiaRemFlag( $o_VTA_DocumentoBN->getImpresionGuiaRemFlag() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaImpresionGuiRem() ) )
        {
            $this->setFechaImpresionGuiRem( $o_VTA_DocumentoBN->getFechaImpresionGuiRem() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getNumeroRefAdicional1() ) )
        {
            $this->setNumeroRefAdicional1( $o_VTA_DocumentoBN->getNumeroRefAdicional1() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaRefAdicional1() ) )
        {
            $this->setFechaRefAdicional1( $o_VTA_DocumentoBN->getFechaRefAdicional1() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getComentario() ) )
        {
            $this->setComentario( $o_VTA_DocumentoBN->getComentario() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getAnulacionComentario() ) )
        {
            $this->setAnulacionComentario( $o_VTA_DocumentoBN->getAnulacionComentario() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getCanalVenta() ) )
        {
            $this->setCanalVenta( $o_VTA_DocumentoBN->getCanalVenta() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaCobranza() ) )
        {
            $this->setFechaCobranza( $o_VTA_DocumentoBN->getFechaCobranza() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getCobranzaEstado() ) )
        {
            $this->setCobranzaEstado( $o_VTA_DocumentoBN->getCobranzaEstado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getEstado() ) )
        {
            $this->setEstado( $o_VTA_DocumentoBN->getEstado() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getComision() ) )
        {
            $this->setComision( $o_VTA_DocumentoBN->getComision() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_VTA_DocumentoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_VTA_DocumentoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_DocumentoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_DocumentoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_DocumentoBN->getFechaCreacion() );
        }
    }

    /**
    * @return VTA_DocumentoBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTipoDocumento, $i_IdCompania, $s_NumeroDocumento )
    {
        if( is_null( $s_IdTipoDocumento ) ){ $s_IdTipoDocumento = '-1'; } 
        if( is_null( $i_IdCompania ) ){ $i_IdCompania = -1; } 
        if( is_null( $s_NumeroDocumento ) ){ $s_NumeroDocumento = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_Documento ";
        $s_SQLQuery .= "WHERE IdTipoDocumento = '".$s_IdTipoDocumento."' ";
        $s_SQLQuery .= "AND IdCompania = ".$i_IdCompania." ";
        $s_SQLQuery .= "AND NumeroDocumento = '".$s_NumeroDocumento."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_DocumentoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_DocumentoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_DocumentoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTipoDocumento() ) ) $s_SQLQuery .= "VTA_Documento.IdTipoDocumento = '".$this->getIdTipoDocumento()."' AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "VTA_Documento.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getNumeroDocumento() ) ) $s_SQLQuery .= "VTA_Documento.NumeroDocumento = '".$this->getNumeroDocumento()."' AND ";
        if ( !is_null( $this->getSucursal() ) ) $s_SQLQuery .= "VTA_Documento.Sucursal = '".$this->getSucursal()."' AND ";
        if ( !is_null( $this->getIdAlmacen() ) ) $s_SQLQuery .= "VTA_Documento.IdAlmacen = '".$this->getIdAlmacen()."' AND ";
        if ( !is_null( $this->getAlmacenDespacho() ) ) $s_SQLQuery .= "VTA_Documento.AlmacenDespacho = '".$this->getAlmacenDespacho()."' AND ";
        if ( !is_null( $this->getIdFormaPago() ) ) $s_SQLQuery .= "VTA_Documento.IdFormaPago = '".$this->getIdFormaPago()."' AND ";
        if ( !is_null( $this->getFormaPagoCod() ) ) $s_SQLQuery .= "VTA_Documento.FormaPagoCod = '".$this->getFormaPagoCod()."' AND ";
        if ( !is_null( $this->getTerminoPago() ) ) $s_SQLQuery .= "VTA_Documento.TerminoPago = ".$this->getTerminoPago()." AND ";
        if ( !is_null( $this->getIdCierre() ) ) $s_SQLQuery .= "VTA_Documento.IdCierre = ".$this->getIdCierre()." AND ";
        if ( !is_null( $this->getIdCaja() ) ) $s_SQLQuery .= "VTA_Documento.IdCaja = ".$this->getIdCaja()." AND ";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "VTA_Documento.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getIdProyecto() ) ) $s_SQLQuery .= "VTA_Documento.IdProyecto = ".$this->getIdProyecto()." AND ";
        if ( !is_null( $this->getIdMotivo() ) ) $s_SQLQuery .= "VTA_Documento.IdMotivo = ".$this->getIdMotivo()." AND ";
        if ( !is_null( $this->getDocumentoCod() ) ) $s_SQLQuery .= "VTA_Documento.DocumentoCod = '".$this->getDocumentoCod()."' AND ";
        if ( !is_null( $this->getDocumentoSerie() ) ) $s_SQLQuery .= "VTA_Documento.DocumentoSerie = '".$this->getDocumentoSerie()."' AND ";
        if ( !is_null( $this->getDocumentoNumero() ) ) $s_SQLQuery .= "VTA_Documento.DocumentoNumero = '".$this->getDocumentoNumero()."' AND ";
        if ( !is_null( $this->getNumeroComprobante() ) ) $s_SQLQuery .= "VTA_Documento.NumeroComprobante = '".$this->getNumeroComprobante()."' AND ";
        if ( !is_null( $this->getPeriodo() ) ) $s_SQLQuery .= "VTA_Documento.Periodo = '".$this->getPeriodo()."' AND ";
        if ( !is_null( $this->getFechaDocumento() ) ) $s_SQLQuery .= "VTA_Documento.FechaDocumento = '".$this->getFechaDocumento()."' AND ";
        if ( !is_null( $this->getFechaVencimiento() ) ) $s_SQLQuery .= "VTA_Documento.FechaVencimiento = '".$this->getFechaVencimiento()."' AND ";
        if ( !is_null( $this->getDocumentoParentId() ) ) $s_SQLQuery .= "VTA_Documento.DocumentoParentId = ".$this->getDocumentoParentId()." AND ";
        if ( !is_null( $this->getDocumentoParentCod() ) ) $s_SQLQuery .= "VTA_Documento.DocumentoParentCod = '".$this->getDocumentoParentCod()."' AND ";
        if ( !is_null( $this->getClienteNumero() ) ) $s_SQLQuery .= "VTA_Documento.ClienteNumero = '".$this->getClienteNumero()."' AND ";
        if ( !is_null( $this->getClienteTipoDoc() ) ) $s_SQLQuery .= "VTA_Documento.ClienteTipoDoc = '".$this->getClienteTipoDoc()."' AND ";
        if ( !is_null( $this->getClienteRUC() ) ) $s_SQLQuery .= "VTA_Documento.ClienteRUC = '".$this->getClienteRUC()."' AND ";
        if ( !is_null( $this->getClienteNombre() ) ) $s_SQLQuery .= "VTA_Documento.ClienteNombre = '".$this->getClienteNombre()."' AND ";
        if ( !is_null( $this->getClienteDireccionSecuencia() ) ) $s_SQLQuery .= "VTA_Documento.ClienteDireccionSecuencia = ".$this->getClienteDireccionSecuencia()." AND ";
        if ( !is_null( $this->getClienteDireccion() ) ) $s_SQLQuery .= "VTA_Documento.ClienteDireccion = '".$this->getClienteDireccion()."' AND ";
        if ( !is_null( $this->getClienteReferencia() ) ) $s_SQLQuery .= "VTA_Documento.ClienteReferencia = '".$this->getClienteReferencia()."' AND ";
        if ( !is_null( $this->getClienteContacto() ) ) $s_SQLQuery .= "VTA_Documento.ClienteContacto = '".$this->getClienteContacto()."' AND ";
        if ( !is_null( $this->getDepartamento() ) ) $s_SQLQuery .= "VTA_Documento.Departamento = '".$this->getDepartamento()."' AND ";
        if ( !is_null( $this->getProvincia() ) ) $s_SQLQuery .= "VTA_Documento.Provincia = '".$this->getProvincia()."' AND ";
        if ( !is_null( $this->getDistrito() ) ) $s_SQLQuery .= "VTA_Documento.Distrito = '".$this->getDistrito()."' AND ";
        if ( !is_null( $this->getUbigeo() ) ) $s_SQLQuery .= "VTA_Documento.Ubigeo = '".$this->getUbigeo()."' AND ";
        if ( !is_null( $this->getTipoFacturacion() ) ) $s_SQLQuery .= "VTA_Documento.TipoFacturacion = '".$this->getTipoFacturacion()."' AND ";
        if ( !is_null( $this->getOrdenCompraRef() ) ) $s_SQLQuery .= "VTA_Documento.OrdenCompraRef = '".$this->getOrdenCompraRef()."' AND ";
        if ( !is_null( $this->getTipoVenta() ) ) $s_SQLQuery .= "VTA_Documento.TipoVenta = '".$this->getTipoVenta()."' AND ";
        if ( !is_null( $this->getVendedor() ) ) $s_SQLQuery .= "VTA_Documento.Vendedor = '".$this->getVendedor()."' AND ";
        if ( !is_null( $this->getDetraccionTipoId() ) ) $s_SQLQuery .= "VTA_Documento.DetraccionTipoId = ".$this->getDetraccionTipoId()." AND ";
        if ( !is_null( $this->getDetraccionPorcentaje() ) ) $s_SQLQuery .= "VTA_Documento.DetraccionPorcentaje = ".$this->getDetraccionPorcentaje()." AND ";
        if ( !is_null( $this->getDetraccionMedPagoId() ) ) $s_SQLQuery .= "VTA_Documento.DetraccionMedPagoId = ".$this->getDetraccionMedPagoId()." AND ";
        if ( !is_null( $this->getDetraccionTotal() ) ) $s_SQLQuery .= "VTA_Documento.DetraccionTotal = ".$this->getDetraccionTotal()." AND ";
        if ( !is_null( $this->getEsAgenteRetenedor() ) ) $s_SQLQuery .= "VTA_Documento.EsAgenteRetenedor = ".$this->getEsAgenteRetenedor()." AND ";
        if ( !is_null( $this->getRetencionTipoId() ) ) $s_SQLQuery .= "VTA_Documento.RetencionTipoId = ".$this->getRetencionTipoId()." AND ";
        if ( !is_null( $this->getRetencionBaseImponible() ) ) $s_SQLQuery .= "VTA_Documento.RetencionBaseImponible = ".$this->getRetencionBaseImponible()." AND ";
        if ( !is_null( $this->getRetencionPorcentaje() ) ) $s_SQLQuery .= "VTA_Documento.RetencionPorcentaje = ".$this->getRetencionPorcentaje()." AND ";
        if ( !is_null( $this->getRetencionTotal() ) ) $s_SQLQuery .= "VTA_Documento.RetencionTotal = ".$this->getRetencionTotal()." AND ";
        if ( !is_null( $this->getTipodeCambio() ) ) $s_SQLQuery .= "VTA_Documento.TipodeCambio = ".$this->getTipodeCambio()." AND ";
        if ( !is_null( $this->getMonedaDocumento() ) ) $s_SQLQuery .= "VTA_Documento.MonedaDocumento = '".$this->getMonedaDocumento()."' AND ";
        if ( !is_null( $this->getMontoSubTotal() ) ) $s_SQLQuery .= "VTA_Documento.MontoSubTotal = ".$this->getMontoSubTotal()." AND ";
        if ( !is_null( $this->getMontoSubTotalMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoSubTotalMN = ".$this->getMontoSubTotalMN()." AND ";
        if ( !is_null( $this->getMontoAfecto() ) ) $s_SQLQuery .= "VTA_Documento.MontoAfecto = ".$this->getMontoAfecto()." AND ";
        if ( !is_null( $this->getMontoAfectoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoAfectoMN = ".$this->getMontoAfectoMN()." AND ";
        if ( !is_null( $this->getMontoNoAfecto() ) ) $s_SQLQuery .= "VTA_Documento.MontoNoAfecto = ".$this->getMontoNoAfecto()." AND ";
        if ( !is_null( $this->getMontoNoAfectoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoNoAfectoMN = ".$this->getMontoNoAfectoMN()." AND ";
        if ( !is_null( $this->getMontoExonerado() ) ) $s_SQLQuery .= "VTA_Documento.MontoExonerado = ".$this->getMontoExonerado()." AND ";
        if ( !is_null( $this->getMontoExoneradoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoExoneradoMN = ".$this->getMontoExoneradoMN()." AND ";
        if ( !is_null( $this->getMontoGratuito() ) ) $s_SQLQuery .= "VTA_Documento.MontoGratuito = ".$this->getMontoGratuito()." AND ";
        if ( !is_null( $this->getMontoGratuitoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoGratuitoMN = ".$this->getMontoGratuitoMN()." AND ";
        if ( !is_null( $this->getMontoImpuestos() ) ) $s_SQLQuery .= "VTA_Documento.MontoImpuestos = ".$this->getMontoImpuestos()." AND ";
        if ( !is_null( $this->getMontoImpuestoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoImpuestoMN = ".$this->getMontoImpuestoMN()." AND ";
        if ( !is_null( $this->getMontoDescuentos() ) ) $s_SQLQuery .= "VTA_Documento.MontoDescuentos = ".$this->getMontoDescuentos()." AND ";
        if ( !is_null( $this->getMontoDescuentosMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoDescuentosMN = ".$this->getMontoDescuentosMN()." AND ";
        if ( !is_null( $this->getMontoDescuentoLinea() ) ) $s_SQLQuery .= "VTA_Documento.MontoDescuentoLinea = ".$this->getMontoDescuentoLinea()." AND ";
        if ( !is_null( $this->getMontoDescuentoLineaMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoDescuentoLineaMN = ".$this->getMontoDescuentoLineaMN()." AND ";
        if ( !is_null( $this->getMontoAnticipo() ) ) $s_SQLQuery .= "VTA_Documento.MontoAnticipo = ".$this->getMontoAnticipo()." AND ";
        if ( !is_null( $this->getMontoAnticipoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoAnticipoMN = ".$this->getMontoAnticipoMN()." AND ";
        if ( !is_null( $this->getMontoRedondeo() ) ) $s_SQLQuery .= "VTA_Documento.MontoRedondeo = ".$this->getMontoRedondeo()." AND ";
        if ( !is_null( $this->getMontoRedondeoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoRedondeoMN = ".$this->getMontoRedondeoMN()." AND ";
        if ( !is_null( $this->getMontoTotal() ) ) $s_SQLQuery .= "VTA_Documento.MontoTotal = ".$this->getMontoTotal()." AND ";
        if ( !is_null( $this->getMontoTotalMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoTotalMN = ".$this->getMontoTotalMN()." AND ";
        if ( !is_null( $this->getMontoPagado() ) ) $s_SQLQuery .= "VTA_Documento.MontoPagado = ".$this->getMontoPagado()." AND ";
        if ( !is_null( $this->getMontoPagadoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoPagadoMN = ".$this->getMontoPagadoMN()." AND ";
        if ( !is_null( $this->getMontoSaldo() ) ) $s_SQLQuery .= "VTA_Documento.MontoSaldo = ".$this->getMontoSaldo()." AND ";
        if ( !is_null( $this->getMontoSaldoMN() ) ) $s_SQLQuery .= "VTA_Documento.MontoSaldoMN = ".$this->getMontoSaldoMN()." AND ";
        if ( !is_null( $this->getFechaFacturacion() ) ) $s_SQLQuery .= "VTA_Documento.FechaFacturacion = '".$this->getFechaFacturacion()."' AND ";
        if ( !is_null( $this->getFechaAprobacion() ) ) $s_SQLQuery .= "VTA_Documento.FechaAprobacion = '".$this->getFechaAprobacion()."' AND ";
        if ( !is_null( $this->getNotaCreditoDocumento() ) ) $s_SQLQuery .= "VTA_Documento.NotaCreditoDocumento = '".$this->getNotaCreditoDocumento()."' AND ";
        if ( !is_null( $this->getNotaDebitoDocumento() ) ) $s_SQLQuery .= "VTA_Documento.NotaDebitoDocumento = '".$this->getNotaDebitoDocumento()."' AND ";
        if ( !is_null( $this->getImpresionPendienteFlag() ) ) $s_SQLQuery .= "VTA_Documento.ImpresionPendienteFlag = '".$this->getImpresionPendienteFlag()."' AND ";
        if ( !is_null( $this->getFechaImpresion() ) ) $s_SQLQuery .= "VTA_Documento.FechaImpresion = '".$this->getFechaImpresion()."' AND ";
        if ( !is_null( $this->getImpresionGuiaRemFlag() ) ) $s_SQLQuery .= "VTA_Documento.ImpresionGuiaRemFlag = '".$this->getImpresionGuiaRemFlag()."' AND ";
        if ( !is_null( $this->getFechaImpresionGuiRem() ) ) $s_SQLQuery .= "VTA_Documento.FechaImpresionGuiRem = '".$this->getFechaImpresionGuiRem()."' AND ";
        if ( !is_null( $this->getNumeroRefAdicional1() ) ) $s_SQLQuery .= "VTA_Documento.NumeroRefAdicional1 = '".$this->getNumeroRefAdicional1()."' AND ";
        if ( !is_null( $this->getFechaRefAdicional1() ) ) $s_SQLQuery .= "VTA_Documento.FechaRefAdicional1 = '".$this->getFechaRefAdicional1()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "VTA_Documento.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getAnulacionComentario() ) ) $s_SQLQuery .= "VTA_Documento.AnulacionComentario = '".$this->getAnulacionComentario()."' AND ";
        if ( !is_null( $this->getCanalVenta() ) ) $s_SQLQuery .= "VTA_Documento.CanalVenta = '".$this->getCanalVenta()."' AND ";
        if ( !is_null( $this->getFechaCobranza() ) ) $s_SQLQuery .= "VTA_Documento.FechaCobranza = '".$this->getFechaCobranza()."' AND ";
        if ( !is_null( $this->getCobranzaEstado() ) ) $s_SQLQuery .= "VTA_Documento.CobranzaEstado = '".$this->getCobranzaEstado()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "VTA_Documento.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getComision() ) ) $s_SQLQuery .= "VTA_Documento.Comision = '".$this->getComision()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "VTA_Documento.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "VTA_Documento.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_Documento.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_Documento.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_Documento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_DocumentoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_Documento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_DocumentoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_DocumentoBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_DocumentoBN[] = $o_VTA_DocumentoBN;
            }
        }
        return $a_VTA_DocumentoBN;
    }

    /* Devuelve un objeto VTA_DocumentoBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_Documento )
    {
        $o_VTA_DocumentoBN = new VTA_DocumentoBN();
        if ( !is_null( $a_VTA_Documento['IdTipoDocumento'] ) ) $o_VTA_DocumentoBN->setIdTipoDocumento( $a_VTA_Documento['IdTipoDocumento'] );
        if ( !is_null( $a_VTA_Documento['IdCompania'] ) ) $o_VTA_DocumentoBN->setIdCompania( ( integer ) $a_VTA_Documento['IdCompania'] );
        if ( !is_null( $a_VTA_Documento['NumeroDocumento'] ) ) $o_VTA_DocumentoBN->setNumeroDocumento( $a_VTA_Documento['NumeroDocumento'] );
        if ( !is_null( $a_VTA_Documento['Sucursal'] ) ) $o_VTA_DocumentoBN->setSucursal( $a_VTA_Documento['Sucursal'] );
        if ( !is_null( $a_VTA_Documento['IdAlmacen'] ) ) $o_VTA_DocumentoBN->setIdAlmacen( $a_VTA_Documento['IdAlmacen'] );
        if ( !is_null( $a_VTA_Documento['AlmacenDespacho'] ) ) $o_VTA_DocumentoBN->setAlmacenDespacho( $a_VTA_Documento['AlmacenDespacho'] );
        if ( !is_null( $a_VTA_Documento['IdFormaPago'] ) ) $o_VTA_DocumentoBN->setIdFormaPago( $a_VTA_Documento['IdFormaPago'] );
        if ( !is_null( $a_VTA_Documento['FormaPagoCod'] ) ) $o_VTA_DocumentoBN->setFormaPagoCod( $a_VTA_Documento['FormaPagoCod'] );
        if ( !is_null( $a_VTA_Documento['TerminoPago'] ) ) $o_VTA_DocumentoBN->setTerminoPago( ( integer ) $a_VTA_Documento['TerminoPago'] );
        if ( !is_null( $a_VTA_Documento['IdCierre'] ) ) $o_VTA_DocumentoBN->setIdCierre( ( integer ) $a_VTA_Documento['IdCierre'] );
        if ( !is_null( $a_VTA_Documento['IdCaja'] ) ) $o_VTA_DocumentoBN->setIdCaja( ( integer ) $a_VTA_Documento['IdCaja'] );
        if ( !is_null( $a_VTA_Documento['IdTurno'] ) ) $o_VTA_DocumentoBN->setIdTurno( ( integer ) $a_VTA_Documento['IdTurno'] );
        if ( !is_null( $a_VTA_Documento['IdProyecto'] ) ) $o_VTA_DocumentoBN->setIdProyecto( ( integer ) $a_VTA_Documento['IdProyecto'] );
        if ( !is_null( $a_VTA_Documento['IdMotivo'] ) ) $o_VTA_DocumentoBN->setIdMotivo( ( integer ) $a_VTA_Documento['IdMotivo'] );
        if ( !is_null( $a_VTA_Documento['DocumentoCod'] ) ) $o_VTA_DocumentoBN->setDocumentoCod( $a_VTA_Documento['DocumentoCod'] );
        if ( !is_null( $a_VTA_Documento['DocumentoSerie'] ) ) $o_VTA_DocumentoBN->setDocumentoSerie( $a_VTA_Documento['DocumentoSerie'] );
        if ( !is_null( $a_VTA_Documento['DocumentoNumero'] ) ) $o_VTA_DocumentoBN->setDocumentoNumero( $a_VTA_Documento['DocumentoNumero'] );
        if ( !is_null( $a_VTA_Documento['NumeroComprobante'] ) ) $o_VTA_DocumentoBN->setNumeroComprobante( $a_VTA_Documento['NumeroComprobante'] );
        if ( !is_null( $a_VTA_Documento['Periodo'] ) ) $o_VTA_DocumentoBN->setPeriodo( $a_VTA_Documento['Periodo'] );
        if ( !is_null( $a_VTA_Documento['FechaDocumento'] ) ) $o_VTA_DocumentoBN->setFechaDocumento( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaDocumento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['FechaVencimiento'] ) ) $o_VTA_DocumentoBN->setFechaVencimiento( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaVencimiento'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['DocumentoParentId'] ) ) $o_VTA_DocumentoBN->setDocumentoParentId( ( integer ) $a_VTA_Documento['DocumentoParentId'] );
        if ( !is_null( $a_VTA_Documento['DocumentoParentCod'] ) ) $o_VTA_DocumentoBN->setDocumentoParentCod( $a_VTA_Documento['DocumentoParentCod'] );
        if ( !is_null( $a_VTA_Documento['ClienteNumero'] ) ) $o_VTA_DocumentoBN->setClienteNumero( $a_VTA_Documento['ClienteNumero'] );
        if ( !is_null( $a_VTA_Documento['ClienteTipoDoc'] ) ) $o_VTA_DocumentoBN->setClienteTipoDoc( $a_VTA_Documento['ClienteTipoDoc'] );
        if ( !is_null( $a_VTA_Documento['ClienteRUC'] ) ) $o_VTA_DocumentoBN->setClienteRUC( $a_VTA_Documento['ClienteRUC'] );
        if ( !is_null( $a_VTA_Documento['ClienteNombre'] ) ) $o_VTA_DocumentoBN->setClienteNombre( $a_VTA_Documento['ClienteNombre'] );
        if ( !is_null( $a_VTA_Documento['ClienteDireccionSecuencia'] ) ) $o_VTA_DocumentoBN->setClienteDireccionSecuencia( ( float ) $a_VTA_Documento['ClienteDireccionSecuencia'] );
        if ( !is_null( $a_VTA_Documento['ClienteDireccion'] ) ) $o_VTA_DocumentoBN->setClienteDireccion( $a_VTA_Documento['ClienteDireccion'] );
        if ( !is_null( $a_VTA_Documento['ClienteReferencia'] ) ) $o_VTA_DocumentoBN->setClienteReferencia( $a_VTA_Documento['ClienteReferencia'] );
        if ( !is_null( $a_VTA_Documento['ClienteContacto'] ) ) $o_VTA_DocumentoBN->setClienteContacto( $a_VTA_Documento['ClienteContacto'] );
        if ( !is_null( $a_VTA_Documento['Departamento'] ) ) $o_VTA_DocumentoBN->setDepartamento( $a_VTA_Documento['Departamento'] );
        if ( !is_null( $a_VTA_Documento['Provincia'] ) ) $o_VTA_DocumentoBN->setProvincia( $a_VTA_Documento['Provincia'] );
        if ( !is_null( $a_VTA_Documento['Distrito'] ) ) $o_VTA_DocumentoBN->setDistrito( $a_VTA_Documento['Distrito'] );
        if ( !is_null( $a_VTA_Documento['Ubigeo'] ) ) $o_VTA_DocumentoBN->setUbigeo( $a_VTA_Documento['Ubigeo'] );
        if ( !is_null( $a_VTA_Documento['TipoFacturacion'] ) ) $o_VTA_DocumentoBN->setTipoFacturacion( $a_VTA_Documento['TipoFacturacion'] );
        if ( !is_null( $a_VTA_Documento['OrdenCompraRef'] ) ) $o_VTA_DocumentoBN->setOrdenCompraRef( $a_VTA_Documento['OrdenCompraRef'] );
        if ( !is_null( $a_VTA_Documento['TipoVenta'] ) ) $o_VTA_DocumentoBN->setTipoVenta( $a_VTA_Documento['TipoVenta'] );
        if ( !is_null( $a_VTA_Documento['Vendedor'] ) ) $o_VTA_DocumentoBN->setVendedor( $a_VTA_Documento['Vendedor'] );
        if ( !is_null( $a_VTA_Documento['DetraccionTipoId'] ) ) $o_VTA_DocumentoBN->setDetraccionTipoId( ( integer ) $a_VTA_Documento['DetraccionTipoId'] );
        if ( !is_null( $a_VTA_Documento['DetraccionPorcentaje'] ) ) $o_VTA_DocumentoBN->setDetraccionPorcentaje( ( float ) $a_VTA_Documento['DetraccionPorcentaje'] );
        if ( !is_null( $a_VTA_Documento['DetraccionMedPagoId'] ) ) $o_VTA_DocumentoBN->setDetraccionMedPagoId( ( integer ) $a_VTA_Documento['DetraccionMedPagoId'] );
        if ( !is_null( $a_VTA_Documento['DetraccionTotal'] ) ) $o_VTA_DocumentoBN->setDetraccionTotal( ( float ) $a_VTA_Documento['DetraccionTotal'] );
        if ( !is_null( $a_VTA_Documento['EsAgenteRetenedor'] ) ) $o_VTA_DocumentoBN->setEsAgenteRetenedor( ( integer ) $a_VTA_Documento['EsAgenteRetenedor'] );
        if ( !is_null( $a_VTA_Documento['RetencionTipoId'] ) ) $o_VTA_DocumentoBN->setRetencionTipoId( ( integer ) $a_VTA_Documento['RetencionTipoId'] );
        if ( !is_null( $a_VTA_Documento['RetencionBaseImponible'] ) ) $o_VTA_DocumentoBN->setRetencionBaseImponible( ( float ) $a_VTA_Documento['RetencionBaseImponible'] );
        if ( !is_null( $a_VTA_Documento['RetencionPorcentaje'] ) ) $o_VTA_DocumentoBN->setRetencionPorcentaje( ( float ) $a_VTA_Documento['RetencionPorcentaje'] );
        if ( !is_null( $a_VTA_Documento['RetencionTotal'] ) ) $o_VTA_DocumentoBN->setRetencionTotal( ( float ) $a_VTA_Documento['RetencionTotal'] );
        if ( !is_null( $a_VTA_Documento['TipodeCambio'] ) ) $o_VTA_DocumentoBN->setTipodeCambio( ( float ) $a_VTA_Documento['TipodeCambio'] );
        if ( !is_null( $a_VTA_Documento['MonedaDocumento'] ) ) $o_VTA_DocumentoBN->setMonedaDocumento( $a_VTA_Documento['MonedaDocumento'] );
        if ( !is_null( $a_VTA_Documento['MontoSubTotal'] ) ) $o_VTA_DocumentoBN->setMontoSubTotal( ( float ) $a_VTA_Documento['MontoSubTotal'] );
        if ( !is_null( $a_VTA_Documento['MontoSubTotalMN'] ) ) $o_VTA_DocumentoBN->setMontoSubTotalMN( ( float ) $a_VTA_Documento['MontoSubTotalMN'] );
        if ( !is_null( $a_VTA_Documento['MontoAfecto'] ) ) $o_VTA_DocumentoBN->setMontoAfecto( ( float ) $a_VTA_Documento['MontoAfecto'] );
        if ( !is_null( $a_VTA_Documento['MontoAfectoMN'] ) ) $o_VTA_DocumentoBN->setMontoAfectoMN( ( float ) $a_VTA_Documento['MontoAfectoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoNoAfecto'] ) ) $o_VTA_DocumentoBN->setMontoNoAfecto( ( float ) $a_VTA_Documento['MontoNoAfecto'] );
        if ( !is_null( $a_VTA_Documento['MontoNoAfectoMN'] ) ) $o_VTA_DocumentoBN->setMontoNoAfectoMN( ( float ) $a_VTA_Documento['MontoNoAfectoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoExonerado'] ) ) $o_VTA_DocumentoBN->setMontoExonerado( ( float ) $a_VTA_Documento['MontoExonerado'] );
        if ( !is_null( $a_VTA_Documento['MontoExoneradoMN'] ) ) $o_VTA_DocumentoBN->setMontoExoneradoMN( ( float ) $a_VTA_Documento['MontoExoneradoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoGratuito'] ) ) $o_VTA_DocumentoBN->setMontoGratuito( ( float ) $a_VTA_Documento['MontoGratuito'] );
        if ( !is_null( $a_VTA_Documento['MontoGratuitoMN'] ) ) $o_VTA_DocumentoBN->setMontoGratuitoMN( ( float ) $a_VTA_Documento['MontoGratuitoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoImpuestos'] ) ) $o_VTA_DocumentoBN->setMontoImpuestos( ( float ) $a_VTA_Documento['MontoImpuestos'] );
        if ( !is_null( $a_VTA_Documento['MontoImpuestoMN'] ) ) $o_VTA_DocumentoBN->setMontoImpuestoMN( ( float ) $a_VTA_Documento['MontoImpuestoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoDescuentos'] ) ) $o_VTA_DocumentoBN->setMontoDescuentos( ( float ) $a_VTA_Documento['MontoDescuentos'] );
        if ( !is_null( $a_VTA_Documento['MontoDescuentosMN'] ) ) $o_VTA_DocumentoBN->setMontoDescuentosMN( ( float ) $a_VTA_Documento['MontoDescuentosMN'] );
        if ( !is_null( $a_VTA_Documento['MontoDescuentoLinea'] ) ) $o_VTA_DocumentoBN->setMontoDescuentoLinea( ( float ) $a_VTA_Documento['MontoDescuentoLinea'] );
        if ( !is_null( $a_VTA_Documento['MontoDescuentoLineaMN'] ) ) $o_VTA_DocumentoBN->setMontoDescuentoLineaMN( ( float ) $a_VTA_Documento['MontoDescuentoLineaMN'] );
        if ( !is_null( $a_VTA_Documento['MontoAnticipo'] ) ) $o_VTA_DocumentoBN->setMontoAnticipo( ( float ) $a_VTA_Documento['MontoAnticipo'] );
        if ( !is_null( $a_VTA_Documento['MontoAnticipoMN'] ) ) $o_VTA_DocumentoBN->setMontoAnticipoMN( ( float ) $a_VTA_Documento['MontoAnticipoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoRedondeo'] ) ) $o_VTA_DocumentoBN->setMontoRedondeo( ( float ) $a_VTA_Documento['MontoRedondeo'] );
        if ( !is_null( $a_VTA_Documento['MontoRedondeoMN'] ) ) $o_VTA_DocumentoBN->setMontoRedondeoMN( ( float ) $a_VTA_Documento['MontoRedondeoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoTotal'] ) ) $o_VTA_DocumentoBN->setMontoTotal( ( float ) $a_VTA_Documento['MontoTotal'] );
        if ( !is_null( $a_VTA_Documento['MontoTotalMN'] ) ) $o_VTA_DocumentoBN->setMontoTotalMN( ( float ) $a_VTA_Documento['MontoTotalMN'] );
        if ( !is_null( $a_VTA_Documento['MontoPagado'] ) ) $o_VTA_DocumentoBN->setMontoPagado( ( float ) $a_VTA_Documento['MontoPagado'] );
        if ( !is_null( $a_VTA_Documento['MontoPagadoMN'] ) ) $o_VTA_DocumentoBN->setMontoPagadoMN( ( float ) $a_VTA_Documento['MontoPagadoMN'] );
        if ( !is_null( $a_VTA_Documento['MontoSaldo'] ) ) $o_VTA_DocumentoBN->setMontoSaldo( ( float ) $a_VTA_Documento['MontoSaldo'] );
        if ( !is_null( $a_VTA_Documento['MontoSaldoMN'] ) ) $o_VTA_DocumentoBN->setMontoSaldoMN( ( float ) $a_VTA_Documento['MontoSaldoMN'] );
        if ( !is_null( $a_VTA_Documento['FechaFacturacion'] ) ) $o_VTA_DocumentoBN->setFechaFacturacion( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaFacturacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['FechaAprobacion'] ) ) $o_VTA_DocumentoBN->setFechaAprobacion( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaAprobacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['NotaCreditoDocumento'] ) ) $o_VTA_DocumentoBN->setNotaCreditoDocumento( $a_VTA_Documento['NotaCreditoDocumento'] );
        if ( !is_null( $a_VTA_Documento['NotaDebitoDocumento'] ) ) $o_VTA_DocumentoBN->setNotaDebitoDocumento( $a_VTA_Documento['NotaDebitoDocumento'] );
        if ( !is_null( $a_VTA_Documento['ImpresionPendienteFlag'] ) ) $o_VTA_DocumentoBN->setImpresionPendienteFlag( $a_VTA_Documento['ImpresionPendienteFlag'] );
        if ( !is_null( $a_VTA_Documento['FechaImpresion'] ) ) $o_VTA_DocumentoBN->setFechaImpresion( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaImpresion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['ImpresionGuiaRemFlag'] ) ) $o_VTA_DocumentoBN->setImpresionGuiaRemFlag( $a_VTA_Documento['ImpresionGuiaRemFlag'] );
        if ( !is_null( $a_VTA_Documento['FechaImpresionGuiRem'] ) ) $o_VTA_DocumentoBN->setFechaImpresionGuiRem( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaImpresionGuiRem'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['NumeroRefAdicional1'] ) ) $o_VTA_DocumentoBN->setNumeroRefAdicional1( $a_VTA_Documento['NumeroRefAdicional1'] );
        if ( !is_null( $a_VTA_Documento['FechaRefAdicional1'] ) ) $o_VTA_DocumentoBN->setFechaRefAdicional1( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaRefAdicional1'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['Comentario'] ) ) $o_VTA_DocumentoBN->setComentario( $a_VTA_Documento['Comentario'] );
        if ( !is_null( $a_VTA_Documento['AnulacionComentario'] ) ) $o_VTA_DocumentoBN->setAnulacionComentario( $a_VTA_Documento['AnulacionComentario'] );
        if ( !is_null( $a_VTA_Documento['CanalVenta'] ) ) $o_VTA_DocumentoBN->setCanalVenta( $a_VTA_Documento['CanalVenta'] );
        if ( !is_null( $a_VTA_Documento['FechaCobranza'] ) ) $o_VTA_DocumentoBN->setFechaCobranza( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaCobranza'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['CobranzaEstado'] ) ) $o_VTA_DocumentoBN->setCobranzaEstado( $a_VTA_Documento['CobranzaEstado'] );
        if ( !is_null( $a_VTA_Documento['Estado'] ) ) $o_VTA_DocumentoBN->setEstado( $a_VTA_Documento['Estado'] );
        if ( !is_null( $a_VTA_Documento['Comision'] ) ) $o_VTA_DocumentoBN->setComision( $a_VTA_Documento['Comision'] );
        if ( !is_null( $a_VTA_Documento['UsuarioModificacion'] ) ) $o_VTA_DocumentoBN->setUsuarioModificacion( $a_VTA_Documento['UsuarioModificacion'] );
        if ( !is_null( $a_VTA_Documento['FechaModificacion'] ) ) $o_VTA_DocumentoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_VTA_Documento['UsuarioCreacion'] ) ) $o_VTA_DocumentoBN->setUsuarioCreacion( $a_VTA_Documento['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_Documento['FechaCreacion'] ) ) $o_VTA_DocumentoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_Documento['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_DocumentoBN;
    }
}
?>