<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: VTA_DocumentoCuotas.xml */
/* Generado: 2022-09-29 19:36:24 */

/* Busqueda de registros de la tabla VTA_DocumentoCuotas. */
abstract class BaseVTA_DocumentoCuotasFN extends VTA_DocumentoCuotasBN
{
    /* Declaracion de constantes */
    const CuotaId = "VTA_DocumentoCuotas.CuotaId";
    const NumeroDocumentoId = "VTA_DocumentoCuotas.NumeroDocumentoId";
    const CuotaMonto = "VTA_DocumentoCuotas.CuotaMonto";
    const CuotaFecha = "VTA_DocumentoCuotas.CuotaFecha";
    const UsuarioCreacion = "VTA_DocumentoCuotas.UsuarioCreacion";
    const FechaCreacion = "VTA_DocumentoCuotas.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "VTA_DocumentoCuotas.CuotaId AS CuotaId, ";
        $s_SQLQuery .= "VTA_DocumentoCuotas.NumeroDocumentoId AS NumeroDocumentoId, ";
        $s_SQLQuery .= "VTA_DocumentoCuotas.CuotaMonto AS CuotaMonto, ";
        $s_SQLQuery .= "VTA_DocumentoCuotas.CuotaFecha AS CuotaFecha, ";
        $s_SQLQuery .= "VTA_DocumentoCuotas.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "VTA_DocumentoCuotas.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto VTA_DocumentoCuotasBN */
    public function setByBN( VTA_DocumentoCuotasBN $o_VTA_DocumentoCuotasBN )
    {
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getCuotaId() ) )
        {
            $this->setCuotaId( $o_VTA_DocumentoCuotasBN->getCuotaId() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getNumeroDocumentoId() ) )
        {
            $this->setNumeroDocumentoId( $o_VTA_DocumentoCuotasBN->getNumeroDocumentoId() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getCuotaMonto() ) )
        {
            $this->setCuotaMonto( $o_VTA_DocumentoCuotasBN->getCuotaMonto() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getCuotaFecha() ) )
        {
            $this->setCuotaFecha( $o_VTA_DocumentoCuotasBN->getCuotaFecha() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_VTA_DocumentoCuotasBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_VTA_DocumentoCuotasBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_VTA_DocumentoCuotasBN->getFechaCreacion() );
        }
    }

    /**
    * @return VTA_DocumentoCuotasBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_CuotaId )
    {
        if( is_null( $i_CuotaId ) ){ $i_CuotaId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_DocumentoCuotas ";
        $s_SQLQuery .= "WHERE CuotaId = ".$i_CuotaId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_VTA_DocumentoCuotasBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_VTA_DocumentoCuotasBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_VTA_DocumentoCuotasBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getCuotaId() ) ) $s_SQLQuery .= "VTA_DocumentoCuotas.CuotaId = ".$this->getCuotaId()." AND ";
        if ( !is_null( $this->getNumeroDocumentoId() ) ) $s_SQLQuery .= "VTA_DocumentoCuotas.NumeroDocumentoId = ".$this->getNumeroDocumentoId()." AND ";
        if ( !is_null( $this->getCuotaMonto() ) ) $s_SQLQuery .= "VTA_DocumentoCuotas.CuotaMonto = ".$this->getCuotaMonto()." AND ";
        if ( !is_null( $this->getCuotaFecha() ) ) $s_SQLQuery .= "VTA_DocumentoCuotas.CuotaFecha = '".$this->getCuotaFecha()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "VTA_DocumentoCuotas.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "VTA_DocumentoCuotas.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM VTA_DocumentoCuotas WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return VTA_DocumentoCuotasBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM VTA_DocumentoCuotas WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_VTA_DocumentoCuotasBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_VTA_DocumentoCuotasBN = $this->insertObjectBN( $a_SQLRow );
                $a_VTA_DocumentoCuotasBN[] = $o_VTA_DocumentoCuotasBN;
            }
        }
        return $a_VTA_DocumentoCuotasBN;
    }

    /* Devuelve un objeto VTA_DocumentoCuotasBN desde un objeto propel */
    public function insertObjectBN( $a_VTA_DocumentoCuotas )
    {
        $o_VTA_DocumentoCuotasBN = new VTA_DocumentoCuotasBN();
        if ( !is_null( $a_VTA_DocumentoCuotas['CuotaId'] ) ) $o_VTA_DocumentoCuotasBN->setCuotaId( ( integer ) $a_VTA_DocumentoCuotas['CuotaId'] );
        if ( !is_null( $a_VTA_DocumentoCuotas['NumeroDocumentoId'] ) ) $o_VTA_DocumentoCuotasBN->setNumeroDocumentoId( ( integer ) $a_VTA_DocumentoCuotas['NumeroDocumentoId'] );
        if ( !is_null( $a_VTA_DocumentoCuotas['CuotaMonto'] ) ) $o_VTA_DocumentoCuotasBN->setCuotaMonto( ( float ) $a_VTA_DocumentoCuotas['CuotaMonto'] );
        if ( !is_null( $a_VTA_DocumentoCuotas['CuotaFecha'] ) ) $o_VTA_DocumentoCuotasBN->setCuotaFecha( utilTimestamp::getTimestamp( $a_VTA_DocumentoCuotas['CuotaFecha'], "Y-m-d" ) );
        if ( !is_null( $a_VTA_DocumentoCuotas['UsuarioCreacion'] ) ) $o_VTA_DocumentoCuotasBN->setUsuarioCreacion( $a_VTA_DocumentoCuotas['UsuarioCreacion'] );
        if ( !is_null( $a_VTA_DocumentoCuotas['FechaCreacion'] ) ) $o_VTA_DocumentoCuotasBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_VTA_DocumentoCuotas['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_VTA_DocumentoCuotasBN;
    }
}
?>