<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Turno.xml */
/* Generado: 2021-06-27 08:02:02 */

/* Busqueda de registros de la tabla TR_Turno. */
abstract class BaseTR_TurnoFN extends TR_TurnoBN
{
    /* Declaracion de constantes */
    const IdTurno = "TR_Turno.IdTurno";
    const IdCompania = "TR_Turno.IdCompania";
    const IdSucursal = "TR_Turno.IdSucursal";
    const TurnoDescripcion = "TR_Turno.TurnoDescripcion";
    const TurnoDescHora = "TR_Turno.TurnoDescHora";
    const TurnoDescMin = "TR_Turno.TurnoDescMin";
    const Estado = "TR_Turno.Estado";
    const FechaCreacion = "TR_Turno.FechaCreacion";
    const UsuarioCreacion = "TR_Turno.UsuarioCreacion";
    const FechaModificacion = "TR_Turno.FechaModificacion";
    const UsuarioModificacion = "TR_Turno.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "TR_Turno.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "TR_Turno.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "TR_Turno.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "TR_Turno.TurnoDescripcion AS TurnoDescripcion, ";
        $s_SQLQuery .= "TR_Turno.TurnoDescHora AS TurnoDescHora, ";
        $s_SQLQuery .= "TR_Turno.TurnoDescMin AS TurnoDescMin, ";
        $s_SQLQuery .= "TR_Turno.Estado AS Estado, ";
        $s_SQLQuery .= "TR_Turno.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "TR_Turno.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "TR_Turno.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "TR_Turno.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto TR_TurnoBN */
    public function setByBN( TR_TurnoBN $o_TR_TurnoBN )
    {
        if ( !is_null( $o_TR_TurnoBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_TR_TurnoBN->getIdTurno() );
        }
        if ( !is_null( $o_TR_TurnoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_TR_TurnoBN->getIdCompania() );
        }
        if ( !is_null( $o_TR_TurnoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_TR_TurnoBN->getIdSucursal() );
        }
        if ( !is_null( $o_TR_TurnoBN->getTurnoDescripcion() ) )
        {
            $this->setTurnoDescripcion( $o_TR_TurnoBN->getTurnoDescripcion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getTurnoDescHora() ) )
        {
            $this->setTurnoDescHora( $o_TR_TurnoBN->getTurnoDescHora() );
        }
        if ( !is_null( $o_TR_TurnoBN->getTurnoDescMin() ) )
        {
            $this->setTurnoDescMin( $o_TR_TurnoBN->getTurnoDescMin() );
        }
        if ( !is_null( $o_TR_TurnoBN->getEstado() ) )
        {
            $this->setEstado( $o_TR_TurnoBN->getEstado() );
        }
        if ( !is_null( $o_TR_TurnoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_TurnoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_TurnoBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_TurnoBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_TurnoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_TurnoBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return TR_TurnoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdTurno )
    {
        if( is_null( $i_IdTurno ) ){ $i_IdTurno = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Turno ";
        $s_SQLQuery .= "WHERE IdTurno = ".$i_IdTurno." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_TR_TurnoBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_TR_TurnoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_TR_TurnoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "TR_Turno.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "TR_Turno.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "TR_Turno.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getTurnoDescripcion() ) ) $s_SQLQuery .= "TR_Turno.TurnoDescripcion = '".$this->getTurnoDescripcion()."' AND ";
        if ( !is_null( $this->getTurnoDescHora() ) ) $s_SQLQuery .= "TR_Turno.TurnoDescHora = ".$this->getTurnoDescHora()." AND ";
        if ( !is_null( $this->getTurnoDescMin() ) ) $s_SQLQuery .= "TR_Turno.TurnoDescMin = ".$this->getTurnoDescMin()." AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "TR_Turno.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "TR_Turno.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "TR_Turno.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "TR_Turno.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "TR_Turno.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM TR_Turno WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return TR_TurnoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Turno WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_TR_TurnoBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_TR_TurnoBN = $this->insertObjectBN( $a_SQLRow );
                $a_TR_TurnoBN[] = $o_TR_TurnoBN;
            }
        }
        return $a_TR_TurnoBN;
    }

    /* Devuelve un objeto TR_TurnoBN desde un objeto propel */
    public function insertObjectBN( $a_TR_Turno )
    {
        $o_TR_TurnoBN = new TR_TurnoBN();
        if ( !is_null( $a_TR_Turno['IdTurno'] ) ) $o_TR_TurnoBN->setIdTurno( ( integer ) $a_TR_Turno['IdTurno'] );
        if ( !is_null( $a_TR_Turno['IdCompania'] ) ) $o_TR_TurnoBN->setIdCompania( ( integer ) $a_TR_Turno['IdCompania'] );
        if ( !is_null( $a_TR_Turno['IdSucursal'] ) ) $o_TR_TurnoBN->setIdSucursal( ( integer ) $a_TR_Turno['IdSucursal'] );
        if ( !is_null( $a_TR_Turno['TurnoDescripcion'] ) ) $o_TR_TurnoBN->setTurnoDescripcion( $a_TR_Turno['TurnoDescripcion'] );
        if ( !is_null( $a_TR_Turno['TurnoDescHora'] ) ) $o_TR_TurnoBN->setTurnoDescHora( ( integer ) $a_TR_Turno['TurnoDescHora'] );
        if ( !is_null( $a_TR_Turno['TurnoDescMin'] ) ) $o_TR_TurnoBN->setTurnoDescMin( ( integer ) $a_TR_Turno['TurnoDescMin'] );
        if ( !is_null( $a_TR_Turno['Estado'] ) ) $o_TR_TurnoBN->setEstado( $a_TR_Turno['Estado'] );
        if ( !is_null( $a_TR_Turno['FechaCreacion'] ) ) $o_TR_TurnoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_TR_Turno['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Turno['UsuarioCreacion'] ) ) $o_TR_TurnoBN->setUsuarioCreacion( $a_TR_Turno['UsuarioCreacion'] );
        if ( !is_null( $a_TR_Turno['FechaModificacion'] ) ) $o_TR_TurnoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_TR_Turno['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Turno['UsuarioModificacion'] ) ) $o_TR_TurnoBN->setUsuarioModificacion( $a_TR_Turno['UsuarioModificacion'] );
        return $o_TR_TurnoBN;
    }
}
?>