<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_Ruta.xml */
/* Generado: 2020-08-18 04:21:31 */

/* Busqueda de registros de la tabla TR_Ruta. */
abstract class BaseTR_RutaFN extends TR_RutaBN
{
    /* Declaracion de constantes */
    const IdRuta = "TR_Ruta.IdRuta";
    const IdCompania = "TR_Ruta.IdCompania";
    const IdSucursal = "TR_Ruta.IdSucursal";
    const RutaDocumento = "TR_Ruta.RutaDocumento";
    const RutaFechaProgramada = "TR_Ruta.RutaFechaProgramada";
    const IdTurno = "TR_Ruta.IdTurno";
    const IdVehiculo = "TR_Ruta.IdVehiculo";
    const IdChofer = "TR_Ruta.IdChofer";
    const RutaFechaEmision = "TR_Ruta.RutaFechaEmision";
    const RutaFechaPartida = "TR_Ruta.RutaFechaPartida";
    const RutaFechaLlegada = "TR_Ruta.RutaFechaLlegada";
    const RutaComentario = "TR_Ruta.RutaComentario";
    const Estado = "TR_Ruta.Estado";
    const FechaCreacion = "TR_Ruta.FechaCreacion";
    const UsuarioCreacion = "TR_Ruta.UsuarioCreacion";
    const FechaModificacion = "TR_Ruta.FechaModificacion";
    const UsuarioModificacion = "TR_Ruta.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "TR_Ruta.IdRuta AS IdRuta, ";
        $s_SQLQuery .= "TR_Ruta.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "TR_Ruta.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "TR_Ruta.RutaDocumento AS RutaDocumento, ";
        $s_SQLQuery .= "TR_Ruta.RutaFechaProgramada AS RutaFechaProgramada, ";
        $s_SQLQuery .= "TR_Ruta.IdTurno AS IdTurno, ";
        $s_SQLQuery .= "TR_Ruta.IdVehiculo AS IdVehiculo, ";
        $s_SQLQuery .= "TR_Ruta.IdChofer AS IdChofer, ";
        $s_SQLQuery .= "TR_Ruta.RutaFechaEmision AS RutaFechaEmision, ";
        $s_SQLQuery .= "TR_Ruta.RutaFechaPartida AS RutaFechaPartida, ";
        $s_SQLQuery .= "TR_Ruta.RutaFechaLlegada AS RutaFechaLlegada, ";
        $s_SQLQuery .= "TR_Ruta.RutaComentario AS RutaComentario, ";
        $s_SQLQuery .= "TR_Ruta.Estado AS Estado, ";
        $s_SQLQuery .= "TR_Ruta.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "TR_Ruta.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "TR_Ruta.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "TR_Ruta.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto TR_RutaBN */
    public function setByBN( TR_RutaBN $o_TR_RutaBN )
    {
        if ( !is_null( $o_TR_RutaBN->getIdRuta() ) )
        {
            $this->setIdRuta( $o_TR_RutaBN->getIdRuta() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_TR_RutaBN->getIdCompania() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_TR_RutaBN->getIdSucursal() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaDocumento() ) )
        {
            $this->setRutaDocumento( $o_TR_RutaBN->getRutaDocumento() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaProgramada() ) )
        {
            $this->setRutaFechaProgramada( $o_TR_RutaBN->getRutaFechaProgramada() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdTurno() ) )
        {
            $this->setIdTurno( $o_TR_RutaBN->getIdTurno() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdVehiculo() ) )
        {
            $this->setIdVehiculo( $o_TR_RutaBN->getIdVehiculo() );
        }
        if ( !is_null( $o_TR_RutaBN->getIdChofer() ) )
        {
            $this->setIdChofer( $o_TR_RutaBN->getIdChofer() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaEmision() ) )
        {
            $this->setRutaFechaEmision( $o_TR_RutaBN->getRutaFechaEmision() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaPartida() ) )
        {
            $this->setRutaFechaPartida( $o_TR_RutaBN->getRutaFechaPartida() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaFechaLlegada() ) )
        {
            $this->setRutaFechaLlegada( $o_TR_RutaBN->getRutaFechaLlegada() );
        }
        if ( !is_null( $o_TR_RutaBN->getRutaComentario() ) )
        {
            $this->setRutaComentario( $o_TR_RutaBN->getRutaComentario() );
        }
        if ( !is_null( $o_TR_RutaBN->getEstado() ) )
        {
            $this->setEstado( $o_TR_RutaBN->getEstado() );
        }
        if ( !is_null( $o_TR_RutaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_TR_RutaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_TR_RutaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_TR_RutaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_TR_RutaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_TR_RutaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_TR_RutaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_TR_RutaBN->getUsuarioModificacion() );
        }
    }

    /* Busca un registro por su llave primaria */
    public function selectByPK( $i_IdRuta )
    {
        if( is_null( $i_IdRuta ) ){ $i_IdRuta = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Ruta ";
        $s_SQLQuery .= "WHERE IdRuta = ".$i_IdRuta." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_TR_RutaBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_TR_RutaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_TR_RutaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRuta() ) ) $s_SQLQuery .= "TR_Ruta.IdRuta = ".$this->getIdRuta()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "TR_Ruta.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "TR_Ruta.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getRutaDocumento() ) ) $s_SQLQuery .= "TR_Ruta.RutaDocumento = '".$this->getRutaDocumento()."' AND ";
        if ( !is_null( $this->getRutaFechaProgramada() ) ) $s_SQLQuery .= "TR_Ruta.RutaFechaProgramada = '".$this->getRutaFechaProgramada()."' AND ";
        if ( !is_null( $this->getIdTurno() ) ) $s_SQLQuery .= "TR_Ruta.IdTurno = ".$this->getIdTurno()." AND ";
        if ( !is_null( $this->getIdVehiculo() ) ) $s_SQLQuery .= "TR_Ruta.IdVehiculo = ".$this->getIdVehiculo()." AND ";
        if ( !is_null( $this->getIdChofer() ) ) $s_SQLQuery .= "TR_Ruta.IdChofer = ".$this->getIdChofer()." AND ";
        if ( !is_null( $this->getRutaFechaEmision() ) ) $s_SQLQuery .= "TR_Ruta.RutaFechaEmision = '".$this->getRutaFechaEmision()."' AND ";
        if ( !is_null( $this->getRutaFechaPartida() ) ) $s_SQLQuery .= "TR_Ruta.RutaFechaPartida = '".$this->getRutaFechaPartida()."' AND ";
        if ( !is_null( $this->getRutaFechaLlegada() ) ) $s_SQLQuery .= "TR_Ruta.RutaFechaLlegada = '".$this->getRutaFechaLlegada()."' AND ";
        if ( !is_null( $this->getRutaComentario() ) ) $s_SQLQuery .= "TR_Ruta.RutaComentario = '".$this->getRutaComentario()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "TR_Ruta.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "TR_Ruta.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "TR_Ruta.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "TR_Ruta.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "TR_Ruta.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM TR_Ruta WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /* Busca varios registros por los campos establecidos */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_Ruta WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_TR_RutaBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_TR_RutaBN = $this->insertObjectBN( $a_SQLRow );
                $a_TR_RutaBN[] = $o_TR_RutaBN;
            }
        }
        return $a_TR_RutaBN;
    }

    /* Devuelve un objeto TR_RutaBN desde un objeto propel */
    public function insertObjectBN( $a_TR_Ruta )
    {
        $o_TR_RutaBN = new TR_RutaBN();
        if ( !is_null( $a_TR_Ruta['IdRuta'] ) ) $o_TR_RutaBN->setIdRuta( ( integer ) $a_TR_Ruta['IdRuta'] );
        if ( !is_null( $a_TR_Ruta['IdCompania'] ) ) $o_TR_RutaBN->setIdCompania( ( integer ) $a_TR_Ruta['IdCompania'] );
        if ( !is_null( $a_TR_Ruta['IdSucursal'] ) ) $o_TR_RutaBN->setIdSucursal( ( integer ) $a_TR_Ruta['IdSucursal'] );
        if ( !is_null( $a_TR_Ruta['RutaDocumento'] ) ) $o_TR_RutaBN->setRutaDocumento( $a_TR_Ruta['RutaDocumento'] );
        if ( !is_null( $a_TR_Ruta['RutaFechaProgramada'] ) ) $o_TR_RutaBN->setRutaFechaProgramada( utilTimestamp::getTimestamp( $a_TR_Ruta['RutaFechaProgramada'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Ruta['IdTurno'] ) ) $o_TR_RutaBN->setIdTurno( ( integer ) $a_TR_Ruta['IdTurno'] );
        if ( !is_null( $a_TR_Ruta['IdVehiculo'] ) ) $o_TR_RutaBN->setIdVehiculo( ( integer ) $a_TR_Ruta['IdVehiculo'] );
        if ( !is_null( $a_TR_Ruta['IdChofer'] ) ) $o_TR_RutaBN->setIdChofer( ( integer ) $a_TR_Ruta['IdChofer'] );
        if ( !is_null( $a_TR_Ruta['RutaFechaEmision'] ) ) $o_TR_RutaBN->setRutaFechaEmision( utilTimestamp::getTimestamp( $a_TR_Ruta['RutaFechaEmision'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Ruta['RutaFechaPartida'] ) ) $o_TR_RutaBN->setRutaFechaPartida( utilTimestamp::getTimestamp( $a_TR_Ruta['RutaFechaPartida'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Ruta['RutaFechaLlegada'] ) ) $o_TR_RutaBN->setRutaFechaLlegada( utilTimestamp::getTimestamp( $a_TR_Ruta['RutaFechaLlegada'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Ruta['RutaComentario'] ) ) $o_TR_RutaBN->setRutaComentario( $a_TR_Ruta['RutaComentario'] );
        if ( !is_null( $a_TR_Ruta['Estado'] ) ) $o_TR_RutaBN->setEstado( $a_TR_Ruta['Estado'] );
        if ( !is_null( $a_TR_Ruta['FechaCreacion'] ) ) $o_TR_RutaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_TR_Ruta['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Ruta['UsuarioCreacion'] ) ) $o_TR_RutaBN->setUsuarioCreacion( $a_TR_Ruta['UsuarioCreacion'] );
        if ( !is_null( $a_TR_Ruta['FechaModificacion'] ) ) $o_TR_RutaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_TR_Ruta['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_TR_Ruta['UsuarioModificacion'] ) ) $o_TR_RutaBN->setUsuarioModificacion( $a_TR_Ruta['UsuarioModificacion'] );
        return $o_TR_RutaBN;
    }
}
?>