<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: TR_RutaDetGuias.xml */
/* Generado: 2021-06-27 08:47:44 */

/* Busqueda de registros de la tabla TR_RutaDetGuias. */
abstract class BaseTR_RutaDetGuiasFN extends TR_RutaDetGuiasBN
{
    /* Declaracion de constantes */
    const DetGuiaId = "TR_RutaDetGuias.DetGuiaId";
    const IdRuta = "TR_RutaDetGuias.IdRuta";
    const IdRutaLinea = "TR_RutaDetGuias.IdRutaLinea";
    const TipoDocumentoRef = "TR_RutaDetGuias.TipoDocumentoRef";
    const SerieDocumentoRef = "TR_RutaDetGuias.SerieDocumentoRef";
    const NumeroDocumentoRef = "TR_RutaDetGuias.NumeroDocumentoRef";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "TR_RutaDetGuias.DetGuiaId AS DetGuiaId, ";
        $s_SQLQuery .= "TR_RutaDetGuias.IdRuta AS IdRuta, ";
        $s_SQLQuery .= "TR_RutaDetGuias.IdRutaLinea AS IdRutaLinea, ";
        $s_SQLQuery .= "TR_RutaDetGuias.TipoDocumentoRef AS TipoDocumentoRef, ";
        $s_SQLQuery .= "TR_RutaDetGuias.SerieDocumentoRef AS SerieDocumentoRef, ";
        $s_SQLQuery .= "TR_RutaDetGuias.NumeroDocumentoRef AS NumeroDocumentoRef ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto TR_RutaDetGuiasBN */
    public function setByBN( TR_RutaDetGuiasBN $o_TR_RutaDetGuiasBN )
    {
        if ( !is_null( $o_TR_RutaDetGuiasBN->getDetGuiaId() ) )
        {
            $this->setDetGuiaId( $o_TR_RutaDetGuiasBN->getDetGuiaId() );
        }
        if ( !is_null( $o_TR_RutaDetGuiasBN->getIdRuta() ) )
        {
            $this->setIdRuta( $o_TR_RutaDetGuiasBN->getIdRuta() );
        }
        if ( !is_null( $o_TR_RutaDetGuiasBN->getIdRutaLinea() ) )
        {
            $this->setIdRutaLinea( $o_TR_RutaDetGuiasBN->getIdRutaLinea() );
        }
        if ( !is_null( $o_TR_RutaDetGuiasBN->getTipoDocumentoRef() ) )
        {
            $this->setTipoDocumentoRef( $o_TR_RutaDetGuiasBN->getTipoDocumentoRef() );
        }
        if ( !is_null( $o_TR_RutaDetGuiasBN->getSerieDocumentoRef() ) )
        {
            $this->setSerieDocumentoRef( $o_TR_RutaDetGuiasBN->getSerieDocumentoRef() );
        }
        if ( !is_null( $o_TR_RutaDetGuiasBN->getNumeroDocumentoRef() ) )
        {
            $this->setNumeroDocumentoRef( $o_TR_RutaDetGuiasBN->getNumeroDocumentoRef() );
        }
    }

    /**
    * @return TR_RutaDetGuiasBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_DetGuiaId )
    {
        if( is_null( $i_DetGuiaId ) ){ $i_DetGuiaId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_RutaDetGuias ";
        $s_SQLQuery .= "WHERE DetGuiaId = ".$i_DetGuiaId." ";
        $s_SQLQuery .= "LIMIT 1;";
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_TR_RutaDetGuiasBN = null;
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_TR_RutaDetGuiasBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_TR_RutaDetGuiasBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getDetGuiaId() ) ) $s_SQLQuery .= "TR_RutaDetGuias.DetGuiaId = ".$this->getDetGuiaId()." AND ";
        if ( !is_null( $this->getIdRuta() ) ) $s_SQLQuery .= "TR_RutaDetGuias.IdRuta = ".$this->getIdRuta()." AND ";
        if ( !is_null( $this->getIdRutaLinea() ) ) $s_SQLQuery .= "TR_RutaDetGuias.IdRutaLinea = ".$this->getIdRutaLinea()." AND ";
        if ( !is_null( $this->getTipoDocumentoRef() ) ) $s_SQLQuery .= "TR_RutaDetGuias.TipoDocumentoRef = '".$this->getTipoDocumentoRef()."' AND ";
        if ( !is_null( $this->getSerieDocumentoRef() ) ) $s_SQLQuery .= "TR_RutaDetGuias.SerieDocumentoRef = '".$this->getSerieDocumentoRef()."' AND ";
        if ( !is_null( $this->getNumeroDocumentoRef() ) ) $s_SQLQuery .= "TR_RutaDetGuias.NumeroDocumentoRef = '".$this->getNumeroDocumentoRef()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM TR_RutaDetGuias WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return TR_RutaDetGuiasBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM TR_RutaDetGuias WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        if( $this->getDebug() ){ pr( $s_SQLQuery ); }

        $a_TR_RutaDetGuiasBN = array();
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_TR_RutaDetGuiasBN = $this->insertObjectBN( $a_SQLRow );
                $a_TR_RutaDetGuiasBN[] = $o_TR_RutaDetGuiasBN;
            }
        }
        return $a_TR_RutaDetGuiasBN;
    }

    /* Devuelve un objeto TR_RutaDetGuiasBN desde un objeto propel */
    public function insertObjectBN( $a_TR_RutaDetGuias )
    {
        $o_TR_RutaDetGuiasBN = new TR_RutaDetGuiasBN();
        if ( !is_null( $a_TR_RutaDetGuias['DetGuiaId'] ) ) $o_TR_RutaDetGuiasBN->setDetGuiaId( ( integer ) $a_TR_RutaDetGuias['DetGuiaId'] );
        if ( !is_null( $a_TR_RutaDetGuias['IdRuta'] ) ) $o_TR_RutaDetGuiasBN->setIdRuta( ( integer ) $a_TR_RutaDetGuias['IdRuta'] );
        if ( !is_null( $a_TR_RutaDetGuias['IdRutaLinea'] ) ) $o_TR_RutaDetGuiasBN->setIdRutaLinea( ( integer ) $a_TR_RutaDetGuias['IdRutaLinea'] );
        if ( !is_null( $a_TR_RutaDetGuias['TipoDocumentoRef'] ) ) $o_TR_RutaDetGuiasBN->setTipoDocumentoRef( $a_TR_RutaDetGuias['TipoDocumentoRef'] );
        if ( !is_null( $a_TR_RutaDetGuias['SerieDocumentoRef'] ) ) $o_TR_RutaDetGuiasBN->setSerieDocumentoRef( $a_TR_RutaDetGuias['SerieDocumentoRef'] );
        if ( !is_null( $a_TR_RutaDetGuias['NumeroDocumentoRef'] ) ) $o_TR_RutaDetGuiasBN->setNumeroDocumentoRef( $a_TR_RutaDetGuias['NumeroDocumentoRef'] );
        return $o_TR_RutaDetGuiasBN;
    }
}
?>