<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: sys_parametros.xml */
/* Generado: 2022-04-18 21:15:09 */

/* Busqueda de registros de la tabla sys_parametros. */
abstract class BaseSys_parametrosFN extends Sys_parametrosBN
{
    /* Declaracion de constantes */
    const Parametroid = "sys_parametros.parametroid";
    const Parametrocod = "sys_parametros.parametrocod";
    const Paramtetrovalor = "sys_parametros.paramtetrovalor";
    const Comentario = "sys_parametros.Comentario";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "sys_parametros.parametroid AS parametroid, ";
        $s_SQLQuery .= "sys_parametros.parametrocod AS parametrocod, ";
        $s_SQLQuery .= "sys_parametros.paramtetrovalor AS paramtetrovalor, ";
        $s_SQLQuery .= "sys_parametros.Comentario AS Comentario ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto Sys_parametrosBN */
    public function setByBN( Sys_parametrosBN $o_Sys_parametrosBN )
    {
        if ( !is_null( $o_Sys_parametrosBN->getParametroid() ) )
        {
            $this->setParametroid( $o_Sys_parametrosBN->getParametroid() );
        }
        if ( !is_null( $o_Sys_parametrosBN->getParametrocod() ) )
        {
            $this->setParametrocod( $o_Sys_parametrosBN->getParametrocod() );
        }
        if ( !is_null( $o_Sys_parametrosBN->getParamtetrovalor() ) )
        {
            $this->setParamtetrovalor( $o_Sys_parametrosBN->getParamtetrovalor() );
        }
        if ( !is_null( $o_Sys_parametrosBN->getComentario() ) )
        {
            $this->setComentario( $o_Sys_parametrosBN->getComentario() );
        }
    }

    /**
    * @return Sys_parametrosBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_Parametroid, $s_Parametrocod )
    {
        if( is_null( $s_Parametroid ) ){ $s_Parametroid = '-1'; } 
        if( is_null( $s_Parametrocod ) ){ $s_Parametrocod = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM sys_parametros ";
        $s_SQLQuery .= "WHERE parametroid = '".$s_Parametroid."' ";
        $s_SQLQuery .= "AND parametrocod = '".$s_Parametrocod."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_Sys_parametrosBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_Sys_parametrosBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_Sys_parametrosBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getParametroid() ) ) $s_SQLQuery .= "sys_parametros.parametroid = '".$this->getParametroid()."' AND ";
        if ( !is_null( $this->getParametrocod() ) ) $s_SQLQuery .= "sys_parametros.parametrocod = '".$this->getParametrocod()."' AND ";
        if ( !is_null( $this->getParamtetrovalor() ) ) $s_SQLQuery .= "sys_parametros.paramtetrovalor = '".$this->getParamtetrovalor()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "sys_parametros.Comentario = '".$this->getComentario()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM sys_parametros WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return Sys_parametrosBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM sys_parametros WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_Sys_parametrosBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_Sys_parametrosBN = $this->insertObjectBN( $a_SQLRow );
                $a_Sys_parametrosBN[] = $o_Sys_parametrosBN;
            }
        }
        return $a_Sys_parametrosBN;
    }

    /* Devuelve un objeto Sys_parametrosBN desde un objeto propel */
    public function insertObjectBN( $a_Sys_parametros )
    {
        $o_Sys_parametrosBN = new Sys_parametrosBN();
        if ( !is_null( $a_Sys_parametros['parametroid'] ) ) $o_Sys_parametrosBN->setParametroid( $a_Sys_parametros['parametroid'] );
        if ( !is_null( $a_Sys_parametros['parametrocod'] ) ) $o_Sys_parametrosBN->setParametrocod( $a_Sys_parametros['parametrocod'] );
        if ( !is_null( $a_Sys_parametros['paramtetrovalor'] ) ) $o_Sys_parametrosBN->setParamtetrovalor( $a_Sys_parametros['paramtetrovalor'] );
        if ( !is_null( $a_Sys_parametros['Comentario'] ) ) $o_Sys_parametrosBN->setComentario( $a_Sys_parametros['Comentario'] );
        return $o_Sys_parametrosBN;
    }
}
?>