<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_Serie.xml */
/* Generado: 2022-04-18 21:15:06 */

/* Busqueda de registros de la tabla SR_Serie. */
abstract class BaseSR_SerieFN extends SR_SerieBN
{
    /* Declaracion de constantes */
    const SerieId = "SR_Serie.SerieId";
    const MovimientoId = "SR_Serie.MovimientoId";
    const ProductoId = "SR_Serie.ProductoId";
    const SerieNumero = "SR_Serie.SerieNumero";
    const Almacen = "SR_Serie.Almacen";
    const UltimaOperacion = "SR_Serie.UltimaOperacion";
    const Estado = "SR_Serie.Estado";
    const ReferenciaTipo = "SR_Serie.ReferenciaTipo";
    const ReferenciaNumero = "SR_Serie.ReferenciaNumero";
    const Comentario = "SR_Serie.Comentario";
    const UsuarioRegistro = "SR_Serie.UsuarioRegistro";
    const FechaRegistro = "SR_Serie.FechaRegistro";
    const UsuarioModificacion = "SR_Serie.UsuarioModificacion";
    const FechaModificacion = "SR_Serie.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_Serie.SerieId AS SerieId, ";
        $s_SQLQuery .= "SR_Serie.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_Serie.ProductoId AS ProductoId, ";
        $s_SQLQuery .= "SR_Serie.SerieNumero AS SerieNumero, ";
        $s_SQLQuery .= "SR_Serie.Almacen AS Almacen, ";
        $s_SQLQuery .= "SR_Serie.UltimaOperacion AS UltimaOperacion, ";
        $s_SQLQuery .= "SR_Serie.Estado AS Estado, ";
        $s_SQLQuery .= "SR_Serie.ReferenciaTipo AS ReferenciaTipo, ";
        $s_SQLQuery .= "SR_Serie.ReferenciaNumero AS ReferenciaNumero, ";
        $s_SQLQuery .= "SR_Serie.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_Serie.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_Serie.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "SR_Serie.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "SR_Serie.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_SerieBN */
    public function setByBN( SR_SerieBN $o_SR_SerieBN )
    {
        if ( !is_null( $o_SR_SerieBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_SerieBN->getSerieId() );
        }
        if ( !is_null( $o_SR_SerieBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_SerieBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_SerieBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_SerieBN->getProductoId() );
        }
        if ( !is_null( $o_SR_SerieBN->getSerieNumero() ) )
        {
            $this->setSerieNumero( $o_SR_SerieBN->getSerieNumero() );
        }
        if ( !is_null( $o_SR_SerieBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_SerieBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_SerieBN->getUltimaOperacion() ) )
        {
            $this->setUltimaOperacion( $o_SR_SerieBN->getUltimaOperacion() );
        }
        if ( !is_null( $o_SR_SerieBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_SerieBN->getEstado() );
        }
        if ( !is_null( $o_SR_SerieBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_SerieBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_SerieBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_SerieBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_SerieBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_SerieBN->getComentario() );
        }
        if ( !is_null( $o_SR_SerieBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_SerieBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_SerieBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_SerieBN->getFechaRegistro() );
        }
        if ( !is_null( $o_SR_SerieBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_SerieBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_SR_SerieBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_SerieBN->getFechaModificacion() );
        }
    }

    /**
    * @return SR_SerieBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_SerieId )
    {
        if( is_null( $i_SerieId ) ){ $i_SerieId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_Serie ";
        $s_SQLQuery .= "WHERE SerieId = ".$i_SerieId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SR_SerieBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_SerieBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_SerieBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getSerieId() ) ) $s_SQLQuery .= "SR_Serie.SerieId = ".$this->getSerieId()." AND ";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_Serie.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getProductoId() ) ) $s_SQLQuery .= "SR_Serie.ProductoId = '".$this->getProductoId()."' AND ";
        if ( !is_null( $this->getSerieNumero() ) ) $s_SQLQuery .= "SR_Serie.SerieNumero = '".$this->getSerieNumero()."' AND ";
        if ( !is_null( $this->getAlmacen() ) ) $s_SQLQuery .= "SR_Serie.Almacen = '".$this->getAlmacen()."' AND ";
        if ( !is_null( $this->getUltimaOperacion() ) ) $s_SQLQuery .= "SR_Serie.UltimaOperacion = '".$this->getUltimaOperacion()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SR_Serie.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getReferenciaTipo() ) ) $s_SQLQuery .= "SR_Serie.ReferenciaTipo = '".$this->getReferenciaTipo()."' AND ";
        if ( !is_null( $this->getReferenciaNumero() ) ) $s_SQLQuery .= "SR_Serie.ReferenciaNumero = '".$this->getReferenciaNumero()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_Serie.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_Serie.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_Serie.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_Serie.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_Serie.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_Serie WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_SerieBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_Serie WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SR_SerieBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_SerieBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_SerieBN[] = $o_SR_SerieBN;
            }
        }
        return $a_SR_SerieBN;
    }

    /* Devuelve un objeto SR_SerieBN desde un objeto propel */
    public function insertObjectBN( $a_SR_Serie )
    {
        $o_SR_SerieBN = new SR_SerieBN();
        if ( !is_null( $a_SR_Serie['SerieId'] ) ) $o_SR_SerieBN->setSerieId( ( integer ) $a_SR_Serie['SerieId'] );
        if ( !is_null( $a_SR_Serie['MovimientoId'] ) ) $o_SR_SerieBN->setMovimientoId( ( integer ) $a_SR_Serie['MovimientoId'] );
        if ( !is_null( $a_SR_Serie['ProductoId'] ) ) $o_SR_SerieBN->setProductoId( $a_SR_Serie['ProductoId'] );
        if ( !is_null( $a_SR_Serie['SerieNumero'] ) ) $o_SR_SerieBN->setSerieNumero( $a_SR_Serie['SerieNumero'] );
        if ( !is_null( $a_SR_Serie['Almacen'] ) ) $o_SR_SerieBN->setAlmacen( $a_SR_Serie['Almacen'] );
        if ( !is_null( $a_SR_Serie['UltimaOperacion'] ) ) $o_SR_SerieBN->setUltimaOperacion( $a_SR_Serie['UltimaOperacion'] );
        if ( !is_null( $a_SR_Serie['Estado'] ) ) $o_SR_SerieBN->setEstado( $a_SR_Serie['Estado'] );
        if ( !is_null( $a_SR_Serie['ReferenciaTipo'] ) ) $o_SR_SerieBN->setReferenciaTipo( $a_SR_Serie['ReferenciaTipo'] );
        if ( !is_null( $a_SR_Serie['ReferenciaNumero'] ) ) $o_SR_SerieBN->setReferenciaNumero( $a_SR_Serie['ReferenciaNumero'] );
        if ( !is_null( $a_SR_Serie['Comentario'] ) ) $o_SR_SerieBN->setComentario( $a_SR_Serie['Comentario'] );
        if ( !is_null( $a_SR_Serie['UsuarioRegistro'] ) ) $o_SR_SerieBN->setUsuarioRegistro( $a_SR_Serie['UsuarioRegistro'] );
        if ( !is_null( $a_SR_Serie['FechaRegistro'] ) ) $o_SR_SerieBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_Serie['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Serie['UsuarioModificacion'] ) ) $o_SR_SerieBN->setUsuarioModificacion( $a_SR_Serie['UsuarioModificacion'] );
        if ( !is_null( $a_SR_Serie['FechaModificacion'] ) ) $o_SR_SerieBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_Serie['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_SR_SerieBN;
    }
}
?>