<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_SerieEscaneo.xml */
/* Generado: 2022-04-18 21:15:06 */

/* Busqueda de registros de la tabla SR_SerieEscaneo. */
abstract class BaseSR_SerieEscaneoFN extends SR_SerieEscaneoBN
{
    /* Declaracion de constantes */
    const MovimientoDetalleId = "SR_SerieEscaneo.MovimientoDetalleId";
    const SerieId = "SR_SerieEscaneo.SerieId";
    const MovimientoId = "SR_SerieEscaneo.MovimientoId";
    const ProductoId = "SR_SerieEscaneo.ProductoId";
    const Fecha = "SR_SerieEscaneo.Fecha";
    const Operacion = "SR_SerieEscaneo.Operacion";
    const Almacen = "SR_SerieEscaneo.Almacen";
    const ReferenciaTipo = "SR_SerieEscaneo.ReferenciaTipo";
    const ReferenciaNumero = "SR_SerieEscaneo.ReferenciaNumero";
    const Comentario = "SR_SerieEscaneo.Comentario";
    const UsuarioRegistro = "SR_SerieEscaneo.UsuarioRegistro";
    const FechaRegistro = "SR_SerieEscaneo.FechaRegistro";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_SerieEscaneo.MovimientoDetalleId AS MovimientoDetalleId, ";
        $s_SQLQuery .= "SR_SerieEscaneo.SerieId AS SerieId, ";
        $s_SQLQuery .= "SR_SerieEscaneo.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_SerieEscaneo.ProductoId AS ProductoId, ";
        $s_SQLQuery .= "SR_SerieEscaneo.Fecha AS Fecha, ";
        $s_SQLQuery .= "SR_SerieEscaneo.Operacion AS Operacion, ";
        $s_SQLQuery .= "SR_SerieEscaneo.Almacen AS Almacen, ";
        $s_SQLQuery .= "SR_SerieEscaneo.ReferenciaTipo AS ReferenciaTipo, ";
        $s_SQLQuery .= "SR_SerieEscaneo.ReferenciaNumero AS ReferenciaNumero, ";
        $s_SQLQuery .= "SR_SerieEscaneo.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_SerieEscaneo.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_SerieEscaneo.FechaRegistro AS FechaRegistro ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_SerieEscaneoBN */
    public function setByBN( SR_SerieEscaneoBN $o_SR_SerieEscaneoBN )
    {
        if ( !is_null( $o_SR_SerieEscaneoBN->getMovimientoDetalleId() ) )
        {
            $this->setMovimientoDetalleId( $o_SR_SerieEscaneoBN->getMovimientoDetalleId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_SerieEscaneoBN->getSerieId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_SerieEscaneoBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_SerieEscaneoBN->getProductoId() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_SerieEscaneoBN->getFecha() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_SerieEscaneoBN->getOperacion() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_SerieEscaneoBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_SerieEscaneoBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_SerieEscaneoBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_SerieEscaneoBN->getComentario() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_SerieEscaneoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_SerieEscaneoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_SerieEscaneoBN->getFechaRegistro() );
        }
    }

    /**
    * @return SR_SerieEscaneoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MovimientoDetalleId, $i_SerieId )
    {
        if( is_null( $i_MovimientoDetalleId ) ){ $i_MovimientoDetalleId = -1; } 
        if( is_null( $i_SerieId ) ){ $i_SerieId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_SerieEscaneo ";
        $s_SQLQuery .= "WHERE MovimientoDetalleId = ".$i_MovimientoDetalleId." ";
        $s_SQLQuery .= "AND SerieId = ".$i_SerieId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SR_SerieEscaneoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_SerieEscaneoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_SerieEscaneoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMovimientoDetalleId() ) ) $s_SQLQuery .= "SR_SerieEscaneo.MovimientoDetalleId = ".$this->getMovimientoDetalleId()." AND ";
        if ( !is_null( $this->getSerieId() ) ) $s_SQLQuery .= "SR_SerieEscaneo.SerieId = ".$this->getSerieId()." AND ";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_SerieEscaneo.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getProductoId() ) ) $s_SQLQuery .= "SR_SerieEscaneo.ProductoId = '".$this->getProductoId()."' AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "SR_SerieEscaneo.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getOperacion() ) ) $s_SQLQuery .= "SR_SerieEscaneo.Operacion = '".$this->getOperacion()."' AND ";
        if ( !is_null( $this->getAlmacen() ) ) $s_SQLQuery .= "SR_SerieEscaneo.Almacen = '".$this->getAlmacen()."' AND ";
        if ( !is_null( $this->getReferenciaTipo() ) ) $s_SQLQuery .= "SR_SerieEscaneo.ReferenciaTipo = '".$this->getReferenciaTipo()."' AND ";
        if ( !is_null( $this->getReferenciaNumero() ) ) $s_SQLQuery .= "SR_SerieEscaneo.ReferenciaNumero = '".$this->getReferenciaNumero()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_SerieEscaneo.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_SerieEscaneo.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_SerieEscaneo.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_SerieEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_SerieEscaneoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_SerieEscaneo WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SR_SerieEscaneoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_SerieEscaneoBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_SerieEscaneoBN[] = $o_SR_SerieEscaneoBN;
            }
        }
        return $a_SR_SerieEscaneoBN;
    }

    /* Devuelve un objeto SR_SerieEscaneoBN desde un objeto propel */
    public function insertObjectBN( $a_SR_SerieEscaneo )
    {
        $o_SR_SerieEscaneoBN = new SR_SerieEscaneoBN();
        if ( !is_null( $a_SR_SerieEscaneo['MovimientoDetalleId'] ) ) $o_SR_SerieEscaneoBN->setMovimientoDetalleId( ( integer ) $a_SR_SerieEscaneo['MovimientoDetalleId'] );
        if ( !is_null( $a_SR_SerieEscaneo['SerieId'] ) ) $o_SR_SerieEscaneoBN->setSerieId( ( integer ) $a_SR_SerieEscaneo['SerieId'] );
        if ( !is_null( $a_SR_SerieEscaneo['MovimientoId'] ) ) $o_SR_SerieEscaneoBN->setMovimientoId( ( integer ) $a_SR_SerieEscaneo['MovimientoId'] );
        if ( !is_null( $a_SR_SerieEscaneo['ProductoId'] ) ) $o_SR_SerieEscaneoBN->setProductoId( $a_SR_SerieEscaneo['ProductoId'] );
        if ( !is_null( $a_SR_SerieEscaneo['Fecha'] ) ) $o_SR_SerieEscaneoBN->setFecha( utilTimestamp::getTimestamp( $a_SR_SerieEscaneo['Fecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_SerieEscaneo['Operacion'] ) ) $o_SR_SerieEscaneoBN->setOperacion( $a_SR_SerieEscaneo['Operacion'] );
        if ( !is_null( $a_SR_SerieEscaneo['Almacen'] ) ) $o_SR_SerieEscaneoBN->setAlmacen( $a_SR_SerieEscaneo['Almacen'] );
        if ( !is_null( $a_SR_SerieEscaneo['ReferenciaTipo'] ) ) $o_SR_SerieEscaneoBN->setReferenciaTipo( $a_SR_SerieEscaneo['ReferenciaTipo'] );
        if ( !is_null( $a_SR_SerieEscaneo['ReferenciaNumero'] ) ) $o_SR_SerieEscaneoBN->setReferenciaNumero( $a_SR_SerieEscaneo['ReferenciaNumero'] );
        if ( !is_null( $a_SR_SerieEscaneo['Comentario'] ) ) $o_SR_SerieEscaneoBN->setComentario( $a_SR_SerieEscaneo['Comentario'] );
        if ( !is_null( $a_SR_SerieEscaneo['UsuarioRegistro'] ) ) $o_SR_SerieEscaneoBN->setUsuarioRegistro( $a_SR_SerieEscaneo['UsuarioRegistro'] );
        if ( !is_null( $a_SR_SerieEscaneo['FechaRegistro'] ) ) $o_SR_SerieEscaneoBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_SerieEscaneo['FechaRegistro'], "Y-m-d H:i:s" ) );
        return $o_SR_SerieEscaneoBN;
    }
}
?>