<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_PreSerie.xml */
/* Generado: 2022-04-18 21:15:05 */

/* Busqueda de registros de la tabla SR_PreSerie. */
abstract class BaseSR_PreSerieFN extends SR_PreSerieBN
{
    /* Declaracion de constantes */
    const SerieId = "SR_PreSerie.SerieId";
    const MovimientoId = "SR_PreSerie.MovimientoId";
    const ProductoId = "SR_PreSerie.ProductoId";
    const SerieNumero = "SR_PreSerie.SerieNumero";
    const Operacion = "SR_PreSerie.Operacion";
    const Almacen = "SR_PreSerie.Almacen";
    const ReferenciaTipo = "SR_PreSerie.ReferenciaTipo";
    const ReferenciaNumero = "SR_PreSerie.ReferenciaNumero";
    const Comentario = "SR_PreSerie.Comentario";
    const UsuarioRegistro = "SR_PreSerie.UsuarioRegistro";
    const FechaRegistro = "SR_PreSerie.FechaRegistro";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_PreSerie.SerieId AS SerieId, ";
        $s_SQLQuery .= "SR_PreSerie.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_PreSerie.ProductoId AS ProductoId, ";
        $s_SQLQuery .= "SR_PreSerie.SerieNumero AS SerieNumero, ";
        $s_SQLQuery .= "SR_PreSerie.Operacion AS Operacion, ";
        $s_SQLQuery .= "SR_PreSerie.Almacen AS Almacen, ";
        $s_SQLQuery .= "SR_PreSerie.ReferenciaTipo AS ReferenciaTipo, ";
        $s_SQLQuery .= "SR_PreSerie.ReferenciaNumero AS ReferenciaNumero, ";
        $s_SQLQuery .= "SR_PreSerie.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_PreSerie.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_PreSerie.FechaRegistro AS FechaRegistro ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_PreSerieBN */
    public function setByBN( SR_PreSerieBN $o_SR_PreSerieBN )
    {
        if ( !is_null( $o_SR_PreSerieBN->getSerieId() ) )
        {
            $this->setSerieId( $o_SR_PreSerieBN->getSerieId() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_PreSerieBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getProductoId() ) )
        {
            $this->setProductoId( $o_SR_PreSerieBN->getProductoId() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getSerieNumero() ) )
        {
            $this->setSerieNumero( $o_SR_PreSerieBN->getSerieNumero() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_PreSerieBN->getOperacion() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_PreSerieBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_PreSerieBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_PreSerieBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_PreSerieBN->getComentario() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_PreSerieBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_PreSerieBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_PreSerieBN->getFechaRegistro() );
        }
    }

    /**
    * @return SR_PreSerieBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_SerieId )
    {
        if( is_null( $i_SerieId ) ){ $i_SerieId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_PreSerie ";
        $s_SQLQuery .= "WHERE SerieId = ".$i_SerieId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SR_PreSerieBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_PreSerieBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_PreSerieBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getSerieId() ) ) $s_SQLQuery .= "SR_PreSerie.SerieId = ".$this->getSerieId()." AND ";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_PreSerie.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getProductoId() ) ) $s_SQLQuery .= "SR_PreSerie.ProductoId = '".$this->getProductoId()."' AND ";
        if ( !is_null( $this->getSerieNumero() ) ) $s_SQLQuery .= "SR_PreSerie.SerieNumero = '".$this->getSerieNumero()."' AND ";
        if ( !is_null( $this->getOperacion() ) ) $s_SQLQuery .= "SR_PreSerie.Operacion = '".$this->getOperacion()."' AND ";
        if ( !is_null( $this->getAlmacen() ) ) $s_SQLQuery .= "SR_PreSerie.Almacen = '".$this->getAlmacen()."' AND ";
        if ( !is_null( $this->getReferenciaTipo() ) ) $s_SQLQuery .= "SR_PreSerie.ReferenciaTipo = '".$this->getReferenciaTipo()."' AND ";
        if ( !is_null( $this->getReferenciaNumero() ) ) $s_SQLQuery .= "SR_PreSerie.ReferenciaNumero = '".$this->getReferenciaNumero()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_PreSerie.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_PreSerie.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_PreSerie.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_PreSerie WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_PreSerieBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_PreSerie WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SR_PreSerieBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_PreSerieBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_PreSerieBN[] = $o_SR_PreSerieBN;
            }
        }
        return $a_SR_PreSerieBN;
    }

    /* Devuelve un objeto SR_PreSerieBN desde un objeto propel */
    public function insertObjectBN( $a_SR_PreSerie )
    {
        $o_SR_PreSerieBN = new SR_PreSerieBN();
        if ( !is_null( $a_SR_PreSerie['SerieId'] ) ) $o_SR_PreSerieBN->setSerieId( ( integer ) $a_SR_PreSerie['SerieId'] );
        if ( !is_null( $a_SR_PreSerie['MovimientoId'] ) ) $o_SR_PreSerieBN->setMovimientoId( ( integer ) $a_SR_PreSerie['MovimientoId'] );
        if ( !is_null( $a_SR_PreSerie['ProductoId'] ) ) $o_SR_PreSerieBN->setProductoId( $a_SR_PreSerie['ProductoId'] );
        if ( !is_null( $a_SR_PreSerie['SerieNumero'] ) ) $o_SR_PreSerieBN->setSerieNumero( $a_SR_PreSerie['SerieNumero'] );
        if ( !is_null( $a_SR_PreSerie['Operacion'] ) ) $o_SR_PreSerieBN->setOperacion( $a_SR_PreSerie['Operacion'] );
        if ( !is_null( $a_SR_PreSerie['Almacen'] ) ) $o_SR_PreSerieBN->setAlmacen( $a_SR_PreSerie['Almacen'] );
        if ( !is_null( $a_SR_PreSerie['ReferenciaTipo'] ) ) $o_SR_PreSerieBN->setReferenciaTipo( $a_SR_PreSerie['ReferenciaTipo'] );
        if ( !is_null( $a_SR_PreSerie['ReferenciaNumero'] ) ) $o_SR_PreSerieBN->setReferenciaNumero( $a_SR_PreSerie['ReferenciaNumero'] );
        if ( !is_null( $a_SR_PreSerie['Comentario'] ) ) $o_SR_PreSerieBN->setComentario( $a_SR_PreSerie['Comentario'] );
        if ( !is_null( $a_SR_PreSerie['UsuarioRegistro'] ) ) $o_SR_PreSerieBN->setUsuarioRegistro( $a_SR_PreSerie['UsuarioRegistro'] );
        if ( !is_null( $a_SR_PreSerie['FechaRegistro'] ) ) $o_SR_PreSerieBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_PreSerie['FechaRegistro'], "Y-m-d H:i:s" ) );
        return $o_SR_PreSerieBN;
    }
}
?>