<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_Movimiento.xml */
/* Generado: 2022-04-18 21:15:05 */

/* Busqueda de registros de la tabla SR_Movimiento. */
abstract class BaseSR_MovimientoFN extends SR_MovimientoBN
{
    /* Declaracion de constantes */
    const MovimientoId = "SR_Movimiento.MovimientoId";
    const IdCompania = "SR_Movimiento.IdCompania";
    const IdSucursal = "SR_Movimiento.IdSucursal";
    const Fecha = "SR_Movimiento.Fecha";
    const TipoMovimiento = "SR_Movimiento.TipoMovimiento";
    const Operacion = "SR_Movimiento.Operacion";
    const Almacen = "SR_Movimiento.Almacen";
    const ReferenciaTipo = "SR_Movimiento.ReferenciaTipo";
    const ReferenciaNumero = "SR_Movimiento.ReferenciaNumero";
    const ReferenciaSecuencia = "SR_Movimiento.ReferenciaSecuencia";
    const ReferenciaId = "SR_Movimiento.ReferenciaId";
    const ReferenciaFecha = "SR_Movimiento.ReferenciaFecha";
    const InicioEscaneo = "SR_Movimiento.InicioEscaneo";
    const FinEscaneo = "SR_Movimiento.FinEscaneo";
    const Comentario = "SR_Movimiento.Comentario";
    const UsuarioAprob = "SR_Movimiento.UsuarioAprob";
    const FechaAprob = "SR_Movimiento.FechaAprob";
    const EstadoAprob = "SR_Movimiento.EstadoAprob";
    const ComentarioAprob = "SR_Movimiento.ComentarioAprob";
    const Estado = "SR_Movimiento.Estado";
    const ImpresionEstado = "SR_Movimiento.ImpresionEstado";
    const ControlEstadoSerie = "SR_Movimiento.ControlEstadoSerie";
    const UsuarioRegistro = "SR_Movimiento.UsuarioRegistro";
    const FechaRegistro = "SR_Movimiento.FechaRegistro";
    const UsuarioModificacion = "SR_Movimiento.UsuarioModificacion";
    const FechaModificacion = "SR_Movimiento.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_Movimiento.MovimientoId AS MovimientoId, ";
        $s_SQLQuery .= "SR_Movimiento.IdCompania AS IdCompania, ";
        $s_SQLQuery .= "SR_Movimiento.IdSucursal AS IdSucursal, ";
        $s_SQLQuery .= "SR_Movimiento.Fecha AS Fecha, ";
        $s_SQLQuery .= "SR_Movimiento.TipoMovimiento AS TipoMovimiento, ";
        $s_SQLQuery .= "SR_Movimiento.Operacion AS Operacion, ";
        $s_SQLQuery .= "SR_Movimiento.Almacen AS Almacen, ";
        $s_SQLQuery .= "SR_Movimiento.ReferenciaTipo AS ReferenciaTipo, ";
        $s_SQLQuery .= "SR_Movimiento.ReferenciaNumero AS ReferenciaNumero, ";
        $s_SQLQuery .= "SR_Movimiento.ReferenciaSecuencia AS ReferenciaSecuencia, ";
        $s_SQLQuery .= "SR_Movimiento.ReferenciaId AS ReferenciaId, ";
        $s_SQLQuery .= "SR_Movimiento.ReferenciaFecha AS ReferenciaFecha, ";
        $s_SQLQuery .= "SR_Movimiento.InicioEscaneo AS InicioEscaneo, ";
        $s_SQLQuery .= "SR_Movimiento.FinEscaneo AS FinEscaneo, ";
        $s_SQLQuery .= "SR_Movimiento.Comentario AS Comentario, ";
        $s_SQLQuery .= "SR_Movimiento.UsuarioAprob AS UsuarioAprob, ";
        $s_SQLQuery .= "SR_Movimiento.FechaAprob AS FechaAprob, ";
        $s_SQLQuery .= "SR_Movimiento.EstadoAprob AS EstadoAprob, ";
        $s_SQLQuery .= "SR_Movimiento.ComentarioAprob AS ComentarioAprob, ";
        $s_SQLQuery .= "SR_Movimiento.Estado AS Estado, ";
        $s_SQLQuery .= "SR_Movimiento.ImpresionEstado AS ImpresionEstado, ";
        $s_SQLQuery .= "SR_Movimiento.ControlEstadoSerie AS ControlEstadoSerie, ";
        $s_SQLQuery .= "SR_Movimiento.UsuarioRegistro AS UsuarioRegistro, ";
        $s_SQLQuery .= "SR_Movimiento.FechaRegistro AS FechaRegistro, ";
        $s_SQLQuery .= "SR_Movimiento.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "SR_Movimiento.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_MovimientoBN */
    public function setByBN( SR_MovimientoBN $o_SR_MovimientoBN )
    {
        if ( !is_null( $o_SR_MovimientoBN->getMovimientoId() ) )
        {
            $this->setMovimientoId( $o_SR_MovimientoBN->getMovimientoId() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getIdCompania() ) )
        {
            $this->setIdCompania( $o_SR_MovimientoBN->getIdCompania() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getIdSucursal() ) )
        {
            $this->setIdSucursal( $o_SR_MovimientoBN->getIdSucursal() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getFecha() ) )
        {
            $this->setFecha( $o_SR_MovimientoBN->getFecha() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getTipoMovimiento() ) )
        {
            $this->setTipoMovimiento( $o_SR_MovimientoBN->getTipoMovimiento() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getOperacion() ) )
        {
            $this->setOperacion( $o_SR_MovimientoBN->getOperacion() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getAlmacen() ) )
        {
            $this->setAlmacen( $o_SR_MovimientoBN->getAlmacen() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getReferenciaTipo() ) )
        {
            $this->setReferenciaTipo( $o_SR_MovimientoBN->getReferenciaTipo() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getReferenciaNumero() ) )
        {
            $this->setReferenciaNumero( $o_SR_MovimientoBN->getReferenciaNumero() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getReferenciaSecuencia() ) )
        {
            $this->setReferenciaSecuencia( $o_SR_MovimientoBN->getReferenciaSecuencia() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getReferenciaId() ) )
        {
            $this->setReferenciaId( $o_SR_MovimientoBN->getReferenciaId() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getReferenciaFecha() ) )
        {
            $this->setReferenciaFecha( $o_SR_MovimientoBN->getReferenciaFecha() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getInicioEscaneo() ) )
        {
            $this->setInicioEscaneo( $o_SR_MovimientoBN->getInicioEscaneo() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getFinEscaneo() ) )
        {
            $this->setFinEscaneo( $o_SR_MovimientoBN->getFinEscaneo() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getComentario() ) )
        {
            $this->setComentario( $o_SR_MovimientoBN->getComentario() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getUsuarioAprob() ) )
        {
            $this->setUsuarioAprob( $o_SR_MovimientoBN->getUsuarioAprob() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getFechaAprob() ) )
        {
            $this->setFechaAprob( $o_SR_MovimientoBN->getFechaAprob() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getEstadoAprob() ) )
        {
            $this->setEstadoAprob( $o_SR_MovimientoBN->getEstadoAprob() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getComentarioAprob() ) )
        {
            $this->setComentarioAprob( $o_SR_MovimientoBN->getComentarioAprob() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getEstado() ) )
        {
            $this->setEstado( $o_SR_MovimientoBN->getEstado() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getImpresionEstado() ) )
        {
            $this->setImpresionEstado( $o_SR_MovimientoBN->getImpresionEstado() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getControlEstadoSerie() ) )
        {
            $this->setControlEstadoSerie( $o_SR_MovimientoBN->getControlEstadoSerie() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getUsuarioRegistro() ) )
        {
            $this->setUsuarioRegistro( $o_SR_MovimientoBN->getUsuarioRegistro() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getFechaRegistro() ) )
        {
            $this->setFechaRegistro( $o_SR_MovimientoBN->getFechaRegistro() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SR_MovimientoBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_SR_MovimientoBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SR_MovimientoBN->getFechaModificacion() );
        }
    }

    /**
    * @return SR_MovimientoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_MovimientoId )
    {
        if( is_null( $i_MovimientoId ) ){ $i_MovimientoId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_Movimiento ";
        $s_SQLQuery .= "WHERE MovimientoId = ".$i_MovimientoId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SR_MovimientoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_MovimientoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_MovimientoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getMovimientoId() ) ) $s_SQLQuery .= "SR_Movimiento.MovimientoId = ".$this->getMovimientoId()." AND ";
        if ( !is_null( $this->getIdCompania() ) ) $s_SQLQuery .= "SR_Movimiento.IdCompania = ".$this->getIdCompania()." AND ";
        if ( !is_null( $this->getIdSucursal() ) ) $s_SQLQuery .= "SR_Movimiento.IdSucursal = ".$this->getIdSucursal()." AND ";
        if ( !is_null( $this->getFecha() ) ) $s_SQLQuery .= "SR_Movimiento.Fecha = '".$this->getFecha()."' AND ";
        if ( !is_null( $this->getTipoMovimiento() ) ) $s_SQLQuery .= "SR_Movimiento.TipoMovimiento = '".$this->getTipoMovimiento()."' AND ";
        if ( !is_null( $this->getOperacion() ) ) $s_SQLQuery .= "SR_Movimiento.Operacion = '".$this->getOperacion()."' AND ";
        if ( !is_null( $this->getAlmacen() ) ) $s_SQLQuery .= "SR_Movimiento.Almacen = '".$this->getAlmacen()."' AND ";
        if ( !is_null( $this->getReferenciaTipo() ) ) $s_SQLQuery .= "SR_Movimiento.ReferenciaTipo = '".$this->getReferenciaTipo()."' AND ";
        if ( !is_null( $this->getReferenciaNumero() ) ) $s_SQLQuery .= "SR_Movimiento.ReferenciaNumero = '".$this->getReferenciaNumero()."' AND ";
        if ( !is_null( $this->getReferenciaSecuencia() ) ) $s_SQLQuery .= "SR_Movimiento.ReferenciaSecuencia = ".$this->getReferenciaSecuencia()." AND ";
        if ( !is_null( $this->getReferenciaId() ) ) $s_SQLQuery .= "SR_Movimiento.ReferenciaId = '".$this->getReferenciaId()."' AND ";
        if ( !is_null( $this->getReferenciaFecha() ) ) $s_SQLQuery .= "SR_Movimiento.ReferenciaFecha = '".$this->getReferenciaFecha()."' AND ";
        if ( !is_null( $this->getInicioEscaneo() ) ) $s_SQLQuery .= "SR_Movimiento.InicioEscaneo = '".$this->getInicioEscaneo()."' AND ";
        if ( !is_null( $this->getFinEscaneo() ) ) $s_SQLQuery .= "SR_Movimiento.FinEscaneo = '".$this->getFinEscaneo()."' AND ";
        if ( !is_null( $this->getComentario() ) ) $s_SQLQuery .= "SR_Movimiento.Comentario = '".$this->getComentario()."' AND ";
        if ( !is_null( $this->getUsuarioAprob() ) ) $s_SQLQuery .= "SR_Movimiento.UsuarioAprob = '".$this->getUsuarioAprob()."' AND ";
        if ( !is_null( $this->getFechaAprob() ) ) $s_SQLQuery .= "SR_Movimiento.FechaAprob = '".$this->getFechaAprob()."' AND ";
        if ( !is_null( $this->getEstadoAprob() ) ) $s_SQLQuery .= "SR_Movimiento.EstadoAprob = '".$this->getEstadoAprob()."' AND ";
        if ( !is_null( $this->getComentarioAprob() ) ) $s_SQLQuery .= "SR_Movimiento.ComentarioAprob = '".$this->getComentarioAprob()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SR_Movimiento.Estado = '".$this->getEstado()."' AND ";
        if ( !is_null( $this->getImpresionEstado() ) ) $s_SQLQuery .= "SR_Movimiento.ImpresionEstado = '".$this->getImpresionEstado()."' AND ";
        if ( !is_null( $this->getControlEstadoSerie() ) ) $s_SQLQuery .= "SR_Movimiento.ControlEstadoSerie = '".$this->getControlEstadoSerie()."' AND ";
        if ( !is_null( $this->getUsuarioRegistro() ) ) $s_SQLQuery .= "SR_Movimiento.UsuarioRegistro = '".$this->getUsuarioRegistro()."' AND ";
        if ( !is_null( $this->getFechaRegistro() ) ) $s_SQLQuery .= "SR_Movimiento.FechaRegistro = '".$this->getFechaRegistro()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SR_Movimiento.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SR_Movimiento.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_Movimiento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_MovimientoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_Movimiento WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SR_MovimientoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_MovimientoBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_MovimientoBN[] = $o_SR_MovimientoBN;
            }
        }
        return $a_SR_MovimientoBN;
    }

    /* Devuelve un objeto SR_MovimientoBN desde un objeto propel */
    public function insertObjectBN( $a_SR_Movimiento )
    {
        $o_SR_MovimientoBN = new SR_MovimientoBN();
        if ( !is_null( $a_SR_Movimiento['MovimientoId'] ) ) $o_SR_MovimientoBN->setMovimientoId( ( integer ) $a_SR_Movimiento['MovimientoId'] );
        if ( !is_null( $a_SR_Movimiento['IdCompania'] ) ) $o_SR_MovimientoBN->setIdCompania( ( integer ) $a_SR_Movimiento['IdCompania'] );
        if ( !is_null( $a_SR_Movimiento['IdSucursal'] ) ) $o_SR_MovimientoBN->setIdSucursal( ( integer ) $a_SR_Movimiento['IdSucursal'] );
        if ( !is_null( $a_SR_Movimiento['Fecha'] ) ) $o_SR_MovimientoBN->setFecha( utilTimestamp::getTimestamp( $a_SR_Movimiento['Fecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Movimiento['TipoMovimiento'] ) ) $o_SR_MovimientoBN->setTipoMovimiento( $a_SR_Movimiento['TipoMovimiento'] );
        if ( !is_null( $a_SR_Movimiento['Operacion'] ) ) $o_SR_MovimientoBN->setOperacion( $a_SR_Movimiento['Operacion'] );
        if ( !is_null( $a_SR_Movimiento['Almacen'] ) ) $o_SR_MovimientoBN->setAlmacen( $a_SR_Movimiento['Almacen'] );
        if ( !is_null( $a_SR_Movimiento['ReferenciaTipo'] ) ) $o_SR_MovimientoBN->setReferenciaTipo( $a_SR_Movimiento['ReferenciaTipo'] );
        if ( !is_null( $a_SR_Movimiento['ReferenciaNumero'] ) ) $o_SR_MovimientoBN->setReferenciaNumero( $a_SR_Movimiento['ReferenciaNumero'] );
        if ( !is_null( $a_SR_Movimiento['ReferenciaSecuencia'] ) ) $o_SR_MovimientoBN->setReferenciaSecuencia( ( integer ) $a_SR_Movimiento['ReferenciaSecuencia'] );
        if ( !is_null( $a_SR_Movimiento['ReferenciaId'] ) ) $o_SR_MovimientoBN->setReferenciaId( $a_SR_Movimiento['ReferenciaId'] );
        if ( !is_null( $a_SR_Movimiento['ReferenciaFecha'] ) ) $o_SR_MovimientoBN->setReferenciaFecha( utilTimestamp::getTimestamp( $a_SR_Movimiento['ReferenciaFecha'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Movimiento['InicioEscaneo'] ) ) $o_SR_MovimientoBN->setInicioEscaneo( utilTimestamp::getTimestamp( $a_SR_Movimiento['InicioEscaneo'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Movimiento['FinEscaneo'] ) ) $o_SR_MovimientoBN->setFinEscaneo( utilTimestamp::getTimestamp( $a_SR_Movimiento['FinEscaneo'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Movimiento['Comentario'] ) ) $o_SR_MovimientoBN->setComentario( $a_SR_Movimiento['Comentario'] );
        if ( !is_null( $a_SR_Movimiento['UsuarioAprob'] ) ) $o_SR_MovimientoBN->setUsuarioAprob( $a_SR_Movimiento['UsuarioAprob'] );
        if ( !is_null( $a_SR_Movimiento['FechaAprob'] ) ) $o_SR_MovimientoBN->setFechaAprob( utilTimestamp::getTimestamp( $a_SR_Movimiento['FechaAprob'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Movimiento['EstadoAprob'] ) ) $o_SR_MovimientoBN->setEstadoAprob( $a_SR_Movimiento['EstadoAprob'] );
        if ( !is_null( $a_SR_Movimiento['ComentarioAprob'] ) ) $o_SR_MovimientoBN->setComentarioAprob( $a_SR_Movimiento['ComentarioAprob'] );
        if ( !is_null( $a_SR_Movimiento['Estado'] ) ) $o_SR_MovimientoBN->setEstado( $a_SR_Movimiento['Estado'] );
        if ( !is_null( $a_SR_Movimiento['ImpresionEstado'] ) ) $o_SR_MovimientoBN->setImpresionEstado( $a_SR_Movimiento['ImpresionEstado'] );
        if ( !is_null( $a_SR_Movimiento['ControlEstadoSerie'] ) ) $o_SR_MovimientoBN->setControlEstadoSerie( $a_SR_Movimiento['ControlEstadoSerie'] );
        if ( !is_null( $a_SR_Movimiento['UsuarioRegistro'] ) ) $o_SR_MovimientoBN->setUsuarioRegistro( $a_SR_Movimiento['UsuarioRegistro'] );
        if ( !is_null( $a_SR_Movimiento['FechaRegistro'] ) ) $o_SR_MovimientoBN->setFechaRegistro( utilTimestamp::getTimestamp( $a_SR_Movimiento['FechaRegistro'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SR_Movimiento['UsuarioModificacion'] ) ) $o_SR_MovimientoBN->setUsuarioModificacion( $a_SR_Movimiento['UsuarioModificacion'] );
        if ( !is_null( $a_SR_Movimiento['FechaModificacion'] ) ) $o_SR_MovimientoBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SR_Movimiento['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_SR_MovimientoBN;
    }
}
?>