<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SR_DevolucionLimpieza.xml */
/* Generado: 2022-04-18 21:15:04 */

/* Busqueda de registros de la tabla SR_DevolucionLimpieza. */
abstract class BaseSR_DevolucionLimpiezaFN extends SR_DevolucionLimpiezaBN
{
    /* Declaracion de constantes */
    const LimpiezaId = "SR_DevolucionLimpieza.LimpiezaId";
    const Descripcion = "SR_DevolucionLimpieza.Descripcion";
    const Cantidad = "SR_DevolucionLimpieza.Cantidad";
    const Tipo = "SR_DevolucionLimpieza.Tipo";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SR_DevolucionLimpieza.LimpiezaId AS LimpiezaId, ";
        $s_SQLQuery .= "SR_DevolucionLimpieza.Descripcion AS Descripcion, ";
        $s_SQLQuery .= "SR_DevolucionLimpieza.Cantidad AS Cantidad, ";
        $s_SQLQuery .= "SR_DevolucionLimpieza.Tipo AS Tipo ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SR_DevolucionLimpiezaBN */
    public function setByBN( SR_DevolucionLimpiezaBN $o_SR_DevolucionLimpiezaBN )
    {
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getLimpiezaId() ) )
        {
            $this->setLimpiezaId( $o_SR_DevolucionLimpiezaBN->getLimpiezaId() );
        }
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getDescripcion() ) )
        {
            $this->setDescripcion( $o_SR_DevolucionLimpiezaBN->getDescripcion() );
        }
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getCantidad() ) )
        {
            $this->setCantidad( $o_SR_DevolucionLimpiezaBN->getCantidad() );
        }
        if ( !is_null( $o_SR_DevolucionLimpiezaBN->getTipo() ) )
        {
            $this->setTipo( $o_SR_DevolucionLimpiezaBN->getTipo() );
        }
    }

    /**
    * @return SR_DevolucionLimpiezaBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_LimpiezaId )
    {
        if( is_null( $i_LimpiezaId ) ){ $i_LimpiezaId = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionLimpieza ";
        $s_SQLQuery .= "WHERE LimpiezaId = ".$i_LimpiezaId." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SR_DevolucionLimpiezaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SR_DevolucionLimpiezaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SR_DevolucionLimpiezaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getLimpiezaId() ) ) $s_SQLQuery .= "SR_DevolucionLimpieza.LimpiezaId = ".$this->getLimpiezaId()." AND ";
        if ( !is_null( $this->getDescripcion() ) ) $s_SQLQuery .= "SR_DevolucionLimpieza.Descripcion = '".$this->getDescripcion()."' AND ";
        if ( !is_null( $this->getCantidad() ) ) $s_SQLQuery .= "SR_DevolucionLimpieza.Cantidad = ".$this->getCantidad()." AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "SR_DevolucionLimpieza.Tipo = '".$this->getTipo()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SR_DevolucionLimpieza WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SR_DevolucionLimpiezaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SR_DevolucionLimpieza WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SR_DevolucionLimpiezaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SR_DevolucionLimpiezaBN = $this->insertObjectBN( $a_SQLRow );
                $a_SR_DevolucionLimpiezaBN[] = $o_SR_DevolucionLimpiezaBN;
            }
        }
        return $a_SR_DevolucionLimpiezaBN;
    }

    /* Devuelve un objeto SR_DevolucionLimpiezaBN desde un objeto propel */
    public function insertObjectBN( $a_SR_DevolucionLimpieza )
    {
        $o_SR_DevolucionLimpiezaBN = new SR_DevolucionLimpiezaBN();
        if ( !is_null( $a_SR_DevolucionLimpieza['LimpiezaId'] ) ) $o_SR_DevolucionLimpiezaBN->setLimpiezaId( ( integer ) $a_SR_DevolucionLimpieza['LimpiezaId'] );
        if ( !is_null( $a_SR_DevolucionLimpieza['Descripcion'] ) ) $o_SR_DevolucionLimpiezaBN->setDescripcion( $a_SR_DevolucionLimpieza['Descripcion'] );
        if ( !is_null( $a_SR_DevolucionLimpieza['Cantidad'] ) ) $o_SR_DevolucionLimpiezaBN->setCantidad( ( float ) $a_SR_DevolucionLimpieza['Cantidad'] );
        if ( !is_null( $a_SR_DevolucionLimpieza['Tipo'] ) ) $o_SR_DevolucionLimpiezaBN->setTipo( $a_SR_DevolucionLimpieza['Tipo'] );
        return $o_SR_DevolucionLimpiezaBN;
    }
}
?>