<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SRV_UbicacionEstadoLog.xml */
/* Generado: 2022-04-18 21:15:04 */

/* Busqueda de registros de la tabla SRV_UbicacionEstadoLog. */
abstract class BaseSRV_UbicacionEstadoLogFN extends SRV_UbicacionEstadoLogBN
{
    /* Declaracion de constantes */
    const IdUbicacionEstLog = "SRV_UbicacionEstadoLog.IdUbicacionEstLog";
    const IdUbicacion = "SRV_UbicacionEstadoLog.IdUbicacion";
    const IdEstados = "SRV_UbicacionEstadoLog.IdEstados";
    const EstadoNombre = "SRV_UbicacionEstadoLog.EstadoNombre";
    const FechaCreacion = "SRV_UbicacionEstadoLog.FechaCreacion";
    const UsuarioCreacion = "SRV_UbicacionEstadoLog.UsuarioCreacion";
    const FechaModificacion = "SRV_UbicacionEstadoLog.FechaModificacion";
    const UsuarioModificacion = "SRV_UbicacionEstadoLog.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SRV_UbicacionEstadoLog.IdUbicacionEstLog AS IdUbicacionEstLog, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.IdUbicacion AS IdUbicacion, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.IdEstados AS IdEstados, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.EstadoNombre AS EstadoNombre, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SRV_UbicacionEstadoLog.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SRV_UbicacionEstadoLogBN */
    public function setByBN( SRV_UbicacionEstadoLogBN $o_SRV_UbicacionEstadoLogBN )
    {
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getIdUbicacionEstLog() ) )
        {
            $this->setIdUbicacionEstLog( $o_SRV_UbicacionEstadoLogBN->getIdUbicacionEstLog() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getIdUbicacion() ) )
        {
            $this->setIdUbicacion( $o_SRV_UbicacionEstadoLogBN->getIdUbicacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getIdEstados() ) )
        {
            $this->setIdEstados( $o_SRV_UbicacionEstadoLogBN->getIdEstados() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getEstadoNombre() ) )
        {
            $this->setEstadoNombre( $o_SRV_UbicacionEstadoLogBN->getEstadoNombre() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SRV_UbicacionEstadoLogBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SRV_UbicacionEstadoLogBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SRV_UbicacionEstadoLogBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoLogBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SRV_UbicacionEstadoLogBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SRV_UbicacionEstadoLogBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdUbicacionEstLog )
    {
        if( is_null( $i_IdUbicacionEstLog ) ){ $i_IdUbicacionEstLog = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SRV_UbicacionEstadoLog ";
        $s_SQLQuery .= "WHERE IdUbicacionEstLog = ".$i_IdUbicacionEstLog." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SRV_UbicacionEstadoLogBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SRV_UbicacionEstadoLogBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SRV_UbicacionEstadoLogBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUbicacionEstLog() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.IdUbicacionEstLog = ".$this->getIdUbicacionEstLog()." AND ";
        if ( !is_null( $this->getIdUbicacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.IdUbicacion = ".$this->getIdUbicacion()." AND ";
        if ( !is_null( $this->getIdEstados() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.IdEstados = ".$this->getIdEstados()." AND ";
        if ( !is_null( $this->getEstadoNombre() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.EstadoNombre = '".$this->getEstadoNombre()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstadoLog.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SRV_UbicacionEstadoLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SRV_UbicacionEstadoLogBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SRV_UbicacionEstadoLog WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SRV_UbicacionEstadoLogBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SRV_UbicacionEstadoLogBN = $this->insertObjectBN( $a_SQLRow );
                $a_SRV_UbicacionEstadoLogBN[] = $o_SRV_UbicacionEstadoLogBN;
            }
        }
        return $a_SRV_UbicacionEstadoLogBN;
    }

    /* Devuelve un objeto SRV_UbicacionEstadoLogBN desde un objeto propel */
    public function insertObjectBN( $a_SRV_UbicacionEstadoLog )
    {
        $o_SRV_UbicacionEstadoLogBN = new SRV_UbicacionEstadoLogBN();
        if ( !is_null( $a_SRV_UbicacionEstadoLog['IdUbicacionEstLog'] ) ) $o_SRV_UbicacionEstadoLogBN->setIdUbicacionEstLog( ( integer ) $a_SRV_UbicacionEstadoLog['IdUbicacionEstLog'] );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['IdUbicacion'] ) ) $o_SRV_UbicacionEstadoLogBN->setIdUbicacion( ( integer ) $a_SRV_UbicacionEstadoLog['IdUbicacion'] );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['IdEstados'] ) ) $o_SRV_UbicacionEstadoLogBN->setIdEstados( ( integer ) $a_SRV_UbicacionEstadoLog['IdEstados'] );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['EstadoNombre'] ) ) $o_SRV_UbicacionEstadoLogBN->setEstadoNombre( $a_SRV_UbicacionEstadoLog['EstadoNombre'] );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['FechaCreacion'] ) ) $o_SRV_UbicacionEstadoLogBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SRV_UbicacionEstadoLog['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['UsuarioCreacion'] ) ) $o_SRV_UbicacionEstadoLogBN->setUsuarioCreacion( $a_SRV_UbicacionEstadoLog['UsuarioCreacion'] );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['FechaModificacion'] ) ) $o_SRV_UbicacionEstadoLogBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SRV_UbicacionEstadoLog['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SRV_UbicacionEstadoLog['UsuarioModificacion'] ) ) $o_SRV_UbicacionEstadoLogBN->setUsuarioModificacion( $a_SRV_UbicacionEstadoLog['UsuarioModificacion'] );
        return $o_SRV_UbicacionEstadoLogBN;
    }
}
?>