<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SRV_UbicacionEstado.xml */
/* Generado: 2022-04-18 21:15:04 */

/* Busqueda de registros de la tabla SRV_UbicacionEstado. */
abstract class BaseSRV_UbicacionEstadoFN extends SRV_UbicacionEstadoBN
{
    /* Declaracion de constantes */
    const IdUbicacion = "SRV_UbicacionEstado.IdUbicacion";
    const IdEstados = "SRV_UbicacionEstado.IdEstados";
    const EstadoNombre = "SRV_UbicacionEstado.EstadoNombre";
    const FechaCreacion = "SRV_UbicacionEstado.FechaCreacion";
    const UsuarioCreacion = "SRV_UbicacionEstado.UsuarioCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SRV_UbicacionEstado.IdUbicacion AS IdUbicacion, ";
        $s_SQLQuery .= "SRV_UbicacionEstado.IdEstados AS IdEstados, ";
        $s_SQLQuery .= "SRV_UbicacionEstado.EstadoNombre AS EstadoNombre, ";
        $s_SQLQuery .= "SRV_UbicacionEstado.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SRV_UbicacionEstado.UsuarioCreacion AS UsuarioCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SRV_UbicacionEstadoBN */
    public function setByBN( SRV_UbicacionEstadoBN $o_SRV_UbicacionEstadoBN )
    {
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getIdUbicacion() ) )
        {
            $this->setIdUbicacion( $o_SRV_UbicacionEstadoBN->getIdUbicacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getIdEstados() ) )
        {
            $this->setIdEstados( $o_SRV_UbicacionEstadoBN->getIdEstados() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getEstadoNombre() ) )
        {
            $this->setEstadoNombre( $o_SRV_UbicacionEstadoBN->getEstadoNombre() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SRV_UbicacionEstadoBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SRV_UbicacionEstadoBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SRV_UbicacionEstadoBN->getUsuarioCreacion() );
        }
    }

    /**
    * @return SRV_UbicacionEstadoBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdUbicacion )
    {
        if( is_null( $i_IdUbicacion ) ){ $i_IdUbicacion = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SRV_UbicacionEstado ";
        $s_SQLQuery .= "WHERE IdUbicacion = ".$i_IdUbicacion." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SRV_UbicacionEstadoBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SRV_UbicacionEstadoBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SRV_UbicacionEstadoBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdUbicacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstado.IdUbicacion = ".$this->getIdUbicacion()." AND ";
        if ( !is_null( $this->getIdEstados() ) ) $s_SQLQuery .= "SRV_UbicacionEstado.IdEstados = ".$this->getIdEstados()." AND ";
        if ( !is_null( $this->getEstadoNombre() ) ) $s_SQLQuery .= "SRV_UbicacionEstado.EstadoNombre = '".$this->getEstadoNombre()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstado.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SRV_UbicacionEstado.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SRV_UbicacionEstado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SRV_UbicacionEstadoBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SRV_UbicacionEstado WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SRV_UbicacionEstadoBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SRV_UbicacionEstadoBN = $this->insertObjectBN( $a_SQLRow );
                $a_SRV_UbicacionEstadoBN[] = $o_SRV_UbicacionEstadoBN;
            }
        }
        return $a_SRV_UbicacionEstadoBN;
    }

    /* Devuelve un objeto SRV_UbicacionEstadoBN desde un objeto propel */
    public function insertObjectBN( $a_SRV_UbicacionEstado )
    {
        $o_SRV_UbicacionEstadoBN = new SRV_UbicacionEstadoBN();
        if ( !is_null( $a_SRV_UbicacionEstado['IdUbicacion'] ) ) $o_SRV_UbicacionEstadoBN->setIdUbicacion( ( integer ) $a_SRV_UbicacionEstado['IdUbicacion'] );
        if ( !is_null( $a_SRV_UbicacionEstado['IdEstados'] ) ) $o_SRV_UbicacionEstadoBN->setIdEstados( ( integer ) $a_SRV_UbicacionEstado['IdEstados'] );
        if ( !is_null( $a_SRV_UbicacionEstado['EstadoNombre'] ) ) $o_SRV_UbicacionEstadoBN->setEstadoNombre( $a_SRV_UbicacionEstado['EstadoNombre'] );
        if ( !is_null( $a_SRV_UbicacionEstado['FechaCreacion'] ) ) $o_SRV_UbicacionEstadoBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SRV_UbicacionEstado['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SRV_UbicacionEstado['UsuarioCreacion'] ) ) $o_SRV_UbicacionEstadoBN->setUsuarioCreacion( $a_SRV_UbicacionEstado['UsuarioCreacion'] );
        return $o_SRV_UbicacionEstadoBN;
    }
}
?>