<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_TextoAyuda.xml */
/* Generado: 2022-04-18 21:15:03 */

/* Busqueda de registros de la tabla SEG_TextoAyuda. */
abstract class BaseSEG_TextoAyudaFN extends SEG_TextoAyudaBN
{
    /* Declaracion de constantes */
    const IdTarea = "SEG_TextoAyuda.IdTarea";
    const TextoAyuda = "SEG_TextoAyuda.TextoAyuda";
    const FechaCreacion = "SEG_TextoAyuda.FechaCreacion";
    const UsuarioCreacion = "SEG_TextoAyuda.UsuarioCreacion";
    const FechaModificacion = "SEG_TextoAyuda.FechaModificacion";
    const UsuarioModificacion = "SEG_TextoAyuda.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_TextoAyuda.IdTarea AS IdTarea, ";
        $s_SQLQuery .= "SEG_TextoAyuda.TextoAyuda AS TextoAyuda, ";
        $s_SQLQuery .= "SEG_TextoAyuda.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_TextoAyuda.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_TextoAyuda.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_TextoAyuda.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_TextoAyudaBN */
    public function setByBN( SEG_TextoAyudaBN $o_SEG_TextoAyudaBN )
    {
        if ( !is_null( $o_SEG_TextoAyudaBN->getIdTarea() ) )
        {
            $this->setIdTarea( $o_SEG_TextoAyudaBN->getIdTarea() );
        }
        if ( !is_null( $o_SEG_TextoAyudaBN->getTextoAyuda() ) )
        {
            $this->setTextoAyuda( $o_SEG_TextoAyudaBN->getTextoAyuda() );
        }
        if ( !is_null( $o_SEG_TextoAyudaBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_TextoAyudaBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_TextoAyudaBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_TextoAyudaBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_TextoAyudaBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_TextoAyudaBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_TextoAyudaBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_TextoAyudaBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_TextoAyudaBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdTarea )
    {
        if( is_null( $s_IdTarea ) ){ $s_IdTarea = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_TextoAyuda ";
        $s_SQLQuery .= "WHERE IdTarea = '".$s_IdTarea."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_TextoAyudaBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_TextoAyudaBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_TextoAyudaBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdTarea() ) ) $s_SQLQuery .= "SEG_TextoAyuda.IdTarea = '".$this->getIdTarea()."' AND ";
        if ( !is_null( $this->getTextoAyuda() ) ) $s_SQLQuery .= "SEG_TextoAyuda.TextoAyuda = ".$this->getTextoAyuda()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_TextoAyuda.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_TextoAyuda.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_TextoAyuda.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_TextoAyuda.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_TextoAyuda WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_TextoAyudaBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_TextoAyuda WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_TextoAyudaBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_TextoAyudaBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_TextoAyudaBN[] = $o_SEG_TextoAyudaBN;
            }
        }
        return $a_SEG_TextoAyudaBN;
    }

    /* Devuelve un objeto SEG_TextoAyudaBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_TextoAyuda )
    {
        $o_SEG_TextoAyudaBN = new SEG_TextoAyudaBN();
        if ( !is_null( $a_SEG_TextoAyuda['IdTarea'] ) ) $o_SEG_TextoAyudaBN->setIdTarea( $a_SEG_TextoAyuda['IdTarea'] );
        if ( !is_null( $a_SEG_TextoAyuda['TextoAyuda'] ) ) $o_SEG_TextoAyudaBN->setTextoAyuda( ( integer ) $a_SEG_TextoAyuda['TextoAyuda'] );
        if ( !is_null( $a_SEG_TextoAyuda['FechaCreacion'] ) ) $o_SEG_TextoAyudaBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_TextoAyuda['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_TextoAyuda['UsuarioCreacion'] ) ) $o_SEG_TextoAyudaBN->setUsuarioCreacion( $a_SEG_TextoAyuda['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_TextoAyuda['FechaModificacion'] ) ) $o_SEG_TextoAyudaBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_TextoAyuda['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_TextoAyuda['UsuarioModificacion'] ) ) $o_SEG_TextoAyudaBN->setUsuarioModificacion( $a_SEG_TextoAyuda['UsuarioModificacion'] );
        return $o_SEG_TextoAyudaBN;
    }
}
?>