<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Rol.xml */
/* Generado: 2022-04-18 21:15:03 */

/* Busqueda de registros de la tabla SEG_Rol. */
abstract class BaseSEG_RolFN extends SEG_RolBN
{
    /* Declaracion de constantes */
    const IdRol = "SEG_Rol.IdRol";
    const RolDescripcion = "SEG_Rol.RolDescripcion";
    const IdTareaInicio = "SEG_Rol.IdTareaInicio";
    const AccesoGlobal = "SEG_Rol.AccesoGlobal";
    const EsAdministrador = "SEG_Rol.EsAdministrador";
    const FechaCreacion = "SEG_Rol.FechaCreacion";
    const UsuarioCreacion = "SEG_Rol.UsuarioCreacion";
    const FechaModificacion = "SEG_Rol.FechaModificacion";
    const UsuarioModificacion = "SEG_Rol.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_Rol.IdRol AS IdRol, ";
        $s_SQLQuery .= "SEG_Rol.RolDescripcion AS RolDescripcion, ";
        $s_SQLQuery .= "SEG_Rol.IdTareaInicio AS IdTareaInicio, ";
        $s_SQLQuery .= "SEG_Rol.AccesoGlobal AS AccesoGlobal, ";
        $s_SQLQuery .= "SEG_Rol.EsAdministrador AS EsAdministrador, ";
        $s_SQLQuery .= "SEG_Rol.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_Rol.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_Rol.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_Rol.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_RolBN */
    public function setByBN( SEG_RolBN $o_SEG_RolBN )
    {
        if ( !is_null( $o_SEG_RolBN->getIdRol() ) )
        {
            $this->setIdRol( $o_SEG_RolBN->getIdRol() );
        }
        if ( !is_null( $o_SEG_RolBN->getRolDescripcion() ) )
        {
            $this->setRolDescripcion( $o_SEG_RolBN->getRolDescripcion() );
        }
        if ( !is_null( $o_SEG_RolBN->getIdTareaInicio() ) )
        {
            $this->setIdTareaInicio( $o_SEG_RolBN->getIdTareaInicio() );
        }
        if ( !is_null( $o_SEG_RolBN->getAccesoGlobal() ) )
        {
            $this->setAccesoGlobal( $o_SEG_RolBN->getAccesoGlobal() );
        }
        if ( !is_null( $o_SEG_RolBN->getEsAdministrador() ) )
        {
            $this->setEsAdministrador( $o_SEG_RolBN->getEsAdministrador() );
        }
        if ( !is_null( $o_SEG_RolBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_RolBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_RolBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_RolBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_RolBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_RolBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_RolBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_RolBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_RolBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdRol )
    {
        if( is_null( $s_IdRol ) ){ $s_IdRol = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Rol ";
        $s_SQLQuery .= "WHERE IdRol = '".$s_IdRol."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_RolBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_RolBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_RolBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdRol() ) ) $s_SQLQuery .= "SEG_Rol.IdRol = '".$this->getIdRol()."' AND ";
        if ( !is_null( $this->getRolDescripcion() ) ) $s_SQLQuery .= "SEG_Rol.RolDescripcion = '".$this->getRolDescripcion()."' AND ";
        if ( !is_null( $this->getIdTareaInicio() ) ) $s_SQLQuery .= "SEG_Rol.IdTareaInicio = '".$this->getIdTareaInicio()."' AND ";
        if ( !is_null( $this->getAccesoGlobal() ) ) $s_SQLQuery .= "SEG_Rol.AccesoGlobal = '".$this->getAccesoGlobal()."' AND ";
        if ( !is_null( $this->getEsAdministrador() ) ) $s_SQLQuery .= "SEG_Rol.EsAdministrador = '".$this->getEsAdministrador()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_Rol.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_Rol.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_Rol.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_Rol.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_Rol WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_RolBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Rol WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_RolBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_RolBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_RolBN[] = $o_SEG_RolBN;
            }
        }
        return $a_SEG_RolBN;
    }

    /* Devuelve un objeto SEG_RolBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_Rol )
    {
        $o_SEG_RolBN = new SEG_RolBN();
        if ( !is_null( $a_SEG_Rol['IdRol'] ) ) $o_SEG_RolBN->setIdRol( $a_SEG_Rol['IdRol'] );
        if ( !is_null( $a_SEG_Rol['RolDescripcion'] ) ) $o_SEG_RolBN->setRolDescripcion( $a_SEG_Rol['RolDescripcion'] );
        if ( !is_null( $a_SEG_Rol['IdTareaInicio'] ) ) $o_SEG_RolBN->setIdTareaInicio( $a_SEG_Rol['IdTareaInicio'] );
        if ( !is_null( $a_SEG_Rol['AccesoGlobal'] ) ) $o_SEG_RolBN->setAccesoGlobal( $a_SEG_Rol['AccesoGlobal'] );
        if ( !is_null( $a_SEG_Rol['EsAdministrador'] ) ) $o_SEG_RolBN->setEsAdministrador( $a_SEG_Rol['EsAdministrador'] );
        if ( !is_null( $a_SEG_Rol['FechaCreacion'] ) ) $o_SEG_RolBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_Rol['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Rol['UsuarioCreacion'] ) ) $o_SEG_RolBN->setUsuarioCreacion( $a_SEG_Rol['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_Rol['FechaModificacion'] ) ) $o_SEG_RolBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_Rol['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Rol['UsuarioModificacion'] ) ) $o_SEG_RolBN->setUsuarioModificacion( $a_SEG_Rol['UsuarioModificacion'] );
        return $o_SEG_RolBN;
    }
}
?>