<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Patron.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla SEG_Patron. */
abstract class BaseSEG_PatronFN extends SEG_PatronBN
{
    /* Declaracion de constantes */
    const IdPatron = "SEG_Patron.IdPatron";
    const PatronDescripcion = "SEG_Patron.PatronDescripcion";
    const PatronLongDesc = "SEG_Patron.PatronLongDesc";
    const VisibleScreen = "SEG_Patron.VisibleScreen";
    const ContextoPreselec = "SEG_Patron.ContextoPreselec";
    const MantenerDatos = "SEG_Patron.MantenerDatos";
    const FechaCreacion = "SEG_Patron.FechaCreacion";
    const UsuarioCreacion = "SEG_Patron.UsuarioCreacion";
    const FechaModificacion = "SEG_Patron.FechaModificacion";
    const UsuarioModificacion = "SEG_Patron.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_Patron.IdPatron AS IdPatron, ";
        $s_SQLQuery .= "SEG_Patron.PatronDescripcion AS PatronDescripcion, ";
        $s_SQLQuery .= "SEG_Patron.PatronLongDesc AS PatronLongDesc, ";
        $s_SQLQuery .= "SEG_Patron.VisibleScreen AS VisibleScreen, ";
        $s_SQLQuery .= "SEG_Patron.ContextoPreselec AS ContextoPreselec, ";
        $s_SQLQuery .= "SEG_Patron.MantenerDatos AS MantenerDatos, ";
        $s_SQLQuery .= "SEG_Patron.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_Patron.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_Patron.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_Patron.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_PatronBN */
    public function setByBN( SEG_PatronBN $o_SEG_PatronBN )
    {
        if ( !is_null( $o_SEG_PatronBN->getIdPatron() ) )
        {
            $this->setIdPatron( $o_SEG_PatronBN->getIdPatron() );
        }
        if ( !is_null( $o_SEG_PatronBN->getPatronDescripcion() ) )
        {
            $this->setPatronDescripcion( $o_SEG_PatronBN->getPatronDescripcion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getPatronLongDesc() ) )
        {
            $this->setPatronLongDesc( $o_SEG_PatronBN->getPatronLongDesc() );
        }
        if ( !is_null( $o_SEG_PatronBN->getVisibleScreen() ) )
        {
            $this->setVisibleScreen( $o_SEG_PatronBN->getVisibleScreen() );
        }
        if ( !is_null( $o_SEG_PatronBN->getContextoPreselec() ) )
        {
            $this->setContextoPreselec( $o_SEG_PatronBN->getContextoPreselec() );
        }
        if ( !is_null( $o_SEG_PatronBN->getMantenerDatos() ) )
        {
            $this->setMantenerDatos( $o_SEG_PatronBN->getMantenerDatos() );
        }
        if ( !is_null( $o_SEG_PatronBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_PatronBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_PatronBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_PatronBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_PatronBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_PatronBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_PatronBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdPatron )
    {
        if( is_null( $s_IdPatron ) ){ $s_IdPatron = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Patron ";
        $s_SQLQuery .= "WHERE IdPatron = '".$s_IdPatron."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_PatronBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_PatronBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_PatronBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPatron() ) ) $s_SQLQuery .= "SEG_Patron.IdPatron = '".$this->getIdPatron()."' AND ";
        if ( !is_null( $this->getPatronDescripcion() ) ) $s_SQLQuery .= "SEG_Patron.PatronDescripcion = '".$this->getPatronDescripcion()."' AND ";
        if ( !is_null( $this->getPatronLongDesc() ) ) $s_SQLQuery .= "SEG_Patron.PatronLongDesc = ".$this->getPatronLongDesc()." AND ";
        if ( !is_null( $this->getVisibleScreen() ) ) $s_SQLQuery .= "SEG_Patron.VisibleScreen = '".$this->getVisibleScreen()."' AND ";
        if ( !is_null( $this->getContextoPreselec() ) ) $s_SQLQuery .= "SEG_Patron.ContextoPreselec = '".$this->getContextoPreselec()."' AND ";
        if ( !is_null( $this->getMantenerDatos() ) ) $s_SQLQuery .= "SEG_Patron.MantenerDatos = '".$this->getMantenerDatos()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_Patron.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_Patron.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_Patron.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_Patron.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_Patron WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_PatronBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Patron WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_PatronBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_PatronBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_PatronBN[] = $o_SEG_PatronBN;
            }
        }
        return $a_SEG_PatronBN;
    }

    /* Devuelve un objeto SEG_PatronBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_Patron )
    {
        $o_SEG_PatronBN = new SEG_PatronBN();
        if ( !is_null( $a_SEG_Patron['IdPatron'] ) ) $o_SEG_PatronBN->setIdPatron( $a_SEG_Patron['IdPatron'] );
        if ( !is_null( $a_SEG_Patron['PatronDescripcion'] ) ) $o_SEG_PatronBN->setPatronDescripcion( $a_SEG_Patron['PatronDescripcion'] );
        if ( !is_null( $a_SEG_Patron['PatronLongDesc'] ) ) $o_SEG_PatronBN->setPatronLongDesc( ( integer ) $a_SEG_Patron['PatronLongDesc'] );
        if ( !is_null( $a_SEG_Patron['VisibleScreen'] ) ) $o_SEG_PatronBN->setVisibleScreen( $a_SEG_Patron['VisibleScreen'] );
        if ( !is_null( $a_SEG_Patron['ContextoPreselec'] ) ) $o_SEG_PatronBN->setContextoPreselec( $a_SEG_Patron['ContextoPreselec'] );
        if ( !is_null( $a_SEG_Patron['MantenerDatos'] ) ) $o_SEG_PatronBN->setMantenerDatos( $a_SEG_Patron['MantenerDatos'] );
        if ( !is_null( $a_SEG_Patron['FechaCreacion'] ) ) $o_SEG_PatronBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_Patron['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Patron['UsuarioCreacion'] ) ) $o_SEG_PatronBN->setUsuarioCreacion( $a_SEG_Patron['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_Patron['FechaModificacion'] ) ) $o_SEG_PatronBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_Patron['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Patron['UsuarioModificacion'] ) ) $o_SEG_PatronBN->setUsuarioModificacion( $a_SEG_Patron['UsuarioModificacion'] );
        return $o_SEG_PatronBN;
    }
}
?>