<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_NavBoton.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla SEG_NavBoton. */
abstract class BaseSEG_NavBotonFN extends SEG_NavBotonBN
{
    /* Declaracion de constantes */
    const IdNavegation = "SEG_NavBoton.IdNavegation";
    const IdTareaHijo = "SEG_NavBoton.IdTareaHijo";
    const Secuencia = "SEG_NavBoton.Secuencia";
    const DescripcionBoton = "SEG_NavBoton.DescripcionBoton";
    const Bar_type = "SEG_NavBoton.bar_type";
    const FechaCreacion = "SEG_NavBoton.FechaCreacion";
    const UsuarioCreacion = "SEG_NavBoton.UsuarioCreacion";
    const FechaModificacion = "SEG_NavBoton.FechaModificacion";
    const UsuarioModificacion = "SEG_NavBoton.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_NavBoton.IdNavegation AS IdNavegation, ";
        $s_SQLQuery .= "SEG_NavBoton.IdTareaHijo AS IdTareaHijo, ";
        $s_SQLQuery .= "SEG_NavBoton.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "SEG_NavBoton.DescripcionBoton AS DescripcionBoton, ";
        $s_SQLQuery .= "SEG_NavBoton.bar_type AS bar_type, ";
        $s_SQLQuery .= "SEG_NavBoton.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_NavBoton.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_NavBoton.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_NavBoton.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_NavBotonBN */
    public function setByBN( SEG_NavBotonBN $o_SEG_NavBotonBN )
    {
        if ( !is_null( $o_SEG_NavBotonBN->getIdNavegation() ) )
        {
            $this->setIdNavegation( $o_SEG_NavBotonBN->getIdNavegation() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getIdTareaHijo() ) )
        {
            $this->setIdTareaHijo( $o_SEG_NavBotonBN->getIdTareaHijo() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SEG_NavBotonBN->getSecuencia() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getDescripcionBoton() ) )
        {
            $this->setDescripcionBoton( $o_SEG_NavBotonBN->getDescripcionBoton() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getBar_type() ) )
        {
            $this->setBar_type( $o_SEG_NavBotonBN->getBar_type() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_NavBotonBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_NavBotonBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_NavBotonBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_NavBotonBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_NavBotonBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_NavBotonBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdNavegation, $s_IdTareaHijo )
    {
        if( is_null( $s_IdNavegation ) ){ $s_IdNavegation = '-1'; } 
        if( is_null( $s_IdTareaHijo ) ){ $s_IdTareaHijo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_NavBoton ";
        $s_SQLQuery .= "WHERE IdNavegation = '".$s_IdNavegation."' ";
        $s_SQLQuery .= "AND IdTareaHijo = '".$s_IdTareaHijo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_NavBotonBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_NavBotonBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_NavBotonBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdNavegation() ) ) $s_SQLQuery .= "SEG_NavBoton.IdNavegation = '".$this->getIdNavegation()."' AND ";
        if ( !is_null( $this->getIdTareaHijo() ) ) $s_SQLQuery .= "SEG_NavBoton.IdTareaHijo = '".$this->getIdTareaHijo()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "SEG_NavBoton.Secuencia = ".$this->getSecuencia()." AND ";
        if ( !is_null( $this->getDescripcionBoton() ) ) $s_SQLQuery .= "SEG_NavBoton.DescripcionBoton = '".$this->getDescripcionBoton()."' AND ";
        if ( !is_null( $this->getBar_type() ) ) $s_SQLQuery .= "SEG_NavBoton.bar_type = '".$this->getBar_type()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_NavBoton.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_NavBoton.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_NavBoton.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_NavBoton.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_NavBoton WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_NavBotonBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_NavBoton WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_NavBotonBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_NavBotonBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_NavBotonBN[] = $o_SEG_NavBotonBN;
            }
        }
        return $a_SEG_NavBotonBN;
    }

    /* Devuelve un objeto SEG_NavBotonBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_NavBoton )
    {
        $o_SEG_NavBotonBN = new SEG_NavBotonBN();
        if ( !is_null( $a_SEG_NavBoton['IdNavegation'] ) ) $o_SEG_NavBotonBN->setIdNavegation( $a_SEG_NavBoton['IdNavegation'] );
        if ( !is_null( $a_SEG_NavBoton['IdTareaHijo'] ) ) $o_SEG_NavBotonBN->setIdTareaHijo( $a_SEG_NavBoton['IdTareaHijo'] );
        if ( !is_null( $a_SEG_NavBoton['Secuencia'] ) ) $o_SEG_NavBotonBN->setSecuencia( ( integer ) $a_SEG_NavBoton['Secuencia'] );
        if ( !is_null( $a_SEG_NavBoton['DescripcionBoton'] ) ) $o_SEG_NavBotonBN->setDescripcionBoton( $a_SEG_NavBoton['DescripcionBoton'] );
        if ( !is_null( $a_SEG_NavBoton['bar_type'] ) ) $o_SEG_NavBotonBN->setBar_type( $a_SEG_NavBoton['bar_type'] );
        if ( !is_null( $a_SEG_NavBoton['FechaCreacion'] ) ) $o_SEG_NavBotonBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_NavBoton['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_NavBoton['UsuarioCreacion'] ) ) $o_SEG_NavBotonBN->setUsuarioCreacion( $a_SEG_NavBoton['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_NavBoton['FechaModificacion'] ) ) $o_SEG_NavBotonBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_NavBoton['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_NavBoton['UsuarioModificacion'] ) ) $o_SEG_NavBotonBN->setUsuarioModificacion( $a_SEG_NavBoton['UsuarioModificacion'] );
        return $o_SEG_NavBotonBN;
    }
}
?>