<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: SEG_Menu.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla SEG_Menu. */
abstract class BaseSEG_MenuFN extends SEG_MenuBN
{
    /* Declaracion de constantes */
    const IdMenu = "SEG_Menu.IdMenu";
    const IdTareaHijo = "SEG_Menu.IdTareaHijo";
    const Secuencia = "SEG_Menu.Secuencia";
    const BotonTexto = "SEG_Menu.BotonTexto";
    const Estado = "SEG_Menu.Estado";
    const FechaCreacion = "SEG_Menu.FechaCreacion";
    const UsuarioCreacion = "SEG_Menu.UsuarioCreacion";
    const FechaModificacion = "SEG_Menu.FechaModificacion";
    const UsuarioModificacion = "SEG_Menu.UsuarioModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "SEG_Menu.IdMenu AS IdMenu, ";
        $s_SQLQuery .= "SEG_Menu.IdTareaHijo AS IdTareaHijo, ";
        $s_SQLQuery .= "SEG_Menu.Secuencia AS Secuencia, ";
        $s_SQLQuery .= "SEG_Menu.BotonTexto AS BotonTexto, ";
        $s_SQLQuery .= "SEG_Menu.Estado AS Estado, ";
        $s_SQLQuery .= "SEG_Menu.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "SEG_Menu.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "SEG_Menu.FechaModificacion AS FechaModificacion, ";
        $s_SQLQuery .= "SEG_Menu.UsuarioModificacion AS UsuarioModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto SEG_MenuBN */
    public function setByBN( SEG_MenuBN $o_SEG_MenuBN )
    {
        if ( !is_null( $o_SEG_MenuBN->getIdMenu() ) )
        {
            $this->setIdMenu( $o_SEG_MenuBN->getIdMenu() );
        }
        if ( !is_null( $o_SEG_MenuBN->getIdTareaHijo() ) )
        {
            $this->setIdTareaHijo( $o_SEG_MenuBN->getIdTareaHijo() );
        }
        if ( !is_null( $o_SEG_MenuBN->getSecuencia() ) )
        {
            $this->setSecuencia( $o_SEG_MenuBN->getSecuencia() );
        }
        if ( !is_null( $o_SEG_MenuBN->getBotonTexto() ) )
        {
            $this->setBotonTexto( $o_SEG_MenuBN->getBotonTexto() );
        }
        if ( !is_null( $o_SEG_MenuBN->getEstado() ) )
        {
            $this->setEstado( $o_SEG_MenuBN->getEstado() );
        }
        if ( !is_null( $o_SEG_MenuBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_SEG_MenuBN->getFechaCreacion() );
        }
        if ( !is_null( $o_SEG_MenuBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_SEG_MenuBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_SEG_MenuBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_SEG_MenuBN->getFechaModificacion() );
        }
        if ( !is_null( $o_SEG_MenuBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_SEG_MenuBN->getUsuarioModificacion() );
        }
    }

    /**
    * @return SEG_MenuBN|null
    * @throws SQLException
    */
    public function selectByPK( $s_IdMenu, $s_IdTareaHijo )
    {
        if( is_null( $s_IdMenu ) ){ $s_IdMenu = '-1'; } 
        if( is_null( $s_IdTareaHijo ) ){ $s_IdTareaHijo = '-1'; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Menu ";
        $s_SQLQuery .= "WHERE IdMenu = '".$s_IdMenu."' ";
        $s_SQLQuery .= "AND IdTareaHijo = '".$s_IdTareaHijo."' ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_SEG_MenuBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_SEG_MenuBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_SEG_MenuBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdMenu() ) ) $s_SQLQuery .= "SEG_Menu.IdMenu = '".$this->getIdMenu()."' AND ";
        if ( !is_null( $this->getIdTareaHijo() ) ) $s_SQLQuery .= "SEG_Menu.IdTareaHijo = '".$this->getIdTareaHijo()."' AND ";
        if ( !is_null( $this->getSecuencia() ) ) $s_SQLQuery .= "SEG_Menu.Secuencia = '".$this->getSecuencia()."' AND ";
        if ( !is_null( $this->getBotonTexto() ) ) $s_SQLQuery .= "SEG_Menu.BotonTexto = '".$this->getBotonTexto()."' AND ";
        if ( !is_null( $this->getEstado() ) ) $s_SQLQuery .= "SEG_Menu.Estado = ".$this->getEstado()." AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "SEG_Menu.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "SEG_Menu.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "SEG_Menu.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "SEG_Menu.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM SEG_Menu WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return SEG_MenuBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM SEG_Menu WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_SEG_MenuBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_SEG_MenuBN = $this->insertObjectBN( $a_SQLRow );
                $a_SEG_MenuBN[] = $o_SEG_MenuBN;
            }
        }
        return $a_SEG_MenuBN;
    }

    /* Devuelve un objeto SEG_MenuBN desde un objeto propel */
    public function insertObjectBN( $a_SEG_Menu )
    {
        $o_SEG_MenuBN = new SEG_MenuBN();
        if ( !is_null( $a_SEG_Menu['IdMenu'] ) ) $o_SEG_MenuBN->setIdMenu( $a_SEG_Menu['IdMenu'] );
        if ( !is_null( $a_SEG_Menu['IdTareaHijo'] ) ) $o_SEG_MenuBN->setIdTareaHijo( $a_SEG_Menu['IdTareaHijo'] );
        if ( !is_null( $a_SEG_Menu['Secuencia'] ) ) $o_SEG_MenuBN->setSecuencia( $a_SEG_Menu['Secuencia'] );
        if ( !is_null( $a_SEG_Menu['BotonTexto'] ) ) $o_SEG_MenuBN->setBotonTexto( $a_SEG_Menu['BotonTexto'] );
        if ( !is_null( $a_SEG_Menu['Estado'] ) ) $o_SEG_MenuBN->setEstado( ( integer ) $a_SEG_Menu['Estado'] );
        if ( !is_null( $a_SEG_Menu['FechaCreacion'] ) ) $o_SEG_MenuBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_SEG_Menu['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Menu['UsuarioCreacion'] ) ) $o_SEG_MenuBN->setUsuarioCreacion( $a_SEG_Menu['UsuarioCreacion'] );
        if ( !is_null( $a_SEG_Menu['FechaModificacion'] ) ) $o_SEG_MenuBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_SEG_Menu['FechaModificacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_SEG_Menu['UsuarioModificacion'] ) ) $o_SEG_MenuBN->setUsuarioModificacion( $a_SEG_Menu['UsuarioModificacion'] );
        return $o_SEG_MenuBN;
    }
}
?>