<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PR_AccesoRestriccion.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla PR_AccesoRestriccion. */
abstract class BasePR_AccesoRestriccionFN extends PR_AccesoRestriccionBN
{
    /* Declaracion de constantes */
    const IdPrAccRes = "PR_AccesoRestriccion.IdPrAccRes";
    const IdPrGrupo = "PR_AccesoRestriccion.IdPrGrupo";
    const Tipo = "PR_AccesoRestriccion.Tipo";
    const TipoCondicion = "PR_AccesoRestriccion.TipoCondicion";
    const Valor = "PR_AccesoRestriccion.Valor";
    const UsuarioCreacion = "PR_AccesoRestriccion.UsuarioCreacion";
    const FechaCreacion = "PR_AccesoRestriccion.FechaCreacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PR_AccesoRestriccion.IdPrAccRes AS IdPrAccRes, ";
        $s_SQLQuery .= "PR_AccesoRestriccion.IdPrGrupo AS IdPrGrupo, ";
        $s_SQLQuery .= "PR_AccesoRestriccion.Tipo AS Tipo, ";
        $s_SQLQuery .= "PR_AccesoRestriccion.TipoCondicion AS TipoCondicion, ";
        $s_SQLQuery .= "PR_AccesoRestriccion.Valor AS Valor, ";
        $s_SQLQuery .= "PR_AccesoRestriccion.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PR_AccesoRestriccion.FechaCreacion AS FechaCreacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PR_AccesoRestriccionBN */
    public function setByBN( PR_AccesoRestriccionBN $o_PR_AccesoRestriccionBN )
    {
        if ( !is_null( $o_PR_AccesoRestriccionBN->getIdPrAccRes() ) )
        {
            $this->setIdPrAccRes( $o_PR_AccesoRestriccionBN->getIdPrAccRes() );
        }
        if ( !is_null( $o_PR_AccesoRestriccionBN->getIdPrGrupo() ) )
        {
            $this->setIdPrGrupo( $o_PR_AccesoRestriccionBN->getIdPrGrupo() );
        }
        if ( !is_null( $o_PR_AccesoRestriccionBN->getTipo() ) )
        {
            $this->setTipo( $o_PR_AccesoRestriccionBN->getTipo() );
        }
        if ( !is_null( $o_PR_AccesoRestriccionBN->getTipoCondicion() ) )
        {
            $this->setTipoCondicion( $o_PR_AccesoRestriccionBN->getTipoCondicion() );
        }
        if ( !is_null( $o_PR_AccesoRestriccionBN->getValor() ) )
        {
            $this->setValor( $o_PR_AccesoRestriccionBN->getValor() );
        }
        if ( !is_null( $o_PR_AccesoRestriccionBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PR_AccesoRestriccionBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PR_AccesoRestriccionBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PR_AccesoRestriccionBN->getFechaCreacion() );
        }
    }

    /**
    * @return PR_AccesoRestriccionBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdPrAccRes )
    {
        if( is_null( $i_IdPrAccRes ) ){ $i_IdPrAccRes = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_AccesoRestriccion ";
        $s_SQLQuery .= "WHERE IdPrAccRes = ".$i_IdPrAccRes." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_PR_AccesoRestriccionBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PR_AccesoRestriccionBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PR_AccesoRestriccionBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdPrAccRes() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.IdPrAccRes = ".$this->getIdPrAccRes()." AND ";
        if ( !is_null( $this->getIdPrGrupo() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.IdPrGrupo = '".$this->getIdPrGrupo()."' AND ";
        if ( !is_null( $this->getTipo() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.Tipo = '".$this->getTipo()."' AND ";
        if ( !is_null( $this->getTipoCondicion() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.TipoCondicion = '".$this->getTipoCondicion()."' AND ";
        if ( !is_null( $this->getValor() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.Valor = '".$this->getValor()."' AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PR_AccesoRestriccion.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PR_AccesoRestriccion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PR_AccesoRestriccionBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PR_AccesoRestriccion WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_PR_AccesoRestriccionBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PR_AccesoRestriccionBN = $this->insertObjectBN( $a_SQLRow );
                $a_PR_AccesoRestriccionBN[] = $o_PR_AccesoRestriccionBN;
            }
        }
        return $a_PR_AccesoRestriccionBN;
    }

    /* Devuelve un objeto PR_AccesoRestriccionBN desde un objeto propel */
    public function insertObjectBN( $a_PR_AccesoRestriccion )
    {
        $o_PR_AccesoRestriccionBN = new PR_AccesoRestriccionBN();
        if ( !is_null( $a_PR_AccesoRestriccion['IdPrAccRes'] ) ) $o_PR_AccesoRestriccionBN->setIdPrAccRes( ( integer ) $a_PR_AccesoRestriccion['IdPrAccRes'] );
        if ( !is_null( $a_PR_AccesoRestriccion['IdPrGrupo'] ) ) $o_PR_AccesoRestriccionBN->setIdPrGrupo( $a_PR_AccesoRestriccion['IdPrGrupo'] );
        if ( !is_null( $a_PR_AccesoRestriccion['Tipo'] ) ) $o_PR_AccesoRestriccionBN->setTipo( $a_PR_AccesoRestriccion['Tipo'] );
        if ( !is_null( $a_PR_AccesoRestriccion['TipoCondicion'] ) ) $o_PR_AccesoRestriccionBN->setTipoCondicion( $a_PR_AccesoRestriccion['TipoCondicion'] );
        if ( !is_null( $a_PR_AccesoRestriccion['Valor'] ) ) $o_PR_AccesoRestriccionBN->setValor( $a_PR_AccesoRestriccion['Valor'] );
        if ( !is_null( $a_PR_AccesoRestriccion['UsuarioCreacion'] ) ) $o_PR_AccesoRestriccionBN->setUsuarioCreacion( $a_PR_AccesoRestriccion['UsuarioCreacion'] );
        if ( !is_null( $a_PR_AccesoRestriccion['FechaCreacion'] ) ) $o_PR_AccesoRestriccionBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PR_AccesoRestriccion['FechaCreacion'], "Y-m-d H:i:s" ) );
        return $o_PR_AccesoRestriccionBN;
    }
}
?>