<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: PRD_OrdenDet.xml */
/* Generado: 2022-04-18 21:15:02 */

/* Busqueda de registros de la tabla PRD_OrdenDet. */
abstract class BasePRD_OrdenDetFN extends PRD_OrdenDetBN
{
    /* Declaracion de constantes */
    const IdOrdenDet = "PRD_OrdenDet.IdOrdenDet";
    const IdOrdenCab = "PRD_OrdenDet.IdOrdenCab";
    const IdItem = "PRD_OrdenDet.IdItem";
    const ItemTipo = "PRD_OrdenDet.ItemTipo";
    const DescripcionItem = "PRD_OrdenDet.DescripcionItem";
    const IdUnidad = "PRD_OrdenDet.IdUnidad";
    const CantidadPedida = "PRD_OrdenDet.CantidadPedida";
    const CantidadRecibida = "PRD_OrdenDet.CantidadRecibida";
    const PrecioCostoUnit = "PRD_OrdenDet.PrecioCostoUnit";
    const PrecioCostoTotal = "PRD_OrdenDet.PrecioCostoTotal";
    const UsuarioCreacion = "PRD_OrdenDet.UsuarioCreacion";
    const FechaCreacion = "PRD_OrdenDet.FechaCreacion";
    const UsuarioModificacion = "PRD_OrdenDet.UsuarioModificacion";
    const FechaModificacion = "PRD_OrdenDet.FechaModificacion";

    public $a_Condition = array();
    public $a_OrderBy = array();
    public $a_GroupBy = array();
    public $b_Debug = false;

    /* Obtiene una conexion a la base de datos */
    public function getConnect()
    {
        $o_DBConnect = Conexion::getConexion();
        return $o_DBConnect;
    }

    public function getDebug()
    {
        if( SF_DEBUG )
        {
            $this->b_Debug = true;
        }
        return $this->b_Debug;
    }

    public function setDebug( $v )
    {
        $this->b_Debug = $v;
    }

    /* Obtiene la cadena de columas */
    public function getSelectColumns()
    {
        $s_SQLQuery = "PRD_OrdenDet.IdOrdenDet AS IdOrdenDet, ";
        $s_SQLQuery .= "PRD_OrdenDet.IdOrdenCab AS IdOrdenCab, ";
        $s_SQLQuery .= "PRD_OrdenDet.IdItem AS IdItem, ";
        $s_SQLQuery .= "PRD_OrdenDet.ItemTipo AS ItemTipo, ";
        $s_SQLQuery .= "PRD_OrdenDet.DescripcionItem AS DescripcionItem, ";
        $s_SQLQuery .= "PRD_OrdenDet.IdUnidad AS IdUnidad, ";
        $s_SQLQuery .= "PRD_OrdenDet.CantidadPedida AS CantidadPedida, ";
        $s_SQLQuery .= "PRD_OrdenDet.CantidadRecibida AS CantidadRecibida, ";
        $s_SQLQuery .= "PRD_OrdenDet.PrecioCostoUnit AS PrecioCostoUnit, ";
        $s_SQLQuery .= "PRD_OrdenDet.PrecioCostoTotal AS PrecioCostoTotal, ";
        $s_SQLQuery .= "PRD_OrdenDet.UsuarioCreacion AS UsuarioCreacion, ";
        $s_SQLQuery .= "PRD_OrdenDet.FechaCreacion AS FechaCreacion, ";
        $s_SQLQuery .= "PRD_OrdenDet.UsuarioModificacion AS UsuarioModificacion, ";
        $s_SQLQuery .= "PRD_OrdenDet.FechaModificacion AS FechaModificacion ";
        return $s_SQLQuery;
    }

    /* Establece el condicion de filtro de la lista resultante */
    public function addCondition( $s_Const, $s_Operator, $u_Value, $b_ComSimple = true )
    {
        $this->a_Condition[] = array( "COLUMN" => $s_Const, "OPERATOR" => $s_Operator, "VALUE" => $u_Value, "FLAG_COMILLAS" => $b_ComSimple );
    }

    /* Establece el orden de la lista resultante */
    public function addOrderBy( $s_Const, $b_OrderAsc = true )
    {
        $this->a_OrderBy[] = array( "COLUMN" => $s_Const, "ASC" => $b_OrderAsc );
    }

    /* Establece el orden de la lista resultante */
    public function addGroupBy( $s_Const )
    {
        $this->a_GroupBy[] = array( "COLUMN" => $s_Const );
    }

    /* Establece los valores desde un objeto PRD_OrdenDetBN */
    public function setByBN( PRD_OrdenDetBN $o_PRD_OrdenDetBN )
    {
        if ( !is_null( $o_PRD_OrdenDetBN->getIdOrdenDet() ) )
        {
            $this->setIdOrdenDet( $o_PRD_OrdenDetBN->getIdOrdenDet() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getIdOrdenCab() ) )
        {
            $this->setIdOrdenCab( $o_PRD_OrdenDetBN->getIdOrdenCab() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getIdItem() ) )
        {
            $this->setIdItem( $o_PRD_OrdenDetBN->getIdItem() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getItemTipo() ) )
        {
            $this->setItemTipo( $o_PRD_OrdenDetBN->getItemTipo() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getDescripcionItem() ) )
        {
            $this->setDescripcionItem( $o_PRD_OrdenDetBN->getDescripcionItem() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getIdUnidad() ) )
        {
            $this->setIdUnidad( $o_PRD_OrdenDetBN->getIdUnidad() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getCantidadPedida() ) )
        {
            $this->setCantidadPedida( $o_PRD_OrdenDetBN->getCantidadPedida() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getCantidadRecibida() ) )
        {
            $this->setCantidadRecibida( $o_PRD_OrdenDetBN->getCantidadRecibida() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getPrecioCostoUnit() ) )
        {
            $this->setPrecioCostoUnit( $o_PRD_OrdenDetBN->getPrecioCostoUnit() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getPrecioCostoTotal() ) )
        {
            $this->setPrecioCostoTotal( $o_PRD_OrdenDetBN->getPrecioCostoTotal() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getUsuarioCreacion() ) )
        {
            $this->setUsuarioCreacion( $o_PRD_OrdenDetBN->getUsuarioCreacion() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getFechaCreacion() ) )
        {
            $this->setFechaCreacion( $o_PRD_OrdenDetBN->getFechaCreacion() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getUsuarioModificacion() ) )
        {
            $this->setUsuarioModificacion( $o_PRD_OrdenDetBN->getUsuarioModificacion() );
        }
        if ( !is_null( $o_PRD_OrdenDetBN->getFechaModificacion() ) )
        {
            $this->setFechaModificacion( $o_PRD_OrdenDetBN->getFechaModificacion() );
        }
    }

    /**
    * @return PRD_OrdenDetBN|null
    * @throws SQLException
    */
    public function selectByPK( $i_IdOrdenDet )
    {
        if( is_null( $i_IdOrdenDet ) ){ $i_IdOrdenDet = -1; } 
 
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_OrdenDet ";
        $s_SQLQuery .= "WHERE IdOrdenDet = ".$i_IdOrdenDet." ";
        $s_SQLQuery .= "LIMIT 1;";
        $o_PRD_OrdenDetBN = null;
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows   = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            $o_ResultSet->next();
            $a_SQLRow = $o_ResultSet->getRow(); //devuele array
            $o_PRD_OrdenDetBN = $this->insertObjectBN( $a_SQLRow );
        }
        return $o_PRD_OrdenDetBN;
    }

    public function buildConsult()
    {
        $s_SQLQuery = "";
        if ( !is_null( $this->getIdOrdenDet() ) ) $s_SQLQuery .= "PRD_OrdenDet.IdOrdenDet = ".$this->getIdOrdenDet()." AND ";
        if ( !is_null( $this->getIdOrdenCab() ) ) $s_SQLQuery .= "PRD_OrdenDet.IdOrdenCab = ".$this->getIdOrdenCab()." AND ";
        if ( !is_null( $this->getIdItem() ) ) $s_SQLQuery .= "PRD_OrdenDet.IdItem = '".$this->getIdItem()."' AND ";
        if ( !is_null( $this->getItemTipo() ) ) $s_SQLQuery .= "PRD_OrdenDet.ItemTipo = '".$this->getItemTipo()."' AND ";
        if ( !is_null( $this->getDescripcionItem() ) ) $s_SQLQuery .= "PRD_OrdenDet.DescripcionItem = '".$this->getDescripcionItem()."' AND ";
        if ( !is_null( $this->getIdUnidad() ) ) $s_SQLQuery .= "PRD_OrdenDet.IdUnidad = ".$this->getIdUnidad()." AND ";
        if ( !is_null( $this->getCantidadPedida() ) ) $s_SQLQuery .= "PRD_OrdenDet.CantidadPedida = ".$this->getCantidadPedida()." AND ";
        if ( !is_null( $this->getCantidadRecibida() ) ) $s_SQLQuery .= "PRD_OrdenDet.CantidadRecibida = ".$this->getCantidadRecibida()." AND ";
        if ( !is_null( $this->getPrecioCostoUnit() ) ) $s_SQLQuery .= "PRD_OrdenDet.PrecioCostoUnit = ".$this->getPrecioCostoUnit()." AND ";
        if ( !is_null( $this->getPrecioCostoTotal() ) ) $s_SQLQuery .= "PRD_OrdenDet.PrecioCostoTotal = ".$this->getPrecioCostoTotal()." AND ";
        if ( !is_null( $this->getUsuarioCreacion() ) ) $s_SQLQuery .= "PRD_OrdenDet.UsuarioCreacion = '".$this->getUsuarioCreacion()."' AND ";
        if ( !is_null( $this->getFechaCreacion() ) ) $s_SQLQuery .= "PRD_OrdenDet.FechaCreacion = '".$this->getFechaCreacion()."' AND ";
        if ( !is_null( $this->getUsuarioModificacion() ) ) $s_SQLQuery .= "PRD_OrdenDet.UsuarioModificacion = '".$this->getUsuarioModificacion()."' AND ";
        if ( !is_null( $this->getFechaModificacion() ) ) $s_SQLQuery .= "PRD_OrdenDet.FechaModificacion = '".$this->getFechaModificacion()."' AND ";
        if ( count( $this->a_Condition ) > 0 )
        {
            foreach ( $this->a_Condition as $a_Condition )
            {
                if( $a_Condition['FLAG_COMILLAS'] )
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." '".$a_Condition[ "VALUE" ]."' AND ";
                }
                else
                {
                    $s_SQLQuery .= $a_Condition[ "COLUMN" ]." ".$a_Condition[ "OPERATOR" ]." ".$a_Condition[ "VALUE" ]." AND ";
                }
            }
        }
        $s_SQLQuery .= "1 = 1 ";
        return $s_SQLQuery;
    }

    public function selectNumRows()
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= "COUNT(*) AS cnt ";
        $s_SQLQuery .= "FROM PRD_OrdenDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if( $this->getDebug() ){ pr( $s_SQLQuery ); }
        $o_Resource = $this->getConnect();
        $o_Statement = $o_Resource->prepareStatement( $s_SQLQuery );
        $o_ResultSet = $o_Statement->executeQuery();
        $o_ResultSet->next();
        $i_NumRows    = $o_ResultSet->getInt( 'cnt' );
        return $i_NumRows;
    }

    /**
    * @param null $i_Position
    * @param null $i_Rows
    * @return PRD_OrdenDetBN[]
    * @throws SQLException
    */
    public function select( $i_Position = null, $i_Rows = null )
    {
        $s_SQLQuery = "SELECT ";
        $s_SQLQuery .= $this->getSelectColumns();
        $s_SQLQuery .= "FROM PRD_OrdenDet WHERE ";
        $s_SQLQuery .= $this->buildConsult();
        if ( count( $this->a_GroupBy ) > 0 )
        {
            $s_SQLQuery .= "GROUP BY ";
            $s_Separator = "";
            foreach ( $this->a_GroupBy as $a_GroupBy )
            {
                $s_SQLQuery .= $s_Separator.$a_GroupBy[ "COLUMN" ]." ";
                $s_Separator = ", ";
            }
        }
        if ( count( $this->a_OrderBy ) > 0 )
        {
            $s_SQLQuery = $s_SQLQuery."ORDER BY ";
            $s_Separator = "";
            foreach ( $this->a_OrderBy as $a_OrderBy )
            {
                $s_SQLQuery .= $s_Separator.$a_OrderBy[ "COLUMN" ]." ";
                if ( $a_OrderBy[ "ASC" ] === false ) $s_SQLQuery .= "DESC ";
                $s_Separator = ", ";
            }
        }
        if( !is_null( $i_Position ) && is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position;
        if( !is_null( $i_Position ) && !is_null( $i_Rows ) ) $s_SQLQuery .= "LIMIT ".$i_Position.", ".$i_Rows;
        $s_SQLQuery .= ";";

        $a_PRD_OrdenDetBN = array();
        $f_Micro1 = microtime( true );
        $o_ResultSet = $this->getConnect()->prepareStatement( $s_SQLQuery )->executeQuery();
        $f_Micro2 = microtime( true );
        if( $this->getDebug() ){ pr( "[".( round( $f_Micro2 - $f_Micro1, 2 ) )."] ".$s_SQLQuery ); }
        $i_NumRows = $o_ResultSet->getRecordCount();
        if( $i_NumRows > 0 )
        {
            while( $o_ResultSet->next() ) 
            {
                $a_SQLRow = $o_ResultSet->getRow(); //devuele array
                $o_PRD_OrdenDetBN = $this->insertObjectBN( $a_SQLRow );
                $a_PRD_OrdenDetBN[] = $o_PRD_OrdenDetBN;
            }
        }
        return $a_PRD_OrdenDetBN;
    }

    /* Devuelve un objeto PRD_OrdenDetBN desde un objeto propel */
    public function insertObjectBN( $a_PRD_OrdenDet )
    {
        $o_PRD_OrdenDetBN = new PRD_OrdenDetBN();
        if ( !is_null( $a_PRD_OrdenDet['IdOrdenDet'] ) ) $o_PRD_OrdenDetBN->setIdOrdenDet( ( integer ) $a_PRD_OrdenDet['IdOrdenDet'] );
        if ( !is_null( $a_PRD_OrdenDet['IdOrdenCab'] ) ) $o_PRD_OrdenDetBN->setIdOrdenCab( ( integer ) $a_PRD_OrdenDet['IdOrdenCab'] );
        if ( !is_null( $a_PRD_OrdenDet['IdItem'] ) ) $o_PRD_OrdenDetBN->setIdItem( $a_PRD_OrdenDet['IdItem'] );
        if ( !is_null( $a_PRD_OrdenDet['ItemTipo'] ) ) $o_PRD_OrdenDetBN->setItemTipo( $a_PRD_OrdenDet['ItemTipo'] );
        if ( !is_null( $a_PRD_OrdenDet['DescripcionItem'] ) ) $o_PRD_OrdenDetBN->setDescripcionItem( $a_PRD_OrdenDet['DescripcionItem'] );
        if ( !is_null( $a_PRD_OrdenDet['IdUnidad'] ) ) $o_PRD_OrdenDetBN->setIdUnidad( ( integer ) $a_PRD_OrdenDet['IdUnidad'] );
        if ( !is_null( $a_PRD_OrdenDet['CantidadPedida'] ) ) $o_PRD_OrdenDetBN->setCantidadPedida( ( float ) $a_PRD_OrdenDet['CantidadPedida'] );
        if ( !is_null( $a_PRD_OrdenDet['CantidadRecibida'] ) ) $o_PRD_OrdenDetBN->setCantidadRecibida( ( float ) $a_PRD_OrdenDet['CantidadRecibida'] );
        if ( !is_null( $a_PRD_OrdenDet['PrecioCostoUnit'] ) ) $o_PRD_OrdenDetBN->setPrecioCostoUnit( ( float ) $a_PRD_OrdenDet['PrecioCostoUnit'] );
        if ( !is_null( $a_PRD_OrdenDet['PrecioCostoTotal'] ) ) $o_PRD_OrdenDetBN->setPrecioCostoTotal( ( float ) $a_PRD_OrdenDet['PrecioCostoTotal'] );
        if ( !is_null( $a_PRD_OrdenDet['UsuarioCreacion'] ) ) $o_PRD_OrdenDetBN->setUsuarioCreacion( $a_PRD_OrdenDet['UsuarioCreacion'] );
        if ( !is_null( $a_PRD_OrdenDet['FechaCreacion'] ) ) $o_PRD_OrdenDetBN->setFechaCreacion( utilTimestamp::getTimestamp( $a_PRD_OrdenDet['FechaCreacion'], "Y-m-d H:i:s" ) );
        if ( !is_null( $a_PRD_OrdenDet['UsuarioModificacion'] ) ) $o_PRD_OrdenDetBN->setUsuarioModificacion( $a_PRD_OrdenDet['UsuarioModificacion'] );
        if ( !is_null( $a_PRD_OrdenDet['FechaModificacion'] ) ) $o_PRD_OrdenDetBN->setFechaModificacion( utilTimestamp::getTimestamp( $a_PRD_OrdenDet['FechaModificacion'], "Y-m-d H:i:s" ) );
        return $o_PRD_OrdenDetBN;
    }
}
?>